/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Set;

public class IBMDb2LocksTest
extends GenericTest {
    private static final int MEASURES_COUNT = 8;
    public String user;
    public String password;
    private String dbName;
    private HashMap lastValues;
    private ArrayList activeDatabases;

    public IBMDb2LocksTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(8);
        this.user = this.getValueForParam("user");
        this.password = this.getValueForParam("password");
        this.dbName = this.getValueForParam("database");
        this.lastValues = new HashMap();
    }

    public static void main(String[] stringArray) {
        new IBMDb2LocksTest(stringArray).computeMeasures(null);
    }

    public void computeMeasures(Hashtable hashtable) {
        HashMap hashMap = this.getLockStats();
        if (hashMap != null && hashMap.size() > 0) {
            Set set = hashMap.keySet();
            for (String string : set) {
                ArrayList arrayList = (ArrayList)hashMap.get(string);
                System.out.println(string + "=" + arrayList);
                if (this.activeDatabases.contains(string)) {
                    this.addNewMeasure(string, arrayList);
                    continue;
                }
                this.addNewMeasure(string, this.getNotAvailableMeasures());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap getLockStats() {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        HashMap hashMap = new HashMap();
        DB2JdbcHelper dB2JdbcHelper = null;
        String string = null;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = -5.0;
        double d11 = -5.0;
        double d12 = -5.0;
        double d13 = -5.0;
        double d14 = -5.0;
        double d15 = -5.0;
        double d16 = -5.0;
        dB2JdbcHelper = new DB2JdbcHelper(this.targetHost, this.portNo, this.user, this.password, this.dbName);
        connection = dB2JdbcHelper.getConnection();
        if (connection == null) {
            System.out.println("Error in getting database connection");
            return null;
        }
        String string2 = dB2JdbcHelper.getDbSnapshotFunction(connection);
        System.out.println("snapshotTable for " + this.entity + " = " + string2);
        String string3 = "SELECT DB_NAME,LOCKS_HELD,LOCK_ESCALS,X_LOCK_ESCALS,LOCK_TIMEOUTS,LOCK_WAITS,LOCK_WAIT_TIME,LOCKS_WAITING,APPLS_CUR_CONS,DEADLOCKS FROM table(" + string2 + ") DB";
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string3);
            this.activeDatabases = new ArrayList();
            while (resultSet.next()) {
                string = resultSet.getString("DB_NAME");
                d = resultSet.getDouble("LOCKS_HELD");
                d2 = resultSet.getDouble("LOCK_ESCALS");
                d3 = resultSet.getDouble("X_LOCK_ESCALS");
                d4 = resultSet.getDouble("LOCK_TIMEOUTS");
                d5 = resultSet.getDouble("LOCK_WAITS");
                d6 = resultSet.getDouble("LOCK_WAIT_TIME");
                d7 = resultSet.getDouble("LOCKS_WAITING");
                d8 = resultSet.getDouble("APPLS_CUR_CONS");
                d9 = resultSet.getDouble("DEADLOCKS");
                this.activeDatabases.add(string);
                ArrayList<Double> arrayList = (ArrayList<Double>)this.lastValues.get(string);
                if (arrayList == null) {
                    arrayList = new ArrayList<Double>(6);
                    arrayList.add(new Double(d2));
                    arrayList.add(new Double(d3));
                    arrayList.add(new Double(d4));
                    arrayList.add(new Double(d5));
                    arrayList.add(new Double(d6));
                    arrayList.add(new Double(d9));
                } else {
                    double d17 = (Double)arrayList.get(0);
                    double d18 = (Double)arrayList.get(1);
                    double d19 = (Double)arrayList.get(2);
                    double d20 = (Double)arrayList.get(3);
                    double d21 = (Double)arrayList.get(4);
                    double d22 = (Double)arrayList.get(5);
                    if (this.timeSinceLastTest > 0.0) {
                        d13 = (d5 - d20) / this.timeSinceLastTest;
                    }
                    d16 = d9 - d22;
                    d11 = d3 - d18;
                    d12 = d4 - d19;
                    d10 = d2 - d17;
                    double d23 = d6 - d21;
                    double d24 = d5 - d20;
                    d14 = d23 > 0.0 ? d24 / d23 : 0.0;
                    d15 = d8 > 0.0 ? d7 * 100.0 / d8 : 0.0;
                    arrayList.set(0, new Double(d2));
                    arrayList.set(1, new Double(d3));
                    arrayList.set(2, new Double(d4));
                    arrayList.set(3, new Double(d5));
                    arrayList.set(4, new Double(d6));
                    arrayList.set(5, new Double(d9));
                }
                this.lastValues.put(string, arrayList);
                ArrayList<Double> arrayList2 = new ArrayList<Double>(8);
                arrayList2.add(new Double(d16 < 0.0 ? -5.0 : d16));
                arrayList2.add(new Double(d11 < 0.0 ? -5.0 : d11));
                arrayList2.add(new Double(d < 0.0 ? -5.0 : d));
                arrayList2.add(new Double(d12 < 0.0 ? -5.0 : d12));
                arrayList2.add(new Double(d10 < 0.0 ? -5.0 : d10));
                arrayList2.add(new Double(d15));
                arrayList2.add(new Double(d13 < 0.0 ? -5.0 : d13));
                arrayList2.add(new Double(d14 < 0.0 ? -5.0 : d14));
                hashMap.put(string, arrayList2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            dB2JdbcHelper.closeStatement(statement);
            dB2JdbcHelper.closeResultSet(resultSet);
        }
        dB2JdbcHelper.closeConnection(connection);
        return hashMap;
    }

    private ArrayList getNotAvailableMeasures() {
        ArrayList<Double> arrayList = new ArrayList<Double>(8);
        for (int i = 0; i < 8; ++i) {
            arrayList.add(new Double(-5.0));
        }
        return arrayList;
    }
}

