/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class IBMDb2ActivityTest
extends GenericTest {
    private static final int MEASURES_COUNT = 7;
    private String user;
    private String password;
    private String dbName;
    private Hashtable lastValues;
    private ArrayList activeDatabases;

    public IBMDb2ActivityTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(7);
        this.user = this.getValueForParam("user");
        this.password = this.getValueForParam("password");
        this.dbName = this.getValueForParam("database");
        this.lastValues = new Hashtable();
    }

    public static void main(String[] stringArray) {
        IBMDb2ActivityTest iBMDb2ActivityTest = new IBMDb2ActivityTest(stringArray);
        iBMDb2ActivityTest.computeMeasures(new Hashtable());
    }

    public void computeMeasures(Hashtable hashtable) {
        Hashtable hashtable2 = this.getSqlActivity();
        if (hashtable2 == null || hashtable2.size() == 0) {
            return;
        }
        Enumeration enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            ArrayList arrayList = (ArrayList)hashtable2.get(string);
            if (this.activeDatabases.contains(string)) {
                this.addNewMeasure(string, arrayList);
                continue;
            }
            this.addNewMeasure(string, this.getNotAvailableMeasures());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Hashtable getSqlActivity() {
        double d = -5.0;
        double d2 = -5.0;
        double d3 = -5.0;
        double d4 = -5.0;
        double d5 = -5.0;
        double d6 = -5.0;
        double d7 = -5.0;
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        DB2JdbcHelper dB2JdbcHelper = null;
        Hashtable hashtable = new Hashtable();
        dB2JdbcHelper = new DB2JdbcHelper(this.targetHost, this.portNo, this.user, this.password, this.dbName);
        connection = dB2JdbcHelper.getConnection();
        if (connection == null) {
            System.out.println("Error in getting database connection");
            return null;
        }
        String string = dB2JdbcHelper.getDbSnapshotFunction(connection);
        System.out.println("snapshotTable for " + this.entity + " = " + string);
        String string2 = "SELECT DB_NAME, DYNAMIC_SQL_STMTS, SELECT_SQL_STMTS, UID_SQL_STMTS, FAILED_SQL_STMTS,(FAILED_SQL_STMTS)/(TOTAL_STATIC_DYNAMIC_STMTS) AS PCT_FAILED_SQL, (DDL_SQL_STMTS)/(TOTAL_STATIC_DYNAMIC_STMTS) AS PCT_DDL_SQL,(UID_SQL_STMTS)/(TOTAL_STATIC_DYNAMIC_STMTS) AS PCT_UID_SQL,STATIC_SQL_STMTS, DDL_SQL_STMTS FROM  ( SELECT DB_NAME, DDL_SQL_STMTS,CASE TOTAL_STATIC_DYNAMIC_STMTS WHEN 0 THEN 1 ELSE TOTAL_STATIC_DYNAMIC_STMTS END AS  TOTAL_STATIC_DYNAMIC_STMTS,STATIC_SQL_STMTS, DYNAMIC_SQL_STMTS, FAILED_SQL_STMTS, SELECT_SQL_STMTS, UID_SQL_STMTS FROM (SELECT DB_NAME, DDL_SQL_STMTS, (DYNAMIC_SQL_STMTS + STATIC_SQL_STMTS) AS TOTAL_STATIC_DYNAMIC_STMTS, DYNAMIC_SQL_STMTS, STATIC_SQL_STMTS, FAILED_SQL_STMTS, SELECT_SQL_STMTS, UID_SQL_STMTS FROM TABLE(" + string + ") AS T\t) B\t) A";
        this.activeDatabases = new ArrayList();
        try {
            statement = connection.createStatement();
            System.out.println(string2);
            resultSet = statement.executeQuery(string2);
            ArrayList<Double> arrayList = null;
            while (resultSet.next()) {
                String string3 = resultSet.getString("DB_NAME");
                double d8 = resultSet.getDouble("DYNAMIC_SQL_STMTS");
                double d9 = resultSet.getDouble("SELECT_SQL_STMTS");
                double d10 = resultSet.getDouble("UID_SQL_STMTS");
                double d11 = resultSet.getDouble("FAILED_SQL_STMTS");
                double d12 = resultSet.getDouble("STATIC_SQL_STMTS");
                double d13 = resultSet.getDouble("DDL_SQL_STMTS");
                this.activeDatabases.add(string3);
                ArrayList<Double> arrayList2 = (ArrayList<Double>)this.lastValues.get(string3);
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList<Double>(6);
                    arrayList2.add(new Double(d8));
                    arrayList2.add(new Double(d9));
                    arrayList2.add(new Double(d10));
                    arrayList2.add(new Double(d11));
                    arrayList2.add(new Double(d12));
                    arrayList2.add(new Double(d13));
                } else {
                    double d14 = (Double)arrayList2.get(0);
                    double d15 = (Double)arrayList2.get(1);
                    double d16 = (Double)arrayList2.get(2);
                    double d17 = (Double)arrayList2.get(3);
                    double d18 = (Double)arrayList2.get(4);
                    double d19 = (Double)arrayList2.get(5);
                    double d20 = d8 - d14;
                    double d21 = d9 - d15;
                    double d22 = d12 - d18;
                    double d23 = d11 - d17;
                    double d24 = d10 - d16;
                    double d25 = d13 - d19;
                    d = this.timeSinceLastTest > 0.0 ? d20 / this.timeSinceLastTest : -1.0;
                    d = d < 0.0 ? -5.0 : d;
                    d2 = this.timeSinceLastTest > 0.0 ? d21 / this.timeSinceLastTest : -1.0;
                    d2 = d2 < 0.0 ? -5.0 : d2;
                    d3 = this.timeSinceLastTest > 0.0 ? d24 / this.timeSinceLastTest : -1.0;
                    d3 = d3 < 0.0 ? -5.0 : d3;
                    d4 = this.timeSinceLastTest > 0.0 ? d23 / this.timeSinceLastTest : -1.0;
                    d4 = d4 < 0.0 ? -5.0 : d4;
                    double d26 = d22 + d20;
                    d5 = d26 > 0.0 ? 100.0 * (d23 / d26) : 0.0;
                    d6 = d26 > 0.0 ? 100.0 * (d25 / d26) : 0.0;
                    d7 = d26 > 0.0 ? 100.0 * (d24 / d26) : 0.0;
                    arrayList2.set(0, new Double(d8));
                    arrayList2.set(1, new Double(d9));
                    arrayList2.set(2, new Double(d10));
                    arrayList2.add(3, new Double(d11));
                    arrayList2.add(4, new Double(d12));
                    arrayList2.add(5, new Double(d13));
                }
                this.lastValues.put(string3, arrayList2);
                arrayList = new ArrayList<Double>(7);
                arrayList.add(new Double(d));
                arrayList.add(new Double(d2));
                arrayList.add(new Double(d3));
                arrayList.add(new Double(d4));
                arrayList.add(new Double(d5));
                arrayList.add(new Double(d6));
                arrayList.add(new Double(d7));
                hashtable.put(string3, arrayList);
            }
            dB2JdbcHelper.closeStatement(statement);
            dB2JdbcHelper.closeResultSet(resultSet);
        }
        catch (Exception exception) {
            try {
                exception.printStackTrace();
                System.out.println("Exception occured in Db2SqlActTest " + exception);
                dB2JdbcHelper.closeStatement(statement);
                dB2JdbcHelper.closeResultSet(resultSet);
            }
            catch (Throwable throwable) {
                dB2JdbcHelper.closeStatement(statement);
                dB2JdbcHelper.closeResultSet(resultSet);
                throw throwable;
            }
        }
        dB2JdbcHelper.closeConnection(connection);
        return hashtable;
    }

    private ArrayList getNotAvailableMeasures() {
        ArrayList<Double> arrayList = new ArrayList<Double>(7);
        for (int i = 0; i < 7; ++i) {
            arrayList.add(new Double(-5.0));
        }
        return arrayList;
    }
}

