/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class GtmPoolStatusTest
extends EgSnmpGenericTest {
    private boolean isFirst = true;

    public GtmPoolStatusTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(2);
        this.isNewDynamicInfoTest = true;
        this.snmpPortNo = this.getValueForParam("snmpPort");
        this.snmpVersion = this.getValueForParam("snmpVersion");
        this.community = this.getValueForParam("snmpCommunity");
    }

    public void computeMeasures(Hashtable hashtable) {
        try {
            Hashtable hashtable2 = this.getMeasures(".1.3.6.1.4.1.3375.2.3.6.3.2.1.1");
            Hashtable hashtable3 = this.getMeasures(".1.3.6.1.4.1.3375.2.3.6.3.2.1.2");
            Hashtable hashtable4 = this.getMeasures(".1.3.6.1.4.1.3375.2.3.6.3.2.1.3");
            if (hashtable2 == null || hashtable2.size() == 0) {
                if (this.isFirst) {
                    this.logToErrorFile("Info :", "GtmPoolStatusTest No pools are configured for ", this.targetHost);
                    this.isFirst = false;
                }
                return;
            }
            Enumeration enumeration = hashtable2.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = (String)hashtable2.get(string);
                String string3 = (String)hashtable3.get(string);
                String string4 = (String)hashtable4.get(string);
                double d = this.getDoubleValue(string3);
                double d2 = this.getDoubleValue(string4);
                if (d >= 0.0) {
                    d = d == 1.0 ? 0.0 : (d == 4.0 ? 1.0 : (d == 5.0 ? 2.0 : (d == 2.0 ? 4.0 : (d == 3.0 ? 5.0 : 3.0))));
                }
                if (d2 >= 0.0) {
                    if (d2 == 2.0) {
                        d2 = 3.0;
                    }
                    if (d2 == 3.0) {
                        d2 = 2.0;
                    }
                }
                ArrayList<Double> arrayList = new ArrayList<Double>();
                arrayList.add(new Double(d));
                arrayList.add(new Double(d2));
                System.out.println(this.entity + " Info :" + string2 + " MeasureList :" + arrayList);
                this.addNewMeasure(string2, arrayList);
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Exception :", "GtmPoolStatusTest Exception occured in computeMeasures() for " + this.targetHost, exception.toString());
        }
    }

    private double getDoubleValue(String string) {
        double d = -5.0;
        try {
            d = string != null && string.trim().length() > 0 ? Double.parseDouble(string) : -5.0;
        }
        catch (Exception exception) {
            this.logToErrorFile("Exception :", "GtmPoolStatusTest Exception occured in getDoubleValue() for " + this.targetHost, exception.toString());
            d = -5.0;
        }
        return d;
    }

    private Hashtable getMeasures(String string) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        try {
            String string2 = "";
            String string3 = "";
            boolean bl = this.runSnmpCmdForOid(string);
            if (bl) {
                for (int i = 0; i < this.lhs.length; ++i) {
                    string2 = this.lhs[i].trim();
                    if (this.rhs[i] != null && this.rhs[i].trim().length() > 0) {
                        string3 = this.rhs[i].trim();
                        hashtable.put(string2, string3);
                        continue;
                    }
                    hashtable.put(string2, "-5");
                }
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Exception :", "GtmPoolStatusTest Exception occured in getMeasures() for " + this.targetHost, exception.toString());
        }
        return hashtable;
    }

    public static void main(String[] stringArray) {
        GtmPoolStatusTest gtmPoolStatusTest = new GtmPoolStatusTest(stringArray);
        gtmPoolStatusTest.computeMeasures(new Hashtable());
    }
}

