/*
 * Decompiled with CFR 0.152.
 */
import com.sun.management.GarbageCollectionNotificationInfo;
import java.lang.management.MemoryUsage;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GCNotificationListener
implements NotificationListener {
    String nodeId = null;
    private long timeTooKill;
    private int factor = 2;
    private SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
    private boolean isOpenJ9 = false;

    public GCNotificationListener(String string, long l) {
        this.nodeId = string;
        this.timeTooKill = l * (long)this.factor;
    }

    @Override
    public void handleNotification(Notification notification, Object object) {
        if (notification.getType().equals("com.sun.management.gc.notification")) {
            Object object2;
            Object object3;
            Map<String, MemoryUsage> map;
            Object object4;
            Object[] objectArray;
            String[] stringArray;
            Object object5;
            Object object6;
            if (!this.isOpenJ9) {
                try {
                    object6 = GarbageCollectionNotificationInfo.from((CompositeData)notification.getUserData());
                    long l = ((GarbageCollectionNotificationInfo)object6).getGcInfo().getStartTime();
                    long l2 = ((GarbageCollectionNotificationInfo)object6).getGcInfo().getEndTime();
                    object5 = ((GarbageCollectionNotificationInfo)object6).getGcName();
                    stringArray = ((GarbageCollectionNotificationInfo)object6).getGcAction();
                    if ("end of minor GC".equals(stringArray)) {
                        stringArray = "M";
                    } else if ("end of major GC".equals(stringArray)) {
                        stringArray = "F";
                    }
                    objectArray = stringArray;
                    object4 = this.simpleDateFormat.format(notification.getTimeStamp());
                    long l3 = l2 - l;
                    map = ((GarbageCollectionNotificationInfo)object6).getGcInfo().getMemoryUsageAfterGc();
                    object3 = ((GarbageCollectionNotificationInfo)object6).getGcInfo().getMemoryUsageBeforeGc();
                    object2 = new ArrayList<Object>();
                    ((ArrayList)object2).add(objectArray);
                    ((ArrayList)object2).add(object4);
                    ((ArrayList)object2).add(l3);
                    ((ArrayList)object2).add(this.getUsedMem(map));
                    ((ArrayList)object2).add(this.getUsedMem((Map)object3));
                    JVMGCDataRepository.JVMSetRepository(this.nodeId, object2, this.timeTooKill);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    System.out.println("GCNotificationListener - IllegalArgumentException , trying for Open J9 for the " + this.nodeId);
                    this.isOpenJ9 = true;
                }
                catch (Exception exception) {
                    System.out.println("GCNotificationListener - Exception in the method handleNotification() " + exception.getMessage());
                    exception.printStackTrace();
                }
            }
            if (this.isOpenJ9) {
                try {
                    object6 = (CompositeData)notification.getUserData();
                    if (object6 != null) {
                        String[] stringArray2 = new String[]{"gcName", "gcAction", "gcInfo"};
                        Object[] objectArray2 = object6.getAll(stringArray2);
                        String string = (String)objectArray2[0];
                        String string2 = (String)objectArray2[1];
                        object5 = (CompositeData)objectArray2[2];
                        stringArray = new String[]{"startTime", "endTime", "usageAfterGc", "usageBeforeGc"};
                        objectArray = object5.getAll(stringArray);
                        object4 = (Long)objectArray[0];
                        Long l = (Long)objectArray[1];
                        Map<String, MemoryUsage> map2 = this.convertTabularDataToMemoryUsageMap((TabularData)objectArray[2]);
                        map = this.convertTabularDataToMemoryUsageMap((TabularData)objectArray[3]);
                        if ("end of minor GC".equals(string2)) {
                            string2 = "M";
                        } else if ("end of major GC".equals(string2)) {
                            string2 = "F";
                        }
                        object3 = string2;
                        object2 = this.simpleDateFormat.format(notification.getTimeStamp());
                        long l4 = l - (Long)object4;
                        ArrayList<Object> arrayList = new ArrayList<Object>();
                        arrayList.add(object3);
                        arrayList.add(object2);
                        arrayList.add(l4);
                        arrayList.add(this.getUsedMem(map2));
                        arrayList.add(this.getUsedMem(map));
                        JVMGCDataRepository.JVMSetRepository(this.nodeId, arrayList, this.timeTooKill);
                    }
                }
                catch (Exception exception) {
                    System.out.println("GCNotificationListener - Exception while fetching data from Open J9 JVM for the " + this.nodeId);
                }
            }
        }
    }

    private Hashtable getUsedMem(Map map) {
        Hashtable<String, Long> hashtable = new Hashtable<String, Long>();
        try {
            for (Map.Entry entry : map.entrySet()) {
                MemoryUsage memoryUsage = (MemoryUsage)entry.getValue();
                String string = (String)entry.getKey();
                hashtable.put(string, memoryUsage.getUsed());
            }
        }
        catch (Exception exception) {
            System.out.println("GCNotificationListener - Exception in the method getUsedMem() : " + exception.getMessage());
            exception.printStackTrace();
        }
        return hashtable;
    }

    private Map<String, MemoryUsage> convertTabularDataToMemoryUsageMap(TabularData tabularData) {
        HashMap<String, MemoryUsage> hashMap = new HashMap<String, MemoryUsage>();
        try {
            for (CompositeData compositeData : tabularData.values()) {
                String string = (String)compositeData.get("key");
                MemoryUsage memoryUsage = MemoryUsage.from((CompositeData)compositeData.get("value"));
                long l = memoryUsage.getUsed();
                hashMap.put(string, memoryUsage);
            }
        }
        catch (Exception exception) {
            System.out.println("GCNotificationListener - Exception in the memoryusage : " + exception.getMessage());
        }
        return hashMap;
    }
}

