/*
 * Decompiled with CFR 0.152.
 */
import com.sssw.rt.util.AgRuntime;
import com.sssw.rt.util.AgiUserLogin;
import com.sssw.rt.util.AgrServerSession;
import com.sssw.rts.adminapi.AgiAdmServer;
import com.sssw.rts.adminapi.AgiAdmSession;
import com.sssw.rts.adminapi.AgiAdmStatistics;
import com.sssw.rts.adminclient.AgAdmin;
import java.util.Enumeration;

public class EgSilverStream {
    private boolean isAuthenticated = false;
    private String user = "";
    private String pass = "";
    private boolean wrongArgs = false;
    private String targetHost;
    private String portNo;
    private long msecPerMin = 60000L;
    private long codeTimeout = 2L * this.msecPerMin;
    EgDateInfo dateInfo = new EgDateInfo();

    public static void main(String[] stringArray) {
        EgSilverStream egSilverStream = new EgSilverStream(stringArray);
        egSilverStream.takeMeasures();
        System.exit(0);
    }

    public EgSilverStream(String[] stringArray) {
        if (stringArray.length < 2 || !stringArray[0].equalsIgnoreCase("-host")) {
            this.wrongArgs = true;
            return;
        }
        if (stringArray.length > 2 && !stringArray[2].equalsIgnoreCase("-port")) {
            this.wrongArgs = true;
            return;
        }
        if (stringArray.length > 4 && !stringArray[4].equalsIgnoreCase("-rootPath")) {
            this.wrongArgs = true;
            return;
        }
        if (stringArray.length > 6 && !stringArray[6].equalsIgnoreCase("-isAuthenticated")) {
            this.wrongArgs = true;
            return;
        }
        if (stringArray.length > 8 && !stringArray[8].equalsIgnoreCase("-user")) {
            this.wrongArgs = true;
            return;
        }
        if (stringArray.length > 10 && !stringArray[10].equalsIgnoreCase("-password")) {
            this.wrongArgs = true;
            return;
        }
        if (stringArray.length > 12 && !stringArray[12].equalsIgnoreCase("-adminPort")) {
            this.wrongArgs = true;
            return;
        }
        this.targetHost = new String(stringArray[1]);
        this.portNo = stringArray[13];
        if (stringArray[7].equalsIgnoreCase("Y")) {
            this.isAuthenticated = true;
        } else if (stringArray[7].equalsIgnoreCase("N")) {
            this.isAuthenticated = false;
        } else {
            this.wrongArgs = true;
            return;
        }
        this.user = stringArray[9];
        this.pass = stringArray[11];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void takeMeasures() {
        AgrServerSession agrServerSession;
        Enumeration enumeration;
        AgiAdmStatistics agiAdmStatistics;
        AgiAdmServer agiAdmServer;
        EgLoginHandler egLoginHandler;
        block12: {
            block11: {
                block10: {
                    if (this.wrongArgs) {
                        System.out.println("ErrorMsg=WrongArgs");
                        return;
                    }
                    egLoginHandler = null;
                    agiAdmServer = null;
                    agiAdmStatistics = null;
                    enumeration = null;
                    agrServerSession = null;
                    try {
                        try {
                            EgSsHelperThread egSsHelperThread;
                            block14: {
                                block15: {
                                    block13: {
                                        egLoginHandler = new EgLoginHandler(this.user, this.pass);
                                        AgRuntime.init((AgiUserLogin)egLoginHandler);
                                        egSsHelperThread = new EgSsHelperThread(this.targetHost, this.portNo);
                                        boolean bl = this.checkForTimeout(egSsHelperThread);
                                        if (!bl) break block13;
                                        agrServerSession = egSsHelperThread.session;
                                        if (agrServerSession != null) break block14;
                                        break block15;
                                    }
                                    System.out.println("ErrorMsg=Failed to connect to SilverStream Server");
                                    egSsHelperThread = null;
                                    Object var41_9 = null;
                                    agiAdmServer = null;
                                    agiAdmStatistics = null;
                                    enumeration = null;
                                    egLoginHandler = null;
                                    if (agrServerSession == null) return;
                                    break block10;
                                }
                                System.out.println("ErrorMsg=Failed to connect to SilverStream Server");
                                egSsHelperThread = null;
                                break block11;
                            }
                            egSsHelperThread = null;
                            agiAdmServer = AgAdmin.getServer((AgrServerSession)agrServerSession);
                            agiAdmStatistics = agiAdmServer.getStatistics();
                            enumeration = agiAdmServer.getSessions();
                            int n = agiAdmStatistics.getServerLoad();
                            long l = agiAdmStatistics.getFreeThreadCount() + 1;
                            long l2 = agiAdmStatistics.getIdleThreadCount() - 1;
                            long l3 = agiAdmStatistics.getTotalThreadCount();
                            long l4 = l3 - l;
                            double d = l4 * 100L / l3;
                            double d2 = 0.0;
                            try {
                                d2 = l2 * 100L / l4;
                            }
                            catch (ArithmeticException arithmeticException) {
                                d2 = 0.0;
                            }
                            long l5 = agiAdmStatistics.getHitCount();
                            long l6 = agiAdmStatistics.getEmittedBytes();
                            long l7 = agiAdmStatistics.getMeanRequestTime();
                            long l8 = agiAdmStatistics.getMaxRequestTime();
                            long l9 = agiAdmStatistics.getFreeMemory();
                            long l10 = agiAdmStatistics.getTotalMemory();
                            long l11 = l10 - l9;
                            double d3 = l11 * 100L / l10;
                            int n2 = 0;
                            int n3 = 0;
                            while (enumeration.hasMoreElements()) {
                                ++n3;
                                AgiAdmSession agiAdmSession = (AgiAdmSession)enumeration.nextElement();
                                if (!agiAdmSession.getState().equalsIgnoreCase("Busy")) {
                                    ++n2;
                                }
                                agiAdmSession = null;
                            }
                            --n3;
                            System.out.print("ServerUsageMetric=" + n);
                            System.out.print(",UsedThreadPct=" + d);
                            System.out.print(",IdleThreadPct=" + d2);
                            System.out.print(",HitCount=" + l5);
                            System.out.print(",MeanResponseTime=" + l7);
                            System.out.print(",MaxResponseTime=" + l8);
                            System.out.print(",EmittedBytes=" + l6);
                            System.out.print(",MemoryUtil=" + d3);
                            System.out.print(",TotalSessCount=" + n3);
                            System.out.print(",IdleSessCount=" + n2);
                            break block12;
                        }
                        catch (Exception exception) {
                            System.out.println("ErrorMsg=FailedToGetMeasure");
                            Object var41_12 = null;
                            agiAdmServer = null;
                            agiAdmStatistics = null;
                            enumeration = null;
                            egLoginHandler = null;
                            if (agrServerSession == null) return;
                            agrServerSession.close();
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var41_13 = null;
                        agiAdmServer = null;
                        agiAdmStatistics = null;
                        enumeration = null;
                        egLoginHandler = null;
                        if (agrServerSession == null) throw throwable;
                        agrServerSession.close();
                        throw throwable;
                    }
                }
                agrServerSession.close();
                return;
            }
            Object var41_10 = null;
            agiAdmServer = null;
            agiAdmStatistics = null;
            enumeration = null;
            egLoginHandler = null;
            if (agrServerSession == null) return;
            agrServerSession.close();
            return;
        }
        Object var41_11 = null;
        agiAdmServer = null;
        agiAdmStatistics = null;
        enumeration = null;
        egLoginHandler = null;
        if (agrServerSession == null) return;
        agrServerSession.close();
    }

    private boolean checkForTimeout(EgSsHelperThread egSsHelperThread) {
        long l;
        long l2 = this.codeTimeout;
        long l3 = 0L;
        long l4 = 100L;
        do {
            this.threadSleep(l4);
            if (egSsHelperThread.done) {
                return true;
            }
            if ((l3 += l4) >= l2) {
                egSsHelperThread.interrupt();
                Thread.currentThread();
                Thread.yield();
                egSsHelperThread.stop();
                return false;
            }
            l = l4 * 2L;
            if (l2 - l3 >= l) continue;
            l = l2 - l3;
        } while ((l4 = l) > 0L);
        egSsHelperThread.interrupt();
        Thread.currentThread();
        Thread.yield();
        egSsHelperThread.stop();
        return false;
    }

    private void threadSleep(long l) {
        long l2 = System.currentTimeMillis() + l;
        while (l > 0L) {
            block3: {
                try {
                    Thread.sleep(l);
                }
                catch (InterruptedException interruptedException) {
                    long l3 = System.currentTimeMillis();
                    l = l2 - l3;
                    if (l >= 0L) break block3;
                    return;
                }
            }
            long l4 = System.currentTimeMillis();
            l = l2 - l4;
        }
    }
}

