/*
 * Decompiled with CFR 0.152.
 */
import com.egurkha.util.EgUtilities;
import com.ibm.mq.MQC;
import com.ibm.mq.MQException;
import com.ibm.mq.MQGetMessageOptions;
import com.ibm.mq.MQMessage;
import com.ibm.mq.MQQueue;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.pcf.PCFException;
import com.ibm.mq.pcf.PCFMessage;
import com.ibm.mq.pcf.PCFMessageAgent;
import com.ibm.mq.pcf.PCFParameter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Hashtable;

public class EgMq {
    PCFMessageAgent pcfmessageagent;
    MQQueueManager mqQueueManager;
    MQQueueManager qMgr = null;
    MQQueue queue;
    public int numDDMessages = 20;
    public int messageLimit = 1000;
    public boolean messageOverLimit = false;
    EgDateInfo dateInfo = null;
    boolean pcf_init = false;
    String host = null;
    int port = -1;
    String srvConn = null;
    String qmgr = null;
    public double qmgr_avail = 0.0;
    public double qmgr_resp = -1.0;
    public double port_avail = 0.0;
    public double conn_avail = 0.0;
    public Hashtable messageHash = new Hashtable();
    public Hashtable qstats = new Hashtable();
    public Hashtable corruptedQueuestats = new Hashtable();
    private Hashtable htProps = new Hashtable();
    public Hashtable channelstats = new Hashtable();
    String[] lqueues = null;
    String[] channels = null;
    private String user = null;
    private String pass = null;
    private int numQstats = 4;
    private int numChannelstats = 9;
    private Hashtable lastChannelTime = new Hashtable();
    private Hashtable lastChannelSend = new Hashtable();
    private boolean isQMconnect = false;
    boolean ignoreSystemChannels = true;
    ArrayList includeChannelsList = new ArrayList();
    boolean includeChannelsFlag = false;
    ArrayList excludeChannelsList = new ArrayList();
    boolean excludeChannelsFlag = false;
    boolean showInactiveChannels = true;

    private boolean mqConnect() {
        try {
            double d = System.currentTimeMillis();
            this.mqQueueManager = new MQQueueManager(this.qmgr, this.htProps);
            double d2 = System.currentTimeMillis();
            this.qmgr_avail = 100.0;
            this.qmgr_resp = (d2 - d) / 1000.0;
            this.isQMconnect = true;
            return true;
        }
        catch (MQException mQException) {
            this.logToErrorFile("ERROR", "EgMq.mqConnect()", "Unable to Connect Queue Manager " + this.qmgr);
            System.out.println("Error in queue manager connect....");
            System.out.println("QMGR Name : " + this.qmgr);
            System.out.println("CC   : " + mQException.completionCode);
            System.out.println("RC   : " + mQException.reasonCode);
            mQException.printStackTrace();
            System.out.println("[EgMq]Mqconnect host:" + this.host + " " + new Date());
            System.out.println("[EgMq]Mqconnect Port:" + this.port + " " + new Date());
            System.out.println("[EgMq]Mqconnect user:" + this.user + " " + new Date());
            System.out.println("[EgMq]Mqconnect srvConn:" + this.srvConn + " " + new Date());
            this.qmgr_avail = 0.0;
            this.qmgr_resp = -1.0;
            this.isQMconnect = false;
            return false;
        }
        catch (Exception exception) {
            this.logToErrorFile("ERROR", "EgMq.mqConnect()", "Unable to Connect Queue Manager " + this.qmgr);
            System.out.println("Error in queue manager connect....");
            System.out.println("QMGR Name : " + this.qmgr + " " + new Date());
            System.out.println("[EgMq]Mqconnect host:" + this.host + " " + new Date());
            System.out.println("[EgMq]Mqconnect Port:" + this.port + " " + new Date());
            System.out.println("[EgMq]Mqconnect user:" + this.user + " " + new Date());
            System.out.println("[EgMq]Mqconnect srvConn:" + this.srvConn + " " + new Date());
            exception.printStackTrace();
            this.qmgr_avail = 0.0;
            this.qmgr_resp = -1.0;
            this.isQMconnect = false;
            return false;
        }
    }

    private void mqDisconnect() {
        try {
            if (this.mqQueueManager != null) {
                this.mqQueueManager.disconnect();
                this.mqQueueManager = null;
            }
        }
        catch (MQException mQException) {
            this.logToErrorFile("ERROR", "EgMq.mqDisconnect()", "Unable to DisConnect Queue Manager " + this.qmgr);
            System.out.println("Error in queue manager disconnect....");
            System.out.println("QMGR Name : " + this.qmgr);
            System.out.println("CC   : " + mQException.completionCode);
            System.out.println("RC   : " + mQException.reasonCode);
            System.out.println("[EgMq]mqDisconnect host:" + this.host + " " + new Date());
            System.out.println("[EgMq]mqDisconnect Port:" + this.port + " " + new Date());
            System.out.println("[EgMq]mqDisconnect user:" + this.user + " " + new Date());
            System.out.println("[EgMq]mqDisconnect srvConn:" + this.srvConn + " " + new Date());
            mQException.printStackTrace();
        }
        catch (Exception exception) {
            this.logToErrorFile("ERROR", "EgMq.mqDisconnect()", "Unable to DisConnect Queue Manager " + this.qmgr);
            System.out.println("Error in QManager disconnect ");
            System.out.println("[EgMq]mqDisconnect host:" + this.host + " " + new Date());
            System.out.println("[EgMq]mqDisconnect Port:" + this.port + " " + new Date());
            System.out.println("[EgMq]mqDisconnect user:" + this.user + " " + new Date());
            System.out.println("[EgMq]mqDisconnect srvConn:" + this.srvConn + " " + new Date());
            exception.printStackTrace();
        }
        this.isQMconnect = false;
    }

    public boolean isOpen() {
        return this.doesSocketExist(this.host, this.port, 15000);
    }

    private boolean doesSocketExist(String string, int n, int n2) {
        long l;
        TcpHelperThread tcpHelperThread = new TcpHelperThread(string, n, n2);
        long l2 = 0L;
        long l3 = 10L;
        do {
            this.suspendForPeriod(l3);
            if (tcpHelperThread.done) {
                this.logToErrorFile("INFO :", "EgMq.doesSocketExist()", "TcpHelperThread complete the process and status : " + tcpHelperThread.status);
                return tcpHelperThread.status;
            }
            if ((l2 += l3) >= (long)n2) {
                tcpHelperThread.interrupt();
                this.logToErrorFile("WARNING :", "EgMq.doesSocketExist()", "totalSleepTime  : " + l2 + " timeOut: " + n2 + "  TcpHelperThread interrupt the process and doesSocketExist method returned as  false ");
                Thread.currentThread();
                Thread.yield();
                tcpHelperThread = null;
                return false;
            }
            l = l3;
            if ((long)n2 - l2 >= l) continue;
            l = (long)n2 - l2;
        } while ((l3 = l) > 0L);
        tcpHelperThread.interrupt();
        this.logToErrorFile("WARNING :", "EgMq.doesSocketExist()", "sleepTime  : " + l3 + "  TcpHelperThread interrupt the process and and doesSocketExist method returned as  false  ");
        Thread.currentThread();
        Thread.yield();
        tcpHelperThread = null;
        return false;
    }

    private void suspendForPeriod(long l) {
        long l2 = System.currentTimeMillis() + l;
        while (l > 0L) {
            try {
                Thread.currentThread();
                Thread.sleep(l);
            }
            catch (Exception exception) {
                this.logToErrorFile("ERROR :", "EgMq.suspendForPeriod()", "sleepPeriod  : " + l + "  exception raised in the  Thread.currentThread().sleep method   ");
            }
            long l3 = System.currentTimeMillis();
            l = l2 - l3;
        }
    }

    public void checkPorts() {
        this.port_avail = 0.0;
        this.conn_avail = 0.0;
        boolean bl = this.isOpen();
        if (!bl) {
            return;
        }
        this.port_avail = 100.0;
        bl = this.initPcf();
        if (!bl) {
            return;
        }
        this.conn_avail = 100.0;
    }

    public static void main(String[] stringArray) {
        EgMq egMq = new EgMq();
        if (stringArray.length < 2) {
            System.out.println("Args: ip port srvrConnection");
            return;
        }
        int n = Integer.parseInt(stringArray[1]);
        if (stringArray.length < 3) {
            egMq.setAttributes(stringArray[0], n, "SYSTEM.DEF.SVRCONN");
        } else if (stringArray.length < 5) {
            egMq.setAttributes(stringArray[0], n, stringArray[2]);
        } else {
            egMq.setAttributes(stringArray[0], n, stringArray[2], stringArray[3], stringArray[4]);
        }
        egMq.checkPorts();
        System.out.println("CheckPorts: " + egMq.port_avail + " " + egMq.conn_avail);
        egMq.checkQmgr(true);
        System.out.println("QueueManager: " + egMq.qmgr + " " + egMq.qmgr_avail + " " + egMq.qmgr_resp);
        egMq.checkQueues();
        egMq.checkChannels();
        egMq.end();
        egMq.printResults(egMq.qstats, "*********** QUEUE STATS *************", egMq.numQstats);
        egMq.printResults(egMq.channelstats, "*********** CHANNEL STATS *************", egMq.numChannelstats);
    }

    public void printResults(Hashtable hashtable, String string, int n) {
        System.out.println(string);
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            double[] dArray = (double[])hashtable.get(string2);
            if (dArray == null || dArray.length < n) continue;
            String string3 = "";
            for (int i = 0; i < n; ++i) {
                string3 = string3 + dArray[i] + " ";
            }
            System.out.println(string2 + " --- " + string3);
        }
    }

    public void checkChannels() {
        try {
            String string;
            int n;
            this.channelstats = new Hashtable();
            if (!this.pcf_init) {
                this.initPcf();
            }
            if (!this.pcf_init) {
                this.endPcf();
                return;
            }
            try {
                this.getChannelnames();
            }
            catch (Exception exception) {
                this.logToErrorFile("ERROR", "EgMq.checkChannels()", "Unable to get Channel Names " + exception.toString());
            }
            if (this.channels == null) {
                this.endPcf();
                return;
            }
            for (n = 0; n < this.channels.length; ++n) {
                string = this.channels[n].trim();
                double[] dArray = this.getChannelStatus(string);
                if (dArray != null) {
                    this.channelstats.put(string, dArray);
                    continue;
                }
                boolean bl = false;
                if (this.includeChannelToList(string)) {
                    bl = true;
                } else if (!this.excludeChannelToList(string) && this.showInactiveChannels && !this.ignoreSystemChannelToList(string)) {
                    bl = true;
                }
                if (!bl) continue;
                dArray = this.getInactiveChannelStatus();
                this.channelstats.put(string, dArray);
            }
            for (n = 0; n < this.channels.length; ++n) {
                string = this.channels[n].trim();
                if (!this.excludeChannelToList(string) || this.includeChannelToList(string)) continue;
                this.channelstats.remove(string);
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("ERROR", "EgMq.checkChannels()", "Unable to get Channel Names " + exception.toString());
            exception.printStackTrace();
        }
    }

    public void checkChannels(boolean bl) {
        try {
            if (!bl) {
                this.checkChannels();
            } else {
                this.getChannelStatusV6();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Hashtable peekQueues() {
        Hashtable<String, ArrayList> hashtable = new Hashtable<String, ArrayList>();
        try {
            this.checkQmgr(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.qmgr == null) {
            return null;
        }
        if (this.mqConnect()) {
            try {
                this.lqueues = this.getQnames();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.lqueues == null) {
                this.mqDisconnect();
                return null;
            }
            try {
                for (int i = 0; i < this.lqueues.length; ++i) {
                    ArrayList arrayList = this.mqPeek(this.lqueues[i]);
                    if (arrayList == null || arrayList.size() == 0) {
                        hashtable.put(this.lqueues[i], new ArrayList());
                        continue;
                    }
                    hashtable.put(this.lqueues[i], arrayList);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mqDisconnect();
        }
        return hashtable;
    }

    public Hashtable peekQueues(boolean bl, ArrayList arrayList) {
        Hashtable<String, ArrayList> hashtable = new Hashtable<String, ArrayList>();
        if (this.messageHash != null) {
            this.messageHash.clear();
        }
        try {
            this.checkQmgr(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.qmgr == null) {
            return null;
        }
        if (this.mqConnect()) {
            try {
                this.lqueues = this.getQnames();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.lqueues == null) {
                this.mqDisconnect();
                return null;
            }
            try {
                String string = "";
                for (int i = 0; i < this.lqueues.length; ++i) {
                    if (this.lqueues[i] == null) continue;
                    string = this.lqueues[i].trim().toLowerCase();
                    if (bl && string.startsWith("system.")) continue;
                    if (arrayList != null && arrayList.size() > 0) {
                        boolean bl2 = false;
                        for (int j = 0; j < arrayList.size(); ++j) {
                            String string2 = (String)arrayList.get(j);
                            if (!EgUtilities.isMatch((String)string, (String)string2)) continue;
                            bl2 = true;
                            break;
                        }
                        if (bl2) continue;
                        ArrayList arrayList2 = this.mqPeek(this.lqueues[i]);
                        if (arrayList2 == null || arrayList2.size() == 0) {
                            hashtable.put(this.lqueues[i], new ArrayList());
                            continue;
                        }
                        hashtable.put(this.lqueues[i], arrayList2);
                        continue;
                    }
                    ArrayList arrayList3 = this.mqPeek(this.lqueues[i]);
                    if (arrayList3 == null || arrayList3.size() == 0) {
                        hashtable.put(this.lqueues[i], new ArrayList());
                        continue;
                    }
                    hashtable.put(this.lqueues[i], arrayList3);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mqDisconnect();
        }
        return hashtable;
    }

    public Hashtable peekQueues(boolean bl, ArrayList arrayList, boolean bl2) {
        Hashtable<String, ArrayList> hashtable = new Hashtable<String, ArrayList>();
        if (this.messageHash != null) {
            this.messageHash.clear();
        }
        try {
            this.checkQmgr(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.qmgr == null) {
            this.endPcf();
            return null;
        }
        if (this.mqConnect()) {
            try {
                this.lqueues = this.getQnames();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.lqueues == null) {
                this.mqDisconnect();
                this.endPcf();
                return null;
            }
            try {
                String string = "";
                if (arrayList != null && arrayList.size() > 0) {
                    for (int i = 0; i < arrayList.size(); ++i) {
                        String string2 = (String)arrayList.get(i);
                        for (int j = 0; j < this.lqueues.length; ++j) {
                            if (this.lqueues[j] == null) continue;
                            string = this.lqueues[j].trim().toLowerCase();
                            if (bl && string.startsWith("system.") || !EgUtilities.isMatch((String)string, (String)string2)) continue;
                            ArrayList arrayList2 = this.mqPeek(this.lqueues[j]);
                            if (arrayList2 == null || arrayList2.size() == 0) {
                                hashtable.put(this.lqueues[j], new ArrayList());
                                continue;
                            }
                            hashtable.put(this.lqueues[j], arrayList2);
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mqDisconnect();
            this.endPcf();
        }
        return hashtable;
    }

    public void checkQueues() {
        this.qstats = new Hashtable();
        this.corruptedQueuestats = new Hashtable();
        try {
            this.checkQmgr(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.qmgr == null) {
            return;
        }
        if (this.mqConnect()) {
            this.lqueues = this.getQnames();
            if (this.lqueues == null) {
                this.mqDisconnect();
                return;
            }
            for (int i = 0; i < this.lqueues.length; ++i) {
                Object object;
                if (this.mqOpen(this.lqueues[i])) {
                    try {
                        object = this.mqStats(this.lqueues[i]);
                        if (object != null) {
                            this.qstats.put(this.lqueues[i], object);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    this.mqClose(this.lqueues[i]);
                    continue;
                }
                object = new ArrayList();
                try {
                    int n = 0;
                    n = 40;
                    this.queue = this.mqQueueManager.accessQueue(this.lqueues[i], n, null, null, null);
                }
                catch (MQException mQException) {
                    System.out.println("Error in opening queue ....");
                    System.out.println("Queue Name : " + this.lqueues[i]);
                    System.out.println("CC   : " + mQException.completionCode);
                    System.out.println("RC   : " + mQException.reasonCode);
                    ((ArrayList)object).add("" + mQException.completionCode);
                    ((ArrayList)object).add("" + mQException.reasonCode);
                    String string = null;
                    try {
                        StringWriter stringWriter = new StringWriter();
                        PrintWriter printWriter = new PrintWriter(stringWriter);
                        mQException.printStackTrace(printWriter);
                        string = stringWriter.toString();
                        printWriter.close();
                    }
                    catch (Exception exception) {
                        string = mQException.toString();
                    }
                    System.out.println(string);
                    ((ArrayList)object).add(string);
                    mQException.printStackTrace();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                double[] dArray = new double[]{-5.0, 1.0, -5.0, -5.0, -5.0, -5.0, 0.0};
                this.qstats.put(this.lqueues[i], dArray);
                this.corruptedQueuestats.put(this.lqueues[i], object);
                this.logToErrorFile("ERROR", "checkQueus", "Unable to open Queue or Queue corrupted " + this.lqueues[i]);
                System.out.println("[ERROR] checkQueus : Unable to open Queue or Queue corrupted " + this.lqueues[i]);
            }
            this.mqDisconnect();
        }
    }

    public HashMap checkQueues(boolean bl, ArrayList arrayList) {
        this.qstats = new Hashtable();
        this.corruptedQueuestats = new Hashtable();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        try {
            this.checkQmgr(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.qmgr == null) {
            this.endPcf();
            return null;
        }
        if (this.mqConnect()) {
            this.lqueues = this.getQnames();
            if (this.lqueues == null) {
                this.mqDisconnect();
                this.endPcf();
                return null;
            }
            String string = "";
            for (int i = 0; i < this.lqueues.length; ++i) {
                String string2;
                int n;
                if (this.lqueues[i] == null) continue;
                string = this.lqueues[i].trim().toLowerCase();
                this.lqueues[i] = this.lqueues[i].trim();
                if (bl && string.startsWith("system.")) continue;
                if (arrayList != null && arrayList.size() > 0) {
                    boolean bl2 = false;
                    for (n = 0; n < arrayList.size(); ++n) {
                        string2 = (String)arrayList.get(n);
                        if (!EgUtilities.isMatch((String)string, (String)string2)) continue;
                        bl2 = true;
                        break;
                    }
                    if (bl2) continue;
                }
                if (this.mqOpen(this.lqueues[i])) {
                    Object object;
                    try {
                        object = this.mqStats(this.lqueues[i]);
                        if (object != null) {
                            this.qstats.put(this.lqueues[i], object);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    this.mqClose(this.lqueues[i]);
                    try {
                        object = this.mqPeek(this.lqueues[i]);
                        if (object == null || ((ArrayList)object).size() <= 0) continue;
                        hashMap.put(this.lqueues[i], object);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    continue;
                }
                ArrayList<String> arrayList2 = new ArrayList<String>();
                try {
                    n = 0;
                    n = 40;
                    this.queue = this.mqQueueManager.accessQueue(this.lqueues[i], n, null, null, null);
                }
                catch (MQException mQException) {
                    System.out.println("Error in opening queue ....");
                    System.out.println("Queue Name : " + this.lqueues[i]);
                    System.out.println("CC   : " + mQException.completionCode);
                    System.out.println("RC   : " + mQException.reasonCode);
                    arrayList2.add("" + mQException.completionCode);
                    arrayList2.add("" + mQException.reasonCode);
                    string2 = null;
                    try {
                        StringWriter stringWriter = new StringWriter();
                        PrintWriter printWriter = new PrintWriter(stringWriter);
                        mQException.printStackTrace(printWriter);
                        string2 = stringWriter.toString();
                        printWriter.close();
                    }
                    catch (Exception exception) {
                        string2 = mQException.toString();
                    }
                    arrayList2.add(string2);
                    mQException.printStackTrace();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                double[] dArray = new double[]{-5.0, 1.0, -5.0, -5.0, -5.0, -5.0, 0.0};
                this.qstats.put(this.lqueues[i], dArray);
                this.corruptedQueuestats.put(this.lqueues[i], arrayList2);
                this.logToErrorFile("ERROR", "checkQueus", "Unable to open Queue or Queue corrupted " + this.lqueues[i]);
                System.out.println("[ERROR] checkQueus : Unable to open Queue or Queue corrupted " + this.lqueues[i]);
            }
            this.mqDisconnect();
            this.endPcf();
        }
        return hashMap;
    }

    public HashMap checkQueues(boolean bl, ArrayList arrayList, boolean bl2) {
        this.qstats = new Hashtable();
        this.corruptedQueuestats = new Hashtable();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        try {
            this.checkQmgr(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.qmgr == null) {
            return null;
        }
        if (this.mqConnect()) {
            this.lqueues = this.getQnames();
            if (this.lqueues == null) {
                this.mqDisconnect();
                this.endPcf();
                return null;
            }
            String string = "";
            if (arrayList != null && arrayList.size() > 0) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    String string2 = (String)arrayList.get(i);
                    for (int j = 0; j < this.lqueues.length; ++j) {
                        Object object;
                        if (this.lqueues[j] == null) continue;
                        string = this.lqueues[j].trim().toLowerCase();
                        this.lqueues[j] = this.lqueues[j].trim();
                        if (bl && string.startsWith("system.") || !EgUtilities.isMatch((String)string, (String)string2)) continue;
                        if (this.mqOpen(this.lqueues[j])) {
                            try {
                                object = this.mqStats(this.lqueues[j]);
                                if (object != null) {
                                    this.qstats.put(this.lqueues[j], object);
                                }
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                            this.mqClose(this.lqueues[j]);
                            try {
                                object = this.mqPeek(this.lqueues[j]);
                                if (object == null || ((ArrayList)object).size() <= 0) continue;
                                hashMap.put(this.lqueues[j], object);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                            continue;
                        }
                        object = new ArrayList();
                        try {
                            int n = 0;
                            n = 40;
                            this.queue = this.mqQueueManager.accessQueue(this.lqueues[j], n, null, null, null);
                        }
                        catch (MQException mQException) {
                            System.out.println("Error in opening queue ....");
                            System.out.println("Queue Name : " + this.lqueues[j]);
                            System.out.println("CC   : " + mQException.completionCode);
                            System.out.println("RC   : " + mQException.reasonCode);
                            ((ArrayList)object).add("" + mQException.completionCode);
                            ((ArrayList)object).add("" + mQException.reasonCode);
                            String string3 = null;
                            try {
                                StringWriter stringWriter = new StringWriter();
                                PrintWriter printWriter = new PrintWriter(stringWriter);
                                mQException.printStackTrace(printWriter);
                                string3 = stringWriter.toString();
                                printWriter.close();
                            }
                            catch (Exception exception) {
                                string3 = mQException.toString();
                            }
                            ((ArrayList)object).add(string3);
                            mQException.printStackTrace();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        double[] dArray = new double[]{-5.0, 1.0, -5.0, -5.0, -5.0, -5.0, 0.0};
                        this.qstats.put(this.lqueues[j], dArray);
                        this.corruptedQueuestats.put(this.lqueues[j], object);
                        this.logToErrorFile("ERROR", "checkQueus", "Unable to open Queue or Queue corrupted " + this.lqueues[j]);
                        System.out.println("[ERROR] checkQueus : Unable to open Queue or Queue corrupted " + this.lqueues[j]);
                    }
                }
            }
            this.mqDisconnect();
            this.endPcf();
        }
        return hashMap;
    }

    public ArrayList mqPeek(String string) {
        ArrayList arrayList = new ArrayList();
        if (this.qmgr == null) {
            return arrayList;
        }
        boolean bl = false;
        if (!this.isQMconnect) {
            bl = true;
            if (!this.mqConnect()) {
                return arrayList;
            }
        }
        if (this.mqOpenPeek(string)) {
            try {
                arrayList = this.mqBrowse(string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.mqClose(string);
        }
        if (bl) {
            this.mqDisconnect();
        }
        return arrayList;
    }

    public ArrayList mqBrowse(String string) {
        double d = 0.0;
        try {
            d = this.queue.getCurrentDepth();
        }
        catch (MQException mQException) {
            this.logToErrorFile("INFO", "EgMq.browseQueue for queue " + string, "MQ exception: CC = " + mQException.completionCode + " RC = " + mQException.reasonCode + " " + mQException.toString());
            mQException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.messageHash.put(string, new Double(d));
        this.messageOverLimit = d >= (double)this.messageLimit;
        int n = 0;
        MQGetMessageOptions mQGetMessageOptions = new MQGetMessageOptions();
        mQGetMessageOptions.options = 17;
        MQMessage mQMessage = new MQMessage();
        boolean bl = false;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        do {
            try {
                Object object;
                int n2;
                mQMessage.clearMessage();
                mQMessage.correlationId = MQC.MQCI_NONE;
                mQMessage.messageId = MQC.MQMI_NONE;
                this.queue.get(mQMessage, mQGetMessageOptions);
                GregorianCalendar gregorianCalendar = mQMessage.putDateTime;
                Date date = gregorianCalendar.getTime();
                String string2 = "";
                byte[] byArray = mQMessage.messageId;
                String string3 = "";
                for (n2 = 0; n2 < byArray.length; ++n2) {
                    if (byArray[n2] >= 0 && byArray[n2] <= 31 || byArray[n2] == 127) continue;
                    char c = (char)byArray[n2];
                    object = "" + c;
                    string3 = string3 + (String)object;
                }
                string2 = string3.endsWith("(") ? string3.substring(0, string3.indexOf("(")) : string3;
                n2 = string2.indexOf("\n");
                if (n2 >= 0) {
                    string2 = string2.substring(0, n2);
                }
                String string4 = new String(mQMessage.correlationId);
                object = new ArrayList();
                ((ArrayList)object).add(date);
                ((ArrayList)object).add(string2.trim());
                ((ArrayList)object).add(string4.trim());
                ((ArrayList)object).add(mQMessage.putApplicationName.trim());
                ((ArrayList)object).add(new Long(mQMessage.messageSequenceNumber));
                ((ArrayList)object).add(mQMessage.userId.trim());
                int n3 = -1;
                try {
                    n3 = mQMessage.getMessageLength();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ((ArrayList)object).add(new Long(n3));
                arrayList.add(object);
                ++n;
                mQGetMessageOptions.options = 33;
            }
            catch (MQException mQException) {
                this.logToErrorFile("INFO", "EgMq.browseQueue for queue " + string, "MQ exception: CC = " + mQException.completionCode + " RC = " + mQException.reasonCode + " " + mQException.toString());
                bl = true;
            }
            catch (IOException iOException) {
                this.logToErrorFile("INFO", "EgMq.browseQueue For queue " + string, iOException.toString());
                bl = true;
            }
            catch (Exception exception) {
                bl = true;
            }
        } while ((!this.messageOverLimit || this.numDDMessages <= 0 || n < this.numDDMessages) && !bl);
        return arrayList;
    }

    public void end() {
        this.endPcf();
    }

    public void checkQmgr(boolean bl) {
        try {
            System.out.println("pcf_init  value is :" + this.pcf_init);
            if (!this.pcf_init) {
                this.initPcf();
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("ERROR", "EgMq.checkQmgr.initPcf()", "Unable to Init PCF " + exception.toString());
            exception.printStackTrace();
        }
        this.qmgr_avail = 0.0;
        this.qmgr_resp = -1.0;
        this.qmgr = null;
        if (this.pcf_init) {
            this.discoverQmgr();
            if (this.qmgr == null) {
                this.qmgr_avail = 0.0;
                this.qmgr_resp = -1.0;
                return;
            }
            if (bl) {
                this.mqConnect();
                this.mqDisconnect();
            }
        } else {
            this.printOut("WARNING:  EgMq.checkQmgr.initPcf() ,Init PCF value is  " + this.pcf_init);
        }
    }

    public boolean discoverQmgr() {
        PCFMessage pCFMessage;
        int n = 2015;
        if (this.pcfmessageagent == null) {
            this.logToErrorFile("ERROR", "EgMq.discoverQmgr()", "PCF message agent is null ,So unable to discover Qmanagers  ");
            System.out.println("EgMq.discoverQmgr() : PCF message agent is null ,So unable to discover Qmanagers  ");
            this.endPcf();
            this.qmgr = null;
            return false;
        }
        try {
            pCFMessage = new PCFMessage(2);
            pCFMessage.addParameter(1001, new int[]{n});
        }
        catch (Exception exception) {
            this.logToErrorFile("ERROR", "EgMq.discoverQmgr()", "Unable to discover Qmanagers  " + exception.toString());
            System.out.println("Unable to discover Qmanagers ");
            exception.printStackTrace();
            return false;
        }
        this.qmgr = null;
        try {
            PCFMessage[] pCFMessageArray = this.pcfmessageagent.send(pCFMessage);
            Enumeration enumeration = pCFMessageArray[0].getParameters();
            while (enumeration.hasMoreElements()) {
                PCFParameter pCFParameter = (PCFParameter)enumeration.nextElement();
                if (pCFParameter.getParameter() != n) continue;
                this.qmgr = (String)pCFParameter.getValue();
                this.qmgr = this.qmgr.trim();
            }
            return true;
        }
        catch (PCFException pCFException) {
            PCFMessage[] pCFMessageArray = (PCFMessage[])pCFException.exceptionSource;
            for (int i = 0; i < pCFMessageArray.length; ++i) {
                this.logToErrorFile("ERROR", "EgMq.discoverQmgr()", "Unable to discover Qmanagers  " + pCFMessageArray[i].toString());
                System.out.println(pCFMessageArray[i].toString());
            }
            pCFException.printStackTrace();
            return false;
        }
        catch (Exception exception) {
            this.logToErrorFile("ERROR", "EgMq.discoverQmgr()", "Unable to discover Qmanagers  " + exception.toString());
            exception.printStackTrace();
            return false;
        }
    }

    public void init() {
        try {
            this.htProps.put("hostname", this.host);
            this.htProps.put("channel", this.srvConn);
            this.htProps.put("port", new Integer(this.port));
            System.out.println("htProps " + this.htProps);
            if (this.user != null && !this.user.equalsIgnoreCase("none")) {
                this.htProps.put("userID", this.user);
            }
            if (this.pass != null && !this.pass.equalsIgnoreCase("none")) {
                this.htProps.put("password", this.pass);
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("ERROR", "EgMq.discoverQmgr()", "Unable to discover Qmanagers  " + exception.toString());
            exception.printStackTrace();
        }
    }

    public void setAttributes(String string, int n, String string2) {
        this.host = string;
        this.port = n;
        this.srvConn = string2;
        this.init();
    }

    public void setAttributes(String string, int n, String string2, String string3, String string4) {
        this.host = string;
        this.port = n;
        this.srvConn = string2;
        this.user = string3;
        this.pass = string4;
        this.init();
    }

    public boolean initPcf() {
        int n;
        PCFMessage[] pCFMessageArray;
        String string = "[initPcf] :";
        String string2 = null;
        this.end();
        try {
            this.qMgr = new MQQueueManager(null, this.htProps);
            this.printOut(string + " QManager object  :" + this.qMgr);
        }
        catch (PCFException pCFException) {
            pCFMessageArray = (PCFMessage[])pCFException.exceptionSource;
            for (n = 0; n < pCFMessageArray.length; ++n) {
                this.printOut(string + "  " + pCFMessageArray[n].toString());
            }
            string2 = string + "Exception  while create MQQueuemanager object :";
            this.printOut(string2 + (Object)((Object)pCFException));
            string2 = null;
        }
        catch (MQException mQException) {
            string2 = string + "Exception  while create MQQueuemanager object :";
            this.printOut(string2 + (Object)((Object)mQException));
            string2 = null;
        }
        catch (Exception exception) {
            string2 = string + "General exception caused :";
            this.printOut(string2 + exception);
            string2 = null;
        }
        if (this.qMgr == null) {
            this.printOut(string + " Qmanager instance  is null, so returning with null data");
            this.endPcf();
            this.pcf_init = false;
            return false;
        }
        try {
            this.pcfmessageagent = new PCFMessageAgent(this.qMgr);
            this.printOut(string + " PCFMessageAgent object  :" + this.pcfmessageagent);
        }
        catch (PCFException pCFException) {
            pCFMessageArray = (PCFMessage[])pCFException.exceptionSource;
            for (n = 0; n < pCFMessageArray.length; ++n) {
                this.printOut(string + "  " + pCFMessageArray[n].toString());
            }
            string2 = string + "";
            this.printOut(string2 + (Object)((Object)pCFException));
            string2 = null;
        }
        catch (MQException mQException) {
            string2 = string + "Message Agent is null!  :";
            this.printOut(string2 + (Object)((Object)mQException));
            string2 = null;
        }
        catch (Exception exception) {
            string2 = string + "General exception caused :";
            this.printOut(string2 + exception);
            string2 = null;
        }
        if (this.pcfmessageagent == null) {
            this.printOut(string + " pcfmessageagent is null, so returning with null data");
            this.endPcf();
            this.pcf_init = false;
            return false;
        }
        this.pcf_init = true;
        return true;
    }

    void printOut(String string) {
        System.out.println("DEBUG : [" + this.getClass().getName() + "]:" + string);
    }

    public void endPcf() {
        if (this.pcfmessageagent != null) {
            try {
                this.pcfmessageagent.disconnect();
                this.pcfmessageagent = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (this.qMgr != null) {
            try {
                this.qMgr.disconnect();
                this.qMgr = null;
            }
            catch (Exception exception) {
                this.logToErrorFile("ERROR", "EgMq.endPcf()", "Unable to DisConnect Queue Manager ");
                System.out.println("ERROR   EgMq.endPcf()   Unable to DisConnect Queue Manager ");
                exception.printStackTrace();
            }
        }
        this.pcf_init = false;
    }

    private boolean isValidDateTime(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        if (string.trim().length() < 8) {
            return false;
        }
        return string2.trim().length() >= 8;
    }

    private double calcTimeDiff(String string, String string2, String string3, String string4) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh.mm.ss");
        double d = -1.0;
        if (string.length() == 0 || string2.length() == 0) {
            return -1.0;
        }
        try {
            Date date = simpleDateFormat.parse(string + " " + string2);
            Date date2 = simpleDateFormat.parse(string3 + " " + string4);
            long l = date.getTime();
            long l2 = date2.getTime();
            d = (double)(l2 - l) / 1000.0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return d;
    }

    public double[] getInactiveChannelStatus() {
        double[] dArray = new double[9];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = -5.0;
        }
        dArray[8] = 0.0;
        return dArray;
    }

    public double[] getChannelStatus(String string) {
        Long l;
        Object object;
        Object object2;
        Object var2_2 = null;
        if (this.pcfmessageagent == null) {
            return null;
        }
        double d = -1.0;
        PCFMessage[] pCFMessageArray = null;
        int[] nArray = new int[]{3525, 3524};
        try {
            object2 = new PCFMessage(42);
            object2.addParameter(3501, string);
            object2.addParameter(1524, nArray);
            try {
                pCFMessageArray = this.pcfmessageagent.send(object2);
            }
            catch (PCFException pCFException) {
                this.logToErrorFile("ERROR", "EgMq.getChannelStatus", "Unable to add pcf paramter  " + pCFException.toString());
                return null;
            }
            catch (MQException mQException) {
                this.logToErrorFile("ERROR", "EgMq.getChannelStatus", "MQExeception   " + mQException.toString());
            }
            catch (IOException iOException) {
                this.logToErrorFile("ERROR", "EgMq.getChannelStatus", "IOExeception   " + iOException.toString());
                iOException.printStackTrace();
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("ERROR", "EgMq.getChannelStatus", "Unable to add pcf paramter  " + exception.toString());
            return null;
        }
        try {
            object2 = (String)pCFMessageArray[0].getParameterValue(nArray[0]);
            object = (String)pCFMessageArray[0].getParameterValue(nArray[1]);
            String string2 = (String)this.lastChannelTime.get(string);
            if (this.isValidDateTime((String)object2, (String)object)) {
                String string3 = (String)object2 + " " + (String)object;
                if (string2 != null && !string3.equals(string2)) {
                    this.lastChannelSend.put(string, new Long(System.currentTimeMillis()));
                    this.lastChannelTime.put(string, string3);
                    d = 0.0;
                } else {
                    l = (Long)this.lastChannelSend.get(string);
                    if (l == null) {
                        this.lastChannelSend.put(string, new Long(System.currentTimeMillis()));
                        d = -1.0;
                    } else {
                        d = System.currentTimeMillis() - l;
                        d = d < 0.0 ? -1.0 : d / 1000.0;
                    }
                    this.lastChannelTime.put(string, string3);
                }
            } else {
                d = -1.0;
                this.lastChannelTime.remove(string);
                this.lastChannelSend.remove(string);
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("ERROR", "EgMq.getChannelStatus", "Unable to collect channel last message time  " + exception.toString());
            return null;
        }
        try {
            PCFMessage[] pCFMessageArray2;
            object2 = new PCFMessage(42);
            object2.addParameter(3501, string);
            try {
                pCFMessageArray2 = this.pcfmessageagent.send(object2);
            }
            catch (Exception exception) {
                this.logToErrorFile("ERROR", "EgMq.getChannelStatus", "Unable to collect channel status  " + exception.toString());
                return null;
            }
            object = new double[9];
            for (int i = 0; i < ((Object)object).length; ++i) {
                object[i] = 0.0;
            }
            object[7] = d;
            Enumeration enumeration = pCFMessageArray2[0].getParameters();
            boolean bl = false;
            while (enumeration.hasMoreElements()) {
                l = (PCFParameter)enumeration.nextElement();
                int n = -1;
                double d2 = -1.0;
                try {
                    n = l.getParameter();
                    if (n != 1539 && n != 1538 && n != 1536 && n != 1535 && n != 1527 && n != 1531 && n != 1534) continue;
                    Integer n2 = (Integer)l.getValue();
                    d2 = n2.intValue();
                }
                catch (Exception exception) {
                    continue;
                }
                if (n == 1539) {
                    bl = true;
                    object[0] = d2;
                    continue;
                }
                if (n == 1538) {
                    bl = true;
                    object[1] = d2;
                    continue;
                }
                if (n == 1536) {
                    object[2] = d2;
                    bl = true;
                    continue;
                }
                if (n == 1535) {
                    object[3] = d2;
                    bl = true;
                    continue;
                }
                if (n == 1527) {
                    bl = true;
                    object[4] = d2;
                    object[8] = d2;
                    continue;
                }
                if (n == 1531) {
                    bl = true;
                    object[5] = d2;
                    continue;
                }
                if (n != 1534) continue;
                object[6] = d2;
                bl = true;
            }
            if (bl) {
                return object;
            }
            return null;
        }
        catch (Exception exception) {
            this.logToErrorFile("ERROR", "EgMq.getChannelStatus", "Unable to channel details  " + exception.toString());
            return null;
        }
    }

    public String[] getChannelnames() {
        this.channels = null;
        try {
            PCFMessage pCFMessage = new PCFMessage(20);
            pCFMessage.addParameter(3501, "*");
            pCFMessage.addParameter(1511, 5);
            PCFMessage[] pCFMessageArray = this.pcfmessageagent.send(pCFMessage);
            this.channels = (String[])pCFMessageArray[0].getParameterValue(3512);
            return this.channels;
        }
        catch (PCFException pCFException) {
            this.logToErrorFile("ERROR", "EgMq.getChannelnames", "Unable to get channel names  " + pCFException.toString());
            PCFMessage[] pCFMessageArray = (PCFMessage[])pCFException.exceptionSource;
            for (int i = 0; i < pCFMessageArray.length; ++i) {
                System.out.println(pCFMessageArray[i].toString());
            }
        }
        catch (MQException mQException) {
            this.logToErrorFile("ERROR", "EgMq.getChannelnames", "Unable to get channel names  " + mQException.toString());
            mQException.printStackTrace();
        }
        catch (IOException iOException) {
            this.logToErrorFile("ERROR", "EgMq.getChannelnames", "Unable to get channel names  " + iOException.toString());
            iOException.printStackTrace();
        }
        catch (Exception exception) {
            this.logToErrorFile("ERROR", "EgMq.getChannelnames", "Unable to get channel names  " + exception.toString());
            exception.printStackTrace();
        }
        return this.channels;
    }

    public String[] getQnames() {
        try {
            PCFMessage pCFMessage = new PCFMessage(18);
            pCFMessage.addParameter(2016, "*");
            pCFMessage.addParameter(20, 1);
            PCFMessage[] pCFMessageArray = this.pcfmessageagent.send(pCFMessage);
            String[] stringArray = (String[])pCFMessageArray[0].getParameterValue(3011);
            return stringArray;
        }
        catch (PCFException pCFException) {
            this.logToErrorFile("ERROR", "EgMq.getQnames", "Unable to get channel names  " + pCFException.toString());
            System.out.println("PCF error: " + (Object)((Object)pCFException));
            pCFException.printStackTrace();
        }
        catch (MQException mQException) {
            this.logToErrorFile("ERROR", "EgMq.getQnames", "Unable to get channel names  " + mQException.toString());
            System.out.println((Object)mQException);
        }
        catch (IOException iOException) {
            this.logToErrorFile("ERROR", "EgMq.getChannelnames", "Unable to get channel names  " + iOException.toString());
            System.out.println(iOException);
        }
        catch (Exception exception) {
            this.logToErrorFile("ERROR", "EgMq.getChannelnames", "Unable to get channel names  " + exception.toString());
            exception.printStackTrace();
        }
        return null;
    }

    private double[] mqStats(String string) {
        double[] dArray = null;
        long l = -1L;
        long l2 = -1L;
        long l3 = -1L;
        int n = -1;
        int n2 = -1;
        long l4 = -1L;
        if (this.queue != null) {
            try {
                l = this.queue.getCurrentDepth();
                l4 = this.queue.getMaximumDepth();
                l2 = this.queue.getOpenInputCount();
                l3 = this.queue.getOpenOutputCount();
                n = this.queue.getInhibitGet();
                n2 = this.queue.getInhibitPut();
                System.out.println("Qname :" + string + "  ,Get message state :" + n + "  ,Put message state :" + n2);
                dArray = new double[]{l, l4, l2, l3, n, n2, 100.0};
                return dArray;
            }
            catch (Exception exception) {
                dArray = new double[]{-1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0};
                return dArray;
            }
        }
        return null;
    }

    private boolean mqOpenPeek(String string) {
        try {
            int n = 0;
            n = 42;
            this.queue = this.mqQueueManager.accessQueue(string, n, null, null, null);
            return true;
        }
        catch (MQException mQException) {
            System.out.println("Error in opening queue ....");
            System.out.println("Queue Name : " + string);
            System.out.println("CC   : " + mQException.completionCode);
            System.out.println("RC   : " + mQException.reasonCode);
            mQException.printStackTrace();
            return false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private boolean mqOpen(String string) {
        try {
            int n = 0;
            n = 40;
            this.queue = this.mqQueueManager.accessQueue(string, n, null, null, null);
            return true;
        }
        catch (MQException mQException) {
            System.out.println("Error in opening queue ....");
            System.out.println("Queue Name : " + string);
            System.out.println("CC   : " + mQException.completionCode);
            System.out.println("RC   : " + mQException.reasonCode);
            mQException.printStackTrace();
            return false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private void mqClose(String string) {
        try {
            if (this.queue != null) {
                this.queue.close();
            }
        }
        catch (MQException mQException) {
            System.out.println("Error in closing queue ....");
            System.out.println("Queue Name : " + string);
            System.out.println("CC   : " + mQException.completionCode);
            System.out.println("RC   : " + mQException.reasonCode);
            mQException.printStackTrace();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setChannelAttributes(boolean bl, boolean bl2, ArrayList arrayList, ArrayList arrayList2) {
        this.ignoreSystemChannels = bl2;
        this.includeChannelsList = arrayList;
        this.excludeChannelsList = arrayList2;
        this.showInactiveChannels = bl;
        if (arrayList != null && !arrayList.isEmpty() && arrayList.size() > 0) {
            this.includeChannelsFlag = true;
        }
        if (arrayList2 != null && !arrayList2.isEmpty() && arrayList2.size() > 0) {
            this.excludeChannelsFlag = true;
        }
    }

    private boolean includeChannelToList(String string) {
        boolean bl = false;
        if (this.includeChannelsFlag) {
            for (int i = 0; i < this.includeChannelsList.size(); ++i) {
                for (int j = 0; j < this.includeChannelsList.size(); ++j) {
                    String string2 = (String)this.includeChannelsList.get(j);
                    String string3 = string.trim().toLowerCase();
                    if (!EgUtilities.isMatch((String)string3, (String)string2)) continue;
                    bl = true;
                }
            }
        }
        return bl;
    }

    private boolean excludeChannelToList(String string) {
        boolean bl = false;
        if (this.excludeChannelsFlag) {
            for (int i = 0; i < this.excludeChannelsList.size(); ++i) {
                for (int j = 0; j < this.excludeChannelsList.size(); ++j) {
                    String string2 = (String)this.excludeChannelsList.get(j);
                    String string3 = string.trim().toLowerCase();
                    if (!EgUtilities.isMatch((String)string3, (String)string2)) continue;
                    bl = true;
                }
            }
        }
        return bl;
    }

    private boolean ignoreSystemChannelToList(String string) {
        boolean bl = false;
        String string2 = string.trim().toLowerCase();
        if (this.ignoreSystemChannels && string2.startsWith("system.")) {
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void getChannelStatusV6() throws Exception {
        int n;
        boolean bl = false;
        this.channelstats = new Hashtable();
        PCFMessageAgent pCFMessageAgent = null;
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        double d = -1.0;
        MQQueueManager mQQueueManager = null;
        PCFMessage pCFMessage = new PCFMessage(42);
        pCFMessage.addParameter(3501, "*");
        pCFMessage.addParameter(1523, 1011);
        int[] nArray = new int[]{3501, 3506, 1534, 3525, 3524, 1527, 1539, 1538, 1536, 1535, 1531};
        pCFMessage.addParameter(1524, nArray);
        String string5 = "[getChannelStatusV6] :";
        String string6 = null;
        try {
            mQQueueManager = new MQQueueManager(null, this.htProps);
            this.printOut(string5 + " QManager object  :" + mQQueueManager);
        }
        catch (PCFException pCFException) {
            PCFMessage[] pCFMessageArray = (PCFMessage[])pCFException.exceptionSource;
            for (n = 0; n < pCFMessageArray.length; ++n) {
                this.printOut(string5 + "  " + pCFMessageArray[n].toString());
            }
            string6 = string5 + "Exception  while create MQQueuemanager object :";
            this.printOut(string6 + (Object)((Object)pCFException));
            string6 = null;
        }
        catch (MQException mQException) {
            string6 = string5 + "Exception  while create MQQueuemanager object :";
            this.printOut(string6 + (Object)((Object)mQException));
            string6 = null;
        }
        catch (Exception exception) {
            string6 = string5 + "General exception caused :";
            this.printOut(string6 + exception);
            string6 = null;
        }
        if (mQQueueManager == null) {
            this.printOut(string5 + " Qmanager instance  is null, so returning with null data");
            if (mQQueueManager == null) return;
            try {
                mQQueueManager.disconnect();
                return;
            }
            catch (Exception exception) {
                this.logToErrorFile("ERROR", "EgMq.getChannelStatusV6()", "Unable to DisConnect Queue Manager ");
                System.out.println("ERROR   EgMq.getChannelStatusV6()   Unable to DisConnect Queue Manager ");
                exception.printStackTrace();
            }
            return;
        }
        try {
            pCFMessageAgent = new PCFMessageAgent(mQQueueManager);
        }
        catch (PCFException pCFException) {
            PCFMessage[] pCFMessageArray = (PCFMessage[])pCFException.exceptionSource;
            for (n = 0; n < pCFMessageArray.length; ++n) {
                this.printOut(string5 + "  " + pCFMessageArray[n].toString());
            }
            string6 = string5 + "";
            this.printOut(string6 + (Object)((Object)pCFException));
            string6 = null;
        }
        catch (MQException mQException) {
            string6 = string5 + "Message Agent is null!  :";
            this.printOut(string6 + (Object)((Object)mQException));
            string6 = null;
        }
        catch (Exception exception) {
            string6 = string5 + "General exception caused :";
            this.printOut(string6 + exception);
            string6 = null;
        }
        if (pCFMessageAgent == null) {
            this.printOut(string5 + " pcfmessageagent is null, so returning with null data");
            if (pCFMessageAgent != null) {
                try {
                    pCFMessageAgent.disconnect();
                    pCFMessageAgent = null;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (mQQueueManager == null) return;
            try {
                mQQueueManager.disconnect();
                return;
            }
            catch (Exception exception) {
                this.logToErrorFile("ERROR", "EgMq.getChannelStatusV6()", "Unable to DisConnect Queue Manager ");
                System.out.println("ERROR   EgMq.getChannelStatusV6()   Unable to DisConnect Queue Manager ");
                exception.printStackTrace();
            }
            return;
        }
        try {
            int n2;
            PCFMessage[] pCFMessageArray = pCFMessageAgent.send(pCFMessage);
            for (int i = 0; i < pCFMessageArray.length; ++i) {
                int n3;
                int n4;
                int n5;
                int n6;
                int n7;
                int n8;
                int n9;
                try {
                    string3 = pCFMessageArray[i].getStringParameterValue(3501);
                    string3 = string3.trim();
                }
                catch (Exception exception) {
                    System.out.println("channel name is null");
                    continue;
                }
                if (string3 == null || string3.trim().length() == 0 || this.channelstats.containsKey(string3)) continue;
                double[] dArray = new double[9];
                for (int j = 0; j < dArray.length; ++j) {
                    dArray[j] = 0.0;
                }
                try {
                    string4 = pCFMessageArray[i].getStringParameterValue(3506);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    string = pCFMessageArray[i].getStringParameterValue(3525);
                    string2 = pCFMessageArray[i].getStringParameterValue(3524);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                try {
                    n9 = pCFMessageArray[i].getIntParameterValue(1539);
                }
                catch (Exception exception) {
                    n9 = -5;
                }
                dArray[0] = n9;
                try {
                    n8 = pCFMessageArray[i].getIntParameterValue(1538);
                }
                catch (Exception exception) {
                    n8 = -5;
                }
                dArray[1] = n8;
                try {
                    n7 = pCFMessageArray[i].getIntParameterValue(1536);
                }
                catch (Exception exception) {
                    n7 = -5;
                }
                dArray[2] = n7;
                try {
                    n6 = pCFMessageArray[i].getIntParameterValue(1535);
                }
                catch (Exception exception) {
                    n6 = -5;
                }
                dArray[3] = n6;
                try {
                    n5 = pCFMessageArray[i].getIntParameterValue(1527);
                }
                catch (Exception exception) {
                    n5 = -5;
                }
                dArray[4] = n5;
                dArray[8] = n5;
                try {
                    n4 = pCFMessageArray[i].getIntParameterValue(1531);
                }
                catch (Exception exception) {
                    n4 = -5;
                }
                dArray[5] = n4;
                try {
                    n3 = pCFMessageArray[i].getIntParameterValue(1534);
                }
                catch (Exception exception) {
                    n3 = -5;
                }
                dArray[6] = n3;
                if (this.isValidDateTime(string, string2)) {
                    String string7 = string + " " + string2;
                    String string8 = (String)this.lastChannelTime.get(string3);
                    if (string8 != null && !string7.equals(string8)) {
                        this.lastChannelSend.put(string3, new Long(System.currentTimeMillis()));
                        this.lastChannelTime.put(string3, string7);
                        d = 0.0;
                    } else {
                        Long l = (Long)this.lastChannelSend.get(string3);
                        if (l == null) {
                            this.lastChannelSend.put(string3, new Long(System.currentTimeMillis()));
                            d = -1.0;
                        } else {
                            d = System.currentTimeMillis() - l;
                            d = d < 0.0 ? -1.0 : d / 1000.0;
                        }
                        this.lastChannelTime.put(string3, string7);
                    }
                } else {
                    d = -1.0;
                    this.lastChannelTime.remove(string3);
                    this.lastChannelSend.remove(string3);
                }
                dArray[7] = d;
                this.channelstats.put(string3, dArray);
            }
            String[] stringArray = null;
            try {
                PCFMessage pCFMessage2 = new PCFMessage(20);
                pCFMessage2.addParameter(3501, "*");
                pCFMessage2.addParameter(1511, 5);
                PCFMessage[] pCFMessageArray2 = pCFMessageAgent.send(pCFMessage2);
                stringArray = (String[])pCFMessageArray2[0].getParameterValue(3512);
            }
            catch (PCFException pCFException) {
                this.logToErrorFile("ERROR", "v6ChannelNames", "Unable to get channel names  " + pCFException.toString());
                PCFMessage[] pCFMessageArray3 = (PCFMessage[])pCFException.exceptionSource;
                for (int i = 0; i < pCFMessageArray3.length; ++i) {
                    System.out.println(pCFMessageArray3[i].toString());
                }
            }
            catch (MQException mQException) {
                this.logToErrorFile("ERROR", "v6ChannelNames", "Unable to get channel names  " + mQException.toString());
                mQException.printStackTrace();
            }
            catch (IOException iOException) {
                this.logToErrorFile("ERROR", "v6ChannelNames", "Unable to get channel names  " + iOException.toString());
                iOException.printStackTrace();
            }
            catch (Exception exception) {
                this.logToErrorFile("ERROR", "v6ChannelNames", "Unable to get channel names  " + exception.toString());
                exception.printStackTrace();
            }
            if (stringArray == null || stringArray.length <= 0) return;
            double[] dArray = new double[9];
            for (n2 = 0; n2 < dArray.length; ++n2) {
                dArray[n2] = -5.0;
            }
            dArray[4] = 0.0;
            dArray[8] = 0.0;
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                String string9 = stringArray[n2].trim();
                boolean bl2 = false;
                if (!this.channelstats.containsKey(string9)) {
                    System.out.println("v6ChannelName  :" + string9);
                    if (this.includeChannelToList(string9)) {
                        bl2 = true;
                    } else if (!this.excludeChannelToList(string9) && this.showInactiveChannels && !this.ignoreSystemChannelToList(string9)) {
                        bl2 = true;
                    }
                }
                if (!bl2) continue;
                this.channelstats.put(string9, dArray);
            }
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                String string10 = stringArray[n2].trim();
                if (!this.excludeChannelToList(string10) || this.includeChannelToList(string10)) continue;
                this.channelstats.remove(string10);
            }
            return;
        }
        catch (PCFException pCFException) {
            switch (pCFException.reasonCode) {
                case 3065: {
                    pCFException.printStackTrace();
                    return;
                }
                default: {
                    System.out.println("PCF Exception NOT!! handled in ChannelStatus");
                    throw pCFException;
                }
            }
        }
        finally {
            if (pCFMessageAgent != null) {
                try {
                    pCFMessageAgent.disconnect();
                    pCFMessageAgent = null;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (mQQueueManager != null) {
                try {
                    mQQueueManager.disconnect();
                    mQQueueManager = null;
                }
                catch (Exception exception) {
                    this.logToErrorFile("ERROR", "EgMq.getChannelStatusV6()", "Unable to DisConnect Queue Manager ");
                    System.out.println("ERROR   EgMq.getChannelStatusV6()   Unable to DisConnect Queue Manager ");
                    exception.printStackTrace();
                }
            }
        }
    }

    public synchronized void logToErrorFile(String string, String string2, String string3) {
        PrintWriter printWriter;
        if (this.dateInfo == null) {
            this.dateInfo = new EgDateInfo();
        }
        String string4 = this.dateInfo.egetDate();
        EgConfigInfo egConfigInfo = new EgConfigInfo("agent");
        try {
            printWriter = new PrintWriter(new FileWriter(EgConfigInfo.egAgentErrorFile, true));
        }
        catch (Exception exception) {
            System.err.println("Cannot open log file ");
            return;
        }
        String string5 = new String(string4 + " " + string + " " + string2 + ": " + string3);
        printWriter.println(string5);
        printWriter.close();
    }
}

