/*
 * Decompiled with CFR 0.152.
 */
import com.eg.JmxMBeanData;
import java.io.IOException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIClientSocketFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.rmi.RMIConnector;
import javax.management.remote.rmi.RMIServer;
import javax.rmi.ssl.SslRMIClientSocketFactory;

public class EgJmxTest
extends EgSmartTest {
    private EgTesterInfo testerInfo = new EgTesterInfo("agent");
    private String domain;
    private String[] instances;
    private String[] instances_neg;
    private String[] attributes;
    private Hashtable attributeValues;
    private boolean firstTime = true;
    private JMXServiceURL jmxService = null;
    private JMXConnector jmxConnector = null;
    private RMIConnector rmiConnector = null;
    private MBeanServerConnection beanServerConn = null;

    public static void main(String[] stringArray) {
        EgJmxTest egJmxTest = new EgJmxTest(stringArray);
        egJmxTest.computeMeasures(new Hashtable());
    }

    public EgJmxTest(String[] stringArray) {
        super(stringArray);
        this.isNewDynamicInfoTest = true;
    }

    public void computeMeasures(Hashtable hashtable) {
        boolean bl = false;
        if (this.checkForUpdate()) {
            bl = true;
        }
        this.firstTime = bl;
        if (!this.setMeasures()) {
            return;
        }
        this.firstTime = bl;
        if (!this.loadMethods()) {
            return;
        }
        ArrayList arrayList = null;
        this.attributeValues = this.getAttributeValues();
        if (this.attributeValues == null) {
            return;
        }
        try {
            Set set = this.attributeValues.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                arrayList = new ArrayList();
                String string = (String)iterator.next();
                Hashtable hashtable2 = (Hashtable)this.attributeValues.get(string);
                for (int i = 0; i < this.attributes.length; ++i) {
                    Object v = hashtable2.get(this.attributes[i]);
                    if (!this.isConfigTest) {
                        if (v != null) {
                            arrayList.add((Double)v);
                            continue;
                        }
                        arrayList.add(new Double(-5.0));
                        continue;
                    }
                    if (v != null) {
                        arrayList.add(String.valueOf((Double)v));
                        continue;
                    }
                    arrayList.add("-");
                }
                String string2 = this.formatDescriptor(string);
                if (!this.isConfigTest) {
                    arrayList = this.processMeasures(string2, arrayList);
                }
                this.addNewMeasure(string2, arrayList);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private boolean setMeasures() {
        boolean bl = this.getData();
        if (this.domain == null || this.domain.length() == 0) {
            this.setErrorMessage("No Jmx Objects Defined");
            return false;
        }
        if (this.attributes == null) {
            this.setErrorMessage("No Jmx Counters Defined");
            return false;
        }
        if (!this.isConfigTest && this.attributes.length != this.measureCount) {
            this.setErrorMessage("Incorrect Number of Counters configured");
            return false;
        }
        return true;
    }

    private boolean getData() {
        if (this.firstTime || this.checkForUpdate()) {
            this.domain = this.testsFilePtr.getValue("OBJECTS", this.entity);
            String string = this.testsFilePtr.getValue("INSTANCES_NEG", this.entity);
            if (string != null && string.length() != 0) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "#");
                int n = stringTokenizer.countTokens();
                this.instances_neg = new String[n];
                for (int i = 0; i < n; ++i) {
                    String string2 = stringTokenizer.nextToken();
                    if (string2 != null && (string2.equals("*") || string2.equalsIgnoreCase("all"))) continue;
                    this.instances_neg[i] = string2;
                }
            }
            if ((string = this.testsFilePtr.getValue("COUNTERS", this.entity)) != null && string.length() != 0) {
                this.attributes = this.tokenizeAttributes(string);
            }
            if ((string = this.testsFilePtr.getValue("INSTANCES", this.entity)) == null || string.length() == 0) {
                if (this.domain != null) {
                    this.instances = this.tokenizeInstances(string);
                }
            } else {
                this.instances = this.tokenizeInstances(string);
            }
            this.firstTime = false;
            return true;
        }
        return false;
    }

    private Hashtable getAttributeValues() {
        Hashtable hashtable;
        block6: {
            boolean bl = false;
            hashtable = new Hashtable();
            if (this.connectToJVM()) {
                try {
                    String[] stringArray = this.beanServerConn.getDomains();
                    if (stringArray == null || stringArray.length <= 0) break block6;
                    for (int i = 0; i < stringArray.length; ++i) {
                        String string = stringArray[i];
                        if (string.equals(this.domain)) continue;
                        bl = true;
                        break;
                    }
                    if (bl) {
                        hashtable = this.getValues(this.domain);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                return null;
            }
        }
        this.closeJVMConn();
        return hashtable;
    }

    private Hashtable getValues(String string) {
        Hashtable<Object, Object> hashtable;
        block16: {
            Object[] objectArray = (String[])this.attributes.clone();
            Arrays.sort(objectArray);
            hashtable = new Hashtable<Object, Object>();
            JmxMBeanData jmxMBeanData = new JmxMBeanData(this.beanServerConn, "agent");
            try {
                if (this.instances == null || this.instances.length <= 0) break block16;
                for (int i = 0; i < this.instances.length; ++i) {
                    boolean bl = false;
                    String string2 = this.instances[i];
                    String string3 = "";
                    if (string2 != null && string2.length() > 1 && string2.indexOf("*") > -1) {
                        bl = true;
                        string3 = "*";
                    } else {
                        string3 = string2.length() == 1 ? "*" : string2 + ",*";
                    }
                    ObjectName objectName = new ObjectName(string + ":" + string3);
                    Set<ObjectName> set = this.beanServerConn.queryNames(objectName, null);
                    Iterator<ObjectName> iterator = set.iterator();
                    while (iterator.hasNext()) {
                        Object object;
                        Object object2;
                        Object object3;
                        Object object4;
                        boolean bl2 = false;
                        ObjectName objectName2 = iterator.next();
                        String string4 = objectName2.toString();
                        if (bl && !this.patternMatch(string4, string2)) continue;
                        if (this.instances_neg != null && this.instances_neg.length > 0) {
                            for (int j = 0; j < this.instances_neg.length; ++j) {
                                object4 = this.instances_neg[j];
                                if (object4 != null && ((String)object4).length() > 1 && ((String)object4).indexOf("*") > -1) {
                                    if (!this.patternMatch(string4, (String)object4)) continue;
                                    bl2 = true;
                                    break;
                                }
                                if (string4 == null || string4.indexOf((String)object4) <= -1) continue;
                                bl2 = true;
                                break;
                            }
                        }
                        if (bl2) continue;
                        String string5 = jmxMBeanData.toString(objectName2);
                        object4 = new StringTokenizer(string5, "\n");
                        Hashtable<Object, Object> hashtable2 = new Hashtable<Object, Object>();
                        while (((StringTokenizer)object4).hasMoreTokens()) {
                            object3 = ((StringTokenizer)object4).nextToken().trim();
                            if (object3 != null && ((String)object3).startsWith("MBean:") || object3 == null || ((String)object3).length() <= 0 || ((String)object3).indexOf("=") <= 0) continue;
                            object2 = ((String)object3).substring(0, ((String)object3).indexOf("=")).trim();
                            object = ((String)object3).substring(((String)object3).indexOf("=") + 1).trim();
                            if (object2 == null || object == null) continue;
                            hashtable2.put(object2, object);
                        }
                        object3 = new Hashtable();
                        if (hashtable2 != null && hashtable2.size() > 0) {
                            object2 = hashtable2.keySet();
                            object = object2.iterator();
                            while (object.hasNext()) {
                                String string6 = (String)object.next();
                                double d = 0.0;
                                int n = Arrays.binarySearch(objectArray, string6);
                                if (n < 0) continue;
                                String string7 = (String)hashtable2.get(string6);
                                try {
                                    d = Double.parseDouble(string7);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    d = string7.equalsIgnoreCase("true") ? 1.0 : 0.0;
                                }
                                catch (Exception exception) {
                                    d = -1.0;
                                }
                                ((Hashtable)object3).put(string6, new Double(d));
                            }
                        }
                        if (object3 == null || ((Hashtable)object3).size() <= 0) continue;
                        object2 = objectName2.toString();
                        if (object2 != null && ((String)object2).indexOf(":") > -1) {
                            object2 = ((String)object2).substring(((String)object2).indexOf(":") + 1);
                        }
                        hashtable.put(object2, object3);
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return hashtable;
    }

    private boolean connectToJVM() {
        boolean bl = false;
        String string = this.getValueForParam("Jmx_Remote_Port");
        String string2 = this.getValueForParam("Jndi_Name");
        String string3 = this.getValueForParam("user");
        String string4 = this.getValueForParam("password");
        String string5 = this.getValueForParam("Dynamic_Info_Test");
        String string6 = this.getValueForParam("Provider");
        if (string6 == null || string6.length() <= 0) {
            string6 = "com.sun.jmx.remote.protocol";
        }
        if (string5 == null || !string5.equalsIgnoreCase("true")) {
            this.isNewDynamicInfoTest = false;
        }
        if (string2 == null || "None".equalsIgnoreCase(string2) || "Null".equalsIgnoreCase(string2)) {
            string2 = "jmxrmi";
        }
        if (string3 == null) {
            string3 = "none";
        }
        if (string4 == null) {
            string4 = "none";
        }
        String string7 = "service:jmx:rmi:///jndi/rmi://" + this.targetHost + ":" + string + "/" + string2;
        try {
            String[] stringArray;
            this.jmxService = new JMXServiceURL(string7);
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("jmx.remote.protocol.provider.pkgs", string6);
            boolean bl2 = false;
            if (string3.equalsIgnoreCase("none") || string4.equalsIgnoreCase("none")) {
                try {
                    this.jmxConnector = JMXConnectorFactory.connect(this.jmxService, hashMap);
                }
                catch (IOException iOException) {
                    bl2 = true;
                }
            } else {
                stringArray = new String[]{string3, string4};
                hashMap.put("jmx.remote.credentials", stringArray);
                try {
                    this.jmxConnector = JMXConnectorFactory.connect(this.jmxService, hashMap);
                }
                catch (IOException iOException) {
                    bl2 = true;
                }
            }
            if (bl2) {
                stringArray = new SslRMIClientSocketFactory();
                Registry registry = LocateRegistry.getRegistry(this.targetHost, Integer.parseInt(string), (RMIClientSocketFactory)stringArray);
                RMIServer rMIServer = (RMIServer)registry.lookup(string2);
                this.rmiConnector = new RMIConnector(rMIServer, hashMap);
                this.rmiConnector.connect(hashMap);
                this.beanServerConn = this.rmiConnector.getMBeanServerConnection();
            } else {
                this.beanServerConn = this.jmxConnector.getMBeanServerConnection();
            }
            if (this.beanServerConn == null) {
                System.out.println("connection to JVM is not established for " + this.entity + " for reportingHost " + this.reportingName);
                return false;
            }
            bl = true;
        }
        catch (Exception exception) {
            System.out.println("connection to JVM is not established for " + this.entity + " for reportingHost " + this.reportingName);
            this.closeJVMConn();
            return false;
        }
        return bl;
    }

    private void closeJVMConn() {
        try {
            if (this.jmxConnector != null) {
                this.jmxConnector.close();
            }
            if (this.rmiConnector != null) {
                this.rmiConnector.close();
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    private boolean patternMatch(String string, String string2) {
        int n;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!string2.startsWith("*")) {
            bl2 = true;
        }
        if (!string2.endsWith("*")) {
            bl3 = true;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "*");
        int n2 = stringTokenizer.countTokens();
        String string3 = new String(string);
        String[] stringArray = new String[n2];
        if (n2 <= 0) {
            return false;
        }
        for (n = 0; n < n2; ++n) {
            stringArray[n] = stringTokenizer.nextToken();
        }
        n = 0;
        if (bl2 && !string3.startsWith(stringArray[0])) {
            return false;
        }
        if (bl3 && !string3.endsWith(stringArray[n2 - 1])) {
            return false;
        }
        String string4 = null;
        for (int i = 0; i < n2; ++i) {
            int n3 = stringArray[i].lastIndexOf(".");
            string4 = n3 >= 0 ? (stringArray[i].endsWith(".exe") || stringArray[i].endsWith(".scr") || stringArray[i].endsWith(".com") || stringArray[i].endsWith(".bat") || stringArray[i].endsWith(".pl") || stringArray[i].endsWith(".vbs") || stringArray[i].endsWith(".wsf") || stringArray[i].endsWith(".wav") || stringArray[i].endsWith(".prn") ? stringArray[i].substring(0, n3) : stringArray[i]) : stringArray[i];
            n = string3.indexOf(string4);
            if (n == -1) {
                return false;
            }
            bl = true;
            string3 = new String(string3.substring(n += string4.length()));
        }
        return bl;
    }

    private String[] tokenizeAttributes(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n = stringTokenizer.countTokens();
        if (n < 1) {
            return null;
        }
        String[] stringArray = new String[n];
        String string2 = null;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            string2 = stringTokenizer.nextToken().trim();
            n2 = string2.indexOf(":");
            if (n2 < 0) continue;
            stringArray[i] = string2.substring(n2 + 1);
        }
        return stringArray;
    }

    private String[] tokenizeInstances(String stringArray) {
        String[] stringArray2;
        StringTokenizer stringTokenizer = new StringTokenizer((String)stringArray, "#");
        int n = stringTokenizer.countTokens();
        if (n < 1) {
            String[] stringArray3 = new String[]{"*"};
            return stringArray3;
        }
        if (n == 1 && (stringArray2 = stringArray) != null && (stringArray2.equals("*") || stringArray2.equalsIgnoreCase("all"))) {
            String[] stringArray4 = new String[]{"*"};
            return stringArray4;
        }
        stringArray2 = new String[n];
        for (int i = 0; i < n; ++i) {
            String string = stringTokenizer.nextToken().trim();
            stringArray2[i] = string != null && string.equals("*") ? (string = "*") : string;
        }
        return stringArray2;
    }

    private String formatDescriptor(String string) {
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null && string.indexOf(",") > -1) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (string2 != null && string2.indexOf("=") > -1) {
                    String string3 = string2.substring(string2.lastIndexOf("=") + 1);
                    if (bl) {
                        bl = false;
                        stringBuffer.append(string3);
                        continue;
                    }
                    stringBuffer.append(":");
                    stringBuffer.append(string3);
                    continue;
                }
                stringBuffer.append(string2);
            }
        } else if (string != null && string.indexOf("=") > -1) {
            String string4 = string.substring(string.lastIndexOf("=") + 1);
            if (bl) {
                bl = false;
                stringBuffer.append(string4);
            } else {
                stringBuffer.append(":");
                stringBuffer.append(string4);
            }
        }
        return stringBuffer.toString();
    }
}

