/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Properties;

public class EgDb2Test
extends EgTest {
    public static final String instanceSeparator = ":";
    private String perfDataFile = "";
    public static Hashtable perfdataHash = new Hashtable();
    public static Hashtable lastModifiedTimeHash = new Hashtable();
    public static Hashtable timeSinceLastReadHash = new Hashtable();
    public static Hashtable firstTimeHash = new Hashtable();

    public EgDb2Test(String[] stringArray) {
        super(stringArray);
        if (stringArray.length < 2 || !stringArray[0].equalsIgnoreCase("-host")) {
            System.err.println("Usage: EgDb2TestTest -host <hostname> -port <port number>");
            System.exit(-1);
        }
        this.targetHost = new String(stringArray[1]);
        if (stringArray.length > 2) {
            for (int i = 2; i < stringArray.length; ++i) {
                if (!stringArray[i].equalsIgnoreCase("-port")) continue;
                if (++i < stringArray.length) {
                    this.portNo = new String(stringArray[i]);
                    continue;
                }
                System.err.println("Usage:  -host <hostName> -port <portNo>");
                return;
            }
        }
    }

    public void stopTest() {
        perfdataHash.remove(this.portNo);
        lastModifiedTimeHash.remove(this.portNo);
        timeSinceLastReadHash.remove(this.portNo);
        firstTimeHash.remove(this.portNo);
    }

    public void suspendForPeriod(long l) {
        long l2 = System.currentTimeMillis() + l;
        while (l > 0L) {
            try {
                Thread.sleep(l);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            long l3 = System.currentTimeMillis();
            l = l2 - l3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean getLatestMeasures(String string, String string2) {
        InputStream inputStream = null;
        File file = null;
        Hashtable hashtable = perfdataHash;
        synchronized (hashtable) {
            try {
                this.perfDataFile = "db2" + string2 + ".dat";
                String string3 = EgConfigInfo.egAgentConfigDir;
                String string4 = string3 + this.perfDataFile;
                File file2 = new File(string3 + this.perfDataFile);
                boolean bl = true;
                if (firstTimeHash.get(string2) == null) {
                    perfdataHash.put(string2, new Properties());
                    lastModifiedTimeHash.put(string2, new Long(file2.lastModified()));
                    firstTimeHash.put(string2, new Boolean(false));
                }
                long l = (Long)lastModifiedTimeHash.get(string2);
                if (file2.exists() && file2.lastModified() > l) {
                    String string5 = string3 + this.perfDataFile.substring(0, this.perfDataFile.lastIndexOf(".dat")) + ".loc";
                    file = new File(string5);
                    for (int i = 0; i < 10; ++i) {
                        bl = file.createNewFile();
                        if (bl) {
                            inputStream = new FileInputStream(string4);
                            Properties properties = (Properties)perfdataHash.get(string2);
                            properties.clear();
                            properties.load(inputStream);
                            long l2 = (file2.lastModified() - l) / 1000L;
                            timeSinceLastReadHash.put(string2, new Long(l2));
                            lastModifiedTimeHash.put(string2, new Long(file2.lastModified()));
                            inputStream.close();
                            file.delete();
                            return true;
                        }
                        this.suspendForPeriod(1000L);
                    }
                    return true;
                }
                return false;
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                        file.delete();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                System.out.println("Cannot find file");
                return false;
            }
            catch (IOException iOException) {
                System.out.println("IO problems");
                if (inputStream != null) {
                    try {
                        inputStream.close();
                        file.delete();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return false;
            }
        }
    }

    public void invalidateIndex(String string) {
        this.results.remove(string);
    }

    public static void main(String[] stringArray) throws IOException {
    }
}

