/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class EDirProtocolTest
extends EgSnmpGenericTest {
    private static String id = ".1.3.6.1.4.1.23.2.98.1.2.3.1.1.3";
    private static String protoIfUnauthBinds = ".1.3.6.1.4.1.23.2.98.1.2.3.1.1.4";
    private static String protoIfBindSecurityErrors = ".1.3.6.1.4.1.23.2.98.1.2.3.1.1.7";
    private static String protoIfReadOps = ".1.3.6.1.4.1.23.2.98.1.2.3.1.1.9";
    private static String protoIfAddEntryOps = ".1.3.6.1.4.1.23.2.98.1.2.3.1.1.11";
    private static String protoIfRemoveEntryOps = ".1.3.6.1.4.1.23.2.98.1.2.3.1.1.12";
    private static String protoIfModifyEntryOps = ".1.3.6.1.4.1.23.2.98.1.2.3.1.1.13";
    private static String protoIfSearchOps = ".1.3.6.1.4.1.23.2.98.1.2.3.1.1.16";
    private static String protoIfChainings = ".1.3.6.1.4.1.23.2.98.1.2.3.1.1.21";
    private static String protoIfErrors = ".1.3.6.1.4.1.23.2.98.1.2.3.1.1.23";
    private static String protoIfReplicationUpdatesIn = ".1.3.6.1.4.1.23.2.98.1.2.3.1.1.24";
    private static String protoIfReplicationUpdatesOut = ".1.3.6.1.4.1.23.2.98.1.2.3.1.1.25";
    private static String protoIfInBytes = ".1.3.6.1.4.1.23.2.98.1.2.3.1.1.26";
    private static String protoIfOutBytes = ".1.3.6.1.4.1.23.2.98.1.2.3.1.1.27";
    private static int numMeasures = 13;
    private int rediscCount = -1;
    private static int maxRediscPeriod = 4;
    ArrayList idNames = new ArrayList();
    private Hashtable idMap = new Hashtable();
    private Hashtable ProtoIfUnauthBinds;
    private Hashtable ProtoIfBindSecurityErrors;
    private Hashtable ProtoIfReadOps;
    private Hashtable ProtoIfAddEntryOps;
    private Hashtable ProtoIfRemoveEntryOps;
    private Hashtable ProtoIfModifyEntryOps;
    private Hashtable ProtoIfSearchOps;
    private Hashtable ProtoIfChainings;
    private Hashtable ProtoIfErrors;
    private Hashtable ProtoIfReplicationUpdatesIn;
    private Hashtable ProtoIfReplicationUpdatesOut;
    private Hashtable ProtoIfInBytes;
    private Hashtable ProtoIfOutBytes;
    private Hashtable prevProtoIfUnauthBinds = new Hashtable();
    private Hashtable prevProtoIfBindSecurityErrors = new Hashtable();
    private Hashtable prevProtoIfReadOps = new Hashtable();
    private Hashtable prevProtoIfAddEntryOps = new Hashtable();
    private Hashtable prevProtoIfRemoveEntryOps = new Hashtable();
    private Hashtable prevProtoIfModifyEntryOps = new Hashtable();
    private Hashtable prevProtoIfSearchOps = new Hashtable();
    private Hashtable prevProtoIfChainings = new Hashtable();
    private Hashtable prevProtoIfErrors = new Hashtable();
    private Hashtable prevProtoIfReplicationUpdatesIn = new Hashtable();
    private Hashtable prevProtoIfReplicationUpdatesOut = new Hashtable();
    private Hashtable prevProtoIfInBytes = new Hashtable();
    private Hashtable prevProtoIfOutBytes = new Hashtable();
    private int numIds = 0;

    public EDirProtocolTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(numMeasures);
    }

    public static void main(String[] stringArray) {
        stringArray = new String[]{"-host", "192.168.10.34", "-port", "NULL", "-snmpCommunity", "public", "-snmpPort", "161"};
        EDirProtocolTest eDirProtocolTest = new EDirProtocolTest(stringArray);
        for (int i = 0; i < 10; ++i) {
            eDirProtocolTest.computeMeasures(new Hashtable());
        }
    }

    private void initAll() {
        this.ProtoIfUnauthBinds = new Hashtable();
        this.ProtoIfBindSecurityErrors = new Hashtable();
        this.ProtoIfReadOps = new Hashtable();
        this.ProtoIfAddEntryOps = new Hashtable();
        this.ProtoIfRemoveEntryOps = new Hashtable();
        this.ProtoIfModifyEntryOps = new Hashtable();
        this.ProtoIfSearchOps = new Hashtable();
        this.ProtoIfChainings = new Hashtable();
        this.ProtoIfErrors = new Hashtable();
        this.ProtoIfReplicationUpdatesIn = new Hashtable();
        this.ProtoIfReplicationUpdatesOut = new Hashtable();
        this.ProtoIfInBytes = new Hashtable();
        this.ProtoIfOutBytes = new Hashtable();
    }

    private void initPrev() {
        this.prevProtoIfUnauthBinds = new Hashtable();
        this.prevProtoIfBindSecurityErrors = new Hashtable();
        this.prevProtoIfReadOps = new Hashtable();
        this.prevProtoIfAddEntryOps = new Hashtable();
        this.prevProtoIfRemoveEntryOps = new Hashtable();
        this.prevProtoIfModifyEntryOps = new Hashtable();
        this.prevProtoIfSearchOps = new Hashtable();
        this.prevProtoIfChainings = new Hashtable();
        this.prevProtoIfErrors = new Hashtable();
        this.prevProtoIfReplicationUpdatesIn = new Hashtable();
        this.prevProtoIfReplicationUpdatesOut = new Hashtable();
        this.prevProtoIfInBytes = new Hashtable();
        this.prevProtoIfOutBytes = new Hashtable();
    }

    private void discIds() {
        int n;
        ++this.rediscCount;
        if (this.rediscCount >= maxRediscPeriod) {
            this.rediscCount = 0;
        }
        if (this.rediscCount != 0) {
            return;
        }
        boolean bl = this.runSnmpCmdForOid(id);
        if (!bl || this.lhs == null || this.lhs.length <= 0) {
            this.rediscCount = -1;
            return;
        }
        this.idMap = new Hashtable();
        boolean bl2 = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n = 0; n < this.lhs.length; ++n) {
            this.idMap.put(this.lhs[n], this.rhs[n]);
            arrayList.add(this.rhs[n]);
        }
        if (arrayList.size() != this.idNames.size()) {
            bl2 = true;
        } else {
            String string;
            for (n = 0; n < arrayList.size(); ++n) {
                string = (String)arrayList.get(n);
                if (this.idNames.contains(string)) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                for (n = 0; n < this.idNames.size(); ++n) {
                    string = (String)this.idNames.get(n);
                    if (arrayList.contains(string)) continue;
                    bl2 = true;
                    break;
                }
            }
        }
        if (bl2) {
            this.initPrev();
        }
        this.idNames = arrayList;
        this.numIds = this.lhs.length;
    }

    private double getValue(String string) {
        double d = -5.0;
        try {
            d = Double.parseDouble(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return d;
    }

    public void computeMeasures(Hashtable hashtable) {
        this.initAll();
        this.discIds();
        if (this.numIds == 0) {
            return;
        }
        this.runCommand(protoIfUnauthBinds, this.ProtoIfUnauthBinds, this.prevProtoIfUnauthBinds);
        this.runCommand(protoIfBindSecurityErrors, this.ProtoIfBindSecurityErrors, this.prevProtoIfBindSecurityErrors);
        this.runCommand(protoIfReadOps, this.ProtoIfReadOps, this.prevProtoIfReadOps);
        this.runCommand(protoIfAddEntryOps, this.ProtoIfAddEntryOps, this.prevProtoIfAddEntryOps);
        this.runCommand(protoIfRemoveEntryOps, this.ProtoIfRemoveEntryOps, this.prevProtoIfRemoveEntryOps);
        this.runCommand(protoIfModifyEntryOps, this.ProtoIfModifyEntryOps, this.prevProtoIfModifyEntryOps);
        this.runCommand(protoIfSearchOps, this.ProtoIfSearchOps, this.prevProtoIfSearchOps);
        this.runCommand(protoIfChainings, this.ProtoIfChainings, this.prevProtoIfChainings);
        this.runCommand(protoIfErrors, this.ProtoIfErrors, this.prevProtoIfErrors);
        this.runCommand(protoIfReplicationUpdatesIn, this.ProtoIfReplicationUpdatesIn, this.prevProtoIfReplicationUpdatesIn);
        this.runCommand(protoIfReplicationUpdatesOut, this.ProtoIfReplicationUpdatesOut, this.prevProtoIfReplicationUpdatesOut);
        this.runCommand(protoIfInBytes, this.ProtoIfInBytes, this.prevProtoIfInBytes);
        this.runCommand(protoIfOutBytes, this.ProtoIfOutBytes, this.prevProtoIfOutBytes);
        Enumeration enumeration = this.idMap.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)this.idMap.get(string);
            ArrayList<Double> arrayList = new ArrayList<Double>();
            arrayList.add(new Double(this.getValueFromTable(this.ProtoIfUnauthBinds, string)));
            arrayList.add(new Double(this.getValueFromTable(this.ProtoIfBindSecurityErrors, string)));
            arrayList.add(new Double(this.getValueFromTable(this.ProtoIfReadOps, string)));
            arrayList.add(new Double(this.getValueFromTable(this.ProtoIfAddEntryOps, string)));
            arrayList.add(new Double(this.getValueFromTable(this.ProtoIfRemoveEntryOps, string)));
            arrayList.add(new Double(this.getValueFromTable(this.ProtoIfModifyEntryOps, string)));
            arrayList.add(new Double(this.getValueFromTable(this.ProtoIfSearchOps, string)));
            arrayList.add(new Double(this.getValueFromTable(this.ProtoIfChainings, string)));
            arrayList.add(new Double(this.getValueFromTable(this.ProtoIfErrors, string)));
            arrayList.add(new Double(this.getValueFromTable(this.ProtoIfReplicationUpdatesIn, string)));
            arrayList.add(new Double(this.getValueFromTable(this.ProtoIfReplicationUpdatesOut, string)));
            double d = this.getValueFromTable(this.ProtoIfInBytes, string);
            double d2 = this.getValueFromTable(this.ProtoIfOutBytes, string);
            arrayList.add(new Double(d < 0.0 ? d : d / 1024.0));
            arrayList.add(new Double(d2 < 0.0 ? d2 : d2 / 1024.0));
            this.addNewMeasure(string2, arrayList);
        }
    }

    public double getValueFromTable(Hashtable hashtable, String string) {
        double d = -5.0;
        if (hashtable != null && hashtable.containsKey(string)) {
            d = (Double)hashtable.get(string);
        }
        return d;
    }

    public void runCommand(String string, Hashtable hashtable, Hashtable hashtable2) {
        if (this.runSnmpCmdForOid(string) && this.lhs != null && this.lhs.length > 0) {
            for (int i = 0; i < this.lhs.length; ++i) {
                double d = this.getValue(this.rhs[i]);
                double d2 = -1.0;
                if (hashtable2.containsKey(this.lhs[i])) {
                    d2 = (Double)hashtable2.get(this.lhs[i]);
                }
                double d3 = -5.0;
                if (d >= 0.0 && d2 >= 0.0) {
                    d3 = d - d2;
                    double d4 = d3 = d3 >= 0.0 ? d3 : -5.0;
                }
                if (d >= 0.0) {
                    hashtable2.put(this.lhs[i], new Double(d));
                }
                hashtable.put(this.lhs[i], new Double(d3));
            }
        }
    }
}

