/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.StringTokenizer;

public class DominoNetTest
extends EgSnmpTest {
    public static final boolean verbose = false;
    private static int bytesRcvdRateIndex = 0;
    private static int bytesSentRateIndex = 1;
    private static int inboundSessionRateIndex = 2;
    private static int outboundSessionRateIndex = 3;
    private static int dropSessionRateIndex = 4;
    private static int concurrSessionLimitIndex = 5;
    private double bytesRcvdRate = -1.0;
    private double bytesSentRate = -1.0;
    private double inboundSessionRate = -1.0;
    private double outboundSessionRate = -1.0;
    private double dropSessionRate = -1.0;
    private long concurrSessionLimit = -1L;
    private ArrayList arrByteRcvd = null;
    private ArrayList arrByteSent = null;
    private ArrayList arrInSess = null;
    private ArrayList arrOutSess = null;
    private ArrayList arrDropSess = null;
    private ArrayList prevArrByteRcvd = new ArrayList();
    private ArrayList prevArrByteSent = new ArrayList();
    private ArrayList prevArrInSess = new ArrayList();
    private ArrayList prevArrOutSess = new ArrayList();
    private ArrayList prevArrDropSess = new ArrayList();
    private ArrayList arrPortNames = new ArrayList();
    private String portName = "";
    private long bytesRcvd = -1L;
    private long bytesSent = -1L;
    private long inboundSession = -1L;
    private long outboundSession = -1L;
    private long dropSession = -1L;
    private int entry = 0;
    private static String bytesRcvdOid = ".1.3.6.1.4.1.334.72.1.1.7.6.1.3";
    private static String bytesSentOid = ".1.3.6.1.4.1.334.72.1.1.7.6.1.4";
    private static String inboundSessionOid = ".1.3.6.1.4.1.334.72.1.1.7.6.1.5";
    private static String outboundSessionOid = ".1.3.6.1.4.1.334.72.1.1.7.6.1.6";
    private static String dropSessionOid = ".1.3.6.1.4.1.334.72.1.1.7.6.1.11";
    private static String concurrSessionLimitOid = ".1.3.6.1.4.1.334.72.1.1.7.6.1.7";
    private static String portNameOid = ".1.3.6.1.4.1.334.72.1.1.7.6.1.2";

    public DominoNetTest(String[] stringArray) {
        super(stringArray);
        this.numOutputFields = 6;
        if (stringArray.length < 2 || !stringArray[0].equalsIgnoreCase("-host")) {
            System.err.println("Usage: DominoNetTest -host <targetHost> -port <port>-snmpPort <snmpPort> -snmpCommunity <community>");
            System.exit(-1);
        }
        this.targetHost = new String(stringArray[1]);
        if (stringArray.length > 2) {
            for (int i = 2; i < stringArray.length; ++i) {
                if (stringArray[i].equalsIgnoreCase("-port")) {
                    if (++i < stringArray.length) {
                        this.portNo = new String(stringArray[i]);
                        continue;
                    }
                    System.err.println("Usage: DominoNetTest -host <targetHost> -port <port>-snmpPort <snmpPort> -snmpCommunity <community>");
                    return;
                }
                if (stringArray[i].equalsIgnoreCase("-snmpPort")) {
                    if (++i < stringArray.length) {
                        this.snmpPortNo = new String(stringArray[i]);
                        continue;
                    }
                    System.err.println("Usage: DominoNetTest -host <targetHost> -port <port>-snmpPort <snmpPort> -snmpCommunity <community>");
                    return;
                }
                if (!stringArray[i].equalsIgnoreCase("-snmpCommunity")) continue;
                if (++i < stringArray.length) {
                    this.community = new String(stringArray[i]);
                    continue;
                }
                System.err.println("Usage: DominoNetTest -host <targetHost> -port <port>-snmpPort <snmpPort> -snmpCommunity <community>");
                return;
            }
        }
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"-host", "192.168.10.40", "-snmpPort", "161", "-snmpCommunity", "public"};
        DominoNetTest dominoNetTest = new DominoNetTest(stringArray2);
        try {
            for (int i = 0; i < 4; ++i) {
                dominoNetTest.executeTest();
                Thread.sleep(5000L);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean executeTest() {
        this.initTest();
        String string = this.siteName + siteAndInfoSeparator + infoFieldSeparator;
        String string2 = "";
        ArrayList arrayList = null;
        String string3 = "";
        arrayList = this.getPortNames(portNameOid);
        long[] lArray = this.getMeasure(bytesRcvdOid);
        long[] lArray2 = this.getMeasure(bytesSentOid);
        long[] lArray3 = this.getMeasure(inboundSessionOid);
        long[] lArray4 = this.getMeasure(outboundSessionOid);
        long[] lArray5 = this.getMeasure(dropSessionOid);
        long[] lArray6 = this.getMeasure(concurrSessionLimitOid);
        if (arrayList != null && arrayList.size() > 0) {
            for (int i = 0; i < arrayList.size(); ++i) {
                string3 = ((String)arrayList.get(i)).trim();
                string2 = string + string3;
                if (lArray != null && lArray2 != null && lArray3 != null && lArray4 != null && lArray5 != null && lArray6 != null) {
                    this.bytesRcvd = lArray[i];
                    this.bytesSent = lArray2[i];
                    this.inboundSession = lArray3[i];
                    this.outboundSession = lArray4[i];
                    this.dropSession = lArray5[i];
                    this.concurrSessionLimit = lArray6[i];
                }
                if ((this.entry = this.arrPortNames.indexOf(string3)) == -1) {
                    this.arrPortNames.add(string3);
                    this.prevArrByteRcvd.add(new Long(this.bytesRcvd));
                    this.prevArrByteSent.add(new Long(this.bytesSent));
                    this.prevArrInSess.add(new Long(this.inboundSession));
                    this.prevArrOutSess.add(new Long(this.outboundSession));
                    this.prevArrDropSess.add(new Long(this.dropSession));
                    this.addValueToResultSet(string2, bytesRcvdRateIndex, -1.0);
                    this.addValueToResultSet(string2, bytesSentRateIndex, -1.0);
                    this.addValueToResultSet(string2, inboundSessionRateIndex, -1.0);
                    this.addValueToResultSet(string2, outboundSessionRateIndex, -1.0);
                    this.addValueToResultSet(string2, dropSessionRateIndex, -1.0);
                    this.addValueToResultSet(string2, concurrSessionLimitIndex, -1.0);
                    continue;
                }
                if (this.timeSinceLastTest < 0.0) {
                    this.addValueToResultSet(string2, bytesRcvdRateIndex, -1.0);
                    this.addValueToResultSet(string2, bytesSentRateIndex, -1.0);
                    this.addValueToResultSet(string2, inboundSessionRateIndex, -1.0);
                    this.addValueToResultSet(string2, outboundSessionRateIndex, -1.0);
                    this.addValueToResultSet(string2, dropSessionRateIndex, -1.0);
                    this.addValueToResultSet(string2, concurrSessionLimitIndex, -1.0);
                    continue;
                }
                Long l = (Long)this.prevArrByteRcvd.get(this.entry);
                long l2 = l.intValue();
                l = (Long)this.prevArrByteSent.get(this.entry);
                long l3 = l.intValue();
                l = (Long)this.prevArrInSess.get(this.entry);
                long l4 = l.intValue();
                l = (Long)this.prevArrOutSess.get(this.entry);
                long l5 = l.intValue();
                l = (Long)this.prevArrDropSess.get(this.entry);
                long l6 = l.intValue();
                this.bytesRcvdRate = ((double)this.bytesRcvd - (double)l2) / this.timeSinceLastTest;
                this.bytesRcvdRate = this.bytesRcvdRate < 0.0 ? -1.0 : this.bytesRcvdRate;
                this.bytesSentRate = ((double)this.bytesSent - (double)l3) / this.timeSinceLastTest;
                this.bytesSentRate = this.bytesSentRate < 0.0 ? -1.0 : this.bytesSentRate;
                this.inboundSessionRate = ((double)this.inboundSession - (double)l4) / this.timeSinceLastTest;
                this.inboundSessionRate = this.inboundSessionRate < 0.0 ? -1.0 : this.inboundSessionRate;
                this.outboundSessionRate = ((double)this.outboundSession - (double)l5) / this.timeSinceLastTest;
                this.outboundSessionRate = this.outboundSessionRate < 0.0 ? -1.0 : this.outboundSessionRate;
                this.dropSessionRate = ((double)this.dropSession - (double)l6) / this.timeSinceLastTest;
                this.dropSessionRate = this.dropSessionRate < 0.0 ? -1.0 : this.dropSessionRate;
                this.addValueToResultSet(string2, bytesRcvdRateIndex, this.bytesRcvdRate);
                this.addValueToResultSet(string2, bytesSentRateIndex, this.bytesSentRate);
                this.addValueToResultSet(string2, inboundSessionRateIndex, this.inboundSessionRate);
                this.addValueToResultSet(string2, outboundSessionRateIndex, this.outboundSessionRate);
                this.addValueToResultSet(string2, dropSessionRateIndex, this.dropSessionRate);
                this.addValueToResultSet(string2, concurrSessionLimitIndex, this.concurrSessionLimit);
                this.updateAllResultSets(true);
            }
        } else {
            this.updateAllResultSets(true);
        }
        return true;
    }

    private long[] getMeasure(String string) {
        long[] lArray = null;
        if (this.runSnmpCmdForOid(string)) {
            lArray = new long[this.rhs.length];
            for (int i = 0; i < this.lhs.length; ++i) {
                lArray[i] = Long.parseLong(this.rhs[i]);
            }
        }
        if (lArray != null) {
            return lArray;
        }
        return null;
    }

    public String convert(String string) {
        byte[] byArray = string.getBytes();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; i += 2) {
            int n = 0;
            try {
                n = Integer.parseInt(new String(byArray, i, 2), 16);
                stringBuffer.append((char)n);
                continue;
            }
            catch (Exception exception) {
                return string;
            }
        }
        return stringBuffer.toString();
    }

    private ArrayList getPortNames(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.runSnmpCmdForOid(string)) {
            for (int i = 0; i < this.lhs.length; ++i) {
                if (this.rhs[i] == null) {
                    return null;
                }
                arrayList.add(this.convert(this.removeSpace(this.rhs[i])).trim());
            }
        }
        return arrayList;
    }

    private String removeSpace(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append(stringTokenizer.nextToken());
        }
        return stringBuffer.toString();
    }
}

