/*
 * Decompiled with CFR 0.152.
 */
public class DominoMailStatsTest
extends EgSnmpTest {
    public static boolean verbose = false;
    private static int deliveredMailRateIndex = 0;
    private static int pctDeadMailsIndex = 1;
    private static int numMailWaitingIndex = 2;
    private static int avgMailDeliveryTimeIndex = 3;
    private static int pctMailTransferFailIndex = 4;
    private static int numMailWaitLocalDelvIndex = 5;
    private double deliveredMailRate = -1.0;
    private double pctDeadMails = -1.0;
    private double numMailWaiting = -1.0;
    private double avgMailDeliveryTime = -1.0;
    private double pctMailTransferFail = -1.0;
    private double numMailWaitLocalDelv = -1.0;
    private double deliveredMail = -1.0;
    private double prevDeliveredMail = 0.0;
    private double currDeliveredMail = -1.0;
    private double numDeadMails = -1.0;
    private double prevDeadMail = 0.0;
    private double currDeadMail = -1.0;
    private double numMailTransferFail = -1.0;
    private double prevMailTransferFail = 0.0;
    private double currTfrMailFail = -1.0;
    private static String deliveredMailOid = ".1.3.6.1.4.1.334.72.1.1.4.2";
    private static String numDeadMailsOid = ".1.3.6.1.4.1.334.72.1.1.4.1";
    private static String numMailWaitingOid = ".1.3.6.1.4.1.334.72.1.1.4.6";
    private static String avgMailDeliveryTimeOid = ".1.3.6.1.4.1.334.72.1.1.4.9";
    private static String numMailTransferFailOid = ".1.3.6.1.4.1.334.72.1.1.4.3";
    private static String numMailWaitLocalDelvOid = ".1.3.6.1.4.1.334.72.1.1.4.7";

    public DominoMailStatsTest(String[] stringArray) {
        super(stringArray);
        this.numOutputFields = 6;
        if (stringArray.length < 2 || !stringArray[0].equalsIgnoreCase("-host")) {
            System.err.println("Usage: DominoMailStatsTest -host <targetHost> -port <port>-snmpPort <snmpPort> -snmpCommunity <community>");
            System.exit(-1);
        }
        this.targetHost = new String(stringArray[1]);
        if (stringArray.length > 2) {
            for (int i = 2; i < stringArray.length; ++i) {
                if (stringArray[i].equalsIgnoreCase("-port")) {
                    if (++i < stringArray.length) {
                        this.portNo = new String(stringArray[i]);
                        continue;
                    }
                    System.err.println("Usage: DominoMailStatsTest -host <targetHost> -port <port>-snmpPort <snmpPort> -snmpCommunity <community>");
                    return;
                }
                if (stringArray[i].equalsIgnoreCase("-snmpPort")) {
                    if (++i < stringArray.length) {
                        this.snmpPortNo = new String(stringArray[i]);
                        continue;
                    }
                    System.err.println("Usage: DominoMailStatsTest -host <targetHost> -port <port>-snmpPort <snmpPort> -snmpCommunity <community>");
                    return;
                }
                if (!stringArray[i].equalsIgnoreCase("-snmpCommunity")) continue;
                if (++i < stringArray.length) {
                    this.community = new String(stringArray[i]);
                    continue;
                }
                System.err.println("Usage: DominoMailStatsTest -host <targetHost> -port <port>-snmpPort <snmpPort> -snmpCommunity <community>");
                return;
            }
        }
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"-host", "192.168.10.38", "-snmpPort", "161", "-snmpCommunity", "public"};
        DominoMailStatsTest dominoMailStatsTest = new DominoMailStatsTest(stringArray2);
        try {
            for (int i = 0; i < 10; ++i) {
                dominoMailStatsTest.executeTest();
                Thread.sleep(20000L);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean executeTest() {
        this.initTest();
        String string = this.siteName + siteAndInfoSeparator + infoFieldSeparator;
        this.deliveredMail = this.getMeasure(deliveredMailOid);
        this.numDeadMails = this.getMeasure(numDeadMailsOid);
        this.numMailWaiting = this.getMeasure(numMailWaitingOid);
        this.avgMailDeliveryTime = this.getMeasure(avgMailDeliveryTimeOid);
        if (this.avgMailDeliveryTime < 0.0) {
            this.avgMailDeliveryTime = 0.0;
        }
        this.numMailTransferFail = this.getMeasure(numMailTransferFailOid);
        this.numMailWaitLocalDelv = this.getMeasure(numMailWaitLocalDelvOid);
        if (verbose) {
            System.out.println(this.deliveredMailRate);
            System.out.println(this.numDeadMails);
            System.out.println(this.numMailWaiting);
            System.out.println(this.avgMailDeliveryTime);
            System.out.println(this.numMailTransferFail);
            System.out.println(this.numMailWaitLocalDelv);
        }
        this.currDeliveredMail = this.deliveredMail - this.prevDeliveredMail;
        this.currDeliveredMail = this.currDeliveredMail >= 0.0 ? this.currDeliveredMail : -1.0;
        this.prevDeliveredMail = this.deliveredMail;
        this.deliveredMailRate = this.currDeliveredMail;
        this.deliveredMailRate = this.deliveredMailRate >= 0.0 ? this.deliveredMailRate : -1.0;
        this.currDeadMail = this.numDeadMails - this.prevDeadMail;
        this.pctDeadMails = this.currDeadMail >= 0.0 ? this.currDeadMail : -1.0;
        this.prevDeadMail = this.numDeadMails;
        this.pctMailTransferFail = this.numMailTransferFail - this.prevMailTransferFail;
        this.pctMailTransferFail = this.pctMailTransferFail >= 0.0 ? this.pctMailTransferFail : -1.0;
        this.prevMailTransferFail = this.numMailTransferFail;
        this.addValueToResultSet(string, deliveredMailRateIndex, this.deliveredMailRate);
        this.addValueToResultSet(string, pctDeadMailsIndex, this.pctDeadMails);
        this.addValueToResultSet(string, numMailWaitingIndex, this.numMailWaiting);
        this.addValueToResultSet(string, avgMailDeliveryTimeIndex, this.avgMailDeliveryTime);
        this.addValueToResultSet(string, pctMailTransferFailIndex, this.pctMailTransferFail);
        this.addValueToResultSet(string, numMailWaitLocalDelvIndex, this.numMailWaitLocalDelv);
        this.updateAllResultSets();
        return true;
    }

    private long getMeasure(String string) {
        String string2 = null;
        if (this.runSnmpCmdForOid(string)) {
            for (int i = 0; i < this.lhs.length; ++i) {
                string2 = this.rhs[i];
            }
        }
        if (string2 != null) {
            long l = -1L;
            try {
                l = Long.parseLong(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return l;
        }
        return -1L;
    }
}

