/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgSSL;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class CtxXmlTicketTest
extends GenericTest {
    private static int numMeasures = 5;
    private String user;
    private String pass;
    private String domain;
    private int timeout = 60000;
    private String data;
    private String header;
    private String nfuseHost;
    private String nfusePort;
    private int port;
    private int contentLen = 0;
    private boolean isSsl = false;
    private String dctype = "NT";

    public static void main(String[] stringArray) {
        CtxXmlTicketTest ctxXmlTicketTest = new CtxXmlTicketTest(stringArray);
        ctxXmlTicketTest.executeTest();
    }

    public CtxXmlTicketTest(String[] stringArray) {
        super(stringArray);
        String string;
        String string2;
        this.setMeasureCount(numMeasures);
        this.user = this.getValueForParam("user");
        this.pass = this.getValueForParam("password");
        this.domain = this.getValueForParam("domain");
        this.nfuseHost = this.getValueForParam("xmlHost");
        this.nfusePort = this.getValueForParam("xmlPort");
        if (this.domain.equalsIgnoreCase("none")) {
            this.domain = "";
        }
        if ((string2 = this.getValueForParam("ssl")) != null && (string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("yes"))) {
            this.isSsl = true;
        }
        if (this.domain.equalsIgnoreCase("none")) {
            this.domain = "";
        }
        this.dctype = this.getValueForParam("domainType");
        if (this.dctype == null) {
            this.dctype = "NT";
        }
        if ((string = this.getValueForParam("timeout")) != null) {
            try {
                this.timeout = Integer.parseInt(string) * 1000;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.port = 80;
        try {
            this.port = Integer.parseInt(this.nfusePort);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.data = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE NFuseProtocol SYSTEM \"NFuse.dtd\">\n<NFuseProtocol version=\"4.1\">\n<RequestTicket>\n<Credentials>\n<UserName>" + this.user + "</UserName>\n" + "<Password encoding=\"cleartext\">" + this.pass + "</Password>\n" + "<Domain type=\"" + this.dctype + "\">$domain</Domain>\n" + "</Credentials>\n" + "<TicketType>CtxLogon</TicketType>\n" + "<TicketTag>" + this.targetHost + "</TicketTag>\n" + "<TimetoLive>2</TimetoLive>\n" + "</RequestTicket>\n" + "</NFuseProtocol>\n";
        this.contentLen = this.data.length();
    }

    public void computeMeasures(Hashtable hashtable) {
        Object object;
        HttpURLConnection httpURLConnection;
        Object object2;
        String string;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        double d = -5.0;
        double d2 = -5.0;
        if (this.isSsl) {
            try {
                EgSSL egSSL = EgSSL.getInstance();
                egSSL.enableSSL();
                SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
                string = null;
                try {
                    object2 = new MyX509TrustManager();
                    httpURLConnection = null;
                    object = new TrustManager[]{object2};
                    SSLContext sSLContext = SSLContext.getInstance("SSL");
                    sSLContext.init((KeyManager[])httpURLConnection, (TrustManager[])object, new SecureRandom());
                    SSLSocketFactory sSLSocketFactory2 = sSLContext.getSocketFactory();
                    HttpsURLConnection.setDefaultSSLSocketFactory(sSLSocketFactory2);
                    HttpsURLConnection.setDefaultHostnameVerifier(new MyHostnameVerifier());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        long l = System.currentTimeMillis();
        try {
            string = "";
            string = this.isSsl ? "https://" + this.targetHost + ":" + this.port + "/scripts/wpnbr.dll" : "http://" + this.targetHost + ":" + this.port + "/scripts/wpnbr.dll";
            object2 = new URL(string);
            httpURLConnection = (HttpURLConnection)((URL)object2).openConnection();
            httpURLConnection.setRequestMethod("POST");
            HttpURLConnection.setFollowRedirects(false);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setRequestProperty("Content-Type", "text/xml");
            httpURLConnection.setRequestProperty("Content-Length", this.contentLen + "");
            object = new CtxXmlHelper(httpURLConnection, this.data);
            long l2 = 0L;
            long l3 = 250L;
            long l4 = System.currentTimeMillis();
            do {
                this.suspendForPeriod(l3);
                if (!((CtxXmlHelper)object).done) continue;
                if (!((CtxXmlHelper)object).status || ((CtxXmlHelper)object).output == null || ((CtxXmlHelper)object).output.size() == 0) {
                    ArrayList<Double> arrayList = new ArrayList<Double>();
                    arrayList.add(new Double(n));
                    arrayList.add(new Double(n3));
                    arrayList.add(new Double(n2));
                    arrayList.add(new Double(d));
                    arrayList.add(new Double(d2));
                    this.addNewMeasure(arrayList);
                    return;
                }
                if (((CtxXmlHelper)object).connectTime > 0L) {
                    n = 100;
                    d = (double)(((CtxXmlHelper)object).connectTime - l) / 1000.0;
                } else {
                    d = -5.0;
                }
                d2 = ((CtxXmlHelper)object).finishTime > 0L ? (double)(((CtxXmlHelper)object).finishTime - l) / 1000.0 : -5.0;
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = true;
                boolean bl4 = false;
                boolean bl5 = true;
                if (((CtxXmlHelper)object).output != null) {
                    for (int i = 0; i < ((CtxXmlHelper)object).output.size(); ++i) {
                        String string2 = (String)((CtxXmlHelper)object).output.get(i);
                        if ((string2 = string2.toLowerCase()).indexOf("</nfuseprotocol>") >= 0) {
                            bl = true;
                            break;
                        }
                        if (string2.indexOf("<nfuseprotocol") >= 0) {
                            bl2 = true;
                        } else if (string2.indexOf("<errorid>") >= 0 || string2.indexOf("<error-id") >= 0) {
                            bl3 = false;
                        } else if (string2.indexOf("ticket>") >= 0) {
                            bl4 = true;
                        }
                        if (string2.indexOf("failed-credentials") < 0) continue;
                        bl5 = false;
                        break;
                    }
                }
                if (bl5) {
                    n3 = 100;
                }
                n2 = !bl || !bl2 || !bl4 || !bl5 ? 0 : 100;
                ArrayList<Double> arrayList = new ArrayList<Double>();
                arrayList.add(new Double(n));
                arrayList.add(new Double(n3));
                arrayList.add(new Double(n2));
                arrayList.add(new Double(d));
                arrayList.add(new Double(d2));
                this.addNewMeasure(arrayList);
                return;
            } while ((l2 = System.currentTimeMillis() - l4) < (long)this.timeout);
            ((Thread)object).interrupt();
            Thread.yield();
            object = null;
            ArrayList<Double> arrayList = new ArrayList<Double>();
            arrayList.add(new Double(n));
            arrayList.add(new Double(n3));
            arrayList.add(new Double(n2));
            arrayList.add(new Double(d));
            arrayList.add(new Double(d2));
            this.addNewMeasure(arrayList);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            object2 = new ArrayList<Double>();
            ((ArrayList)object2).add(new Double(n));
            ((ArrayList)object2).add(new Double(n3));
            ((ArrayList)object2).add(new Double(n2));
            ((ArrayList)object2).add(new Double(d));
            ((ArrayList)object2).add(new Double(d2));
            this.addNewMeasure((ArrayList)object2);
            return;
        }
    }

    private void suspendForPeriod(long l) {
        long l2 = System.currentTimeMillis() + l;
        while (l > 0L) {
            if (l < 25L) {
                l = 25L;
            }
            try {
                Thread.sleep(l);
            }
            catch (Exception exception) {
                // empty catch block
            }
            long l3 = System.currentTimeMillis();
            l = l2 - l3;
        }
    }
}

