/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class CiscoOspfNbrStTest
extends EgSnmpGenericTest {
    private boolean isFirst = true;

    public CiscoOspfNbrStTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(2);
        this.isNewDynamicInfoTest = true;
        this.snmpPortNo = this.getValueForParam("snmpPort");
        this.snmpVersion = this.getValueForParam("snmpVersion");
        this.community = this.getValueForParam("snmpCommunity");
    }

    public void computeMeasures(Hashtable hashtable) {
        try {
            Hashtable hashtable2 = this.getMeasures(".1.3.6.1.2.1.14.10.1.3");
            Hashtable hashtable3 = this.getMeasures(".1.3.6.1.2.1.14.10.1.6");
            Hashtable hashtable4 = this.getMeasures(".1.3.6.1.2.1.14.10.1.9");
            if (hashtable2 == null || hashtable2.size() == 0) {
                if (this.isFirst) {
                    this.logToErrorFile("Info", "No OSPF Neighbor configured for ", this.targetHost);
                    this.isFirst = false;
                }
                return;
            }
            Enumeration enumeration = hashtable2.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = (String)hashtable2.get(string);
                String string3 = (String)hashtable3.get(string);
                String string4 = (String)hashtable4.get(string);
                double d = this.getDoubleValue(string3);
                double d2 = this.getDoubleValue(string4);
                if (d2 == 2.0) {
                    d2 = 5.0;
                }
                if (d2 == 3.0) {
                    d2 = 4.0;
                }
                if (d2 == 4.0) {
                    d2 = 2.0;
                }
                if (d2 == 5.0) {
                    d2 = 3.0;
                }
                ArrayList<Double> arrayList = new ArrayList<Double>();
                arrayList.add(new Double(d));
                arrayList.add(new Double(d2));
                System.out.println(this.entity + " Info :" + string2 + " MeasureList :" + arrayList);
                this.addNewMeasure(string2, arrayList);
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Exception :", "CiscoOspfNbrStTest Exception occured in computeMeasures() for ", this.targetHost);
        }
    }

    private double getDoubleValue(String string) {
        double d = -5.0;
        try {
            d = string != null && string.trim().length() > 0 ? Double.parseDouble(string) : -5.0;
        }
        catch (Exception exception) {
            this.logToErrorFile("Exception :", "CiscoOspfNbrStTest Exception occured in getDoubleValue() for " + this.targetHost, exception.toString());
            d = -5.0;
        }
        return d;
    }

    private Hashtable getMeasures(String string) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        try {
            String string2 = "";
            String string3 = "";
            boolean bl = this.runSnmpCmdForOid(string);
            if (bl) {
                for (int i = 0; i < this.lhs.length; ++i) {
                    string2 = this.lhs[i].trim();
                    if (this.rhs[i] != null && this.rhs[i].trim().length() > 0) {
                        string3 = this.rhs[i].trim();
                        hashtable.put(string2, string3);
                        continue;
                    }
                    hashtable.put(string2, "-5");
                }
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Exception :", "CiscoOspfNbrStTest Exception occured in getMeasures() for " + this.targetHost, exception.toString());
        }
        return hashtable;
    }
}

