/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class BobiDFSQueryTest
extends BobiBase {
    private static final String RUNNING_QUERIES = "Number of Running Queries";
    private static final String QUERIES_CONSUMING_MEMORY = "Number of Queries Consuming Memory";
    private static final String QUERIES_USING_DISK = "Number of Queries Using Disk";
    private static final String QUERIES_WAITING_RESOURCE = "Number of Queries Waiting for Resources";
    private static final String FAILED_QUERIES = "Number of Failed Queries";
    private static final String QUERIES_IN_QUERY_ANALYZE_STEP = "Number of Queries in Query Analyze Step";
    private static final String QUERIES_IN_QUERY_OPTIMIZ_STEP = "Number of Queries in Query Optimization Step";
    private static final String QUERIES_IN_QUERYEC_STEP = "Number of Queries in Query Execution Step";
    private static final String BYTES_PRODUCED_BY_QUERYEC = "Total Bytes Produced by Query Execution";
    private static final String BYTES_TRANS_FROM_DATA_SOURCE = "Total Bytes Transferred from Data Sources";
    private static final double BYTES_TO_MB = 1048576.0;
    private static final ArrayList attrArrayList = new ArrayList();
    private static final ArrayList dummymeasureArrayList = new ArrayList();

    public BobiDFSQueryTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(attrArrayList.size());
        this.isDynamicInfoTest = true;
    }

    public void debugComputeMeasures(Hashtable hashtable, boolean bl) {
        Hashtable hashtable2 = null;
        this.printOut("Node name :" + this.nodeName);
        String string = "Servers:name=" + this.nodeName + "*,type=aps";
        this.printOut("Query Filter : " + string);
        hashtable2 = this.getAttrs(string, attrArrayList);
        this.printOut("DEBUG : dataHT is " + hashtable2);
        if (hashtable2 == null || hashtable2.size() == 0 || hashtable2.isEmpty()) {
            this.logToErrorFile("WARNING", this.reportingName + ":" + this.entity, "Attributes data hashtable value is null");
            this.printOut("WARNING : Attributes data hashtable value is not usable : " + hashtable2);
            this.addNewMeasure(dummymeasureArrayList);
            return;
        }
        Enumeration enumeration = hashtable2.keys();
        double d = -5.0;
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            Hashtable hashtable3 = (Hashtable)hashtable2.get(string2);
            ArrayList<Double> arrayList = new ArrayList<Double>();
            this.printOut("Info :" + string2);
            for (int i = 0; i < attrArrayList.size(); ++i) {
                String string3 = (String)attrArrayList.get(i);
                d = this.getHashtableData(hashtable3, string3);
                if (i > 7) {
                    try {
                        d = d < 0.0 ? -5.0 : this.roundDouble(d / 1048576.0, 2);
                    }
                    catch (Exception exception) {
                        d = -5.0;
                    }
                }
                arrayList.add(new Double(d));
            }
            if (!bl) {
                this.addNewMeasure(string2, arrayList);
            }
            this.printOut("Info  :" + string2 + "  ,Measure ArrayList  :" + arrayList);
        }
    }

    public void computeMeasures(Hashtable hashtable) {
        this.debugComputeMeasures(hashtable, false);
    }

    public static void main(String[] stringArray) {
        BobiDFSQueryTest bobiDFSQueryTest = new BobiDFSQueryTest(stringArray);
        bobiDFSQueryTest.debugComputeMeasures(new Hashtable(), true);
    }

    static {
        attrArrayList.add(RUNNING_QUERIES);
        attrArrayList.add(QUERIES_CONSUMING_MEMORY);
        attrArrayList.add(QUERIES_USING_DISK);
        attrArrayList.add(QUERIES_WAITING_RESOURCE);
        attrArrayList.add(FAILED_QUERIES);
        attrArrayList.add(QUERIES_IN_QUERY_ANALYZE_STEP);
        attrArrayList.add(QUERIES_IN_QUERY_OPTIMIZ_STEP);
        attrArrayList.add(QUERIES_IN_QUERYEC_STEP);
        attrArrayList.add(BYTES_PRODUCED_BY_QUERYEC);
        attrArrayList.add(BYTES_TRANS_FROM_DATA_SOURCE);
        attrArrayList.add("Total Bytes of Memory Used by Query Execution");
        attrArrayList.add("Total Bytes of Disk Used by Query Execution");
        attrArrayList.add("Total Bytes of Memory Used by Metadata Cache");
        for (int i = 0; i < attrArrayList.size(); ++i) {
            dummymeasureArrayList.add(new Double(-5.0));
        }
    }
}

