/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class AsAbapSpoolTest_cf
extends AsAbapTblBase {
    String parameters = "rspo/auth/pagelimit,rspo/check_memory,rspo/devinit/datafile,rspo/global_shm/action_list,rspo/global_shm/job_list,rspo/global_shm/printer_list,rspo/global_shm/server_list,rspo/log/maxerror,rspo/lpq/retries,rspo/lpq/temp_disable_slow,rspo/lpq/temp_disable_time,rspo/rspoget2_daemon/saplpd_block_size,rspo/rspoget2_daemon/tcp_block_size,rspo/spool_id/chunk,rspo/spool_id/loopbreak,rspo/spool_id/max_number,rspo/stat/jobs,rspo/stat/query,rspo/store_location,rspo/tcp/retries,rspo/tcp/retrytime,rspo/tcp/timeout/connect,rspo/tcp/timeout/read,rspo/tcp/timeout/write,rspo/to_host/datafile";
    Hashtable paramNameMappingTbl = null;
    Hashtable previousMeasTbl = new Hashtable();

    public AsAbapSpoolTest_cf(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(3);
        this.setConfigInfoTestFlag(true);
        this.paramNameMappingTbl = new Hashtable();
        this.paramNameMappingTbl.put("rspo/auth/pagelimit", "Activation of page limit check for spool devices");
        this.paramNameMappingTbl.put("rspo/check_memory", "Is internal memory checking activated");
        this.paramNameMappingTbl.put("rspo/devinit/datafile", "Pathname for file containing device initialization");
        this.paramNameMappingTbl.put("rspo/global_shm/action_list", "Startup size for spool action list");
        this.paramNameMappingTbl.put("rspo/global_shm/job_list", "Number of entries allowed in spool system's request queue");
        this.paramNameMappingTbl.put("rspo/global_shm/printer_list", "number of entries allowed in the shared memory cache of the SAP spool system");
        this.paramNameMappingTbl.put("rspo/global_shm/server_list", "Startup cache size for spool server cache");
        this.paramNameMappingTbl.put("rspo/log/maxerror", "Maximum error log allowed");
        this.paramNameMappingTbl.put("rspo/lpq/retries", "Number of query retries until jobs go to problem state");
        this.paramNameMappingTbl.put("rspo/lpq/temp_disable_slow", "Time threshold (seconds) after which slow printers are deactivated");
        this.paramNameMappingTbl.put("rspo/lpq/temp_disable_time", "Duration (seconds) for which slow printers are deactivated");
        this.paramNameMappingTbl.put("rspo/rspoget2_daemon/saplpd_block_size", "Maximum packet size for saplpd");
        this.paramNameMappingTbl.put("rspo/rspoget2_daemon/tcp_block_size", "Maximum packet size for access method U");
        this.paramNameMappingTbl.put("rspo/spool_id/chunk", "Number of spool IDs reserved at one time");
        this.paramNameMappingTbl.put("rspo/spool_id/loopbreak", "Maximum loopcount for spool ID check");
        this.paramNameMappingTbl.put("rspo/spool_id/max_number", "Upper limit of spool ID number range");
        this.paramNameMappingTbl.put("rspo/stat/jobs", "Write statistic data for printjobs into TSPJSTAT");
        this.paramNameMappingTbl.put("rspo/stat/query", "Write statistic data for printer queues into TSPQSTAT");
        this.paramNameMappingTbl.put("rspo/store_location", "where TemSe stores data from R/3 spool");
        this.paramNameMappingTbl.put("rspo/tcp/retries", "Number of attempts to connect to remote printer");
        this.paramNameMappingTbl.put("rspo/tcp/retrytime", "Maximum delay between attempts to establish LPD communication");
        this.paramNameMappingTbl.put("rspo/tcp/timeout/connect", "Connect timeout");
        this.paramNameMappingTbl.put("rspo/tcp/timeout/read", "Read timeout");
        this.paramNameMappingTbl.put("rspo/tcp/timeout/write", "Write timeout");
        this.paramNameMappingTbl.put("rspo/to_host/datafile", "Name of file to send to host spooler");
    }

    public void computeMeasures(Hashtable hashtable) {
        this.debugComputeMeasures(hashtable, true);
    }

    public void debugComputeMeasures(Hashtable hashtable, boolean bl) {
        Hashtable hashtable2 = this.getParamValues(this.parameters);
        ArrayList arrayList = null;
        if (hashtable2 == null || hashtable2.isEmpty()) {
            this.printOut("No config measures Got from base............so looking for previous measure..........");
            if (this.previousMeasTbl == null || this.previousMeasTbl.isEmpty()) {
                this.printOut("No previous measures exist for this component " + this.reportingName + " ......... so not calling addNewMeasure()......returning........");
                return;
            }
            Enumeration enumeration = this.previousMeasTbl.keys();
            while (enumeration.hasMoreElements()) {
                arrayList = new ArrayList();
                String string = (String)enumeration.nextElement();
                arrayList = (ArrayList)this.previousMeasTbl.get(string);
                this.printOut("Logon Profile name : " + string + " And it's configuration : " + arrayList);
                if (!bl) continue;
                this.addNewMeasure(string, arrayList);
            }
            return;
        }
        this.previousMeasTbl = new Hashtable();
        StringTokenizer stringTokenizer = new StringTokenizer(this.parameters, ",");
        while (stringTokenizer.hasMoreElements()) {
            arrayList = new ArrayList();
            String string = (String)stringTokenizer.nextElement();
            String string2 = (String)hashtable2.get(string);
            String string3 = null;
            if (string != null && string2 != null && (string.equals("rspo/stat/jobs") || string.equals("rspo/stat/query") || string.equals("rspo/check_memory"))) {
                string2 = string2.equals("0") ? "No" : (string2.equals("") ? "Disabled" : "Yes");
            }
            if (string2 == null || string2.equals("")) {
                string2 = "Disabled";
            }
            if (string.equals("rspo/rspoget2_daemon/tcp_block_size")) {
                string2 = string2 + " (Bytes)";
            } else if (string.equals("rspo/tcp/retrytime")) {
                string2 = string2 + " (Seconds)";
            } else if (string.equals("rspo/tcp/timeout/connect")) {
                string2 = string2 + " (Seconds)";
            } else if (string.equals("rspo/tcp/timeout/read")) {
                string2 = string2 + " (Seconds)";
            } else if (string.equals("rspo/tcp/timeout/write")) {
                string2 = string2 + " (Seconds)";
            }
            if (string2.indexOf("Disabled") > -1) {
                string2 = "Disabled";
            }
            string3 = this.paramNameMappingTbl.containsKey(string) ? (String)this.paramNameMappingTbl.get(string) : "-";
            arrayList.add(string2);
            arrayList.add(string3);
            this.printOut("Profile parameter is : " + string + " and it's measure value is >>>>>> " + string2);
            this.previousMeasTbl.put(string, arrayList);
            if (!bl) continue;
            this.addNewMeasure(string, arrayList);
        }
    }

    public static void main(String[] stringArray) {
        AsAbapSpoolTest_cf asAbapSpoolTest_cf = new AsAbapSpoolTest_cf(stringArray);
        asAbapSpoolTest_cf.debugComputeMeasures(new Hashtable(), false);
    }
}

