/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.management.ObjectName;
import javax.management.openmbean.TabularData;

public abstract class ActiveMQBase
extends JVMInstrumentation {
    Hashtable prevMeasure = new Hashtable();
    protected static final String[] queueOrTopicAttributeNames = new String[]{"ProducerCount", "ConsumerCount", "QueueSize", "DequeueCount", "EnqueueCount", "DispatchCount", "ExpiredCount", "InFlightCount", "Subscriptions", "DLQ", "AverageMessageSize", "MaxPageSize", "MaxEnqueueTime", "MinEnqueueTime", "AverageEnqueueTime", "MemoryLimit", "MemoryPercentUsage", "MemoryUsageByteCount"};
    protected static final String[] BrokerAttributeNames = new String[]{"TotalProducerCount", "TotalConsumerCount", "TotalMessageCount", "AverageMessageSize", "TotalEnqueueCount", "TotalDequeueCount", "QueueProducers", "QueueSubscribers", "TemporaryQueues", "TemporaryQueueProducers", "TemporaryQueueSubscribers", "TopicProducers", "TopicSubscribers", "TemporaryTopics", "TemporaryTopicProducers", "TemporaryTopicSubscribers", "DurableTopicSubscribers", "InactiveDurableTopicSubscribers", "MemoryLimit", "MemoryPercentUsage", "StoreLimit", "StorePercentUsage", "TempLimit", "TempPercentUsage", "BrokerVersion"};

    public ActiveMQBase(String[] stringArray) {
        super(stringArray);
    }

    private Hashtable connectionMetricCollection(ObjectName objectName, String string) {
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        try {
            Set<ObjectName> set = this.beanServerConn.queryNames(objectName, null);
            Iterator<ObjectName> iterator = set.iterator();
            while (iterator.hasNext()) {
                try {
                    Integer n;
                    String string2;
                    ObjectName objectName2 = iterator.next();
                    Hashtable<String, String> hashtable2 = objectName2.getKeyPropertyList();
                    if (hashtable2.containsKey("connectionViewType") || (string2 = hashtable2.get("connectorName")) == null || (n = (Integer)this.beanServerConn.invoke(objectName2, string, new Object[0], new String[0])) == null) continue;
                    hashtable.put(string2, n);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return hashtable;
    }

    private Hashtable healthMetricCollection(ObjectName objectName, String string) {
        Hashtable<String, Serializable> hashtable = new Hashtable<String, Serializable>();
        try {
            Serializable serializable;
            Iterator<ObjectName> iterator;
            Set<ObjectName> set;
            TabularData tabularData = null;
            try {
                set = this.beanServerConn.queryNames(objectName, null);
                iterator = set.iterator();
                if (iterator.hasNext()) {
                    serializable = iterator.next();
                    tabularData = (TabularData)this.beanServerConn.invoke((ObjectName)serializable, string, new Object[0], new String[0]);
                }
            }
            catch (Exception exception) {
                System.out.println("Exception while getting ActiveMQ Health " + exception);
                exception.printStackTrace();
            }
            if (tabularData != null) {
                set = tabularData.keySet();
                iterator = set.iterator();
                serializable = new ArrayList();
                ArrayList<String> arrayList = new ArrayList<String>();
                while (iterator.hasNext()) {
                    List list = (List)((Object)iterator.next());
                    if (list == null || list.size() != 4) continue;
                    String string2 = (String)list.get(1);
                    arrayList.add(string2);
                    String string3 = (String)list.get(2);
                    if (string2 == null || !string2.equals("WARNING")) continue;
                    ((ArrayList)serializable).add(string2);
                    ((ArrayList)serializable).add(string3);
                }
                hashtable.put(string, serializable);
                hashtable.put("warningSize", arrayList);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return hashtable;
    }

    public Hashtable serverMetricCollection(String string, String[] stringArray) {
        Hashtable hashtable = new Hashtable();
        if (this.beanServerConn == null) {
            return hashtable;
        }
        try {
            Set<ObjectName> set = this.beanServerConn.queryNames(new ObjectName(string), null);
            for (ObjectName objectName : set) {
                Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
                Hashtable<String, String> hashtable3 = objectName.getKeyPropertyList();
                if (hashtable3.containsKey("clientId") || hashtable3.containsKey("producerId") || hashtable3.containsKey("remoteAddress")) continue;
                String string2 = "";
                String string3 = hashtable3.get("destinationName");
                String string4 = hashtable3.get("destinationType");
                if (string3 != null && string3.contains("Advisory")) continue;
                String string5 = hashtable3.get("brokerName");
                if (string3 != null && string4 != null) {
                    string2 = string3;
                } else if (string5 != null) {
                    string2 = string5;
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    Object object = null;
                    try {
                        object = this.beanServerConn.getAttribute(objectName, stringArray[i]);
                    }
                    catch (Exception exception) {
                        continue;
                    }
                    if (object == null) continue;
                    hashtable2.put(stringArray[i], object);
                }
                hashtable.put(string2, hashtable2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            hashtable = null;
        }
        return hashtable;
    }

    public Hashtable getActiveMQStatus(String[] stringArray, String[] stringArray2) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        if (this.beanServerConn == null) {
            return hashtable;
        }
        try {
            String string = "connectionCount";
            String string2 = "health";
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray3;
                ObjectName objectName = new ObjectName(stringArray[i]);
                String string3 = stringArray2[i];
                String string4 = objectName.toString();
                if (string3.equals("health")) {
                    stringArray3 = this.healthMetricCollection(objectName, string2);
                    hashtable.put("ACTIVEMQ_HEALTH", stringArray3);
                    continue;
                }
                if (string3.equals("broker")) {
                    try {
                        stringArray3 = new String[]{"TotalConnectionsCount"};
                        Hashtable hashtable2 = this.serverMetricCollection(string4, stringArray3);
                        if (hashtable2 == null || hashtable2.size() <= 0) continue;
                        Set set = hashtable2.keySet();
                        for (String string5 : set) {
                            Hashtable hashtable3 = (Hashtable)hashtable2.get(string5);
                            hashtable.put("ACTIVEMQ_TOTAL_CONNECTION", hashtable3);
                        }
                        continue;
                    }
                    catch (Exception exception) {
                        continue;
                    }
                }
                if (!string3.equals("connector")) continue;
                stringArray3 = this.connectionMetricCollection(objectName, string);
                hashtable.put("ACTIVEMQ_CONNECTION", stringArray3);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return hashtable;
    }

    protected double getAttributeDetails(Hashtable hashtable, String string) {
        double d = -5.0;
        try {
            Object v = hashtable.get(string);
            if (v != null) {
                if (v instanceof Long) {
                    Long l = (Long)v;
                    d = l.doubleValue();
                } else if (v instanceof Double) {
                    Double d2 = (Double)v;
                    d = d2 / 1000.0;
                } else if (v instanceof Integer) {
                    Integer n = (Integer)v;
                    d = n.doubleValue();
                } else if (v instanceof Boolean) {
                    Boolean bl = (Boolean)v;
                    boolean bl2 = bl;
                    d = bl2 ? 0.0 : 1.0;
                } else if (v instanceof Object[]) {
                    Object[] objectArray = (Object[])v;
                    d = objectArray.length;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return d;
    }

    protected String changeUnit(double d) {
        String string = Double.toString(d);
        return EgUtils.convertMemoryValues(string, "B", "MB");
    }

    protected double getCurrentMinusPrevious(String string, double d) {
        double d2 = d;
        if (this.prevMeasure != null && this.prevMeasure.containsKey(string)) {
            Double d3 = (Double)this.prevMeasure.get(string);
            if (d3 != null) {
                double d4 = Double.parseDouble(d3.toString());
                if (d4 >= 0.0) {
                    d2 = d >= d4 ? d - d4 : d;
                }
                this.prevMeasure.put(string, new Double(d));
            }
        } else {
            this.prevMeasure.put(string, new Double(d));
        }
        return d2;
    }
}

