/*
 * Decompiled with CFR 0.152.
 */
import com.ibm.as400.access.AS400;
import com.ibm.as400.access.SystemStatus;
import java.util.ArrayList;
import java.util.Hashtable;

public class AS400UserTest
extends GenericTest {
    private String userID = null;
    private String password = null;
    private String system = null;

    public AS400UserTest(String[] stringArray) {
        super(stringArray);
        this.isNewDynamicInfoTest = true;
        this.system = this.getValueForParam("ServerName");
        this.userID = this.getValueForParam("UserID");
        this.password = this.getValueForParam("Password");
        this.setMeasureCount(this.measureCount);
    }

    public static void main(String[] stringArray) {
        AS400UserTest aS400UserTest = new AS400UserTest(stringArray);
        aS400UserTest.computeMeasures(new Hashtable());
    }

    public void computeMeasures(Hashtable hashtable) {
        block5: {
            ArrayList<Double> arrayList = null;
            double d = 0.0;
            AS400 aS400 = null;
            try {
                aS400 = AS400Helper.getAS400Instance(this.system, this.userID, this.password, this);
                SystemStatus systemStatus = new SystemStatus(aS400);
                systemStatus.setCaching(true);
                if (systemStatus.isCaching()) {
                    double d2 = systemStatus.getUsersCurrentSignedOn();
                    double d3 = systemStatus.getUsersSignedOffWithPrinterOutputWaitingToPrint();
                    double d4 = systemStatus.getUsersSuspendedBySystemRequest();
                    double d5 = systemStatus.getUsersTemporarilySignedOff();
                    d = systemStatus.getUsersSuspendedByGroupJobs();
                    arrayList = new ArrayList<Double>();
                    arrayList.add(new Double(d2));
                    arrayList.add(new Double(d3));
                    arrayList.add(new Double(d4));
                    arrayList.add(new Double(d5));
                    if (this.measureCount > 4) {
                        arrayList.add(new Double(d));
                    }
                    if (debug) {
                        System.out.println("[" + this.entity + "] MeasureList -->" + arrayList);
                    }
                    this.addNewMeasure(arrayList);
                    systemStatus.setCaching(false);
                }
                aS400.disconnectService(2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (aS400 == null) break block5;
                aS400.disconnectService(2);
            }
        }
    }
}

