/*
 * Decompiled with CFR 0.152.
 */
package com.zehon.ftp;

import java.util.Locale;
import org.apache.commons.net.ftp.Configurable;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPFileEntryParser;
import org.apache.commons.net.ftp.parser.DefaultFTPFileEntryParserFactory;
import org.apache.commons.net.ftp.parser.ParserInitializationException;

public class ZehonFTPFileEntryParserFactory
extends DefaultFTPFileEntryParserFactory {
    private static final String OS4690 = "4690";
    private FTPClientConfig config = null;

    public FTPFileEntryParser createFileEntryParser(String key) {
        if (key == null) {
            throw new ParserInitializationException("Parser key cannot be null");
        }
        Class<?> parserClass = null;
        FTPFileEntryParser parser = null;
        try {
            parserClass = Class.forName(key);
            parser = (FTPFileEntryParser)parserClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            try {
                String ukey = null;
                if (null != key) {
                    ukey = key.toUpperCase(Locale.ENGLISH);
                }
                if (ukey.indexOf("UNIX") >= 0 || ukey.indexOf("TYPE: L8") >= 0) {
                    parser = this.createUnixFTPEntryParser();
                }
                if (ukey.indexOf("VMS") >= 0) {
                    parser = this.createVMSVersioningFTPEntryParser();
                }
                if (ukey.indexOf("WINDOWS") >= 0) {
                    parser = this.createNTFTPEntryParser();
                }
                if (ukey.indexOf("OS/2") >= 0 || ukey.indexOf(OS4690) >= 0) {
                    parser = this.createOS2FTPEntryParser();
                }
                if (ukey.indexOf("OS/400") >= 0 || ukey.indexOf("AS/400") >= 0) {
                    parser = this.createOS400FTPEntryParser();
                }
                if (ukey.indexOf("MVS") >= 0) {
                    parser = this.createMVSEntryParser();
                }
                if (ukey.indexOf("NETWARE") >= 0) {
                    parser = this.createNetwareFTPEntryParser();
                }
                throw new ParserInitializationException("Unknown parser type: " + key);
            }
            catch (NoClassDefFoundError nf) {
                throw new ParserInitializationException("Error initializing parser", (Throwable)nf);
            }
        }
        catch (NoClassDefFoundError e) {
            throw new ParserInitializationException("Error initializing parser", (Throwable)e);
        }
        catch (ClassCastException e) {
            throw new ParserInitializationException(parserClass.getName() + " does not implement the interface " + "org.apache.commons.net.ftp.FTPFileEntryParser.", (Throwable)e);
        }
        catch (Throwable e) {
            throw new ParserInitializationException("Error initializing parser", e);
        }
        if (parser instanceof Configurable) {
            ((Configurable)parser).configure(this.config);
        }
        return parser;
    }

    public FTPFileEntryParser createFileEntryParser(FTPClientConfig config) throws ParserInitializationException {
        this.config = config;
        String key = config.getServerSystemKey();
        return this.createFileEntryParser(key);
    }
}

