/*
 * Decompiled with CFR 0.152.
 */
package com.zehon.ftp;

import com.zehon.BatchTransferProgress;
import com.zehon.FileTransferClient;
import com.zehon.exception.FileTransferException;
import com.zehon.ftp.ZehonFTPFileEntryParserFactory;
import java.io.InputStream;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.ftp.parser.FTPFileEntryParserFactory;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.provider.ftp.FtpFileSystemConfigBuilder;

public class FTPClient
extends FileTransferClient {
    private String serverName;
    private String username;
    private String password;
    private int port = 21;
    private static final Log log = LogFactory.getLog(FTPClient.class);

    public FTPClient() {
    }

    public FTPClient(String serverName, String username, String password) {
        this.setServerName(serverName);
        this.setUsername(username);
        this.setPassword(password);
    }

    public FTPClient(String serverName, int port, String username, String password) {
        this.setServerName(serverName);
        this.setPort(port);
        this.setUsername(username);
        this.setPassword(password);
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    protected boolean validate() {
        try {
            Class<?> ftpDependency = Class.forName("org.apache.commons.net.ftp.FTPClient");
        }
        catch (ClassNotFoundException e) {
            log.fatal((Object)"++++++++++++PLEASE MAKE SURE HAVE ALL THE DEPENDENCY JARS IN THE CLASSPATH ++++++");
            return false;
        }
        return super.validate();
    }

    public int sendFile(String localFilePath, String ftpDestFolder) throws FileTransferException {
        return super.sendFile(localFilePath, ftpDestFolder);
    }

    public int sendFile(String localFilePath, String filetransferDestFolder, String nameOfFileToStore) throws FileTransferException {
        return this.sendFile(localFilePath, filetransferDestFolder, nameOfFileToStore, false);
    }

    public int sendFile(InputStream inputStream, String nameOfFileToStore, String ftpDestFolder) throws FileTransferException {
        return super.sendFile(inputStream, nameOfFileToStore, ftpDestFolder);
    }

    public InputStream getFileAsStream(String remoteFileName, String ftpFolder) throws FileTransferException {
        return super.getFileAsStream(remoteFileName, ftpFolder);
    }

    public int getFile(String remoteFileName, String ftpFolder, String toLocalFolder) throws FileTransferException {
        return super.getFile(remoteFileName, ftpFolder, toLocalFolder);
    }

    public int deleteFile(String nameOfFileToDelete, String ftpFolder) throws FileTransferException {
        return super.deleteFile(nameOfFileToDelete, ftpFolder);
    }

    public int createFolder(String nameOfFolderToCreate, String ftpFolder) throws FileTransferException {
        return super.createFolder(nameOfFolderToCreate, ftpFolder);
    }

    public int moveFile(String nameOfFileToMove, String ftpFromFolder, String newNameOfFile, String ftpToFolder) throws FileTransferException {
        return super.moveFile(nameOfFileToMove, ftpFromFolder, newNameOfFile, ftpToFolder);
    }

    public int copyFile(String sourceFilePath, String destFilePath) throws FileTransferException {
        return super.copyFile(sourceFilePath, destFilePath);
    }

    public int getFolder(String ftpFolder, String toLocalFolder, BatchTransferProgress batchTransferProgress) throws FileTransferException {
        return super.getFolder(ftpFolder, toLocalFolder, batchTransferProgress, true, true);
    }

    public int getFolder(String ftpFolder, String toLocalFolder, BatchTransferProgress batchTransferProgress, boolean recursive) throws FileTransferException {
        return super.getFolder(ftpFolder, toLocalFolder, batchTransferProgress, true, recursive);
    }

    public int getFolderCreate(String ftpFolder, String toLocalFolder, BatchTransferProgress batchTransferProgress) throws FileTransferException {
        return super.getFolder(ftpFolder, toLocalFolder, batchTransferProgress, false, true);
    }

    public int getFolderCreate(String ftpFolder, String toLocalFolder, BatchTransferProgress batchTransferProgress, boolean recursive) throws FileTransferException {
        return super.getFolder(ftpFolder, toLocalFolder, batchTransferProgress, false, recursive);
    }

    public String[] getFileNamesInFolder(String ftpFolder) throws FileTransferException {
        return super.getFileNamesInFolder(ftpFolder);
    }

    public int sendFolder(String sendingFolder, String ftpFolder, BatchTransferProgress batchTransferProgress) throws FileTransferException {
        return super.sendFolder(sendingFolder, ftpFolder, batchTransferProgress, true, true);
    }

    public int sendFolder(String sendingFolder, String ftpFolder, BatchTransferProgress batchTransferProgress, boolean recursive) throws FileTransferException {
        return super.sendFolder(sendingFolder, ftpFolder, batchTransferProgress, true, recursive);
    }

    public int sendFolderCreate(String sendingFolder, String ftpFolder, BatchTransferProgress batchTransferProgress) throws FileTransferException {
        return super.sendFolder(sendingFolder, ftpFolder, batchTransferProgress, false, true);
    }

    public int sendFolderCreate(String sendingFolder, String ftpFolder, BatchTransferProgress batchTransferProgress, boolean recursive) throws FileTransferException {
        return super.sendFolder(sendingFolder, ftpFolder, batchTransferProgress, false, recursive);
    }

    public boolean folderExists(String ftpFolder) throws FileTransferException {
        return super.folderExists(ftpFolder);
    }

    public boolean fileExists(String ftpFolder, String nameOfFile) throws FileTransferException {
        return super.fileExists(ftpFolder, nameOfFile);
    }

    public long getLastModificationTime(String filePath) throws FileTransferException {
        return super.getLastModificationTime(filePath);
    }

    public Date getLastModificationTimeDate(String filePath) throws FileTransferException {
        return super.getLastModificationTimeDate(filePath);
    }

    protected FileSystemOptions getFileSystemOptions() throws FileSystemException {
        FileSystemOptions fsOptions = new FileSystemOptions();
        FtpFileSystemConfigBuilder.getInstance().setUserDirIsRoot(fsOptions, true);
        FtpFileSystemConfigBuilder.getInstance().setPassiveMode(fsOptions, true);
        FtpFileSystemConfigBuilder.getInstance().setEntryParserFactory(fsOptions, (FTPFileEntryParserFactory)new ZehonFTPFileEntryParserFactory());
        return fsOptions;
    }

    protected String getProtocol() {
        return "ftp";
    }
}

