/*
 * Decompiled with CFR 0.152.
 */
package com.thinweb.tds;

import com.thinweb.tds.CallableStatement;
import com.thinweb.tds.Columns;
import com.thinweb.tds.Connection;
import com.thinweb.tds.Constructors;
import com.thinweb.tds.Context;
import com.thinweb.tds.PacketColumnInfoResult;
import com.thinweb.tds.PacketColumnNamesResult;
import com.thinweb.tds.PacketColumnOrderResult;
import com.thinweb.tds.PacketControlResult;
import com.thinweb.tds.PacketDoneInProcResult;
import com.thinweb.tds.PacketEndTokenResult;
import com.thinweb.tds.PacketMsgResult;
import com.thinweb.tds.PacketResult;
import com.thinweb.tds.PacketTabNameResult;
import com.thinweb.tds.PacketUnknown;
import com.thinweb.tds.ResultSet;
import com.thinweb.tds.SQLWarningChain;
import com.thinweb.tds.Tds;
import com.thinweb.tds.TdsException;
import com.thinweb.tds.TdsUnknownPacketSubType;
import com.thinweb.tds.UniqueId;
import java.io.IOException;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.StringTokenizer;
import java.util.Vector;

public class Statement
implements java.sql.Statement {
    private Connection connection;
    protected SQLWarningChain warningChain;
    protected int timeout = 0;
    protected Tds tds = null;
    protected ResultSet results = null;
    private ResultSetMetaData metaResults = null;
    private boolean escapeProcessing = true;
    protected int updateCount = -1;
    private int maxFieldSize;
    private int maxRows = 0;
    private int resultSetType = 1003;
    private int resultSetConcurrency = 1007;
    protected Vector batchSqlStmts = null;
    protected long rowCount;
    boolean isFirstRs;
    public int fetchSize = 1;
    private String cursorName;
    private String sql = null;
    protected Vector batchUpdateCounts = new Vector();
    private boolean eatRow = false;
    private boolean isBatch = false;
    protected Vector outParams;
    private boolean usingCursor;

    public Statement(Object object, Tds tds) throws SQLException {
        this.maxFieldSize = Integer.MAX_VALUE;
        this.tds = tds;
        this.connection = (Connection)object;
        this.warningChain = new SQLWarningChain();
    }

    public void addBatch(String string) throws SQLException {
        if (this.batchSqlStmts == null) {
            this.batchSqlStmts = new Vector();
        }
        this.batchSqlStmts.addElement(string);
    }

    public void cancel() throws SQLException {
        if (this.tds == null) {
            throw new SQLException("Statement is closed");
        }
        try {
            this.tds.cancel();
        }
        catch (TdsException tdsException) {
            throw new SQLException(tdsException.getMessage());
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.getMessage());
        }
    }

    public void clearBatch() throws SQLException {
        if (this.batchSqlStmts != null) {
            this.batchSqlStmts = null;
        }
    }

    public void clearWarnings() throws SQLException {
        this.warningChain.clearWarnings();
    }

    public void close() throws SQLException {
        if (this.tds == null) {
            throw new SQLException("Statement has already been closed.");
        }
        this.closeAllResults();
        if (!this.connection.getAutoCommit() && this.connection.isClosingConn()) {
            try {
                this.rollback();
            }
            catch (Exception exception) {
                throw new SQLException(exception.getMessage());
            }
        }
        Tds tds = this.tds;
        this.tds = null;
        try {
            this.connection.relinquish(tds);
        }
        catch (TdsException tdsException) {
            throw new SQLException("Internal Error: " + tdsException.getMessage());
        }
        tds.close();
        try {
            this.connection.markAsClosed((java.sql.Statement)this);
        }
        catch (TdsException tdsException) {
            throw new SQLException(tdsException.getMessage());
        }
    }

    protected void closeAllResults() throws SQLException {
        try {
            this.tds.discardAllResults();
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    protected void closeResults() throws SQLException {
        if (this.results != null) {
            this.results.close();
            this.results = null;
        }
    }

    public void commit() throws SQLException, IOException, TdsUnknownPacketSubType, TdsException {
        String string = "IF @@TRANCOUNT > 0 COMMIT TRAN ";
        if (this.tds == null) {
            throw new SQLException("Statement is closed");
        }
        this.executeQuery(string);
        this.closeAllResults();
    }

    public boolean execute(String string) throws SQLException {
        this.isFirstRs = true;
        boolean bl = false;
        this.setSql(string);
        if (this.needCursor(string)) {
            string = this.createCursorStmt(string);
            this.eatRow = true;
            bl = true;
        }
        if (this.tds == null) {
            throw new SQLException("Statement is closed");
        }
        this.closeAllResults();
        this.clearWarnings();
        this.updateCount = -1;
        try {
            if (this.escapeProcessing) {
                string = Tds.toNativeSql(string, this.tds.getServerType());
            }
            this.tds.executeQuery(string, this, this.timeout, bl);
        }
        catch (IOException iOException) {
            throw new SQLException("Network error during execute - " + iOException.getMessage());
        }
        catch (TdsException tdsException) {
            throw new SQLException("Tds error : " + tdsException.getMessage());
        }
        return this.getMoreResults();
    }

    /*
     * Unable to fully structure code
     */
    public int[] executeBatch() throws SQLException {
        if (this.batchSqlStmts == null) {
            this.clearBatch();
            return new int[0];
        }
        var1_1 = this.batchSqlStmts.size();
        var2_2 = new int[var1_1];
        var3_3 = 0;
        while (var3_3 < var1_1) {
            var2_2[var3_3] = -2;
            ++var3_3;
        }
        var4_4 = 0;
        while (var4_4 < var1_1) {
            block8: {
                var5_5 = (Statement)this.getConnection().createStatement();
                var6_6 = (String)this.batchSqlStmts.elementAt(var4_4);
                try {
                    var7_7 = var5_5.execute(var6_6);
                    if (var7_7) {
                        var8_9 = new int[var4_4];
                        var9_11 = 0;
                        while (var9_11 < var4_4) {
                            var8_9[var9_11] = var2_2[var9_11];
                            ++var9_11;
                        }
                        this.clearBatch();
                        throw new SQLException("SELECT not permitted in batch");
                    }
                    var2_2[var4_4] = var5_5.getUpdateCount();
                    var5_5.close();
                    break block8;
                }
                catch (Exception var7_8) {
                    var8_10 = new int[var4_4];
                    var9_12 = 0;
                    ** while (var9_12 < var4_4)
                }
lbl-1000:
                // 1 sources

                {
                    var8_10[var9_12] = var2_2[var9_12];
                    ++var9_12;
                    continue;
                }
lbl36:
                // 1 sources

                var5_5.close();
                this.clearBatch();
                throw new SQLException(var7_8.getMessage());
            }
            ++var4_4;
        }
        this.clearBatch();
        return var2_2;
    }

    public int executeUpdate(String string) throws SQLException {
        if (this.execute(string)) {
            this.startResultSet();
            this.closeAllResults();
            throw new SQLException("executeUpdate can't return a result set");
        }
        return this.getUpdateCount();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.tds != null) {
            this.close();
        }
    }

    public int getFetchDirection() throws SQLException {
        return 1002;
    }

    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    public int getMaxFieldSize() throws SQLException {
        return this.maxFieldSize;
    }

    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    public boolean getMoreResults() throws SQLException {
        Object object;
        Throwable throwable = null;
        if (this.tds == null) {
            throw new SQLException("Statement is closed");
        }
        int n = this.updateCount;
        this.updateCount = -1;
        if (!this.tds.moreResults()) {
            this.updateCount = n;
            return false;
        }
        try {
            while (!this.tds.hitEndOfData() && this.tds.isEndOfResults()) {
                if (this.tds.hitEndOfData()) {
                    return false;
                }
                object = (PacketEndTokenResult)this.tds.processSubPacket();
                this.updateCount = ((PacketEndTokenResult)object).getRowCount();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.updateCount != -1) {
            return false;
        }
        this.updateCount = n;
        if (this.tds.hitEndOfData()) {
            return false;
        }
        if (this.tds.isEndOfPacket() && !this.tds.isMoreIncomingPackets()) {
            return false;
        }
        try {
            while (!(this.tds.hitEndOfData() || this.tds.isResultSet() || this.tds.isEndOfResults())) {
                if (this.tds.isProcId()) {
                    this.tds.processSubPacket();
                    continue;
                }
                if (this.tds.isDoneInProc()) {
                    object = (PacketDoneInProcResult)this.tds.processSubPacket();
                    continue;
                }
                if (this.tds.isTextUpdate()) {
                    if (this.outParams == null) {
                        this.outParams = new Vector();
                    }
                    this.outParams.addElement(this.tds.processSubPacket());
                    continue;
                }
                if (this.tds.isMessagePacket()) {
                    object = (PacketMsgResult)this.tds.processSubPacket();
                    continue;
                }
                if (this.tds.isErrorPacket()) {
                    object = (PacketMsgResult)this.tds.processSubPacket();
                    throwable = this.warningChain.addOrReturn((PacketMsgResult)object);
                    continue;
                }
                if (this.tds.isEndOfResults()) {
                    object = (PacketEndTokenResult)this.tds.processSubPacket();
                    if (!this.tds.hitEndOfData()) continue;
                    break;
                }
                if (this.tds.isRetStat()) {
                    this.tds.processSubPacket();
                    continue;
                }
                if (this.tds.isResultRow()) {
                    object = new Context();
                    ((Context)object).setColumnInfo(this.results.getColumnsInfo());
                    this.tds.processSubPacket((Context)object);
                    continue;
                }
                throw new SQLException("Protocol confusion.  Got a 0x " + this.tds.peek() + "  " + Integer.toHexString(this.tds.peek() & 0xFF) + " packet");
            }
            if (throwable != null) {
                try {
                    this.tds.discardResultSet(null);
                }
                catch (IOException iOException) {
                    throw new SQLException("Error discarding result set while processing sql error-  " + throwable.getMessage() + "\nIOException was " + iOException.getMessage());
                }
                catch (TdsException tdsException) {
                    throw new SQLException("Error discarding result set while processing sql error-  " + throwable.getMessage() + "\nIOException was " + tdsException.getMessage());
                }
                throw throwable;
            }
            if (this.tds.hitEndOfData()) {
                return false;
            }
            if (this.tds.isEndOfResults()) {
                while (!this.tds.hitEndOfData() && this.tds.isEndOfResults()) {
                    object = (PacketEndTokenResult)this.tds.processSubPacket();
                    this.updateCount = ((PacketEndTokenResult)object).getRowCount();
                }
                if (!(this instanceof CallableStatement) && this.outParams != null && this.outParams.size() > 0) {
                    this.updateCount = -1;
                    return true;
                }
                if (this instanceof CallableStatement && this.tds.isResultSet()) {
                    this.updateCount = -1;
                    return true;
                }
                if (this.tds.hitEndOfData()) {
                    return false;
                }
                if (this.tds.isResultSet()) {
                    this.updateCount = -1;
                    this.results = null;
                    return true;
                }
                return false;
            }
            if (this.tds.isResultSet()) {
                this.updateCount = -1;
                this.results = null;
                return true;
            }
            throw new SQLException("Protocol confusion.  Got a 0x" + this.tds.peek() + Integer.toHexString(this.tds.peek() & 0xFF) + " packet" + " packet");
        }
        catch (IOException iOException) {
            throw new SQLException("Network error during getMoreResults- " + iOException.getMessage());
        }
        catch (TdsException tdsException) {
            throw new SQLException(tdsException.getMessage());
        }
    }

    public int getQueryTimeout() throws SQLException {
        return this.timeout;
    }

    public int getResultSetConcurrency() {
        return this.resultSetConcurrency;
    }

    public int getResultSetType() {
        return this.resultSetType;
    }

    public long getRowCount() {
        return this.rowCount;
    }

    public int getUpdateCount() throws SQLException {
        return this.updateCount;
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.warningChain.getWarnings();
    }

    boolean isUsingCursor() {
        return this.usingCursor;
    }

    private void NotImplemented() throws SQLException {
        throw new SQLException("Not Implemented");
    }

    public void rollback() throws SQLException, IOException, TdsUnknownPacketSubType, TdsException {
        String string = "IF @@TRANCOUNT > 0 ROLLBACK TRAN ";
        if (this.tds == null) {
            throw new SQLException("Statement is closed");
        }
        this.executeQuery(string);
        this.closeAllResults();
    }

    public void setCursorName(String string) throws SQLException {
        this.cursorName = string;
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        this.escapeProcessing = bl;
    }

    public void setFetchDirection(int n) throws SQLException {
        throw new SQLException("Not supported.");
    }

    public void setFetchSize(int n) throws SQLException {
        this.fetchSize = n;
    }

    public void setMaxFieldSize(int n) throws SQLException {
        this.maxFieldSize = n;
    }

    public void setMaxRows(int n) throws SQLException {
        if (this.maxRows < 0) {
            throw new SQLException("Negative row count");
        }
        this.maxRows = n;
        this.executeUpdate("set rowcount " + this.maxRows);
    }

    public void setQueryTimeout(int n) throws SQLException {
        this.timeout = n;
    }

    public void setResultSetConcurrency(int n) {
        this.resultSetConcurrency = n;
    }

    public void setResultSetType(int n) {
        this.resultSetType = n;
    }

    private void skipToEnd() throws SQLException, IOException, TdsUnknownPacketSubType, TdsException {
        PacketResult packetResult;
        boolean bl;
        while (!(bl = (packetResult = this.tds.processSubPacket()) instanceof PacketEndTokenResult && !((PacketEndTokenResult)packetResult).moreResults())) {
        }
    }

    protected void startResultSet() throws SQLException {
        Columns columns = null;
        Columns columns2 = null;
        SQLException sQLException = null;
        try {
            while (!this.tds.isResultRow() && !this.tds.isEndOfResults()) {
                PacketResult packetResult = this.tds.processSubPacket();
                if (packetResult.getPacketType() == -1) continue;
                if (packetResult instanceof PacketColumnNamesResult) {
                    columns = ((PacketColumnNamesResult)packetResult).getColumnNames();
                    continue;
                }
                if (packetResult instanceof PacketColumnInfoResult) {
                    columns2 = ((PacketColumnInfoResult)packetResult).getColumnInfo();
                    continue;
                }
                if (packetResult instanceof PacketColumnOrderResult || packetResult instanceof PacketTabNameResult || packetResult instanceof PacketControlResult) continue;
                if (packetResult instanceof PacketMsgResult) {
                    sQLException = this.warningChain.addOrReturn((PacketMsgResult)packetResult);
                    continue;
                }
                if (packetResult instanceof PacketUnknown) continue;
                throw new SQLException("Trying to get a result set.  Found a " + packetResult.getClass().getName());
            }
            if (sQLException != null) {
                throw sQLException;
            }
            if (!this.tds.isResultRow() && !this.tds.isEndOfResults()) {
                throw new SQLException("Was expecting a result row.  Got a 0x" + Integer.toHexString(this.tds.peek() & 0xFF));
            }
            if (columns2 != null) {
                columns.merge(columns2);
            }
            columns.tables = this.tds.tables;
            this.results = Constructors.newResultSet(this.tds, this, columns);
            this.results.setCursorName(this.getCursorName());
            if (this.eatRow && this.results != null) {
                this.results.setCursorName(this.getCursorName());
                this.usingCursor = true;
                this.results.next();
                --this.results.rowPosition;
                this.eatRow = false;
                if (this.tds.getTableNames() != null) {
                    this.results.setTableName((String)this.tds.getTableNames().elementAt(0));
                }
            }
        }
        catch (TdsException tdsException) {
            tdsException.printStackTrace();
            throw new SQLException(tdsException.getMessage());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new SQLException(iOException.getMessage());
        }
    }

    public String toNativeDateFormat(Object object) {
        String string = object.toString();
        int n = (string = string.trim()).indexOf(45);
        if (n < 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        stringBuffer.append(string.substring(0, n++));
        int n2 = string.indexOf(45, n);
        if (n2 < 0) {
            stringBuffer.append(string.substring(n));
        } else {
            stringBuffer.append(string.substring(n, n2++));
            stringBuffer.append(string.substring(n2));
        }
        char c = stringBuffer.charAt(0);
        if (c == '\'' || c == '\"') {
            if (stringBuffer.length() > 23) {
                stringBuffer.setLength(22);
                stringBuffer.append(c);
            }
        } else if (stringBuffer.length() > 21) {
            stringBuffer.setLength(21);
        }
        return stringBuffer.toString();
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String string) {
        this.sql = string;
    }

    private String createCursorStmt(String string) throws SQLException {
        int n = this.getResultSetType();
        int n2 = this.getResultSetConcurrency();
        String string2 = "";
        String string3 = "";
        switch (n2) {
            case 1007: {
                string3 = " READ_ONLY";
                break;
            }
            case 1008: 
            case 1009: 
            case 1010: {
                string3 = " SCROLL_LOCKS";
            }
        }
        switch (n) {
            case 1003: {
                string2 = "FORWARD_ONLY";
                break;
            }
            case 1004: {
                string2 = "SCROLL STATIC";
                n2 = 1007;
                break;
            }
            case 1005: {
                if (n2 == 1007) {
                    string2 = "SCROLL KEYSET";
                    n2 = 1007;
                    break;
                }
            }
            case 1006: {
                string2 = "SCROLL DYNAMIC";
            }
        }
        String string4 = this.getCursorName();
        String string5 = "DECLARE " + string4 + " CURSOR " + string2 + string3 + " FOR " + string;
        if (n2 != 1007) {
            string5 = string5 + " FOR UPDATE";
        }
        string5 = string5 + " OPEN " + string4 + " FETCH NEXT FROM " + string4 + " FETCH RELATIVE -1 FROM " + string4;
        this.setCursorName(string4);
        return string5;
    }

    protected int[] getBatchUpdateCounts() {
        int[] nArray = new int[this.batchUpdateCounts.size()];
        int n = 0;
        while (n < this.batchUpdateCounts.size()) {
            nArray[n] = (Integer)this.batchUpdateCounts.elementAt(n);
            ++n;
        }
        return nArray;
    }

    public String getCursorName() {
        if (this.cursorName != null && this.cursorName.length() > 0) {
            return this.cursorName;
        }
        return new String("##tmpcursor" + UniqueId.getUniqueId());
    }

    private boolean isSelect(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r\f,=(", false);
        if (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            return string2.equalsIgnoreCase("select") && stringTokenizer.hasMoreTokens() && !(string2 = stringTokenizer.nextToken()).equalsIgnoreCase("count");
        }
        return false;
    }

    private boolean needCursor(String string) {
        if (this.getResultSetType() == 1003 && this.getResultSetConcurrency() == 1007) {
            return false;
        }
        return !this.isUsingCursor() && this.isSelect(string);
    }

    public java.sql.ResultSet executeQuery(String string) throws SQLException {
        if (this.execute(string) && !this.tds.hitEndOfData()) {
            this.startResultSet();
        }
        return this.results;
    }

    public java.sql.Connection getConnection() throws SQLException {
        return this.connection;
    }

    ResultSet getCurrentResultSet() {
        return this.results;
    }

    public java.sql.ResultSet getResultSet() throws SQLException {
        block12: {
            try {
                if (this.tds == null) {
                    throw new SQLException("Statement is closed.");
                }
                if (this.results != null) {
                    return this.results;
                }
                if (this.updateCount != -1) {
                    return null;
                }
                if (!this.isFirstRs) {
                    this.isFirstRs = false;
                    this.closeResults();
                }
                if (this.tds.hitEndOfData()) {
                    return null;
                }
                if (this.tds.peek() == -1) {
                    this.tds.processSubPacket();
                }
                if (!this.tds.hitEndOfData() && this.tds.isResultSet()) {
                    this.startResultSet();
                    break block12;
                }
                if (this.updateCount != -1) {
                    if (!this.tds.isEndOfResults()) {
                        throw new SQLException("Internal error.   expected EndOfResults, found 0x" + Integer.toHexString(this.tds.peek() & 0xFF));
                    }
                    PacketEndTokenResult packetEndTokenResult = (PacketEndTokenResult)this.tds.processSubPacket();
                    this.updateCount = packetEndTokenResult.getRowCount();
                    this.results = null;
                    break block12;
                }
                throw new SQLException("Internal error.");
            }
            catch (IOException iOException) {
                throw new SQLException(iOException.getMessage());
            }
            catch (TdsException tdsException) {
                throw new SQLException(tdsException.getMessage());
            }
        }
        return this.results;
    }
}

