/*
 * Decompiled with CFR 0.152.
 */
package com.thinweb.tds;

import com.thinweb.tds.Column;
import com.thinweb.tds.Columns;
import com.thinweb.tds.Statement;
import com.thinweb.tds.Tds;
import com.thinweb.tds.TdsException;
import com.thinweb.tds.UniqueId;
import java.sql.SQLException;

public final class ResultSetMetaData
implements java.sql.ResultSetMetaData {
    static final int columnNoNulls = 0;
    static final int columnNullable = 1;
    static final int columnNullableUnknown = 2;
    private Columns columnsInfo;
    Statement stmt;

    public ResultSetMetaData(Columns columns) {
        this.columnsInfo = columns;
    }

    public String getCatalogName(int n) throws SQLException {
        return "";
    }

    public String getColumnClassName(int n) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public int getColumnCount() throws SQLException {
        return this.columnsInfo.getColumnCount();
    }

    public int getColumnDisplaySize(int n) throws SQLException {
        return this.columnsInfo.getDisplaySize(n);
    }

    public String getColumnLabel(int n) throws SQLException {
        return this.columnsInfo.getLabel(n);
    }

    public String getColumnName(int n) throws SQLException {
        return this.columnsInfo.getName(n);
    }

    public int getColumnNumber(int n) throws SQLException {
        if (n - 1 < 0 || n > this.getColumnCount()) {
            throw new SQLException("Invalid column number");
        }
        return n - 1;
    }

    public int getColumnType(int n) throws SQLException {
        int n2;
        try {
            n2 = Tds.cvtNativeTypeToJdbcType(this.columnsInfo.getType(n), this.columnsInfo.getDisplaySize(n));
        }
        catch (TdsException tdsException) {
            tdsException.printStackTrace();
            throw new SQLException("TDS error- " + tdsException.getMessage());
        }
        return n2;
    }

    public String getColumnTypeName(int n) throws SQLException {
        String string = null;
        switch (this.columnsInfo.getType(n)) {
            case 31: {
                string = "VOID";
                break;
            }
            case 34: {
                string = "IMAGE";
                break;
            }
            case 35: {
                string = "TEXT";
                break;
            }
            case 37: {
                string = "VARBINARY";
                break;
            }
            case 38: {
                string = "INTN";
                break;
            }
            case 39: {
                string = "VARCHAR";
                break;
            }
            case 45: {
                string = "BINARY";
                break;
            }
            case 47: {
                string = "CHAR";
                break;
            }
            case 48: {
                string = "INT1";
                break;
            }
            case 50: {
                string = "BIT";
                break;
            }
            case 52: {
                string = "INT2";
                break;
            }
            case 56: {
                string = "INT4";
                break;
            }
            case 58: {
                string = "DATETIME4";
                break;
            }
            case 59: {
                string = "REAL";
                break;
            }
            case 60: {
                string = "MONEY";
                break;
            }
            case 61: {
                string = "DATETIME";
                break;
            }
            case 62: {
                string = "FLT8";
                break;
            }
            case 106: {
                string = "DECIMAL";
                break;
            }
            case 108: {
                string = "NUMERIC";
                break;
            }
            case 109: {
                string = "FLTN";
                break;
            }
            case 110: {
                string = "MONEYN";
                break;
            }
            case 111: {
                string = "DATETIMN";
                break;
            }
            case 112: {
                string = "MONEY4";
                break;
            }
            default: {
                throw new SQLException("Unknown native type for column " + n);
            }
        }
        return string;
    }

    public int getPrecision(int n) throws SQLException {
        return this.columnsInfo.getPrecision(n);
    }

    public int getScale(int n) throws SQLException {
        return this.columnsInfo.getScale(n);
    }

    public String getSchemaName(int n) throws SQLException {
        return "";
    }

    /*
     * Unable to fully structure code
     */
    public String getTableName(int var1_1) throws SQLException {
        var2_2 = "";
        var3_3 = 0;
        while (var3_3 < this.columnsInfo.tables.size()) {
            var2_2 = var3_3 == 0 ? var2_2 + " (" : var2_2 + ",";
            var2_2 = var2_2 + "'" + (String)this.columnsInfo.tables.elementAt(var3_3) + "'";
            ++var3_3;
        }
        var2_2 = var2_2 + ") ";
        var4_4 = "##t#" + UniqueId.getUniqueId();
        var5_5 = "create table " + var4_4 + " (                         " + "    TABLE_NAME      char(32) null,                          " + "    TABLE_ID        integer null,                           " + "    COL_NAME        char(32) null)                          " + "insert into  " + var4_4 + "                           " + "          select                                            " + "               TABLE_NAME=o.name,                           " + "               TABLE_ID=o.id,                               " + "               COL_NAME=c.name                              " + "          from                                              " + "               sysobjects o,                                " + "               syscolumns c                                 " + "          where o.name in" + var2_2 + "" + "               and c.name = '" + this.getColumnName(var1_1) + "'" + "               and o.id = c.id                              " + "select TABLE_NAME from " + var4_4 + "" + "";
        var6_6 = this.stmt.getConnection().createStatement();
        var7_7 = null;
        try {
            var6_6.executeQuery("drop table " + var4_4);
        }
        catch (SQLException var8_8) {
            // empty catch block
        }
        try {
            var6_6.execute(var5_5);
            if (true) ** GOTO lbl27
        }
        catch (Exception var8_9) {
            throw new SQLException("Internal error." + var8_9.getMessage());
        }
        do {
            var7_7 = var6_6.getResultSet();
lbl27:
            // 2 sources

        } while (var7_7 == null);
        var8_10 = null;
        try {
            while (var7_7.next()) {
                var8_10 = var7_7.getString(1);
            }
        }
        catch (Exception var9_11) {
            // empty catch block
        }
        var6_6.executeQuery("drop table " + var4_4);
        var6_6.close();
        return var8_10;
    }

    public boolean isAutoIncrement(int n) throws SQLException {
        return this.columnsInfo.isAutoIncrement(n);
    }

    public boolean isCaseSensitive(int n) throws SQLException {
        return false;
    }

    public boolean isCurrency(int n) throws SQLException {
        switch (this.columnsInfo.getType(n)) {
            case 110: 
            case 111: 
            case 112: {
                return true;
            }
        }
        return false;
    }

    public boolean isDefinitelyWritable(int n) throws SQLException {
        return false;
    }

    public int isNullable(int n) throws SQLException {
        return this.columnsInfo.isNullable(n);
    }

    public boolean isReadOnly(int n) throws SQLException {
        return this.columnsInfo.isReadOnly(n);
    }

    public boolean isSearchable(int n) throws SQLException {
        return true;
    }

    public boolean isSigned(int n) throws SQLException {
        Column column = this.columnsInfo.getColumn(n);
        int n2 = column.getType();
        switch (n2) {
            case -17: 
            case 31: 
            case 34: 
            case 35: 
            case 37: 
            case 39: 
            case 45: 
            case 47: 
            case 48: 
            case 50: 
            case 58: 
            case 61: 
            case 98: 
            case 99: 
            case 103: 
            case 104: 
            case 111: 
            case 225: 
            case 231: 
            case 239: {
                return false;
            }
            case 38: {
                if (column.getDisplaySize() != 1) break;
                return false;
            }
        }
        return true;
    }

    public boolean isWritable(int n) throws SQLException {
        return true;
    }

    private void NotImplemented() throws SQLException {
        throw new SQLException("Not implemented");
    }

    public ResultSetMetaData(Columns columns, Statement statement) {
        this.columnsInfo = columns;
        this.stmt = statement;
    }
}

