/*
 * Decompiled with CFR 0.152.
 */
package com.thinweb.tds;

import com.thinweb.tds.CallableStatement;
import com.thinweb.tds.Connection;
import com.thinweb.tds.ParameterListItem;
import com.thinweb.tds.ParameterUtils;
import com.thinweb.tds.ResultSet;
import com.thinweb.tds.Statement;
import com.thinweb.tds.Tds;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Vector;

public class PreparedStatement
extends Statement
implements java.sql.PreparedStatement {
    String rawQueryString = null;
    static char[] a = new char[16];
    ParameterListItem[] parameterList = null;
    protected Hashtable outParamNums = new Hashtable();

    public PreparedStatement(Connection connection, Tds tds, String string) throws SQLException {
        super(connection, tds);
        this.rawQueryString = string;
        int n = ParameterUtils.countParameters(this.rawQueryString);
        this.parameterList = new ParameterListItem[n];
        int n2 = 0;
        while (n2 < n) {
            this.parameterList[n2] = new ParameterListItem();
            ++n2;
        }
    }

    public void clearParameters() throws SQLException {
        int n = 0;
        while (n < this.parameterList.length) {
            this.parameterList[n].clear();
            ++n;
        }
    }

    public boolean execute() throws SQLException {
        boolean bl = false;
        this.closeAllResults();
        this.updateCount = -2;
        ParameterUtils.verifyThatParametersAreSet(this.parameterList);
        this.mapOutparamNums();
        String string = this.rawQueryString;
        if (this instanceof CallableStatement) {
            string = this.createSqlWithParamsOld();
        }
        this.results = (ResultSet)this.executeQuery(this.createSQLWithParams(string));
        if (this.results != null) {
            if (!(this instanceof CallableStatement)) {
                return true;
            }
            if (this.parameterList.length != 0) {
                this.results.next();
                return true;
            }
            return true;
        }
        return bl;
    }

    public int executeUpdate() throws SQLException {
        this.closeAllResults();
        this.execute();
        return this.getUpdateCount();
    }

    public int getCurrentIndex(char[] cArray, char c, int n) {
        int n2 = cArray.length;
        boolean bl = false;
        char c2 = ' ';
        if (n >= n2) {
            return -1;
        }
        int n3 = n;
        while (n3 < n2) {
            char c3 = cArray[n3];
            switch (c3) {
                case '\"': 
                case '\'': {
                    if (!bl) {
                        bl = true;
                        c2 = c3;
                        break;
                    }
                    if (c2 != c3) break;
                    bl = false;
                }
            }
            if (c3 == c && !bl) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    protected void NotImplemented() throws SQLException {
        throw new SQLException("Not Implemented");
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        byte[] byArray = new byte[n2];
        try {
            inputStream.read(byArray, 0, n2);
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.getMessage());
        }
        this.setParam(n, new String(byArray), 0, -1);
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        int n2 = 4;
        if (bigDecimal != null) {
            n2 = bigDecimal.scale();
        }
        this.setParam(n, bigDecimal, 0, 3);
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        byte[] byArray = new byte[n2];
        try {
            inputStream.read(byArray, 0, n2);
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.getMessage());
        }
        this.setParam(n, byArray, 0, -4);
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        this.setParam(n, new Boolean(bl), 0, -7);
    }

    public void setByte(int n, byte by) throws SQLException {
        this.setParam(n, new Byte(by), 0, -6);
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        this.setParam(n, byArray, 0, -2);
    }

    public void setDate(int n, Date date) throws SQLException {
        this.setParam(n, date, 0, 91);
    }

    public void setDouble(int n, double d) throws SQLException {
        this.setParam(n, new Double(d), 0, 8);
    }

    public void setFloat(int n, float f) throws SQLException {
        this.setParam(n, new Float(f), 0, 6);
    }

    public void setInt(int n, int n2) throws SQLException {
        this.setParam(n, new Integer(n2), 0, 4);
    }

    public void setLong(int n, long l) throws SQLException {
        this.setParam(n, new Long(l), 0, -5);
    }

    public void setNull(int n, int n2) throws SQLException {
        this.setParam(n, null, 0, n2);
    }

    public void setObject(int n, Object object) throws SQLException {
        try {
            if (object instanceof String || object instanceof StringBuffer) {
                this.setString(n, object.toString());
                return;
            }
            if (object instanceof Double) {
                this.setDouble(n, (Double)object);
                return;
            }
            if (object instanceof Float) {
                this.setFloat(n, ((Float)object).floatValue());
                return;
            }
            if (object instanceof Integer) {
                this.setInt(n, (Integer)object);
                return;
            }
            if (object instanceof Long) {
                this.setLong(n, (Long)object);
                return;
            }
            if (object instanceof Short) {
                this.setShort(n, (Short)object);
                return;
            }
            if (object instanceof Byte) {
                this.setByte(n, (Byte)object);
                return;
            }
            if (object instanceof Timestamp) {
                this.setTimestamp(n, (Timestamp)object);
                return;
            }
            if (object instanceof Time) {
                this.setTime(n, (Time)object);
                return;
            }
            if (object instanceof Boolean) {
                this.setBoolean(n, (Boolean)object);
                return;
            }
            if (object instanceof BigDecimal) {
                this.setBigDecimal(n, (BigDecimal)object);
                return;
            }
            if (object instanceof Date) {
                this.setDate(n, (Date)object);
                return;
            }
            if (object == null) {
                this.setNull(n, 0);
                return;
            }
            if (object instanceof byte[]) {
                this.setBytes(n, (byte[])object);
                return;
            }
            if (object instanceof InputStream) {
                try {
                    this.setBinaryStream(n, (InputStream)object, ((InputStream)object).available());
                }
                catch (IOException iOException) {
                    throw new SQLException("Error reading from the InputStream. IOException was: " + iOException);
                }
                return;
            }
            throw new SQLException("Tds Driver does not support setObject(" + n + ", " + object.getClass() + ")");
        }
        catch (Throwable throwable) {
            throw new SQLException(throwable.getMessage());
        }
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        switch (n2) {
            case 0: {
                this.setObject(n, null);
                return;
            }
            case -11: 
            case -10: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                if (object instanceof InputStream) {
                    this.setObject(n, (InputStream)object);
                } else if (object instanceof String) {
                    this.setObject(n, object.toString());
                }
                return;
            }
            case -7: {
                if (object instanceof String) {
                    object = new Boolean((String)object);
                }
                if (object instanceof Number) {
                    object = new Boolean(((Number)object).intValue() != 0);
                }
                if (!(object instanceof Boolean)) {
                    throw new SQLException("Cannot convert " + object + " to boolean.");
                }
                this.setObject(n, object);
                return;
            }
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                if (object instanceof Byte || object instanceof Short || object instanceof Integer || object instanceof Float || object instanceof Double || object instanceof Long || object instanceof Short) {
                    this.setObject(n, object);
                } else if (object instanceof Character) {
                    this.setObject(n, new Integer(Character.getNumericValue(((Character)object).charValue())));
                } else {
                    throw new SQLException("Unknown object type. Cannot perform conversion.");
                }
                return;
            }
            case -4: 
            case -3: 
            case -2: {
                if (!(object instanceof InputStream) && !(object instanceof byte[])) {
                    throw new SQLException("Cannot convert " + object + " to binary.");
                }
                this.setObject(n, object);
                return;
            }
            case 91: 
            case 92: 
            case 93: {
                if (!(object instanceof Date || object instanceof Time || object instanceof Timestamp)) {
                    throw new SQLException("Cannot convert " + object + " to Date, Time, or Timestamp.");
                }
                this.setObject(n, object);
                return;
            }
        }
        throw new SQLException("Unknown SQL Type for PreparedStatement.setObject (SQL Type=" + n2);
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.setObject(n, object, n2);
    }

    public void setShort(int n, short s) throws SQLException {
        this.setParam(n, new Integer(s), 0, 5);
    }

    public void setString(int n, String string) throws SQLException {
        this.setParam(n, string, 0, 12);
    }

    public void setTime(int n, Time time) throws SQLException {
        this.setParam(n, time, 0, 92);
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.setParam(n, timestamp, 0, 93);
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        byte[] byArray = new byte[n2];
        try {
            inputStream.read(byArray, 0, n2);
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.getMessage());
        }
        this.setParam(n, new String(byArray), 0, -1);
    }

    protected String formatQuoteChars(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '\"') {
                stringBuffer.append('\"');
            }
            if (c == '\'') {
                stringBuffer.append("'");
            }
            stringBuffer.append(c);
            ++n;
        }
        return stringBuffer.toString();
    }

    protected int getOutParamIndex(int n) {
        Integer n2 = (Integer)this.outParamNums.get(new Integer(n));
        return n2;
    }

    protected void mapOutparamNums() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.parameterList.length) {
            if (this.parameterList[n2].type == 1) {
                this.outParamNums.put(new Integer(n2 + 1), new Integer(n++));
            }
            ++n2;
        }
    }

    protected String typeAsString(int n, int n2) throws SQLException {
        String string = ((Connection)this.getConnection()).getProductVersion();
        char c = string.substring(0, 1).charAt(0);
        switch (n) {
            case 0: {
                return "bit";
            }
            case -5: {
                if (n2 == -1) {
                    n2 = 0;
                }
                return "decimal(28," + n2 + ')';
            }
            case 2: 
            case 3: {
                if (n2 == -1) {
                    n2 = 4;
                }
                return "decimal(28," + n2 + ')';
            }
            case -7: {
                return "bit";
            }
            case 91: 
            case 92: 
            case 93: {
                return "datetime";
            }
            case 8: {
                return "float";
            }
            case 6: {
                return "real";
            }
            case 4: {
                return "int";
            }
            case -4: 
            case -3: 
            case -2: 
            case 2000: {
                if (c == '7') {
                    return "varbinary(8000)";
                }
                return "varbinary(255)";
            }
            case 7: {
                return "real";
            }
            case 5: {
                return "smallint";
            }
            case -6: {
                return "tinyint";
            }
            case -1: 
            case 1: 
            case 12: {
                if (c == '7') {
                    return "varchar(8000)";
                }
                return "varchar(255)";
            }
        }
        throw new SQLException("SQL TYPE unknown:" + n);
    }

    public void addBatch() throws SQLException {
        if (this.batchSqlStmts == null) {
            this.batchSqlStmts = new Vector();
        }
        this.batchSqlStmts.addElement(this.createSQLWithParams(this.rawQueryString));
    }

    public void setArray(int n, Array array) throws SQLException {
        this.NotImplemented();
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        this.setBinaryStream(n, blob.getBinaryStream(), (int)blob.length());
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        try {
            char[] cArray = new char[n2];
            int n3 = 0;
            while (n3 < n2) {
                if ((n3 = reader.read(cArray, n3, n2 - n3)) >= 0) continue;
                throw new SQLException("End of stream before " + n2 + " characters read.");
            }
            String string = new String(cArray);
            this.setParam(n, string, 0, -1);
        }
        catch (IOException iOException) {
            throw new SQLException("End of stream before " + n2 + " characters read.");
        }
    }

    public void setClob(int n, Clob clob) throws SQLException {
        this.setAsciiStream(n, clob.getAsciiStream(), (int)clob.length());
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        if (date != null) {
            date = (Date)date.clone();
            date.setTime(date.getTime() - (long)this.setCalendarValues(date, calendar));
        }
        this.setDate(n, date);
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        this.setNull(n, n2);
    }

    public void setRef(int n, Ref ref) throws SQLException {
        this.NotImplemented();
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        if (time != null) {
            time = (Time)time.clone();
            time.setTime(time.getTime() - (long)this.setCalendarValues(time, calendar));
        }
        this.setTime(n, time);
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        if (timestamp != null) {
            timestamp = (Timestamp)timestamp.clone();
            ((java.util.Date)timestamp).setTime(((java.util.Date)timestamp).getTime() - (long)this.setCalendarValues(timestamp, calendar));
        }
        this.setTimestamp(n, timestamp);
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        ResultSet resultSet = (ResultSet)this.getResultSet();
        if (resultSet == null) {
            return null;
        }
        return resultSet.getMetaData();
    }

    protected int setCalendarValues(java.util.Date date, Calendar calendar) {
        calendar.setTime(date);
        int n = -calendar.get(15) - calendar.get(16);
        calendar = Calendar.getInstance();
        calendar.setTime(date);
        return n += calendar.get(15) + calendar.get(16);
    }

    public static String _dmthif(String string) {
        int n = string.length();
        String string2 = "";
        string2 = string2 + string.substring(0, 4);
        string2 = string2 + string.substring(5, 7);
        string2 = string2 + string.substring(8, 10);
        if (n <= 10) {
            return string2;
        }
        string2 = string2 + " " + string.substring(11, string.length());
        return string2;
    }

    public static String _mthif(String string) {
        String string2 = "";
        int n = 0;
        while (true) {
            int n2;
            if ((n2 = string.indexOf("'", n)) < 0) {
                string2 = string2 + string.substring(n);
                return string2;
            }
            string2 = string2 + string.substring(n, n2 + 1);
            string2 = string2 + "'";
            n = n2 + 1;
        }
    }

    public static void a(StringBuffer stringBuffer, ParameterListItem parameterListItem, boolean bl) throws SQLException {
        if (parameterListItem.value == null) {
            stringBuffer.append("NULL");
            return;
        }
        if (bl && (parameterListItem.nativeType == 1 || parameterListItem.nativeType == 12 || parameterListItem.nativeType == -1) && ((String)parameterListItem.value).length() <= 4000) {
            stringBuffer.append('N');
        }
        boolean bl2 = false;
        boolean bl3 = false;
        switch (parameterListItem.nativeType) {
            case -1: 
            case 1: 
            case 12: 
            case 91: 
            case 92: 
            case 93: {
                bl2 = true;
                break;
            }
            default: {
                bl2 = false;
            }
        }
        if (bl2) {
            bl3 = true;
            stringBuffer.append("'");
        }
        switch (parameterListItem.nativeType) {
            case -1: 
            case 1: 
            case 12: {
                int n = ((String)parameterListItem.value).indexOf("'");
                if (n < 0) {
                    stringBuffer.append((String)parameterListItem.value);
                    break;
                }
                stringBuffer.append(PreparedStatement._mthif((String)parameterListItem.value));
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                byte[] byArray = (byte[])parameterListItem.value;
                int n = byArray.length;
                int n2 = 2 * n + 16;
                if (n > 1024) {
                    n2 += 1024;
                }
                stringBuffer.ensureCapacity(n2);
                stringBuffer.append("0x");
                boolean bl4 = false;
                int n3 = 0;
                while (n3 < n) {
                    byte by = byArray[n3];
                    stringBuffer.append(a[(by & 0xF0) >> 4]);
                    stringBuffer.append(a[by & 0xF]);
                    ++n3;
                }
                break;
            }
            case -7: {
                Boolean bl5 = (Boolean)parameterListItem.value;
                if (bl5.booleanValue()) {
                    stringBuffer.append('1');
                    break;
                }
                stringBuffer.append('0');
                break;
            }
            case 91: 
            case 93: {
                stringBuffer.append(PreparedStatement._dmthif(parameterListItem.value.toString()));
                break;
            }
            default: {
                stringBuffer.append(parameterListItem.value.toString());
            }
        }
        if (bl3) {
            stringBuffer.append("'");
        }
    }

    public String createSqlWithParamsOld() throws SQLException {
        try {
            StringBuffer stringBuffer = new StringBuffer(256);
            int n = 0;
            while (n < this.parameterList.length) {
                String string = this.parameterList[n].typeAsString;
                int n2 = this.parameterList[n].type;
                if (n2 == 1) {
                    stringBuffer.append("DECLARE @PAR").append(n + 1).append(' ').append(string).append('\n');
                    if (this.parameterList[n] != null && this.parameterList[n].type != 1) {
                        stringBuffer.append("SET @PAR").append(n + 1).append(" = ").append(this.parameterList[n].value).append('\n');
                    }
                }
                ++n;
            }
            this.rawQueryString = this.formatQuoteChars(this.rawQueryString);
            int n3 = 0;
            char[] cArray = this.rawQueryString.toCharArray();
            int n4 = this.getCurrentIndex(cArray, '?', n3);
            int n5 = 0;
            StringBuffer stringBuffer2 = new StringBuffer("");
            while (n4 > 0) {
                try {
                    String string = new Integer(this.parameterList[n5].nativeType).toString();
                    stringBuffer.append(this.rawQueryString.substring(n3, n4));
                    if (string != null && string.length() > 0 && this.parameterList[n5].type == 1) {
                        if (stringBuffer2.toString().equals("")) {
                            stringBuffer2.append(" SELECT ");
                        }
                        if (stringBuffer2.length() > 9) {
                            stringBuffer2.append(", ");
                        }
                        stringBuffer.append("@PAR").append(n5 + 1);
                        if (!this.rawQueryString.substring(n4 + 1, this.rawQueryString.length()).trim().startsWith("=") && this.parameterList[n5].type == 1) {
                            stringBuffer.append(" output ");
                        }
                        stringBuffer2.append(" @PAR").append(n5 + 1);
                    } else {
                        stringBuffer.append("?");
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new SQLException("Wrong number of parameters");
                }
                ++n5;
                n3 = n4 + 1;
                n4 = this.getCurrentIndex(cArray, '?', n3);
            }
            stringBuffer.append(this.rawQueryString.substring(n3, this.rawQueryString.length()));
            if (this.parameterList != null && this.parameterList.length != 0) {
                stringBuffer.append((Object)stringBuffer2);
            }
            return new String(stringBuffer);
        }
        catch (Throwable throwable) {
            throw new SQLException(throwable.getMessage());
        }
    }

    protected void setParam(int n, Object object, int n2, int n3) throws SQLException {
        if (n < 1) {
            throw new SQLException("Invalid Parameter index " + n + ".  JDBC indexes start at 1.");
        }
        if (n > this.parameterList.length) {
            throw new SQLException("Invalid Parameter index " + n + ".  This statement only has " + this.parameterList.length + " parameters");
        }
        this.parameterList[--n].type = n2;
        this.parameterList[n].isSet = true;
        this.parameterList[n].value = object;
        this.parameterList[n].nativeType = n3;
    }

    protected void setParam(int n, Object object, int n2, int n3, String string) throws SQLException {
        if (n < 1) {
            throw new SQLException("Invalid Parameter index " + n + ".  JDBC indexes start at 1.");
        }
        if (n > this.parameterList.length) {
            throw new SQLException("Invalid Parameter index " + n + ".  This statement only has " + this.parameterList.length + " parameters");
        }
        this.parameterList[--n].type = n2;
        this.parameterList[n].isSet = true;
        this.parameterList[n].value = object;
        this.parameterList[n].nativeType = n3;
        this.parameterList[n].typeAsString = string;
    }

    public PreparedStatement(java.sql.Connection connection, Tds tds, String string) throws SQLException {
        super(connection, tds);
        this.rawQueryString = string;
        int n = ParameterUtils.countParameters(this.rawQueryString);
        this.parameterList = new ParameterListItem[n];
        int n2 = 0;
        while (n2 < n) {
            this.parameterList[n2] = new ParameterListItem();
            ++n2;
        }
    }

    public String createSQLWithParams(String string) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        if (stringBuffer == null) {
            stringBuffer = new StringBuffer();
        }
        stringBuffer.setLength(0);
        stringBuffer.ensureCapacity(n + this.parameterList.length * 16);
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            char c = string.charAt(n3);
            if (c != '?') {
                stringBuffer.append(c);
            } else {
                PreparedStatement.a(stringBuffer, this.parameterList[n2], true);
                ++n2;
            }
            ++n3;
        }
        return stringBuffer.toString();
    }

    public java.sql.ResultSet executeQuery() throws SQLException {
        this.execute();
        return this.results;
    }

    static {
        int n = 0;
        int n2 = 0;
        while (n2 < 10) {
            PreparedStatement.a[n++] = (char)(48 + n2);
            ++n2;
        }
        int n3 = 0;
        while (n3 < 6) {
            PreparedStatement.a[n++] = (char)(65 + n3);
            ++n3;
        }
    }
}

