/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm;

import com.eg.jtm.JTMLog;
import com.eg.jtm.MethodInfo;
import com.eg.jtm.PropsManager;
import com.eg.jtm.UPDManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class URLPatternData {
    String pName;
    String pStr;
    boolean modified = false;
    double[] sumOf;
    double[] numOf;
    private ArrayList SlowURLsList = new ArrayList();
    private ArrayList ErrorURLsList = new ArrayList();
    static final double defaultValue = 0.0;
    static final double defaultMinusFive = -5.0;
    private static List subcomList = Arrays.asList(PropsManager.subCompNames);

    URLPatternData(String pName) {
        this.pName = pName;
        int length = PropsManager.subCompNames.length;
        this.sumOf = new double[length];
        this.numOf = new double[length];
        this.resetHashtables();
    }

    public ArrayList getSlowURLsList() {
        return this.SlowURLsList;
    }

    public ArrayList getErrorURLsList() {
        return this.ErrorURLsList;
    }

    public void cleanSlowURLsList() {
        this.SlowURLsList = null;
    }

    public void cleanErrorURLsList() {
        this.ErrorURLsList = null;
    }

    private void resetHashtables() {
        int k = 11;
        while (k <= 13) {
            this.sumOf[k] = -5.0;
            this.numOf[k] = -5.0;
            ++k;
        }
        k = 15;
        while (k <= 17) {
            this.sumOf[k] = -5.0;
            this.numOf[k] = -5.0;
            ++k;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateHashtables(String subCompType, double time) {
        int subCompIndex;
        if (time >= 0.0 && (subCompIndex = subcomList.indexOf(subCompType)) > -1) {
            try {
                URLPatternData uRLPatternData = this;
                synchronized (uRLPatternData) {
                    this.sumOf[subCompIndex] = this.sumOf[subCompIndex] + time;
                    this.numOf[subCompIndex] = this.numOf[subCompIndex] + 1.0;
                }
            }
            catch (Exception e) {
                JTMLog.logger.warn("Exception occured in the updateHashtables " + subCompType + "  " + time + " " + subCompIndex, e);
            }
        }
    }

    private void parseMinfoAndCalc(MethodInfo Minfo) {
        HashMap orderMap = Minfo.getOrderMap();
        if (orderMap != null && orderMap.size() > 0) {
            Set orderKeys = orderMap.keySet();
            for (Object keyObj : orderKeys) {
                MethodInfo tmpInfo = (MethodInfo)orderMap.get(keyObj);
                String subCompType = tmpInfo.getType();
                double exclTime = tmpInfo.getExclusiveTime();
                this.updateHashtables(subCompType, exclTime);
            }
        }
    }

    void SortedAddToURLList(List URLsList, MethodInfo MI2Add, String URLSubcompName, int MaxURLs) {
        double MI2Add_ExecTime = MI2Add.getExecutionTime();
        int i = 0;
        while (i < URLsList.size()) {
            MethodInfo thisMinfo = (MethodInfo)URLsList.get(i);
            if (thisMinfo.getExecutionTime() < MI2Add_ExecTime) break;
            ++i;
        }
        URLsList.add(i, MI2Add);
        this.updateHashtables(URLSubcompName, MI2Add_ExecTime);
        if (URLsList.size() > MaxURLs) {
            URLsList.remove(URLsList.size() - 1);
        }
    }

    private boolean storeURLIfNeeded(MethodInfo MI2Add) {
        if (!MI2Add.isSlowURL() && !MI2Add.isErrorURL() || !(MI2Add.getExecutionTime() >= 0.0)) {
            return false;
        }
        if (MI2Add.isSlowURL()) {
            this.SortedAddToURLList(this.SlowURLsList, MI2Add, "SLOW_URLS", UPDManager.getMaxSlowURLs());
            JTMLog.logger.info("Added the following SLOW URL to slow urls list for pattern " + this.pName);
            JTMLog.logger.debug(MI2Add.printTree());
        }
        if (MI2Add.isErrorURL()) {
            this.SortedAddToURLList(this.ErrorURLsList, MI2Add, "ERROR_URLS", UPDManager.getMaxErrorURLs());
            JTMLog.logger.info("Added the following ERROR URL to error urls list for pattern " + this.pName);
            JTMLog.logger.debug(MI2Add.printTree());
        }
        return true;
    }

    public void updateAllUrlCount(MethodInfo rootMI) {
        if (rootMI.getExecutionTime() >= 0.0) {
            this.modified = true;
        }
        this.updateHashtables("ALL_URLS", rootMI.getExecutionTime());
        this.parseMinfoAndCalc(rootMI);
    }

    public void addURLInfo(MethodInfo rootMI) {
        if (rootMI.getExecutionTime() >= 0.0) {
            this.modified = true;
        }
        this.updateHashtables("ALL_URLS", rootMI.getExecutionTime());
        this.parseMinfoAndCalc(rootMI);
        boolean isStored = this.storeURLIfNeeded(rootMI);
        if (!isStored) {
            JTMLog.logger.info("Added data from the following URL tree into data for pattern " + this.pName);
            JTMLog.logger.debug(rootMI.printTree());
        }
    }
}

