/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm;

import com.eg.agent.trace.utils.TraceUtils;
import com.eg.jtm.JTMLog;
import com.eg.jtm.JTMUtils;
import com.eg.jtm.PropsManager;
import com.eg.jtm.RequestIdentifier;
import com.eg.jtm.UPDManager;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class MethodInfo {
    private static final NumberFormat NoSciFormat = new DecimalFormat("0.####");
    private String type = "Unknown";
    private List children = null;
    private MethodInfo parent = null;
    private String exceptionStr = null;
    private long startTime = 0L;
    private long endTime = 0L;
    private double exclusiveTime = -1.0;
    private double executionTime = -1.0;
    private Map properties = null;
    private int status = 0;
    boolean error = false;
    private boolean isStartComponent = false;
    private boolean slowURL = false;
    private boolean errorURL = false;
    private boolean MinfoCalcd = false;
    private static final String DDCellColSep = "#=#";
    private static final String DDCellRowSep = "%*%";
    private static final String dummyVal = "-";
    private Hashtable times;
    private Hashtable counts;
    private ArrayList URLMeasureList = null;
    private List urlPatternsMatched = null;
    private boolean extCallURL = false;
    private int lineNo = -1;
    private boolean isEXCEPTIONExits = false;
    private boolean dontRemove = false;
    private String className = null;
    private String methodName = null;
    private String desc = null;
    private StringBuffer methodDisplayName = null;
    private HashMap<String, MethodInfo> levelMap = null;

    public MethodInfo(String className, String methodName, String desc, MethodInfo parent) {
        this.className = className;
        this.methodName = methodName;
        this.desc = desc;
        this.parent = parent;
        this.children = new ArrayList();
        this.isStartComponent = false;
    }

    public MethodInfo(String className, String methodName, String desc, MethodInfo parent, List urlPatternsMatched) {
        this.className = className;
        this.methodName = methodName;
        this.desc = desc;
        this.parent = parent;
        this.urlPatternsMatched = urlPatternsMatched;
        this.children = new ArrayList();
        this.URLMeasureList = new ArrayList();
        this.isStartComponent = true;
    }

    public List getUrlPatternsMatched() {
        return this.urlPatternsMatched;
    }

    public StringBuffer getMethodDisplayName() {
        if (this.methodDisplayName == null) {
            this.methodDisplayName = new StringBuffer();
            String paramNames = TraceUtils.getParamNames(this.desc);
            String dotClassName = this.className.replace("/", ".");
            this.methodDisplayName.append(dotClassName);
            this.methodDisplayName.append(".");
            this.methodDisplayName.append(this.methodName);
            this.methodDisplayName.append("(");
            this.methodDisplayName.append(paramNames);
            this.methodDisplayName.append(")");
        }
        return this.methodDisplayName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getClassName() {
        return this.className;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getRawURL() {
        if (this.isStartComponent) {
            return (String)this.properties.get("requestID");
        }
        return "";
    }

    public boolean isStartComponent() {
        return this.isStartComponent;
    }

    public List getChildMinfos() {
        return this.children;
    }

    void addChildMinfo(MethodInfo childMInfo) {
        if (!this.children.add(childMInfo)) {
            JTMLog.logger.warn("Could not add child Minfo to list. Child Minfo " + childMInfo.toSimpleString());
        }
    }

    void removeChildMinfo(MethodInfo childMInfo) {
        if (!this.children.remove(childMInfo)) {
            JTMLog.logger.warn("Could not remove child Minfo from list. Child Minfo " + childMInfo.toSimpleString());
        }
    }

    public MethodInfo getParent() {
        return this.parent;
    }

    public void setParent(MethodInfo parentMI) {
        this.parent = parentMI;
    }

    public long getStartTime() {
        return this.startTime;
    }

    void setStartTime(long time) {
        this.startTime = time;
        this.status = 0;
    }

    public long getEndTime() {
        return this.endTime;
    }

    void setEndTime(long time, boolean isException) {
        this.endTime = time;
        this.error = false;
        this.status = 1;
        if (isException && !PropsManager.isExceptionMatchedIgnoreExceptionList(this.getIgnoredException())) {
            this.error = true;
            this.status = 2;
            this.errorURL = true;
        }
    }

    public void setLineNo(int lineNo) {
        this.lineNo = lineNo;
    }

    private int getLineNo() {
        return this.lineNo;
    }

    public double getExclusiveTime() {
        return this.calculateExclusiveTime();
    }

    private String getIgnoredException() {
        return this.exceptionStr;
    }

    public void setIgnoredException(String msg) {
        this.exceptionStr = msg;
        this.error = true;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public static boolean isFrontEndComp(String compName) {
        return compName.equals("FILTER") || compName.equals("HTTPSERVLET") || compName.equals("JSP") || compName.equals("STRUTS") || compName.equals("GENERICSERVLET");
    }

    public double getExecutionTime() {
        if (this.executionTime == -1.0) {
            if (this.isCompleted()) {
                double diffInSecs = (double)(this.endTime - this.startTime) / 1000.0;
                this.executionTime = JTMUtils.measurize(diffInSecs);
                return this.executionTime;
            }
            double diffInSecs = (double)(System.currentTimeMillis() - this.startTime) / 1000.0;
            return JTMUtils.measurize(diffInSecs);
        }
        return this.executionTime;
    }

    public void setExecutionTime() {
        this.executionTime = 0.0;
    }

    public int getStatus() {
        return this.status;
    }

    public Map getProperties() {
        return this.properties;
    }

    public void setProperties(Map properties) {
        this.properties = properties;
    }

    public boolean isCompleted() {
        return this.status != 0;
    }

    private double calculateExclusiveTime() {
        if (this.exclusiveTime != -1.0) {
            return this.exclusiveTime;
        }
        double childTimes = 0.0;
        List children = this.getChildMinfos();
        int len = children.size();
        int i = 0;
        while (i < len) {
            childTimes += ((MethodInfo)children.get(i)).getExecutionTime();
            ++i;
        }
        this.exclusiveTime = JTMUtils.measurize(this.getExecutionTime() - childTimes);
        if (this.exclusiveTime < 0.0) {
            this.exclusiveTime = 0.0;
        }
        return this.exclusiveTime;
    }

    public String toSimpleString() {
        String statusStr = this.status == 0 ? "Starting." : (this.status == 1 ? "Completed successfully." : (this.status == 2 ? "Completed with Execption!." : "Completed with unknown status!!!!."));
        if (this.isStartComponent) {
            JTMLog.logger.info(this.getProperties().get("requestID") + " - " + this.getExecutionTime() + ". [ SLOW =  " + this.isSlowURL() + " ] [ ERROR = " + this.isErrorURL() + " ] [ Patterns = " + (this.getUrlPatternsMatched() != null ? this.getUrlPatternsMatched().toString() : "none") + " ] [ AT TREE TOP = " + this.isStartComponent + "]. " + statusStr);
            return this.getMethodDisplayName() + " - " + this.getExecutionTime();
        }
        return this.getMethodDisplayName() + " - " + this.getExecutionTime();
    }

    public String printTree() {
        StringBuffer MISB = new StringBuffer();
        MISB.append("\n");
        MISB.append("---------------------------------------------").append('\n');
        this.printRecursively(MISB, this, 0);
        MISB.append("*******************************************************************************************").append('\n');
        return MISB.toString();
    }

    private void printRecursively(StringBuffer MISB, MethodInfo Minfo, int level) {
        if (this.levelMap == null || this.levelMap.isEmpty()) {
            this.prepareOrderMap();
        }
        TreeSet<String> levelKeys = new TreeSet<String>(this.levelMap.keySet());
        for (String keyString : levelKeys) {
            MethodInfo tempInfo = this.levelMap.get(keyString);
            String methodType = tempInfo.getType();
            StringTokenizer st = new StringTokenizer(keyString, ".");
            int tokens = st.countTokens();
            int numTabs = 0;
            while (numTabs < tokens - 1) {
                MISB.append('\t');
                ++numTabs;
            }
            MISB.append("Level ").append(tokens - 1).append(" ( ").append(methodType).append(" ) => ");
            MISB.append(tempInfo.toSimpleString());
            MISB.append('\n');
        }
    }

    private String getTree() {
        StringBuffer MISB = new StringBuffer();
        this.printNodes(MISB, this, this, "0");
        return MISB.toString();
    }

    private StringBuffer getNodeLabelAndURLParam(MethodInfo nodeMinfo) {
        String subCompType = nodeMinfo.getType();
        double nodeExecTime = nodeMinfo.getExecutionTime();
        double nodeExclTime = nodeMinfo.getExclusiveTime();
        double pctExecTime = JTMUtils.measurize(nodeExecTime * 100.0 / this.getExecutionTime(), 2);
        StringBuffer detailsSB = new StringBuffer();
        detailsSB.append(pctExecTime);
        detailsSB.append(DDCellColSep).append(nodeExecTime);
        detailsSB.append(DDCellColSep).append(nodeExclTime);
        detailsSB.append(DDCellColSep);
        if (subCompType.equals("SQL")) {
            String sqlStmt = (String)nodeMinfo.getProperties().get("sqlStmt");
            String sqlHeading = JTMUtils.getQueryHeading(sqlStmt);
            detailsSB.append(sqlHeading);
            detailsSB.append(DDCellColSep).append(sqlStmt);
        } else if (subCompType.equals("EXCEPTION")) {
            String excpnStr = (String)nodeMinfo.getProperties().get("EXCEPTION");
            if (excpnStr != null && excpnStr.length() > 0) {
                detailsSB.append(excpnStr.substring(0, excpnStr.indexOf("?^?")));
                detailsSB.append(DDCellColSep);
                detailsSB.append(excpnStr);
            }
        } else if (subCompType.equals("HTTP")) {
            Map httpMap = nodeMinfo.getProperties();
            String extUrl = (String)httpMap.get("EXTURL");
            String requestMethod = (String)httpMap.get("METHOD");
            detailsSB.append(extUrl);
            detailsSB.append(DDCellColSep).append(requestMethod);
        } else if (subCompType.equals("WEBSERVICE")) {
            Map webServiceMap = nodeMinfo.getProperties();
            String operationName = (String)webServiceMap.get("OperationName");
            String targetName = (String)webServiceMap.get("TargetUrl");
            detailsSB.append(targetName);
            detailsSB.append(DDCellColSep).append(operationName);
        } else {
            detailsSB.append(nodeMinfo.getMethodDisplayName());
            detailsSB.append(DDCellColSep).append(dummyVal);
        }
        detailsSB.append(DDCellColSep).append(nodeMinfo.getMethodDisplayName());
        return detailsSB;
    }

    private void printNodes(StringBuffer MISB, MethodInfo rootMinfo, MethodInfo Minfo, String idx) {
        if (this.levelMap == null || this.levelMap.isEmpty()) {
            this.prepareOrderMap();
        }
        TreeSet<String> levelKeys = new TreeSet<String>(this.levelMap.keySet());
        int levelSize = levelKeys.size();
        Iterator itr = levelKeys.iterator();
        int level = 1;
        while (itr.hasNext()) {
            String keyString = (String)itr.next();
            MethodInfo tempInfo = this.levelMap.get(keyString);
            String methodType = tempInfo.getType();
            if (methodType.equals("EXCEPTION")) {
                rootMinfo.isEXCEPTIONExits = true;
                rootMinfo.setErrorURL(true);
            }
            MISB.append(keyString);
            MISB.append(DDCellColSep).append(this.getNodeLabelAndURLParam(tempInfo));
            MISB.append(DDCellColSep).append(methodType);
            MISB.append(DDCellColSep).append(tempInfo.getStartTime());
            MISB.append(DDCellColSep).append(tempInfo.getEndTime());
            if (level < levelSize) {
                MISB.append(DDCellRowSep);
            }
            ++level;
        }
    }

    public void calculateMinfo(RequestIdentifier requestIdentifier, boolean cancelScheduledTask) {
        if (!this.MinfoCalcd) {
            ArrayList aList;
            if (this.levelMap == null || this.levelMap.isEmpty()) {
                this.prepareOrderMap();
            }
            if (this.getExecutionTime() > UPDManager.getSlowURLThreshold()) {
                this.slowURL = true;
            }
            if (this.isSlowURL() || this.isErrorURL() || this.isExtCallURL()) {
                this.calculateURLMeasureList();
            }
            if (this.isErrorURL() && !this.isEXCEPTIONExits && requestIdentifier != null && (aList = requestIdentifier.getObjectFromCutOffMethodTracker(this)) != null && aList.size() == 2) {
                MethodInfo expMethodInfo = (MethodInfo)aList.get(0);
                Throwable causeObj = (Throwable)aList.get(1);
                HashMap<String, String> exceptionProperties = new HashMap<String, String>();
                exceptionProperties.put("EXCEPTION", TraceUtils.partialSTEs2Str(causeObj, PropsManager.getMaxExceptionLineCount()));
                int URLMeasureListSize = this.URLMeasureList.size();
                this.URLMeasureList.remove(URLMeasureListSize - 1);
                expMethodInfo.getChildMinfos().clear();
                expMethodInfo.setType("EXCEPTION");
                expMethodInfo.setProperties(exceptionProperties);
                expMethodInfo.exclusiveTime = 0.0;
                expMethodInfo.executionTime = 0.0;
                this.addChildMinfo(expMethodInfo);
                this.levelMap = null;
                String treeString = this.getTree();
                this.URLMeasureList.add(treeString);
            }
            if (cancelScheduledTask) {
                requestIdentifier.removeFromScheduledThreadPoolExecutor();
            }
            this.MinfoCalcd = true;
        }
    }

    public boolean isExtCallURL() {
        return this.extCallURL;
    }

    public void setExtCallURL(boolean extCallURL) {
        this.extCallURL = extCallURL;
    }

    public boolean isSlowURL() {
        return this.slowURL;
    }

    public boolean isErrorURL() {
        return this.errorURL;
    }

    public void setErrorURL(boolean errorURL) {
        this.errorURL = errorURL;
    }

    public List getURLMeasureList(boolean calculateIfEmpty) {
        if (this.isErrorURL() && !this.isStartComponent) {
            if (this.URLMeasureList != null) {
                this.URLMeasureList = null;
            }
        } else if (this.URLMeasureList != null && this.URLMeasureList.size() == 0 && calculateIfEmpty) {
            this.calculateURLMeasureList();
        }
        return this.URLMeasureList;
    }

    private void calculateURLMeasureList() {
        try {
            this.initAndPopulateTimesAndCounts();
            String[] splitRawURL = this.getRawURL().split(" @ ");
            this.URLMeasureList.add(splitRawURL[1]);
            this.URLMeasureList.add(splitRawURL[0]);
            this.URLMeasureList.add(this.properties.get("remoteHost"));
            this.URLMeasureList.add(this.getExecutionTime());
            StringBuffer subCompMeasuresSB = new StringBuffer();
            int count = 0;
            double timeVal = 0.0;
            String subCompName = PropsManager.subCompNames[0];
            if (!(subCompName.equals("ALL_URLS") || subCompName.equals("SLOW_URLS") || subCompName.equals("ERROR_URLS") || (count = ((Integer)this.counts.get(subCompName)).intValue()) <= 0)) {
                subCompMeasuresSB.append(subCompName).append(DDCellColSep);
                timeVal = (Double)this.times.get(subCompName);
                if (timeVal < 0.001) {
                    subCompMeasuresSB.append(NoSciFormat.format(timeVal));
                } else {
                    subCompMeasuresSB.append(timeVal);
                }
                subCompMeasuresSB.append(DDCellColSep).append(count);
            }
            int i = 1;
            while (i < PropsManager.subCompNames.length) {
                subCompName = PropsManager.subCompNames[i];
                if (!(subCompName.equals("ALL_URLS") || subCompName.equals("SLOW_URLS") || subCompName.equals("ERROR_URLS") || (count = ((Integer)this.counts.get(subCompName)).intValue()) <= 0)) {
                    subCompMeasuresSB.append(DDCellRowSep);
                    subCompMeasuresSB.append(subCompName).append(DDCellColSep);
                    timeVal = (Double)this.times.get(subCompName);
                    if (timeVal < 0.001) {
                        subCompMeasuresSB.append(NoSciFormat.format(timeVal));
                    } else {
                        subCompMeasuresSB.append(timeVal);
                    }
                    subCompMeasuresSB.append(DDCellColSep).append(count);
                }
                ++i;
            }
            this.URLMeasureList.add(subCompMeasuresSB.toString());
            this.URLMeasureList.add(this.getTree());
            this.clearSupplementaryData();
        }
        catch (Exception e) {
            JTMLog.logger.error("Raw URL is " + this.getRawURL(), e);
        }
    }

    private void clearSupplementaryData() {
        this.times.clear();
        this.counts.clear();
    }

    private void initAndPopulateTimesAndCounts() {
        if (!(this.times != null && this.times.size() != 0 || this.counts != null && this.counts.size() != 0)) {
            this.times = new Hashtable();
            this.counts = new Hashtable();
            String[] stringArray = PropsManager.subCompNames;
            int n = PropsManager.subCompNames.length;
            int n2 = 0;
            while (n2 < n) {
                String subCompName = stringArray[n2];
                if (!(subCompName.equals("ALL_URLS") || subCompName.equals("SLOW_URLS") || subCompName.equals("ERROR_URLS"))) {
                    this.times.put(subCompName, new Double(0.0));
                    this.counts.put(subCompName, new Integer(0));
                }
                ++n2;
            }
            if (this.levelMap == null || this.levelMap.isEmpty()) {
                this.prepareOrderMap();
            }
            Set<String> levelKeys = this.levelMap.keySet();
            for (String keyString : levelKeys) {
                MethodInfo tempInfo = this.levelMap.get(keyString);
                this.parseMinfoAndCalc(this.times, this.counts, tempInfo);
            }
        }
    }

    private void prepareOrderMap() {
        try {
            Stack<MethodInfo> blocks = new Stack<MethodInfo>();
            MethodInfo thisInfo = this;
            blocks.push(thisInfo);
            HashMap<MethodInfo, String> orderMap = new HashMap<MethodInfo, String>();
            this.levelMap = new HashMap();
            orderMap.put(thisInfo, "0");
            this.levelMap.put("0", thisInfo);
            while (!blocks.isEmpty()) {
                MethodInfo childInfo;
                String childType;
                int childSize;
                String thisType;
                thisInfo = (MethodInfo)blocks.pop();
                String orderString = (String)orderMap.get(thisInfo);
                ArrayList MIList = (ArrayList)thisInfo.getChildMinfos();
                if (MIList == null || MIList.size() <= 0) continue;
                int position = MIList.indexOf(thisInfo);
                if (position > 0) {
                    MIList.remove(position);
                }
                if ((thisType = thisInfo.getType()).equals("SQL") && (childSize = MIList.size()) == 1 && (childType = (childInfo = (MethodInfo)MIList.get(0)).getType()).equals("SQL")) {
                    String parentQry;
                    String childQry;
                    Map childProps = childInfo.getProperties();
                    Map parentProps = thisInfo.getProperties();
                    boolean sameQuery = false;
                    if (childProps != null && parentProps != null && (childQry = (String)childProps.get("sqlStmt")).equals(parentQry = (String)parentProps.get("sqlStmt"))) {
                        sameQuery = true;
                    }
                    if (sameQuery) {
                        thisInfo.removeChildMinfo(childInfo);
                        continue;
                    }
                }
                int k = 0;
                while (k < MIList.size()) {
                    MethodInfo tempInfo = (MethodInfo)MIList.get(k);
                    if (!tempInfo.equals(thisInfo)) {
                        blocks.push(tempInfo);
                        orderMap.put(tempInfo, String.valueOf(orderString) + "." + k);
                        this.levelMap.put(String.valueOf(orderString) + "." + k, tempInfo);
                    }
                    ++k;
                }
            }
            blocks = null;
        }
        catch (Exception e) {
            JTMLog.logger.error(" Error Occured in prepareOrderMap ", e);
        }
    }

    private void parseMinfoAndCalc(Hashtable times, Hashtable counts, MethodInfo Minfo) {
        double exclTime = Minfo.getExclusiveTime();
        String subCompName = Minfo.getType();
        if (subCompName != null && times != null) {
            double subCompTime = (Double)times.get(subCompName);
            times.put(subCompName, new Double(JTMUtils.measurize(subCompTime += exclTime)));
            int subCompCount = (Integer)counts.get(subCompName);
            counts.put(subCompName, new Integer(++subCompCount));
        }
    }

    void clearData(MethodInfo MI) {
        Map props;
        ArrayList MIURLsList = (ArrayList)MI.getURLMeasureList(false);
        if (MIURLsList != null) {
            MIURLsList.clear();
            MIURLsList = null;
        }
        if ((props = MI.getProperties()) != null) {
            props.clear();
            props = null;
        }
        MI.parent = null;
        if (MI.urlPatternsMatched != null) {
            MI.urlPatternsMatched.clear();
        }
    }

    void clearSubTree(MethodInfo MI) {
        Stack<MethodInfo> blocks = new Stack<MethodInfo>();
        blocks.push(MI);
        while (!blocks.isEmpty()) {
            MI = (MethodInfo)blocks.pop();
            ArrayList MIList = (ArrayList)MI.getChildMinfos();
            if (MIList != null && MIList.size() > 0) {
                blocks.addAll(MIList);
            }
            this.clearData(MI);
            MIList.clear();
            Object var3_3 = null;
        }
        blocks = null;
    }

    public void clearURLTree() {
        try {
            this.clearSubTree(this);
        }
        catch (Exception e) {
            JTMLog.logger.warn("Exception while clearing MethodInfo and its details");
        }
        if (this.levelMap != null) {
            this.levelMap.clear();
            this.levelMap = null;
        }
    }

    public HashMap getOrderMap() {
        return this.levelMap;
    }

    public void setDontRemove(boolean dontRemove) {
        this.dontRemove = dontRemove;
    }

    public boolean isDontRemove() {
        return this.dontRemove;
    }
}

