/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm;

import com.eg.jtm.JTMLog;
import com.eg.jtm.PropsManager;
import com.eg.jtm.UPDManager;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;

class JavaAgentCommunicator
implements Runnable {
    private Socket socket = null;
    private static final String egAgentSharedSecretKey = "JTM";
    private static InetAddress registeredAgentIpAddress = null;
    private static long registeredAgentLastCommunicationTime = 0L;
    private static boolean isFirstTime = false;

    JavaAgentCommunicator() {
    }

    void assignClientSock(Socket s) {
        this.socket = s;
    }

    public void run() {
        try {
            if (registeredAgentLastCommunicationTime == 0L && registeredAgentIpAddress == null) {
                isFirstTime = true;
            }
            this.agentCommunicationHandler();
        }
        catch (Exception e) {
            JTMLog.logger.error("Exception while handling request from Agent (Test)", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void agentCommunicationHandler() throws IOException {
        ObjectInputStream objectInputStream;
        ObjectOutputStream objectOutputStream;
        ArrayList agentDataList;
        block31: {
            agentDataList = null;
            this.socket.setTcpNoDelay(true);
            objectOutputStream = null;
            objectInputStream = null;
            boolean flag = false;
            try {
                objectOutputStream = new ObjectOutputStream(this.socket.getOutputStream());
                objectInputStream = new ObjectInputStream(this.socket.getInputStream());
                Object object = objectInputStream.readObject();
                InetAddress clientAgentIpAddress = this.socket.getInetAddress();
                if (!(object instanceof ArrayList)) {
                    JTMLog.logger.info(" Invalid Agent !!! " + clientAgentIpAddress + " Registered Agent is :" + registeredAgentIpAddress);
                    objectOutputStream.writeObject(new String("Invalid Request !!!!"));
                    objectOutputStream.flush();
                    return;
                }
                agentDataList = (ArrayList)object;
                JTMLog.logger.info("agentDataList :" + agentDataList);
                if (agentDataList == null || agentDataList.size() <= 0) break block31;
                if (!egAgentSharedSecretKey.equals((String)agentDataList.remove(0))) {
                    JTMLog.logger.info(" Invalid Agent !! " + clientAgentIpAddress + " Registered Agent is :" + registeredAgentIpAddress);
                    objectOutputStream.writeObject(new String("Invalid Agent !!!!"));
                    objectOutputStream.flush();
                    return;
                }
                if (registeredAgentIpAddress == null) {
                    this.performAgentRegistration(clientAgentIpAddress);
                } else {
                    boolean reject = this.performAgentRejection();
                    if (reject) {
                        JTMLog.logger.info(" Invalid Agent ! " + clientAgentIpAddress + " Registered Agent is :" + registeredAgentIpAddress);
                        objectOutputStream.writeObject(new String("Invalid Agent !!!! "));
                        objectOutputStream.flush();
                        return;
                    }
                }
            }
            catch (Exception exception) {
                JTMLog.logger.error("Error reading AgentData ArrayList from Test", exception);
                return;
            }
        }
        JTMLog.logger.info("Received request for data from agent");
        this.socket.setSoTimeout(1000);
        int remainSize = agentDataList.size();
        if (agentDataList.size() > 0 && registeredAgentIpAddress.equals(this.socket.getInetAddress())) {
            PropsManager.handlePropChangesFromTest(agentDataList);
            isFirstTime = false;
        }
        if (!registeredAgentIpAddress.equals(this.socket.getInetAddress())) return;
        if (isFirstTime && remainSize == 0) {
            JTMLog.logger.warn("Web/Application server has rebooted, so it requires initial config data from eG Agent");
            UPDManager.sendMeasures(objectOutputStream, objectInputStream, true);
            isFirstTime = false;
            return;
        }
        UPDManager.sendMeasures(objectOutputStream, objectInputStream, false);
        return;
        finally {
            try {
                if (agentDataList != null) {
                    agentDataList.clear();
                    agentDataList = null;
                }
                if (objectInputStream != null) {
                    objectInputStream.close();
                    objectInputStream = null;
                }
                if (objectOutputStream != null) {
                    objectOutputStream.close();
                    objectOutputStream = null;
                }
                if (this.socket != null) {
                    this.socket.close();
                    this.socket = null;
                }
            }
            catch (SocketException socketException) {}
        }
    }

    private boolean performAgentRejection() {
        boolean reject = false;
        if (!registeredAgentIpAddress.equals(this.socket.getInetAddress())) {
            if (!PropsManager.TalkingToAgent) {
                long timeDiff = System.currentTimeMillis() - registeredAgentLastCommunicationTime;
                JTMLog.logger.info("Milliseconds since registered agent has contacted " + timeDiff);
                if (timeDiff > UPDManager.getRASwitchOverCutoff()) {
                    registeredAgentIpAddress = this.socket.getInetAddress();
                    JTMLog.logger.info("Since no designated agent was specified and registered agent switched over cutoff has exceeded, registered agent is now the currently active agent at " + registeredAgentIpAddress);
                } else {
                    JTMLog.logger.warn("Rejecting (1)request from unregistered agent at " + this.socket.getInetAddress().toString());
                    reject = true;
                }
            } else {
                JTMLog.logger.warn("Rejecting Request from Invalid Client !!! " + this.socket.getInetAddress().toString());
                reject = true;
            }
        } else {
            registeredAgentLastCommunicationTime = System.currentTimeMillis();
        }
        return reject;
    }

    private void performAgentRegistration(InetAddress requestingAgentIPAddress) {
        if (PropsManager.useDesigAgtOnly) {
            if (registeredAgentIpAddress == null || UPDManager.hasDesigAgtChanged()) {
                registeredAgentIpAddress = UPDManager.getDesigAgtInetAddr();
                JTMLog.logger.info("Registered the designated agent " + registeredAgentIpAddress.toString());
                UPDManager.resetDesigAgtChanged();
            }
        } else if (registeredAgentIpAddress == null) {
            registeredAgentIpAddress = requestingAgentIPAddress;
            JTMLog.logger.info("Registering agent " + registeredAgentIpAddress.toString());
        }
    }
}

