/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.driver;

import com.tmax.tibero.jdbc.TbArrayDescriptor;
import com.tmax.tibero.jdbc.TbNClob;
import com.tmax.tibero.jdbc.TbTypeDescriptor;
import com.tmax.tibero.jdbc.data.Column;
import com.tmax.tibero.jdbc.data.DataTypeConverter;
import com.tmax.tibero.jdbc.data.Row;
import com.tmax.tibero.jdbc.data.ServerInfo;
import com.tmax.tibero.jdbc.data.TbDate;
import com.tmax.tibero.jdbc.data.TbTimestamp;
import com.tmax.tibero.jdbc.driver.TbConnection;
import com.tmax.tibero.jdbc.driver.TbResultSet;
import com.tmax.tibero.jdbc.driver.TbResultSetMetaData;
import com.tmax.tibero.jdbc.driver.TbStatement;
import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.util.TbCommon;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

public abstract class TbResultSetBase
extends TbResultSet {
    public static final int EMPTY_CURSOR_ID = -1;
    public static final int EMPTY_RSET = -2;
    protected TbStatement stmt;
    protected int csrID = -1;
    protected DataTypeConverter typeConverter;
    protected int columnCount = -1;
    protected Column[] cols;
    protected HashMap columnNameMap;
    protected int beginColumnIndex = 0;
    protected int currentRowIndex = -1;
    protected int currentFetchCount = 0;
    protected int fetchDirection = 1000;
    protected int fetchSize = 50;
    protected boolean lastColumnWasNull = false;
    protected byte[] rowChunk;
    protected boolean fetchComplete = false;
    protected boolean isRsetClosed = false;
    protected boolean isSvrCsrClosed = false;
    private boolean closeStatementOnClose = false;
    private int preparedFetchCnt = 0;
    private boolean mapDateToTimestamp = true;

    protected TbResultSetBase(TbStatement tbStatement, int n, int n2, int n3) throws SQLException {
        super(tbStatement.getRealRsetType());
        this.stmt = tbStatement;
        this.csrID = n;
        this.typeConverter = tbStatement.conn.getTypeConverter();
        this.columnCount = n2 + n3;
        this.fetchDirection = tbStatement.getFetchDirection();
        this.fetchSize = tbStatement.getFetchSize();
        this.closeStatementOnClose = false;
        if (tbStatement.getRealRsetType() != null) {
            this.beginColumnIndex = n3 + (tbStatement.getRealRsetType().useRowId() ? 1 : 0);
        }
        this.makeColumnMetaArray(this.columnCount);
    }

    private void buildColumnNameMap() {
        this.columnNameMap = new HashMap();
        for (int i = this.getColumnCount() - 1; i >= 0; --i) {
            this.columnNameMap.put(this.cols[i + this.beginColumnIndex].getName().toUpperCase(), new Integer(i + 1));
        }
    }

    public void cancelRowUpdates() throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    void checkColumnIndex(int n) throws SQLException {
        int n2 = this.getColumnCount();
        if (n2 < 0) {
            throw TbError.newSQLException(-90607);
        }
        if (n <= 0 || n > n2) {
            throw TbError.newSQLException(-90609);
        }
    }

    protected void checkRsetAndConnClosed() throws SQLException {
        if (this.csrID == -1) {
            throw TbError.newSQLException(-90607);
        }
        if (this.isRsetClosed) {
            throw TbError.newSQLException(-90646);
        }
        if (this.isSvrCsrClosed) {
            throw TbError.newSQLException(-90647);
        }
        if (this.stmt.conn == null || this.stmt.conn.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws SQLException {
        if (this.isRsetClosed) {
            return;
        }
        try {
            this.closeCursor();
        }
        catch (SQLException sQLException) {
        }
        finally {
            this.reset();
            this.isRsetClosed = true;
            if (this.closeStatementOnClose) {
                try {
                    this.stmt.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public synchronized void closeCursor() throws SQLException {
        if (this.isSvrCsrClosed) {
            return;
        }
        TbConnection tbConnection = (TbConnection)this.stmt.getConnection();
        ServerInfo serverInfo = tbConnection.getServerInfo();
        if (serverInfo != null) {
            boolean bl = this.fetchComplete;
            int n = serverInfo.getProtocolMajorVersion();
            int n2 = serverInfo.getProtocolMinorVersion();
            if (n > 2 || n == 2 && n2 < 3) {
                bl &= !this.haveLocator;
            }
            if (!(this.stmt == null || bl || !tbConnection.isPooledConnection && tbConnection.isSessionClosed())) {
                tbConnection.closeCursor(this, this.csrID);
            }
        }
        this.isSvrCsrClosed = true;
    }

    public void closeStatementOnClose() {
        this.closeStatementOnClose = true;
    }

    public void deleteRow() throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    protected void fetchRowsChunk() throws SQLException {
        this.stmt.fetch(this);
    }

    public synchronized int findColumn(String string) throws SQLException {
        return this.getColumnPosByName(string);
    }

    public Array getArray(int n) throws SQLException {
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(n);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, n)) {
            return null;
        }
        TbTypeDescriptor tbTypeDescriptor = this.getColumnTypeDescriptor(n);
        TbArrayDescriptor tbArrayDescriptor = tbTypeDescriptor instanceof TbArrayDescriptor ? (TbArrayDescriptor)tbTypeDescriptor : null;
        return this.typeConverter.toArray(this.getRowChunk(row, n), this.getColumnOffset(row, n), this.getColumnLength(row, n), this.getColumnDataType(n), !this.getRsetType().isScrollable(), tbArrayDescriptor);
    }

    public Array getArray(String string) throws SQLException {
        return this.getArray(this.findColumn(string));
    }

    public synchronized InputStream getAsciiStream(int n) throws SQLException {
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(n);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, n)) {
            return null;
        }
        return this.typeConverter.toAsciiStream(this.getRowChunk(row, n), this.getColumnOffset(row, n), this.getColumnLength(row, n), this.getColumnDataType(n));
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    public int getBeginColumnIndex() {
        return this.beginColumnIndex;
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(n);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, n)) {
            return null;
        }
        return this.typeConverter.toBigDecimal(this.getRowChunk(row, n), this.getColumnOffset(row, n), this.getColumnLength(row, n), this.getColumnDataType(n));
    }

    public synchronized BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        return this.getBigDecimal(n);
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n);
    }

    public synchronized InputStream getBinaryStream(int n) throws SQLException {
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(n);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, n)) {
            return null;
        }
        return this.typeConverter.toBinaryStream(this.getRowChunk(row, n), this.getColumnOffset(row, n), this.getColumnLength(row, n), this.getColumnDataType(n));
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    public Blob getBlob(int n) throws SQLException {
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(n);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, n)) {
            return null;
        }
        return this.typeConverter.toBlob(this.getRowChunk(row, n), this.getColumnOffset(row, n), this.getColumnLength(row, n), this.getColumnDataType(n), this.stmt.getRealRsetType().isScrollable());
    }

    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.findColumn(string));
    }

    public synchronized boolean getBoolean(int n) throws SQLException {
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(n);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, n)) {
            return false;
        }
        return this.typeConverter.toBoolean(this.getRowChunk(row, n), this.getColumnOffset(row, n), this.getColumnLength(row, n), this.getColumnDataType(n));
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    public synchronized byte getByte(int n) throws SQLException {
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(n);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, n)) {
            return 0;
        }
        return this.typeConverter.toByte(this.getRowChunk(row, n), this.getColumnOffset(row, n), this.getColumnLength(row, n), this.getColumnDataType(n));
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    public synchronized byte[] getBytes(int n) throws SQLException {
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(n);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, n)) {
            return null;
        }
        return this.typeConverter.toBytes(this.getRowChunk(row, n), this.getColumnOffset(row, n), this.getColumnLength(row, n), this.getColumnDataType(n), this.stmt.getRealRsetType().isScrollable());
    }

    public synchronized int getBytes(int n, byte[] byArray) throws SQLException {
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(n);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, n)) {
            byArray[0] = 0;
            return 0;
        }
        return this.typeConverter.toBytes(this.getRowChunk(row, n), this.getColumnOffset(row, n), this.getColumnLength(row, n), this.getColumnDataType(n), byArray);
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    public synchronized Reader getCharacterStream(int n) throws SQLException {
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(n);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, n)) {
            return null;
        }
        return this.typeConverter.toCharacterStream(this.getRowChunk(row, n), this.getColumnOffset(row, n), this.getColumnLength(row, n), this.getColumnDataType(n));
    }

    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumn(string));
    }

    public Clob getClob(int n) throws SQLException {
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(n);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, n)) {
            return null;
        }
        return this.typeConverter.toClob(this.getRowChunk(row, n), this.getColumnOffset(row, n), this.getColumnLength(row, n), this.getColumnDataType(n), this.stmt.getRealRsetType().isScrollable());
    }

    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.findColumn(string));
    }

    public Column[] getCols() {
        return this.cols;
    }

    int getColumnCount() {
        return this.columnCount - this.beginColumnIndex;
    }

    protected int getColumnDataType(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.cols[n + this.beginColumnIndex - 1].getDataType();
    }

    protected TbTypeDescriptor getColumnTypeDescriptor(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.cols[n + this.beginColumnIndex - 1].getDescriptor();
    }

    private int getColumnLength(Row row, int n) {
        return row.getColumnLength(n + this.beginColumnIndex);
    }

    protected int getColumnMaxLength(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.cols[n + this.beginColumnIndex - 1].getMaxLength();
    }

    protected String getColumnName(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.cols[n + this.beginColumnIndex - 1].getName();
    }

    protected boolean getColumnNullable(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.cols[n + this.beginColumnIndex - 1].isNullable();
    }

    private int getColumnOffset(Row row, int n) {
        return row.getColumnOffset(n + this.beginColumnIndex);
    }

    private int getColumnPosByName(String string) throws SQLException {
        Integer n;
        if (this.cols == null || this.getColumnCount() == 0) {
            throw TbError.newSQLException(-90607);
        }
        if (this.columnNameMap == null) {
            this.buildColumnNameMap();
        }
        if ((n = (Integer)this.columnNameMap.get(string != null ? string.toUpperCase() : "")) == null) {
            throw TbError.newSQLException(-90611, string);
        }
        return n;
    }

    protected int getColumnPrecision(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.cols[n + this.beginColumnIndex - 1].getPrecision();
    }

    protected byte[] getColumnRawData(int n) throws SQLException {
        return this.getCurrentRow().getRawBytes(n + this.beginColumnIndex);
    }

    protected int getColumnScale(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.cols[n + this.beginColumnIndex - 1].getScale();
    }

    protected int getColumnSqlType(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.cols[n + this.beginColumnIndex - 1].getSqlType();
    }

    protected abstract Row getCurrentRow() throws SQLException;

    public int getCursorId() {
        return this.csrID;
    }

    public String getCursorName() throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    public synchronized Date getDate(int n) throws SQLException {
        return this.getDateInternal(n);
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        Date date = this.getDateInternal(n);
        if (calendar != null) {
            calendar.setTime(date);
            date = (Date)calendar.getTime();
        }
        return date;
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(string), calendar);
    }

    private Date getDateInternal(int n) throws SQLException {
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(n);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, n)) {
            return null;
        }
        return this.typeConverter.toDate(this.getRowChunk(row, n), this.getColumnOffset(row, n), this.getColumnLength(row, n), this.getColumnDataType(n));
    }

    public TbDate getTbDate(int n) throws SQLException {
        return this.getTbDateInternal(n);
    }

    private TbDate getTbDateInternal(int n) throws SQLException {
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(n);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, n)) {
            return null;
        }
        return this.typeConverter.toTbDate(this.getRowChunk(row, n), this.getColumnOffset(row, n), this.getColumnLength(row, n), this.getColumnDataType(n));
    }

    public synchronized double getDouble(int n) throws SQLException {
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(n);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, n)) {
            return 0.0;
        }
        return this.typeConverter.toDouble(this.getRowChunk(row, n), this.getColumnOffset(row, n), this.getColumnLength(row, n), this.getColumnDataType(n));
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    public synchronized int getFetchDirection() throws SQLException {
        return this.fetchDirection;
    }

    public synchronized int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    public synchronized float getFloat(int n) throws SQLException {
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(n);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, n)) {
            return 0.0f;
        }
        return this.typeConverter.toFloat(this.getRowChunk(row, n), this.getColumnOffset(row, n), this.getColumnLength(row, n), this.getColumnDataType(n));
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    public synchronized int getInt(int n) throws SQLException {
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(n);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, n)) {
            return 0;
        }
        return this.typeConverter.toInt(this.getRowChunk(row, n), this.getColumnOffset(row, n), this.getColumnLength(row, n), this.getColumnDataType(n));
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    public synchronized long getLong(int n) throws SQLException {
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(n);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, n)) {
            return 0L;
        }
        return this.typeConverter.toLong(this.getRowChunk(row, n), this.getColumnOffset(row, n), this.getColumnLength(row, n), this.getColumnDataType(n));
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    public synchronized InputStream getLongByteStream(int n) throws SQLException {
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(n);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, n)) {
            return null;
        }
        return this.typeConverter.toLongRawStream(this.getRowChunk(row, n), this.getColumnOffset(row, n), this.getColumnLength(row, n), this.getColumnDataType(n));
    }

    public boolean getMapDateToTimestamp() {
        return this.mapDateToTimestamp;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return new TbResultSetMetaData(this.cols, this.beginColumnIndex);
    }

    public Reader getNCharacterStream(int n) throws SQLException {
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(n);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, n)) {
            return null;
        }
        return this.typeConverter.toCharacterStream(this.getRowChunk(row, n), this.getColumnOffset(row, n), this.getColumnLength(row, n), this.getColumnDataType(n));
    }

    public Reader getNCharacterStream(String string) throws SQLException {
        return this.getNCharacterStream(this.findColumn(string));
    }

    public TbNClob getTbNClob(int n) throws SQLException {
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(n);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, n)) {
            return null;
        }
        return this.typeConverter.toTbNClob(this.getRowChunk(row, n), this.getColumnOffset(row, n), this.getColumnLength(row, n), this.getColumnDataType(n));
    }

    public TbNClob getTbNClob(String string) throws SQLException {
        return this.getTbNClob(this.findColumn(string));
    }

    public String getNString(int n) throws SQLException {
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(n);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, n)) {
            return null;
        }
        return this.typeConverter.toString(this.getRowChunk(row, n), this.getColumnOffset(row, n), this.getColumnLength(row, n), this.getColumnDataType(n), this.getColumnPrecision(n), this.getColumnScale(n), !this.getRsetType().isScrollable());
    }

    public String getNString(String string) throws SQLException {
        return this.getNString(this.findColumn(string));
    }

    public synchronized Object getObject(int n) throws SQLException {
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(n);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, n)) {
            return null;
        }
        return this.typeConverter.toObject(this.getRowChunk(row, n), this.getColumnOffset(row, n), this.getColumnLength(row, n), this.getColumnDataType(n), this.getColumnSqlType(n), this.getColumnPrecision(n), this.getColumnScale(n), !this.getRsetType().isScrollable(), this.getColumnTypeDescriptor(n), null, this.stmt.conn.getTypeMap());
    }

    public Object getObject(int n, Map map) throws SQLException {
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(n);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, n)) {
            return null;
        }
        TbTypeDescriptor tbTypeDescriptor = this.getColumnTypeDescriptor(n);
        String string = null;
        Class clazz = null;
        if (tbTypeDescriptor != null && (string = tbTypeDescriptor.getSQLTypeName()) != null && map != null) {
            clazz = (Class)map.get(string);
        }
        return this.typeConverter.toObject(this.getRowChunk(row, n), this.getColumnOffset(row, n), this.getColumnLength(row, n), this.getColumnDataType(n), this.getColumnSqlType(n), this.getColumnPrecision(n), this.getColumnScale(n), !this.getRsetType().isScrollable(), tbTypeDescriptor, clazz, map);
    }

    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    public Object getObject(String string, Map map) throws SQLException {
        return this.getObject(this.findColumn(string), map);
    }

    public Object getObject(String string, Class clazz) throws SQLException {
        return this.getObject(this.findColumn(string), clazz);
    }

    public Object getObject(int n, Class clazz) throws SQLException {
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(n);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, n)) {
            return null;
        }
        return this.typeConverter.toObject(this.getRowChunk(row, n), this.getColumnOffset(row, n), this.getColumnLength(row, n), this.getColumnDataType(n), this.getColumnSqlType(n), this.getColumnPrecision(n), this.getColumnScale(n), !this.getRsetType().isScrollable(), this.getColumnTypeDescriptor(n), clazz, this.stmt.conn.getTypeMap());
    }

    public int getPreparedFetchCnt() {
        return this.preparedFetchCnt;
    }

    public Ref getRef(int n) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    public Ref getRef(String string) throws SQLException {
        return this.getRef(this.findColumn(string));
    }

    public synchronized int getRow() throws SQLException {
        if (this.rowsFetchedCnt == 0 || this.currentRowIndex < 0 || this.currentRowIndex >= this.rowsFetchedCnt) {
            return 0;
        }
        return this.currentRowIndex + 1;
    }

    public byte[] getRowChunk(int n) {
        if (this.rowChunk == null || this.rowChunk.length < n) {
            this.rowChunk = new byte[n];
        }
        return this.rowChunk;
    }

    private Object getRowChunk(Row row, int n) {
        return row.getRowChunk(n + this.beginColumnIndex);
    }

    public synchronized short getShort(int n) throws SQLException {
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(n);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, n)) {
            return 0;
        }
        return this.typeConverter.toShort(this.getRowChunk(row, n), this.getColumnOffset(row, n), this.getColumnLength(row, n), this.getColumnDataType(n));
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    public Statement getStatement() throws SQLException {
        return this.stmt;
    }

    public synchronized String getString(int n) throws SQLException {
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(n);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, n)) {
            return null;
        }
        return this.typeConverter.toString(this.getRowChunk(row, n), this.getColumnOffset(row, n), this.getColumnLength(row, n), this.getColumnDataType(n), this.getColumnPrecision(n), this.getColumnScale(n), !this.getRsetType().isScrollable());
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    public synchronized Time getTime(int n) throws SQLException {
        return this.getTimeInternal(n);
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        Time time = this.getTimeInternal(n);
        if (calendar != null) {
            calendar.setTime(time);
            time = (Time)calendar.getTime();
        }
        return time;
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(string), calendar);
    }

    private Time getTimeInternal(int n) throws SQLException {
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(n);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, n)) {
            return null;
        }
        return this.typeConverter.toTime(this.getRowChunk(row, n), this.getColumnOffset(row, n), this.getColumnLength(row, n), this.getColumnDataType(n));
    }

    public synchronized Timestamp getTimestamp(int n) throws SQLException {
        return this.getTimestampInternal(n);
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        if (calendar == null) {
            return this.getTimestampInternal(n);
        }
        return this.getTimestampInternal(n, calendar);
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    private Timestamp getTimestampInternal(int n) throws SQLException {
        return this.getTimestampInternal(n, null);
    }

    private Timestamp getTimestampInternal(int n, Calendar calendar) throws SQLException {
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(n);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, n)) {
            return null;
        }
        return this.typeConverter.toTimestamp(this.getRowChunk(row, n), this.getColumnOffset(row, n), this.getColumnLength(row, n), this.getColumnDataType(n), calendar);
    }

    public TbTimestamp getTbTimestamp(int n) throws SQLException {
        return this.getTbTimestampInternal(n);
    }

    private TbTimestamp getTbTimestampInternal(int n) throws SQLException {
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(n);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, n)) {
            return null;
        }
        return this.typeConverter.toTbTimestamp(this.getRowChunk(row, n), this.getColumnOffset(row, n), this.getColumnLength(row, n), this.getColumnDataType(n));
    }

    public synchronized InputStream getUnicodeStream(int n) throws SQLException {
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(n);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, n)) {
            return null;
        }
        return this.typeConverter.toUnicodeStream(this.getRowChunk(row, n), this.getColumnOffset(row, n), this.getColumnLength(row, n), this.getColumnDataType(n), !this.getRsetType().isScrollable());
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    public URL getURL(int n) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    public URL getURL(String string) throws SQLException {
        return this.getURL(this.findColumn(string));
    }

    protected boolean hasNoResultReturned() throws SQLException {
        return this.rowsFetchedCnt > 0 ? false : this.fetchComplete;
    }

    public void insertRow() throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    public synchronized boolean isAfterLast() throws SQLException {
        if (this.stmt.getMaxRows() != 0 && this.currentRowIndex + 1 > this.stmt.getMaxRows()) {
            return true;
        }
        return !this.hasNoResultReturned() && this.fetchComplete && this.currentRowIndex + 1 > this.rowsFetchedCnt;
    }

    public synchronized boolean isBeforeFirst() throws SQLException {
        return !this.hasNoResultReturned() && this.currentRowIndex < 0;
    }

    public synchronized boolean isFirst() throws SQLException {
        return !this.hasNoResultReturned() && this.currentRowIndex == 0;
    }

    public boolean isClosed() throws SQLException {
        return this.isRsetClosed;
    }

    public boolean isFetchComplete() {
        return this.fetchComplete;
    }

    private void makeColumnMetaArray(int n) {
        this.mapDateToTimestamp = this.stmt.conn.getMapDateToTimestamp();
        this.cols = new Column[n];
        for (int i = 0; i < n; ++i) {
            this.cols[i] = new Column(this.mapDateToTimestamp);
        }
    }

    public void moveToCurrentRow() throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    public void moveToInsertRow() throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    public synchronized boolean next() throws SQLException {
        if (this.csrID == -1) {
            throw TbError.newSQLException(-90607);
        }
        if (this.isRsetClosed) {
            throw TbError.newSQLException(-90646);
        }
        if (this.stmt.conn == null || this.stmt.conn.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        if (this.isSvrCsrClosed || this.csrID == -2) {
            return false;
        }
        this.currentRowIndex = this.currentRowIndex < 0 ? 0 : ++this.currentRowIndex;
        if (this.stmt.getMaxRows() != 0 && this.currentRowIndex >= this.stmt.getMaxRows()) {
            this.closeCursor();
            return false;
        }
        while (this.currentRowIndex >= this.rowsFetchedCnt) {
            if (this.fetchComplete) {
                return false;
            }
            this.fetchRowsChunk();
        }
        return true;
    }

    public void refreshRow() throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    protected abstract void removeCurrentRow() throws SQLException;

    protected void reset() {
        super.reset();
        if (this.columnNameMap != null) {
            this.columnNameMap.clear();
            this.columnNameMap = null;
        }
        this.stmt = null;
        this.csrID = -1;
        this.lastColumnWasNull = false;
        this.typeConverter = null;
        this.cols = null;
        this.rowChunk = null;
        this.fetchComplete = false;
        this.currentRowIndex = -1;
        this.rowsFetchedCnt = 0;
        this.fetchDirection = 1000;
        this.fetchSize = 50;
        this.isRsetClosed = false;
        this.closeStatementOnClose = false;
    }

    public boolean rowDeleted() throws SQLException {
        return false;
    }

    public boolean rowInserted() throws SQLException {
        return false;
    }

    public boolean rowUpdated() throws SQLException {
        return false;
    }

    public synchronized void setFetchCompleted(int n) {
        this.fetchComplete = TbCommon.getBitmapAt(0, n);
    }

    public synchronized void setFetchDirection(int n) throws SQLException {
        switch (n) {
            case 1000: 
            case 1002: {
                this.fetchDirection = 1000;
                return;
            }
            case 1001: {
                this.fetchDirection = 1001;
                break;
            }
            default: {
                throw TbError.newSQLException(-90608);
            }
        }
    }

    public synchronized void setFetchSize(int n) throws SQLException {
        if (n == 0) {
            this.fetchSize = 50;
        } else if (n > 0) {
            this.fetchSize = n;
        } else {
            throw TbError.newSQLException(-590735);
        }
    }

    protected boolean setLastColumnIsNull(Row row, int n) throws SQLException {
        this.lastColumnWasNull = row.isNull(n + this.beginColumnIndex);
        return this.lastColumnWasNull;
    }

    public void setPreparedFetchCnt(int n) {
        this.preparedFetchCnt = n;
    }

    public void updateArray(int n, Array array) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    public void updateArray(String string, Array array) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    public void updateBlob(int n, Blob blob) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    public void updateBlob(String string, Blob blob) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    public void updateByte(int n, byte by) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    public void updateByte(String string, byte by) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    public void updateClob(int n, Clob clob) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    public void updateClob(String string, Clob clob) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    public void updateDate(int n, Date date) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    public void updateDate(String string, Date date) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    public void updateDouble(int n, double d) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    public void updateDouble(String string, double d) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    public void updateFloat(int n, float f) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    public void updateFloat(String string, float f) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    public void updateInt(int n, int n2) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    public void updateInt(String string, int n) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    public void updateLong(int n, long l) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    public void updateLong(String string, long l) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    public void updateNull(int n) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    public void updateNull(String string) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    public void updateObject(int n, Object object) throws SQLException {
        this.updateObject(n, object, 0);
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    public void updateObject(String string, Object object) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    public void updateRef(int n, Ref ref) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    public void updateRef(String string, Ref ref) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    public void updateRow() throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    public void updateShort(int n, short s) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    public void updateShort(String string, short s) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    public void updateString(int n, String string) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    public void updateString(String string, String string2) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    public void updateTime(int n, Time time) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    public void updateTime(String string, Time time) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    public void updateTbTimestamp(int n, TbTimestamp tbTimestamp) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    public void updateTbTimestamp(String string, TbTimestamp tbTimestamp) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    public synchronized boolean wasNull() throws SQLException {
        return this.lastColumnWasNull;
    }
}

