/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data.charset;

public class MS950ExtCharToByteConverter {
    private static final char[] CP950EXT_TO_CHARSET = new char[]{'\uf9f9', '\uf9f8', '\uf9e6', '\uf9ef', '\uf9dd', '\uf9e8', '\uf9f1', '\uf9df', '\uf9ec', '\uf9f5', '\uf9e3', '\uf9ee', '\uf9f7', '\uf9e5', '\uf9e9', '\uf9f2', '\uf9e0', '\uf9eb', '\uf9f4', '\uf9e2', '\uf9e7', '\uf9f0', '\uf9de', '\uf9ed', '\uf9f6', '\uf9e4', '\uf9ea', '\uf9f3', '\uf9e1', '\uf9fa', '\uf9fb', '\uf9fd', '\uf9fc', '\uf9fe', '\uf9d9', '\uf9dc', '\uf9da', '\uf9d6', '\uf9db', '\uf9d8', '\uf9d7'};
    private static final char[][] CP950EXT_TO_UNICODE_PAGE25 = new char[][]{{'\u0000', '\u0000'}, {'\u0000', '\u0000'}, {'\u0000', '\u0000'}, {'\u0000', '\u0000'}, {'\u0000', '\u0000'}, {'\u0000', '\uffff'}, {'\u0010', '\uffff'}, {' ', '\u0001'}, {'!', '\u0000'}, {'!', '\b'}};
    private static final char[][] CP950EXT_TO_UNICODE_PAGE58 = new char[][]{{'\"', '\u0000'}, {'\"', '\u0000'}, {'\"', '\u0000'}, {'\"', '\u0000'}, {'\"', '\u0000'}, {'\"', '\u0000'}, {'\"', '\u0000'}, {'\"', '\u0000'}, {'\"', '\u0000'}, {'\"', '\u0000'}, {'\"', '\u0000'}, {'\"', '\u0800'}};
    private static final char[][] CP950EXT_TO_UNICODE_PAGE5A = new char[][]{{'#', '\u0000'}, {'#', '\u0000'}, {'#', '\u0000'}, {'#', '\u0000'}, {'#', '\u0000'}, {'#', '\u0000'}, {'#', '\u0000'}, {'#', '\u0000'}, {'#', '\u0000'}, {'#', '\u0000'}, {'#', '\u0000'}, {'#', '\u0000'}, {'#', '\u0000'}, {'#', '\u0000'}, {'#', '\u0000'}, {'#', '\u0400'}};
    private static final char[][] CP950EXT_TO_UNICODE_PAGE60 = new char[][]{{'$', '\u0000'}, {'$', '\u0000'}, {'$', '\u0000'}, {'$', '\u0000'}, {'$', '\u0000'}, {'$', '\u0004'}};
    private static final char[][] CP950EXT_TO_UNICODE_PAGE78 = new char[][]{{'%', '\u0000'}, {'%', '\u0000'}, {'%', '\u0000'}, {'%', '\u0000'}, {'%', '\u0000'}, {'%', '\u0000'}, {'%', '\u0000'}, {'%', '\u0000'}, {'%', '\u0002'}};
    private static final char[][] CP950EXT_TO_UNICODE_PAGE7C = new char[][]{{'&', '\u0000'}, {'&', '\u0000'}, {'&', '\u0000'}, {'&', '\u0000'}, {'&', '\u0000'}, {'&', '\u0000'}, {'&', '\u0000'}, {'&', '\u0000'}, {'&', '\u0000'}, {'&', '\u0000'}, {'&', '\u0080'}};
    private static final char[][] CP950EXT_TO_UNICODE_PAGE88 = new char[][]{{'\'', '\u0000'}, {'\'', '\u0000'}, {'\'', '\u0000'}, {'\'', '\u0000'}, {'\'', '\u0000'}, {'\'', '\u0000'}, {'\'', '\u0000'}, {'\'', '\u0000'}, {'\'', '\u0000'}, {'\'', '\u0000'}, {'\'', '\u0000'}, {'\'', '\u0000'}, {'\'', '\u8000'}};
    private static final char[][] CP950EXT_TO_UNICODE_PAGE92 = new char[][]{{'(', '\u0000'}, {'(', '\u0000'}, {'(', '\u0000'}, {'(', '\u0000'}, {'(', '\u0000'}, {'(', '\u0000'}, {'(', '\u0000'}, {'(', '\u0000'}, {'(', '\u0000'}, {'(', '\u0000'}, {'(', '\u0000'}, {'(', '\u0200'}};
    protected boolean subMode = true;
    protected byte[] subBytes = new byte[]{63};

    public int getMaxBytesPerChar() {
        return 2;
    }

    public int convert(int n, byte[] byArray, int n2) {
        int n3;
        int n4;
        char[] cArray = null;
        if (n >= 9472 && n < 9632) {
            cArray = CP950EXT_TO_UNICODE_PAGE25[(n >> 4) - 592];
        } else if (n >= 22528 && n < 22720) {
            cArray = CP950EXT_TO_UNICODE_PAGE58[(n >> 4) - 1408];
        } else if (n >= 23040 && n < 23296) {
            cArray = CP950EXT_TO_UNICODE_PAGE5A[(n >> 4) - 1440];
        } else if (n >= 24576 && n < 24672) {
            cArray = CP950EXT_TO_UNICODE_PAGE60[(n >> 4) - 1536];
        } else if (n >= 30720 && n < 30864) {
            cArray = CP950EXT_TO_UNICODE_PAGE78[(n >> 4) - 1920];
        } else if (n >= 31744 && n < 31920) {
            cArray = CP950EXT_TO_UNICODE_PAGE7C[(n >> 4) - 1984];
        } else if (n >= 34816 && n < 35024) {
            cArray = CP950EXT_TO_UNICODE_PAGE88[(n >> 4) - 2176];
        } else if (n >= 37376 && n < 37568) {
            cArray = CP950EXT_TO_UNICODE_PAGE92[(n >> 4) - 2336];
        }
        if (cArray != null && ((n4 = cArray[1]) & 1 << (n3 = n & 0xF)) != 0) {
            n4 &= (1 << n3) - 1;
            n4 = (n4 & 0x5555) + ((n4 & 0xAAAA) >> 1);
            n4 = (n4 & 0x3333) + ((n4 & 0xCCCC) >> 2);
            n4 = (n4 & 0xF0F) + ((n4 & 0xF0F0) >> 4);
            n4 = (n4 & 0xFF) + (n4 >> 8);
            char c = CP950EXT_TO_CHARSET[cArray[0] + n4];
            byArray[n2] = (byte)(c >> 8);
            byArray[n2 + 1] = (byte)(c & 0xFF);
            return 0;
        }
        return -1;
    }
}

