/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import java.sql.SQLException;
import java.util.StringTokenizer;

public abstract class TbTypeDescriptor {
    private String sqlTypeName;
    private String schemaName;
    private String packageName;
    private String typeName;
    private int kind;
    private int id;

    void init(int n, String string) throws SQLException {
        this.kind = n;
        this.sqlTypeName = string;
        this.parseSQLTypeName(string);
    }

    public String getSQLTypeName() {
        return this.sqlTypeName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public int getKind() {
        return this.kind;
    }

    int getId() {
        return this.id;
    }

    private int parseSQLTypeName(String string) throws SQLException {
        String string2 = ".";
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        int n = stringTokenizer.countTokens();
        if (n == 2) {
            this.schemaName = stringTokenizer.nextToken().toUpperCase();
            this.typeName = stringTokenizer.nextToken().toUpperCase();
            this.packageName = null;
        } else if (n == 3) {
            this.schemaName = stringTokenizer.nextToken().toUpperCase();
            this.packageName = stringTokenizer.nextToken().toUpperCase();
            this.typeName = stringTokenizer.nextToken().toUpperCase();
        } else {
            throw new SQLException("Invalid type name : " + string);
        }
        return n;
    }
}

