/*
 * Decompiled with CFR 0.152.
 */
package com.citrix.mas.nitro.datatypes;

import com.citrix.mas.nitro.datatypes.MPSConstraint;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class MPSConstraintString
extends MPSConstraint {
    private boolean isRequired = false;
    private int maxStrLen = Integer.MAX_VALUE;
    public int minStrLen = 0;
    private String charSetRegEx = "";

    public void setIsRequired(boolean bl) {
        this.isRequired = bl;
    }

    public void setMaxStrLen(int n) {
        this.maxStrLen = n;
    }

    public void setMinStrLen(int n) {
        this.minStrLen = n;
    }

    public void setCharSetRegEx(String string) {
        this.charSetRegEx = string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void validate(Object object, String string) throws Exception {
        Matcher matcher;
        if (object == null) {
            object = "";
        }
        String string2 = (String)object;
        if (!this.isRequired && string2.length() == 0) {
            return;
        }
        if (string2.length() < this.minStrLen) {
            throw new Exception(string + " String length: " + string2.length() + " is less than minimum length: " + this.minStrLen);
        }
        if (string2.length() > this.maxStrLen) {
            throw new Exception(string + " String length: " + string2.length() + " is greater than maximum length: " + this.maxStrLen);
        }
        if (this.charSetRegEx.length() == 0) {
            return;
        }
        try {
            Pattern pattern = Pattern.compile(this.charSetRegEx);
            matcher = pattern.matcher(string2);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw new Exception("charSetRegEx:" + this.charSetRegEx + " pattern compilation failed " + patternSyntaxException.getMessage());
        }
        if (matcher == null) throw new Exception(string + " String: " + string2 + " Null matcher value returned");
        if (!matcher.matches()) throw new Exception(string + " String: " + string2 + " does not comply with characters: " + this.charSetRegEx);
        if (matcher.start() != 0 || matcher.end() != string2.length()) return;
    }
}

