/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.sql.xa;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;
import oracle.oc4j.sql.xa.EmulatedXADataSource;
import oracle.oc4j.sql.xa.EmulatedXAResource;
import oracle.oc4j.sql.xa.RecoverableCommitStrategy;

public class EmulatedXAConnection
implements XAConnection {
    private EmulatedXADataSource m_xaDataSource = null;
    private EmulatedXAResource m_xaResource = null;
    private PooledConnection m_pooledConnection = null;
    private Connection m_currentLogicalConnection = null;

    public EmulatedXAConnection(EmulatedXADataSource xaDataSource, PooledConnection pooledConnection) {
        if (xaDataSource == null) {
            throw new IllegalArgumentException("The XADataSource can not be null.");
        }
        if (pooledConnection == null) {
            throw new IllegalArgumentException("The PooledConnection cannot be null.");
        }
        this.m_xaDataSource = xaDataSource;
        this.m_pooledConnection = pooledConnection;
    }

    public XAResource getXAResource() throws SQLException {
        if (this.m_xaResource == null) {
            this.m_xaResource = this.m_xaDataSource.createEmulatedXAResource(this);
        }
        return this.m_xaResource;
    }

    public Connection getConnection() throws SQLException {
        if (this.m_currentLogicalConnection == null) {
            this.m_currentLogicalConnection = this.m_pooledConnection.getConnection();
        }
        return this.m_currentLogicalConnection;
    }

    public void close() throws SQLException {
        this.m_pooledConnection.close();
        this.m_currentLogicalConnection = null;
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.m_pooledConnection.addConnectionEventListener(listener);
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.m_pooledConnection.removeConnectionEventListener(listener);
    }

    public EmulatedXADataSource getXADataSource() {
        return this.m_xaDataSource;
    }

    public Connection getCurrentLogicalConnection() {
        return this.m_currentLogicalConnection;
    }

    protected boolean isRecoverableCommitStrategyAvailable(RecoverableCommitStrategy strategy) throws SQLException {
        return strategy.isAvailable(this.getConnection());
    }
}

