/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.sql.spi;

import java.sql.SQLException;
import java.util.HashMap;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import oracle.j2ee.datasource.DataSourceMessages;
import oracle.oc4j.sql.spi.TxAction;
import oracle.oc4j.sql.spi.TxStateValue;

class TxState {
    static final TxStateValue ERROR_ST = TxStateValue.ERROR_ST;
    static final TxStateValue INITIAL_ST = TxStateValue.INITIAL_ST;
    static final TxStateValue ACTIVE_ST = TxStateValue.ACTIVE_ST;
    static final TxStateValue IDLE_ST = TxStateValue.IDLE_ST;
    static final TxStateValue SUSPENDED_ST = TxStateValue.SUSPENDED_ST;
    static final TxStateValue PREPARED_ST = TxStateValue.PREPARED_ST;
    static final TxStateValue ACTIVE_LOCAL_ST = TxStateValue.ACTIVE_LOCAL_ST;
    static final TxAction START_JOIN = TxAction.START_JOIN;
    static final TxAction START_RESUME = TxAction.START_RESUME;
    static final TxAction START_NOFLAGS = TxAction.START_NOFLAGS;
    static final TxAction END_FAIL = TxAction.END_FAIL;
    static final TxAction END_SUSPEND = TxAction.END_SUSPEND;
    static final TxAction END_SUCCESS = TxAction.END_SUCCESS;
    static final TxAction FORGET = TxAction.FORGET;
    static final TxAction PREPARE = TxAction.PREPARE;
    static final TxAction PREPARE_RDONLY = TxAction.PREPARE_RDONLY;
    static final TxAction COMMIT_1PC = TxAction.COMMIT_1PC;
    static final TxAction COMMIT_2PC = TxAction.COMMIT_2PC;
    static final TxAction ROLLBACK = TxAction.ROLLBACK;
    static final TxAction BEGIN_LOCAL = TxAction.BEGIN_LOCAL;
    static final TxAction COMMIT_LOCAL = TxAction.COMMIT_LOCAL;
    static final TxAction ROLLBACK_LOCAL = TxAction.ROLLBACK_LOCAL;
    private HashMap m_txStates = new HashMap();
    private TxStateValue m_currentState = INITIAL_ST;
    private boolean m_isGlobalTxActive = false;
    private boolean m_isLocalTxActive = false;
    private boolean m_isTxActive = false;
    private static final TxStateValue[][] m_states = new TxStateValue[][]{{ACTIVE_ST, ACTIVE_ST, ERROR_ST, ERROR_ST, ERROR_ST, ERROR_ST}, {ERROR_ST, ERROR_ST, ERROR_ST, ACTIVE_ST, ERROR_ST, ERROR_ST}, {ACTIVE_ST, ERROR_ST, ERROR_ST, ERROR_ST, ERROR_ST, ERROR_ST}, {ERROR_ST, IDLE_ST, ERROR_ST, IDLE_ST, ERROR_ST, ERROR_ST}, {ERROR_ST, SUSPENDED_ST, ERROR_ST, ERROR_ST, ERROR_ST, ERROR_ST}, {ERROR_ST, IDLE_ST, ERROR_ST, IDLE_ST, ERROR_ST, ERROR_ST}, {INITIAL_ST, ERROR_ST, ERROR_ST, ERROR_ST, ERROR_ST, ERROR_ST}, {ERROR_ST, ERROR_ST, PREPARED_ST, ERROR_ST, ERROR_ST, ERROR_ST}, {ERROR_ST, ERROR_ST, INITIAL_ST, ERROR_ST, ERROR_ST, ERROR_ST}, {ERROR_ST, ERROR_ST, INITIAL_ST, ERROR_ST, ERROR_ST, ERROR_ST}, {INITIAL_ST, ERROR_ST, ERROR_ST, ERROR_ST, INITIAL_ST, ERROR_ST}, {INITIAL_ST, ERROR_ST, INITIAL_ST, INITIAL_ST, INITIAL_ST, ERROR_ST}, {ACTIVE_LOCAL_ST, ERROR_ST, ERROR_ST, ERROR_ST, ERROR_ST, ERROR_ST}, {ERROR_ST, ERROR_ST, ERROR_ST, ERROR_ST, ERROR_ST, INITIAL_ST}, {ERROR_ST, ERROR_ST, ERROR_ST, ERROR_ST, ERROR_ST, INITIAL_ST}};

    TxState() {
    }

    final boolean isGlobalTxActive() {
        return this.m_isGlobalTxActive;
    }

    final boolean isLocalTxActive() {
        return this.m_isLocalTxActive;
    }

    final boolean isTxActive() {
        return this.m_isTxActive;
    }

    private void setTxActiveStates() {
        this.m_isGlobalTxActive = this.m_currentState == ACTIVE_ST || this.m_currentState == IDLE_ST || this.m_currentState == PREPARED_ST;
        this.m_isLocalTxActive = this.m_currentState == ACTIVE_LOCAL_ST;
        this.m_isTxActive = this.m_isGlobalTxActive || this.m_isLocalTxActive;
    }

    void xaResourceAction(Xid xid, TxAction action) throws XAException {
        TxStateValue txStateValue = this.getTxStateValue(xid);
        this.m_currentState = m_states[action.getIndex()][txStateValue.getIndex()];
        this.setTxActiveStates();
        if (this.m_currentState == ERROR_ST) {
            XAException xaException = new XAException(this.handleInvalidAction(action, txStateValue));
            xaException.errorCode = -6;
            throw xaException;
        }
        this.setTxStateValue(this.m_currentState, xid);
    }

    void localTxAction(TxAction action) throws SQLException {
        TxStateValue txStateValue = this.getTxStateValue(null);
        this.m_currentState = m_states[action.getIndex()][txStateValue.getIndex()];
        this.setTxActiveStates();
        if (this.m_currentState == ERROR_ST) {
            SQLException exception = new SQLException(this.handleInvalidAction(action, txStateValue));
            throw exception;
        }
        this.setTxStateValue(this.m_currentState, null);
    }

    void endLocalTx() {
        if (this.isLocalTxActive()) {
            this.m_currentState = INITIAL_ST;
            this.setTxActiveStates();
            this.setTxStateValue(this.m_currentState, null);
        }
    }

    protected static TxAction actionFromXAResourceStartFlags(int flags) {
        TxAction action = START_NOFLAGS;
        if (flags == 0x200000) {
            action = START_JOIN;
        } else if (flags == 0x8000000) {
            action = START_RESUME;
        }
        return action;
    }

    protected static TxAction actionFromXAResourceEndFlags(int flags) {
        TxAction action = END_SUCCESS;
        if (flags == 0x2000000) {
            action = END_SUSPEND;
        } else if (flags == 0x20000000) {
            action = END_FAIL;
        }
        return action;
    }

    private String handleInvalidAction(TxAction action, TxStateValue txStateValue) {
        this.m_txStates.remove(null);
        return DataSourceMessages.severeTxStateHandleInvalidAction(action.toString(), txStateValue.toString());
    }

    private void setTxStateValue(TxStateValue txStateValue, Xid xid) {
        if (txStateValue != INITIAL_ST) {
            this.m_txStates.put(xid, txStateValue);
        } else {
            this.m_txStates.remove(xid);
        }
    }

    protected TxStateValue getTxStateValue(Xid xid) {
        TxStateValue txStateValue = (TxStateValue)this.m_txStates.get(xid);
        if (txStateValue == null) {
            return INITIAL_ST;
        }
        return txStateValue;
    }

    protected TxStateValue getCurrentState() {
        return this.m_currentState;
    }
}

