/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.sql.config.legacy;

import com.evermind.util.AbstractDescribable;
import com.evermind.util.ObjectUtils;
import com.evermind.xml.XMLUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.oc4j.sql.config.DataSourceConfigException;
import oracle.oc4j.sql.config.PropertyConfig;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LegacyOneDataSourceConfig
extends AbstractDescribable {
    public static final long serialVersionUID = 67564345L;
    protected String connectionDriver;
    protected String url;
    protected String sourceLocation;
    protected String xaSourceLocation;
    protected String xaDataSourceClassName;
    private String recoveryLocation;
    protected String className;
    protected String username;
    private String password;
    protected String description;
    protected boolean isDefault;
    protected int maxInactivityTimeout;
    protected int loginTimeout = 0;
    protected int minConnections;
    protected int maxConnections = Integer.MAX_VALUE;
    protected int stmtCacheSize;
    protected String schemaPath;
    protected String host;
    protected int port;
    protected long taskManagerInterval = -1L;
    protected String xaLocation;
    protected String pooledLocation;
    protected String ejbLocation;
    protected boolean implicit;
    protected long connectionRetryInterval = 1L;
    protected int maxConnectionAttempts = 3;
    protected long waitTimeout = 0L;
    protected List properties;
    public static final String DS_ATTR_CLEAN_AVAILABLE_CONNECTIONS_THRESHOLD = "clean-available-connections-threshold";
    public static final String DS_ATTR_RAC_ENABLED = "rac-enabled";
    public static final int DEFAULT_CLEAN_AVAILABLE_CONNECTIONS_THRESHOLD = 30;
    public static final boolean DEFAULT_RAC_ENABLED = false;
    protected int m_cleanAvailableConnectionsThreshold = 30;
    protected boolean m_racEnabled = false;

    public LegacyOneDataSourceConfig() {
    }

    public LegacyOneDataSourceConfig(Map settings) throws InstantiationException {
        this.setName((String)settings.get("location"));
        this.setDisplayName((String)settings.get("displayName"));
        this.setDescription((String)settings.get("description"));
        this.connectionDriver = (String)settings.get("connectionDriver");
        this.url = (String)settings.get("url");
        this.sourceLocation = (String)settings.get("sourceLocation");
        this.xaSourceLocation = (String)settings.get("xaSourceLocation");
        this.className = (String)settings.get("className");
        this.username = (String)settings.get("username");
        this.password = (String)settings.get("password");
        this.description = (String)settings.get("description");
        this.isDefault = Boolean.TRUE.equals(settings.get("default"));
        this.setInactivityTimeout(ObjectUtils.getInt(settings.get("maxInactivityTimeout"), 0));
        this.loginTimeout = ObjectUtils.getInt(settings.get("loginTimeout"), this.maxInactivityTimeout);
        this.minConnections = ObjectUtils.getInt(settings.get("minConnections"), this.minConnections);
        Object temp = settings.get(DS_ATTR_CLEAN_AVAILABLE_CONNECTIONS_THRESHOLD);
        if (temp != null) {
            this.setCleanAvailableConnectionsThreshold(ObjectUtils.getInt(temp, 30));
        }
        this.setRacEnabled(ObjectUtils.toBoolean(settings.get(DS_ATTR_RAC_ENABLED)));
        this.maxConnections = ObjectUtils.getInt(settings.get("maxConnections"), this.maxConnections);
        this.stmtCacheSize = ObjectUtils.getInt(settings.get("stmtCacheSize"), 0);
        this.host = (String)settings.get("host");
        this.port = ObjectUtils.getInt(settings.get("port"), this.port);
        this.schemaPath = (String)settings.get("schemaPath");
        this.xaLocation = (String)settings.get("xaLocation");
        this.pooledLocation = (String)settings.get("pooledLocation");
        this.ejbLocation = (String)settings.get("ejbLocation");
        if (this.pooledLocation == null && this.ejbLocation != null) {
            this.pooledLocation = this.getLocation() + "_non_tx";
        }
        this.implicit = Boolean.TRUE.equals(settings.get("implicit"));
        this.connectionRetryInterval = ObjectUtils.getLong(settings.get("connectionRetryInterval"), this.connectionRetryInterval);
        this.maxConnectionAttempts = ObjectUtils.getInt(settings.get("maxConnectionAttempts"), this.maxConnectionAttempts);
        this.waitTimeout = ObjectUtils.getLong(settings.get("waitTimeout"), this.waitTimeout);
        this.properties = (ArrayList)settings.get("properties");
    }

    public LegacyOneDataSourceConfig(Node parent) throws InstantiationException {
        String className = XMLUtils.getNodeAttribute(parent, "class");
        if (className == null) {
            throw new InstantiationException("No 'class' attribute specified for <data-source> tag");
        }
        this.setClassName(className);
        String location = XMLUtils.getNodeAttribute(parent, "location");
        if (location != null) {
            this.setName(location);
        }
        this.schemaPath = XMLUtils.getNodeAttribute(parent, "schema");
        this.host = XMLUtils.getNodeAttribute(parent, "host");
        this.sourceLocation = XMLUtils.getNodeAttribute(parent, "source-location");
        this.xaSourceLocation = XMLUtils.getNodeAttribute(parent, "xa-source-location");
        this.recoveryLocation = XMLUtils.getNodeAttribute(parent, "recovery-location");
        this.xaDataSourceClassName = XMLUtils.getNodeAttribute(parent, "xadatasource-class");
        this.className = XMLUtils.getNodeAttribute(parent, "class");
        this.connectionDriver = XMLUtils.getNodeAttribute(parent, "connection-driver");
        this.setDisplayName(XMLUtils.getNodeAttribute(parent, "name"));
        this.username = XMLUtils.getNodeAttribute(parent, "username");
        this.password = XMLUtils.getNodeAttribute(parent, "password");
        this.url = XMLUtils.getNodeAttribute(parent, "url");
        try {
            this.taskManagerInterval = Long.parseLong(XMLUtils.getNodeAttribute(parent, "taskmanager-interval"));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        this.xaLocation = XMLUtils.getNodeAttribute(parent, "xa-location");
        this.pooledLocation = XMLUtils.getNodeAttribute(parent, "pooled-location");
        this.ejbLocation = XMLUtils.getNodeAttribute(parent, "ejb-location");
        if (this.xaLocation != null && location != null && this.ejbLocation != null && location.equals(this.xaLocation) && location.equals(this.ejbLocation)) {
            location = location + "_location";
            this.xaLocation = this.xaLocation + "_xaLocation";
        }
        if (this.pooledLocation == null && this.ejbLocation != null) {
            this.pooledLocation = this.getLocation() + "_non_tx";
        }
        String waitTimeoutString = XMLUtils.getNodeAttribute(parent, "wait-timeout");
        String timeoutString = XMLUtils.getNodeAttribute(parent, "inactivity-timeout");
        String minConnectionsString = XMLUtils.getNodeAttribute(parent, "min-connections");
        String maxConnectionsString = XMLUtils.getNodeAttribute(parent, "max-connections");
        String loginTimeoutString = XMLUtils.getNodeAttribute(parent, "login-timeout");
        String stmtCacheSize = XMLUtils.getNodeAttribute(parent, "stmt-cache-size");
        String connectionAttemptsString = XMLUtils.getNodeAttribute(parent, "max-connect-attempts");
        String connectionRetryInterval = XMLUtils.getNodeAttribute(parent, "connection-retry-interval");
        String cleanAvailableConnectionsThresholdString = XMLUtils.getNodeAttribute(parent, DS_ATTR_CLEAN_AVAILABLE_CONNECTIONS_THRESHOLD);
        String racEnabledString = XMLUtils.getNodeAttribute(parent, DS_ATTR_RAC_ENABLED);
        if (cleanAvailableConnectionsThresholdString != null) {
            try {
                this.setCleanAvailableConnectionsThreshold(Integer.parseInt(cleanAvailableConnectionsThresholdString));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (racEnabledString != null) {
            this.setRacEnabled(racEnabledString.equalsIgnoreCase("true"));
        }
        if (waitTimeoutString != null) {
            try {
                this.waitTimeout = Long.parseLong(waitTimeoutString);
            }
            catch (NumberFormatException e) {
                throw new InstantiationException("Bad format for wait-timeout attribute in data-source: " + waitTimeoutString);
            }
        }
        if (connectionAttemptsString != null) {
            try {
                this.maxConnectionAttempts = Integer.parseInt(connectionAttemptsString);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (connectionRetryInterval != null) {
            try {
                this.connectionRetryInterval = (int)Double.parseDouble(connectionRetryInterval);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        String portString = XMLUtils.getNodeAttribute(parent, "port");
        if (timeoutString != null) {
            try {
                this.maxInactivityTimeout = Integer.parseInt(timeoutString);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (portString != null) {
            try {
                this.port = Integer.parseInt(portString);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (loginTimeoutString != null) {
            try {
                this.loginTimeout = Integer.parseInt(loginTimeoutString);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (minConnectionsString != null) {
            try {
                this.minConnections = Integer.parseInt(minConnectionsString);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (maxConnectionsString != null) {
            try {
                this.maxConnections = Integer.parseInt(maxConnectionsString);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (stmtCacheSize != null) {
            try {
                this.stmtCacheSize = Integer.parseInt(stmtCacheSize);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        NodeList list = parent.getChildNodes();
        int length = list.getLength();
        for (int i = 0; i < length; ++i) {
            Node node = list.item(i);
            String name = node.getNodeName();
            if (name.equals("#text")) continue;
            if (name.equals("source-location")) {
                this.setSourceLocation(XMLUtils.getStringValue(node));
                continue;
            }
            if (name.equals("class-name")) {
                this.setClassName(XMLUtils.getStringValue(node));
                continue;
            }
            if (name.equals("description")) {
                this.setDescription(XMLUtils.getStringValue(node));
                continue;
            }
            if (name.equals("property")) {
                String propertyName = XMLUtils.getNodeAttribute(node, "name");
                String propertyValue = XMLUtils.getNodeAttribute(node, "value");
                if (propertyName == null) {
                    throw new InstantiationException("data-source tag with missing name attribute");
                }
                if (propertyValue == null) {
                    throw new InstantiationException("data-source tag with missing value attribute");
                }
                this.setProperty(propertyName, propertyValue);
                continue;
            }
            if (name.equals("connection-driver")) {
                this.setConnectionDriver(XMLUtils.getStringValue(node));
                continue;
            }
            if (name.equals("name")) {
                this.setDisplayName(XMLUtils.getStringValue(node));
                continue;
            }
            if (name.equals("username")) {
                this.setUsername(XMLUtils.getStringValue(node));
                continue;
            }
            if (name.equals("password")) {
                this.setPassword(XMLUtils.getStringValue(node));
                continue;
            }
            if (name.equals("url")) {
                this.setURL(XMLUtils.getStringValue(node));
                continue;
            }
            if (name.equals("inactivity-timeout")) {
                try {
                    this.setInactivityTimeout(Integer.parseInt(XMLUtils.getStringValue(node)));
                }
                catch (NumberFormatException e) {}
                continue;
            }
            if (name.equals("max-connections")) {
                try {
                    this.setMaxConnections(Integer.parseInt(XMLUtils.getStringValue(node)));
                }
                catch (NumberFormatException e) {}
                continue;
            }
            if (name.equals("stmt-cache-size")) {
                try {
                    this.setStmtCacheSize(Integer.parseInt(XMLUtils.getStringValue(node)));
                }
                catch (NumberFormatException e) {}
                continue;
            }
            if (name.equals("url")) {
                this.setURL(XMLUtils.getStringValue(node));
                continue;
            }
            if (!name.equals("default")) continue;
            this.setDefault(true);
        }
        if (this.className != null && this.className.equals("com.evermind.sql.ConnectionDataSource")) {
            this.className = "com.evermind.sql.DriverManagerDataSource";
        } else if (this.className != null && this.className.equals("com.evermind.sql.DefaultXADataSource")) {
            this.className = "com.evermind.sql.DriverManagerXADataSource";
        }
    }

    public int getCleanAvailableConnectionsThreshold() {
        return this.m_cleanAvailableConnectionsThreshold;
    }

    public void setCleanAvailableConnectionsThreshold(int cleanAvailableConnectionsThreshold) {
        this.m_cleanAvailableConnectionsThreshold = cleanAvailableConnectionsThreshold;
    }

    public boolean isRacEnabled() {
        return this.m_racEnabled;
    }

    public void setRacEnabled(boolean racEnabled) {
        this.m_racEnabled = racEnabled;
    }

    public long getTaskManagerInterval() {
        return this.taskManagerInterval;
    }

    public void setTaskManagerInterval(long _interval) {
        this.taskManagerInterval = _interval;
    }

    public String getLocation() {
        return this.getName();
    }

    public void setLocation(String location) {
        this.setName(location);
    }

    public String getConnectionDriver() {
        return this.connectionDriver;
    }

    public void setConnectionDriver(String connectionDriver) {
        this.connectionDriver = connectionDriver;
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String url) {
        this.url = url;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getXADataSourceClassName() {
        return this.xaDataSourceClassName;
    }

    public void setXADataSourceClassName(String xadatasourceLocation) {
        this.xaDataSourceClassName = xadatasourceLocation;
    }

    public String getRecoveryLocation() {
        return this.recoveryLocation;
    }

    public void setRecoveryLocation(String recoverylocation) {
        this.recoveryLocation = recoverylocation;
    }

    public String getSourceLocation() {
        return this.sourceLocation;
    }

    public void setSourceLocation(String sourceLocation) {
        this.sourceLocation = sourceLocation;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setDefault(boolean isDefault) {
        this.isDefault = isDefault;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getObfuscatedPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setMinConnections(int min) {
        this.minConnections = min;
    }

    public void setMaxConnections(int max) {
        this.maxConnections = max;
    }

    public void setStmtCacheSize(int size) {
        this.stmtCacheSize = size;
    }

    public void setInactivityTimeout(int seconds) {
        this.maxInactivityTimeout = seconds;
    }

    public int getMinConnections() {
        return this.minConnections;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public int getStmtCacheSize() {
        return this.stmtCacheSize;
    }

    public int getInactivityTimeout() {
        return this.maxInactivityTimeout;
    }

    public int getLoginTimeout() {
        return this.loginTimeout;
    }

    public void setLoginTimeout(int timeout) {
        this.loginTimeout = timeout;
    }

    public String getDatabaseSchemaPath() {
        return this.schemaPath;
    }

    public String getXALocation() {
        return this.xaLocation;
    }

    public String getPooledLocation() {
        return this.pooledLocation;
    }

    public String getEJBLocation() {
        return this.ejbLocation;
    }

    public boolean isImplicit() {
        return this.implicit;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public List getProperties() {
        return this.properties;
    }

    public void setProperty(String name, String value) {
        if (this.properties == null) {
            this.properties = new ArrayList();
        }
        try {
            this.properties.add(new PropertyConfig(name, value));
        }
        catch (DataSourceConfigException e) {
            String msg = "Error creating property configs for data source: " + this.getDisplayName() + ".  Exception: " + e;
        }
    }

    public void setXASourceLocation(String xaSourceLocation) {
        this.xaSourceLocation = xaSourceLocation;
    }

    public String getXASourceLocation() {
        return this.xaSourceLocation;
    }

    public int getMaxConnectionAttempts() {
        return this.maxConnectionAttempts;
    }

    public long getConnectionRetryInterval() {
        return this.connectionRetryInterval;
    }

    public void setMaxConnectionAttempts(int attempts) {
        this.maxConnectionAttempts = attempts;
    }

    public void setConnectionRetryInterval(long interval) {
        this.connectionRetryInterval = interval;
    }

    public void setXALocation(String location) {
        this.xaLocation = location;
    }

    public void setPooledLocation(String location) {
        this.pooledLocation = location;
    }

    public void setCMTLocation(String location) {
        this.ejbLocation = location;
    }

    public void setDriverClassName(String className) {
        this.connectionDriver = className;
    }

    public long getWaitTimeout() {
        return this.waitTimeout;
    }

    public void setWaitTimeout(long waitTimeout) {
        this.waitTimeout = waitTimeout;
    }
}

