/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.sql.config;

import oracle.oc4j.sql.config.ConfigObject;
import oracle.oc4j.sql.config.DataSourceConfigException;
import oracle.oc4j.sql.config.DataSourceConfigUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ProxyInterfaceConfig
extends ConfigObject {
    public static final String ROOT_NODE_NAME = "proxy-interface";
    public static final String SQL_OBJECT_ATTRIBUTE = "sql-object";
    public static final String INTERFACE_ATTRIBUTE = "interface";
    public static final String SQL_OBJECT_ATTRIBUTE_VALUE_ARRAY = "Array";
    public static final String SQL_OBJECT_ATTRIBUTE_VALUE_BLOB = "Blob";
    public static final String SQL_OBJECT_ATTRIBUTE_VALUE_CALLABLE_STATEMENT = "CallableStatement";
    public static final String SQL_OBJECT_ATTRIBUTE_VALUE_CLOB = "Clob";
    public static final String SQL_OBJECT_ATTRIBUTE_VALUE_CONNECTION = "Connection";
    public static final String SQL_OBJECT_ATTRIBUTE_VALUE_DATABASE_META_DATA = "DatabaseMetaData";
    public static final String SQL_OBJECT_ATTRIBUTE_VALUE_PARAMETER_META_DATA = "ParameterMetaData";
    public static final String SQL_OBJECT_ATTRIBUTE_VALUE_PREPARED_STATEMENT = "PreparedStatement";
    public static final String SQL_OBJECT_ATTRIBUTE_VALUE_REF = "Ref";
    public static final String SQL_OBJECT_ATTRIBUTE_VALUE_RESULT_SET = "ResultSet";
    public static final String SQL_OBJECT_ATTRIBUTE_VALUE_RESULT_SET_META_DATA = "ResultSetMetaData";
    public static final String SQL_OBJECT_ATTRIBUTE_VALUE_SAVEPOINT = "Savepoint";
    public static final String SQL_OBJECT_ATTRIBUTE_VALUE_SQL_DATA = "SQLData";
    public static final String SQL_OBJECT_ATTRIBUTE_VALUE_SQL_INPUT = "SQLInput";
    public static final String SQL_OBJECT_ATTRIBUTE_VALUE_SQL_OUTPUT = "SQLOutput";
    public static final String SQL_OBJECT_ATTRIBUTE_VALUE_STATEMENT = "Statement";
    public static final String SQL_OBJECT_ATTRIBUTE_VALUE_STRUCT = "Struct";
    private String m_sqlObject;
    private String m_interface;

    public ProxyInterfaceConfig(Node rootNode) throws DataSourceConfigException {
        super(rootNode);
        this.setSqlObject();
        this.setInterface();
    }

    public ProxyInterfaceConfig(String sqlObject, String anInterface) throws DataSourceConfigException {
        super(ROOT_NODE_NAME);
        this.setSqlObject(sqlObject);
        this.setInterface(anInterface);
    }

    public String getInterface() {
        return this.m_interface;
    }

    public void setInterface(String theInterface) throws DataSourceConfigException {
        this.m_interface = DataSourceConfigUtils.trimEmptyNotAllowed(theInterface, INTERFACE_ATTRIBUTE);
    }

    private void setInterface() throws DataSourceConfigException {
        this.setInterface(DataSourceConfigUtils.getAttribute(this.getRootNode(), INTERFACE_ATTRIBUTE));
    }

    public String getSqlObject() {
        return this.m_sqlObject;
    }

    public void setSqlObject(String sqlObject) throws DataSourceConfigException {
        if (!((sqlObject = DataSourceConfigUtils.trimEmptyNotAllowed(sqlObject, SQL_OBJECT_ATTRIBUTE)).equalsIgnoreCase(SQL_OBJECT_ATTRIBUTE_VALUE_ARRAY) || sqlObject.equalsIgnoreCase(SQL_OBJECT_ATTRIBUTE_VALUE_BLOB) || sqlObject.equalsIgnoreCase(SQL_OBJECT_ATTRIBUTE_VALUE_CALLABLE_STATEMENT) || sqlObject.equalsIgnoreCase(SQL_OBJECT_ATTRIBUTE_VALUE_CLOB) || sqlObject.equalsIgnoreCase(SQL_OBJECT_ATTRIBUTE_VALUE_CONNECTION) || sqlObject.equalsIgnoreCase(SQL_OBJECT_ATTRIBUTE_VALUE_DATABASE_META_DATA) || sqlObject.equalsIgnoreCase(SQL_OBJECT_ATTRIBUTE_VALUE_PARAMETER_META_DATA) || sqlObject.equalsIgnoreCase(SQL_OBJECT_ATTRIBUTE_VALUE_PREPARED_STATEMENT) || sqlObject.equalsIgnoreCase(SQL_OBJECT_ATTRIBUTE_VALUE_REF) || sqlObject.equalsIgnoreCase(SQL_OBJECT_ATTRIBUTE_VALUE_RESULT_SET) || sqlObject.equalsIgnoreCase(SQL_OBJECT_ATTRIBUTE_VALUE_RESULT_SET_META_DATA) || sqlObject.equalsIgnoreCase(SQL_OBJECT_ATTRIBUTE_VALUE_SAVEPOINT) || sqlObject.equalsIgnoreCase(SQL_OBJECT_ATTRIBUTE_VALUE_SQL_DATA) || sqlObject.equalsIgnoreCase(SQL_OBJECT_ATTRIBUTE_VALUE_SQL_INPUT) || sqlObject.equalsIgnoreCase(SQL_OBJECT_ATTRIBUTE_VALUE_SQL_OUTPUT) || sqlObject.equalsIgnoreCase(SQL_OBJECT_ATTRIBUTE_VALUE_STATEMENT) || sqlObject.equalsIgnoreCase(SQL_OBJECT_ATTRIBUTE_VALUE_STRUCT))) {
            throw new DataSourceConfigException("The sqlObject: " + sqlObject + " is invalid.");
        }
        this.m_sqlObject = sqlObject;
    }

    private void setSqlObject() throws DataSourceConfigException {
        this.setSqlObject(DataSourceConfigUtils.getAttribute(this.getRootNode(), SQL_OBJECT_ATTRIBUTE));
    }

    protected Node createXML(Document document) throws Exception {
        Element element = document.createElement(ROOT_NODE_NAME);
        element.setAttribute(SQL_OBJECT_ATTRIBUTE, this.getSqlObject());
        element.setAttribute(INTERFACE_ATTRIBUTE, this.getInterface());
        return element;
    }
}

