/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.sql.config;

import com.evermind.xml.XMLUtils;
import oracle.oc4j.sql.config.ConfigObject;
import oracle.oc4j.sql.config.DataSourceConfigException;
import oracle.oc4j.sql.config.DataSourceConfigUtils;
import org.w3c.dom.Node;

public abstract class DataSourceBaseConfig
extends ConfigObject {
    public static final int DEFAULT_LOGIN_TIMEOUT = 0;
    public static final String JNDI_NAME_ATTRIBUTE = "jndi-name";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String USER_ATTRIBUTE = "user";
    public static final String PASSWORD_ATTRIBUTE = "password";
    public static final String LOGIN_TIMEOUT_ATTRIBUTE = "login-timeout";
    private String m_jndiName = "";
    private String m_name = "";
    private String m_user = null;
    private String m_password = null;
    private int m_loginTimeout = 0;

    public DataSourceBaseConfig(Node rootNode) throws DataSourceConfigException {
        super(rootNode);
        if (DataSourceConfigUtils.usernameAttributeExists(rootNode)) {
            throw new DataSourceConfigException("The 'username' attribute is invalid...use 'user' instead.");
        }
        this.setUser();
        this.setPassword();
        this.setJndiName();
        this.setName();
        this.setLoginTimeout();
    }

    public DataSourceBaseConfig(String rootNodeName, String user, String password, String jndiName, String name, int loginTimeout) throws DataSourceConfigException {
        super(rootNodeName);
        this.setUser(user);
        this.setPassword(password);
        this.setJndiName(jndiName);
        this.setName(name);
        this.setLoginTimeout(loginTimeout);
    }

    public String getUser() {
        return this.m_user;
    }

    public void setUser(String user) {
        this.m_user = user;
    }

    private void setUser() {
        this.setUser(XMLUtils.getNodeAttribute(this.getRootNode(), USER_ATTRIBUTE));
    }

    public String getPassword() {
        return this.m_password;
    }

    public void setPassword(String password) {
        this.m_password = password;
    }

    private void setPassword() {
        this.setPassword(XMLUtils.getNodeAttribute(this.getRootNode(), PASSWORD_ATTRIBUTE));
    }

    public String getJndiName() {
        return this.m_jndiName;
    }

    public void setJndiName(String jndiName) throws DataSourceConfigException {
        this.m_jndiName = DataSourceConfigUtils.trimEmptyNotAllowed(jndiName, JNDI_NAME_ATTRIBUTE);
    }

    private void setJndiName() throws DataSourceConfigException {
        this.setJndiName(DataSourceConfigUtils.getAttribute(this.getRootNode(), JNDI_NAME_ATTRIBUTE));
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) throws DataSourceConfigException {
        this.m_name = DataSourceConfigUtils.trimEmptyNotAllowed(name, NAME_ATTRIBUTE);
    }

    private void setName() throws DataSourceConfigException {
        this.setName(DataSourceConfigUtils.getAttribute(this.getRootNode(), NAME_ATTRIBUTE));
    }

    public int getLoginTimeout() {
        return this.m_loginTimeout;
    }

    public void setLoginTimeout(int loginTimeout) {
        this.m_loginTimeout = loginTimeout;
    }

    private void setLoginTimeout() throws DataSourceConfigException {
        this.setLoginTimeout(DataSourceConfigUtils.getIntAttribute(this.getRootNode(), LOGIN_TIMEOUT_ATTRIBUTE, 0));
    }
}

