/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.security.acc;

import java.security.Permission;
import javax.security.jacc.EJBMethodPermission;
import javax.security.jacc.EJBRoleRefPermission;
import javax.security.jacc.WebResourcePermission;
import javax.security.jacc.WebRoleRefPermission;
import javax.security.jacc.WebUserDataPermission;

public class AtzContainerPermission {
    public static final boolean DEFAULT_JACC_OPTIMIZATION_STATE = false;
    public static final String HTTPS = "CONFIDENTIAL";
    public static final String HTTP = "NONE";
    private static boolean sm_jacc_optimization_state_on = false;
    private boolean m_isRoleType;
    private String[] m_resources;
    private String[] m_actions;
    private Boolean m_isSecureTransport;
    private String m_interface;
    private String[] m_arguments;
    private Permission m_jacc_permission;

    protected AtzContainerPermission() {
    }

    protected AtzContainerPermission(Permission jacc_permission) {
        this.m_jacc_permission = jacc_permission;
    }

    protected AtzContainerPermission(boolean isRoleType, String[] resources, String[] action, Boolean isSecureTransport, String interfaceName, String[] arguments) {
        this.m_isRoleType = isRoleType;
        this.m_resources = resources;
        this.m_actions = action;
        this.m_isSecureTransport = isSecureTransport;
        this.m_interface = interfaceName;
        this.m_arguments = arguments;
    }

    public static void setJaccOptimizationOn(boolean state) {
        sm_jacc_optimization_state_on = state;
    }

    public static boolean isJaccOptimizationOn() {
        return sm_jacc_optimization_state_on;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("(AtzContainerPermission ");
        if (null != this.getJaccPermission()) {
            buff.append(this.getJaccPermission());
        } else {
            buff.append("name:").append(this.toString(this.getResources(), ':')).append(' ');
            buff.append("actions:").append(this.toString(this.getActions(), ',')).append(' ');
            buff.append("isSecure:").append(this.getIsSecureTransport());
        }
        return buff.append(')').toString();
    }

    private String toString(String[] arr, char delim) {
        if (null == arr || arr.length <= 0) {
            return "";
        }
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < arr.length; ++i) {
            if (buff.length() > 0) {
                buff.append(delim);
            }
            buff.append(arr[i]);
        }
        return buff.toString();
    }

    public static AtzContainerPermission create(Permission permission) {
        return new AtzContainerPermission(permission);
    }

    public static AtzContainerPermission create(String resource, String action) {
        return new AtzContainerPermission(false, AtzContainerPermission.toArray(AtzContainerPermission.clean(resource)), AtzContainerPermission.toArray(action), null, null, null);
    }

    public static AtzContainerPermission create(String resource, String action, String interfaceName, String[] arguments) {
        return new AtzContainerPermission(false, AtzContainerPermission.toArray(AtzContainerPermission.clean(resource)), AtzContainerPermission.toArray(action), null, interfaceName, AtzContainerPermission.checkNull(arguments));
    }

    public static AtzContainerPermission create(String resource, String action, Boolean isSecureTransport) {
        return new AtzContainerPermission(false, AtzContainerPermission.toArray(AtzContainerPermission.clean(resource)), AtzContainerPermission.toArray(action), isSecureTransport, null, null);
    }

    public static AtzContainerPermission createRoleType(String resource, String role) {
        return new AtzContainerPermission(true, AtzContainerPermission.toArray(AtzContainerPermission.clean(resource)), AtzContainerPermission.toArray(role), null, null, null);
    }

    public static AtzContainerPermission createWebResourcePermission(String name, String actions) {
        if (AtzContainerPermission.isJaccOptimizationOn()) {
            return new AtzContainerPermission((Permission)new WebResourcePermission(AtzContainerPermission.clean(name), actions));
        }
        return AtzContainerPermission.create(name, actions);
    }

    public static AtzContainerPermission createWebResourcePermission(String urlPatternSpec, String[] httpMethods) {
        if (AtzContainerPermission.isJaccOptimizationOn()) {
            return new AtzContainerPermission((Permission)new WebResourcePermission(AtzContainerPermission.clean(urlPatternSpec), httpMethods));
        }
        return new AtzContainerPermission(false, AtzContainerPermission.toArray(AtzContainerPermission.clean(urlPatternSpec)), AtzContainerPermission.checkNull(httpMethods), null, null, null);
    }

    public static AtzContainerPermission createWebUserDataPermission(String name, String actions) {
        if (AtzContainerPermission.isJaccOptimizationOn()) {
            return new AtzContainerPermission((Permission)new WebUserDataPermission(AtzContainerPermission.clean(name), actions));
        }
        return AtzContainerPermission.create(name, actions, Boolean.FALSE);
    }

    public static AtzContainerPermission createWebUserDataPermission(String urlPatternSpec, String[] httpMethods, String transportType) {
        if (AtzContainerPermission.isJaccOptimizationOn()) {
            return new AtzContainerPermission((Permission)new WebUserDataPermission(AtzContainerPermission.clean(urlPatternSpec), httpMethods, transportType));
        }
        return new AtzContainerPermission(false, AtzContainerPermission.toArray(AtzContainerPermission.clean(urlPatternSpec)), AtzContainerPermission.checkNull(httpMethods), new Boolean(null != transportType && transportType.equalsIgnoreCase(HTTPS)), null, null);
    }

    public static AtzContainerPermission createWebRoleRefPermission(String name, String actions) {
        if (AtzContainerPermission.isJaccOptimizationOn()) {
            return new AtzContainerPermission((Permission)new WebRoleRefPermission(AtzContainerPermission.clean(name), actions));
        }
        return AtzContainerPermission.createRoleType(name, actions);
    }

    public static AtzContainerPermission createEJBMethodPermission(String name, String actions) {
        if (AtzContainerPermission.isJaccOptimizationOn()) {
            return new AtzContainerPermission((Permission)new EJBMethodPermission(name, actions));
        }
        return AtzContainerPermission.create(name, actions);
    }

    public static AtzContainerPermission createEJBMethodPermission(String ejbName, String methodName, String methodInterface, String[] arguments) {
        if (AtzContainerPermission.isJaccOptimizationOn()) {
            return new AtzContainerPermission((Permission)new EJBMethodPermission(ejbName, methodName, methodInterface, arguments));
        }
        return AtzContainerPermission.create(ejbName, methodName, methodInterface, arguments);
    }

    public static AtzContainerPermission createEJBRoleRefPermission(String name, String actions) {
        if (AtzContainerPermission.isJaccOptimizationOn()) {
            return new AtzContainerPermission((Permission)new EJBRoleRefPermission(name, actions));
        }
        return AtzContainerPermission.createRoleType(name, actions);
    }

    static String[] toArray(String val) {
        String[] stringArray;
        if (null == val) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = val;
        }
        return stringArray;
    }

    static String[] checkNull(String[] values) {
        return null == values || 0 == values.length ? null : values;
    }

    static String clean(String name) {
        if (null != name && (name.equals("/*") || name.equals("/*:"))) {
            return "/";
        }
        if (null != name) {
            return name.trim();
        }
        return name;
    }

    Permission getJaccPermission() {
        return this.m_jacc_permission;
    }

    public boolean isRoleType() {
        return this.m_isRoleType;
    }

    public String[] getResources() {
        return this.m_resources;
    }

    public String getFirstResource() {
        return null == this.m_resources || 0 == this.m_resources.length ? null : this.m_resources[0];
    }

    public String[] getActions() {
        return this.m_actions;
    }

    public String getFirstAction() {
        return null == this.m_actions || 0 == this.m_actions.length ? null : this.m_actions[0];
    }

    public Boolean getIsSecureTransport() {
        return this.m_isSecureTransport;
    }

    public String getInterface() {
        return this.m_interface;
    }

    public String[] getArguments() {
        return this.m_arguments;
    }
}

