/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.security;

import java.security.Permission;

public class DelegatingSecurityManager
extends SecurityManager {
    private SecurityManager m_underlying;
    private SecurityManager m_original;

    public DelegatingSecurityManager(SecurityManager underlying) {
        this.setUnderlying(underlying);
    }

    public SecurityManager getUnderlying() {
        return this.m_underlying;
    }

    public void setUnderlying(SecurityManager underlying) {
        if (underlying != this.m_underlying && this != underlying) {
            this.m_original = System.getSecurityManager();
            this.m_underlying = underlying;
        }
    }

    public void revertToOriginal() {
        this.m_underlying = this.m_original;
    }

    public Class[] getClassContext() {
        return super.getClassContext();
    }

    public void checkPermission(Permission perm) {
        if (null != this.m_underlying) {
            this.m_underlying.checkPermission(perm);
        }
    }

    public void checkPermission(Permission perm, Object context) {
        if (null != this.m_underlying) {
            this.m_underlying.checkPermission(perm, context);
        }
    }
}

