/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.rmi;

import com.evermind.io.ClassLoaderObjectInputStream;
import com.evermind.io.IOUtils;
import com.evermind.net.NetworkConnection;
import com.evermind.server.rmi.RMIConnection;
import com.evermind.server.rmi.RMIOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.rmi.OracleRemoteException;
import oracle.oc4j.rmi.RmiCommandSource;

public abstract class RmiTransport
implements RmiCommandSource {
    private static Logger m_logger = TraceLogger.getLogger(RmiTransport.class);
    protected NetworkConnection m_connection;
    private String m_disconnectMessage;
    private OutputStream m_outputStream;
    private InputStream m_inputStream;
    private ClassLoaderObjectInputStream in;
    private RMIOutputStream out;
    protected static final byte[] OBJECT_STREAM_HEADER = new byte[]{-84, -19, 0, 5};

    public RmiTransport() {
    }

    public RmiTransport(NetworkConnection connection) {
        this.m_connection = connection;
    }

    public synchronized boolean isConnected() {
        return this.m_connection != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void disconnect(String message) {
        if (!this.isConnected()) {
            return;
        }
        try {
            this.in = null;
            this.out = null;
            this.m_outputStream = null;
            this.m_inputStream = null;
            this.m_disconnectMessage = message == null ? "" : message;
            this.m_connection.close();
        }
        catch (IOException iOException) {
        }
        finally {
            this.m_connection = null;
        }
    }

    public synchronized void openConnection(NetworkConnection connection) throws IOException {
        this.m_connection = connection;
        this.m_disconnectMessage = null;
        this.in = null;
        this.out = null;
        this.m_outputStream = new BufferedOutputStream(this.m_connection.getOutputStream());
        this.m_inputStream = new BufferedInputStream(this.m_connection.getInputStream());
    }

    public InputStream getInputStream() {
        return this.m_inputStream;
    }

    public synchronized OutputStream getOutputStream() {
        return this.m_outputStream;
    }

    protected void createObjectInputStream(RMIConnection connection) throws IOException {
        this.in = this.doCreateInputStream(this.getInputStream(), connection);
    }

    public ClassLoaderObjectInputStream doCreateInputStream(final InputStream in, final RMIConnection connection) throws IOException {
        if (System.getSecurityManager() == null) {
            return this.createObjectInputStream(in, connection);
        }
        try {
            return (ClassLoaderObjectInputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return RmiTransport.this.createObjectInputStream(in, connection);
                }
            });
        }
        catch (PrivilegedActionException pe) {
            if (pe.getException() instanceof IOException) {
                throw (IOException)pe.getException();
            }
            throw new OracleRemoteException("Error creating stream", pe.getException());
        }
    }

    protected void createObjectOutputStream(RMIConnection connection) throws IOException {
        this.out = this.doCreateObjectOutputStream(this.getOutputStream(), connection);
    }

    protected RMIOutputStream doCreateObjectOutputStream(final OutputStream out, final RMIConnection connection) throws IOException {
        if (System.getSecurityManager() == null) {
            return this.createOutputStream(out, connection);
        }
        try {
            return (RMIOutputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return RmiTransport.this.createOutputStream(out, connection);
                }
            });
        }
        catch (PrivilegedActionException pe) {
            if (pe.getException() instanceof IOException) {
                throw (IOException)pe.getException();
            }
            throw new OracleRemoteException("Error creating stream", pe.getException());
        }
    }

    public ClassLoaderObjectInputStream getObjectInputStream() {
        return this.in;
    }

    public RMIOutputStream getObjectOutputStream() {
        return this.out;
    }

    public void annotateException(OracleRemoteException oracleRemoteException) {
        oracleRemoteException.receive(this.m_connection.getInetAddress());
    }

    public NetworkConnection getAddressContainer() {
        return this.m_connection;
    }

    public String getConnectionType() {
        return !this.isConnected() ? "Disconnected" : this.m_connection.getTypeDescription();
    }

    public void setDisconnectTimeout(int timeout) throws IOException {
        this.m_connection.setTimeout(timeout);
    }

    public String getDisconnectMessage() {
        return this.m_disconnectMessage;
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public boolean equalsClass(Object obj) {
        return obj.getClass().equals(this.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void closeDataStreams() {
        try {
            block9: {
                try {
                    if (this.out != null) {
                        this.out.close();
                    } else if (null != this.m_outputStream) {
                        this.m_outputStream.close();
                    }
                    if (this.in != null) {
                        this.in.close();
                        break block9;
                    }
                    if (null == this.m_inputStream) break block9;
                    this.m_inputStream.close();
                }
                catch (IOException e) {
                    if (m_logger.isLoggable(Level.FINER)) {
                        m_logger.log(Level.FINER, "IOException encountered: {0}", e.getMessage());
                    }
                    Object var3_2 = null;
                    this.out = null;
                    this.m_outputStream = null;
                    this.in = null;
                    this.m_inputStream = null;
                }
            }
            Object var3_1 = null;
            this.out = null;
            this.m_outputStream = null;
            this.in = null;
            this.m_inputStream = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.out = null;
            this.m_outputStream = null;
            this.in = null;
            this.m_inputStream = null;
            throw throwable;
        }
    }

    protected abstract ClassLoaderObjectInputStream createObjectInputStream(InputStream var1, RMIConnection var2) throws IOException;

    protected abstract RMIOutputStream createOutputStream(OutputStream var1, RMIConnection var2) throws IOException;

    public abstract MessageOut createDiscreteMessageOut(RMIConnection var1) throws IOException;

    public MessageOut createContinuousMessageOut(RMIConnection connection) throws IOException {
        return new ContinuousMessageOut(connection);
    }

    public RmiCommandSource.MessageIn createContinuousMessageIn(final RMIConnection connection) throws IOException {
        return new RmiCommandSource.MessageIn(){

            public ClassLoaderObjectInputStream getInputStream() throws IOException {
                if (RmiTransport.this.in == null) {
                    RmiTransport.this.createObjectInputStream(connection);
                }
                return RmiTransport.this.in;
            }
        };
    }

    public RmiCommandSource.MessageIn createDiscreteMessageIn(RMIConnection connection) throws IOException {
        return new DiscreteMessageIn(this.getInputStream(), connection);
    }

    protected void completeMessage() throws IOException {
        this.getObjectOutputStream().flush();
        this.getObjectOutputStream().reset();
    }

    protected RMIOutputStream getObjectOutputStreamUnconditionally(RMIConnection connection) throws IOException {
        RMIOutputStream out = this.getObjectOutputStream();
        if (out == null) {
            this.createObjectOutputStream(connection);
            out = this.getObjectOutputStream();
        }
        return out;
    }

    protected void sendConnectionStreamHeader() throws IOException {
        this.getOutputStream().write(OBJECT_STREAM_HEADER);
        this.getOutputStream().flush();
    }

    protected void readConnectionStreamHeader() throws IOException {
        for (int i = 0; i < OBJECT_STREAM_HEADER.length; ++i) {
            byte b = (byte)this.getInputStream().read();
            if (b == OBJECT_STREAM_HEADER[i]) continue;
            throw new IOException("Bad stream header");
        }
    }

    private class ContinuousMessageOut
    implements MessageOut {
        private RMIOutputStream _out;

        public ContinuousMessageOut(RMIConnection connection) throws IOException {
            this._out = RmiTransport.this.getObjectOutputStreamUnconditionally(connection);
        }

        public ObjectOutputStream getOutputStream() {
            return this._out;
        }

        public void send() throws IOException {
            RmiTransport.this.completeMessage();
        }
    }

    public static interface MessageOut {
        public ObjectOutputStream getOutputStream();

        public void send() throws IOException;
    }

    class DiscreteMessageIn
    implements RmiCommandSource.MessageIn {
        private ClassLoaderObjectInputStream m_messageStream;

        public DiscreteMessageIn(InputStream is, RMIConnection connection) throws IOException {
            int length = IOUtils.readCompressedInt(is);
            byte[] buffer = new byte[length];
            if (m_logger.isLoggable(Level.FINER)) {
                m_logger.log(Level.FINER, "Receiving message with " + length + " bytes");
            }
            while (length > 0) {
                int numRead = is.read(buffer, buffer.length - length, length);
                if (m_logger.isLoggable(Level.FINER)) {
                    m_logger.log(Level.FINER, "Received " + numRead + " bytes of message");
                }
                if (numRead < 0) {
                    throw new EOFException("Unable to read to the end of the message");
                }
                length -= numRead;
            }
            this.m_messageStream = RmiTransport.this.doCreateInputStream(new ByteArrayInputStream(buffer), connection);
        }

        public ClassLoaderObjectInputStream getInputStream() throws IOException {
            return this.m_messageStream;
        }
    }
}

