/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.peek;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import oracle.classloader.util.ArrayUtils;
import oracle.oc4j.peek.PageHandler;
import oracle.oc4j.peek.Peek;
import oracle.oc4j.peek.PeekHandler;

public class LogHandler
extends PageHandler {
    public String getURISuffix() {
        return "log";
    }

    public static String getLinkTo(String logFilePath) {
        return LogHandler.getLinkTo(logFilePath, null);
    }

    public static String getLinkTo(String logFilePath, String title) {
        if (logFilePath == null) {
            return "none";
        }
        StringBuffer buf = new StringBuffer(256);
        if (title != null) {
            buf.append("<a title=\"");
            buf.append(title);
            buf.append("\" href=\"");
        } else {
            buf.append("<a href=\"");
        }
        buf.append(Peek.getContextRoot());
        buf.append("log/");
        buf.append(logFilePath);
        buf.append("\">");
        buf.append(logFilePath);
        buf.append("</a>");
        return buf.toString();
    }

    protected void pageBody(String logPath, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PrintWriter out = response.getWriter();
        if (logPath != null) {
            if (logPath.equals("console")) {
                this.writeConsole(out);
            } else if (logPath.equals("unknown")) {
                ((Writer)out).write("Unknown log file.");
            } else {
                this.writeFile(out, logPath);
            }
        } else {
            PrintStream log = Peek.getAccessLog();
            if (log == null) {
                ((Writer)out).write("Access logging not enabled.");
            } else {
                log.flush();
                String logFilePath = PeekHandler.getLogFilePath();
                this.writeFile(out, logFilePath);
            }
        }
    }

    private void writeConsole(Writer out) throws Exception {
        out.write("Cannot find storage for console output.");
    }

    private void writeFile(Writer out, String path) throws Exception {
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        out.write("<h3>");
        out.write(path);
        out.write("</h3>");
        File file = new File(path);
        if (!file.exists()) {
            out.write("Not found.");
        } else if (file.length() == 0L) {
            out.write("&lt;empty&gt;");
        } else {
            FileInputStream in = new FileInputStream(path);
            byte[] bytes = ArrayUtils.read((InputStream)in);
            out.write("<pre>\n");
            out.write(new String(bytes));
            out.write("</pre>\n");
        }
    }
}

