/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.corba.iiop.security;

import com.evermind.server.ApplicationServer;
import com.evermind.server.auth.OC4JPrincipal;
import com.evermind.server.ejb.EJBObjectKey;
import com.evermind.server.ejb.deployment.BeanDescriptor;
import com.evermind.util.IIOPProperties;
import com.evermind.util.OrderedSet;
import com.oracle.corba.ee.impl.orb.ORBManagerImpl;
import com.sun.corba.ee.org.omg.CSIIOP.AS_ContextSec;
import com.sun.corba.ee.org.omg.CSIIOP.SAS_ContextSec;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.security.auth.Subject;
import javax.security.cert.X509Certificate;
import oracle.j2ee.corba.security.CSIV2Messages;
import oracle.oc4j.corba.deployment.EjbIORConfigurationDescriptor;
import oracle.oc4j.corba.iiop.CSIV2TaggedComponentInfo;
import oracle.oc4j.corba.iiop.security.AnonCredential;
import oracle.oc4j.corba.iiop.security.ClientSecurityMechanismSelector;
import oracle.oc4j.corba.iiop.security.ConnectionContext;
import oracle.oc4j.corba.iiop.security.ConnectionExecutionContext;
import oracle.oc4j.corba.iiop.security.GSSUPName;
import oracle.oc4j.corba.iiop.security.GSSUtils;
import oracle.oc4j.corba.iiop.security.InvalidIdentityTokenException;
import oracle.oc4j.corba.iiop.security.InvalidMechanismException;
import oracle.oc4j.corba.iiop.security.SecServerRequestInterceptor;
import oracle.oc4j.corba.iiop.security.SecurityContext;
import oracle.oc4j.corba.iiop.security.SecurityMechanismException;
import oracle.oc4j.corba.iiop.security.ServerConnectionContext;
import oracle.oc4j.corba.iiop.server.ComponentInvocation;
import oracle.oc4j.corba.security.auth.login.PasswordCredential;
import oracle.oc4j.corba.security.auth.login.X509CertificateCredential;
import oracle.oc4j.corba.transport.CorbaEJBHome;
import oracle.oc4j.corba.transport.EJBObjectID;
import oracle.oc4j.corba.transport.HomeLocator;
import oracle.oc4j.corba.util.LocalStringManagerImpl;
import oracle.oc4j.security.iiop.CSIv2Security;
import sun.security.x509.X500Name;

public class SecurityMechanismSelector
extends ClientSecurityMechanismSelector {
    public static final String SERVER_CONNECTION_CONTEXT = "ServerConnContext";
    public static final String SECURITY_REALM = "security.realm";
    private SecurityContext securityContext;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(SecServerRequestInterceptor.class);

    protected void init(boolean orbInitialized) {
        if (orbInitialized) {
            this.orb = ORBManagerImpl.getORBManager().getORBReference();
            this.ctc = new CSIV2TaggedComponentInfo(this.orb);
        }
    }

    public SecurityMechanismSelector() {
        this.init(true);
    }

    public SecurityMechanismSelector(boolean orbInitialized) {
        this.init(orbInitialized);
    }

    protected String getEjbSecPropertiesFileLocation() {
        String propsFileLoc = null;
        try {
            ApplicationServer appServer = ApplicationServer.getInstance();
            if (appServer != null && appServer.getConfig() != null && appServer.getConfig().getURL() != null) {
                propsFileLoc = new File(ApplicationServer.getInstance().getConfig().getURL().getFile()).getParentFile().getCanonicalPath() + File.separator + "ejb_sec.properties";
            }
        }
        catch (IOException e) {
            CSIV2Messages.warningMsg("Unable to get path to ejb sec properties file: " + e.toString());
        }
        return propsFileLoc;
    }

    public static ServerConnectionContext getServerConnectionContext() {
        Hashtable h = ConnectionExecutionContext.getContext();
        ServerConnectionContext scc = (ServerConnectionContext)h.get(SERVER_CONNECTION_CONTEXT);
        return scc;
    }

    public static void setServerConnectionContext(ServerConnectionContext scc) {
        Hashtable h = ConnectionExecutionContext.getContext();
        h.put(SERVER_CONNECTION_CONTEXT, scc);
    }

    public SecurityContext selectSecurityContext() throws InvalidIdentityTokenException, InvalidMechanismException, SecurityMechanismException {
        SecurityContext context = null;
        ConnectionContext cc = this.getClientConnectionContext();
        if (cc == null) {
            return null;
        }
        this.mech = cc.getMechanism();
        if (this.mech == null) {
            return null;
        }
        boolean sslUsed = cc.getSSLUsed();
        boolean clientAuthOccurred = cc.getSSLClientAuthenticationOccurred();
        boolean inServer = this.isServerInvocation();
        CSIV2Messages.finestMsg("SSL used:" + sslUsed + " SSL Mutual auth:" + clientAuthOccurred);
        context = !inServer ? this.getSecurityContextForAppClient(null, sslUsed, clientAuthOccurred) : this.getSecurityContextForWebOrEJB(null, sslUsed, clientAuthOccurred);
        return context;
    }

    protected boolean isServerInvocation() {
        return true;
    }

    public SecurityContext getSecurityContextForWebOrEJB(ComponentInvocation ci, boolean sslUsed, boolean clientAuthOccurred) throws InvalidMechanismException, InvalidIdentityTokenException, SecurityMechanismException {
        SecurityContext ctx = null;
        boolean plainIIOP = true;
        if (!sslUsed) {
            ctx = this.propagateIdentity(plainIIOP, false, ci);
        } else {
            plainIIOP = false;
            ctx = this.propagateIdentity(plainIIOP, clientAuthOccurred, ci);
        }
        return ctx;
    }

    private boolean isMechanismSupported(SAS_ContextSec sas) {
        byte[][] mechanisms = sas.supported_naming_mechanisms;
        byte[] mechSupported = new byte[]{};
        try {
            mechSupported = GSSUtils.getDER(GSSUtils.GSSUP_MECH_OID);
        }
        catch (Exception e) {
            return false;
        }
        if (mechanisms[0].length != mechSupported.length) {
            return false;
        }
        for (int i = 0; i < mechanisms[0].length; ++i) {
            if (mechanisms[0][i] == mechSupported[i]) continue;
            return false;
        }
        return true;
    }

    public boolean isIdentityTypeSupported(SAS_ContextSec sas) {
        int ident_token = sas.supported_identity_types;
        int value = ident_token & 0xF;
        return value != 0;
    }

    protected SecurityContext getUsernameAndPassword(ComponentInvocation ci) {
        if (this.securityContext == null) {
            SecurityContext ctx = null;
            try {
                final Subject s = this.getSubjectFromSecurityCurrent();
                ctx = new SecurityContext();
                ctx.subject = s;
                Set privateCredSet = (Set)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return s.getPrivateCredentials();
                    }
                });
                if (privateCredSet.isEmpty()) {
                    CSIV2Messages.finestMsg("no private credentials - either Anonymous or Run as mode");
                    ctx.authcls = null;
                    ctx.identcls = GSSUPName.class;
                } else {
                    ctx.authcls = PasswordCredential.class;
                }
            }
            catch (Exception e) {
                CSIV2Messages.finerThrowableMsg("Error during security context creation: ", e);
            }
            this.securityContext = ctx;
        }
        return this.securityContext;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SecurityContext propagateIdentity(boolean plainIIOP, boolean clientAuth, ComponentInvocation ci) throws InvalidIdentityTokenException, InvalidMechanismException, SecurityMechanismException {
        SecurityContext ctx = null;
        if (this.mech == null) {
            return null;
        }
        AS_ContextSec asContext = this.mech.as_context_mech;
        SAS_ContextSec sasContext = this.mech.sas_context_mech;
        CSIV2Messages.finestMsg("SAS CONTEXT's target_requires=" + sasContext.target_requires);
        CSIV2Messages.finestMsg("SAS CONTEXT's target_supports=" + sasContext.target_supports);
        if (this.isSet(asContext.target_requires, 64)) {
            ctx = this.setUsernameAndPassword(plainIIOP, ci);
            if (ctx.authcls != null) return ctx;
            String errmsg = localStrings.getLocalString("securitymechansimselector.runas_cannot_propagate_username_password", "Cannot propagate username/password required by target when using run as identity");
            CSIV2Messages.warningMsg(errmsg);
            throw new SecurityMechanismException(errmsg);
        }
        if (this.isSet(sasContext.target_supports, 1024) || this.isSet(sasContext.target_requires, 1024)) {
            if (!this.isIdentityTypeSupported(sasContext)) {
                String errmsg = localStrings.getLocalString("securitymechanismselector.invalid_identity_type", "The given identity token is unsupported.");
                throw new InvalidIdentityTokenException(errmsg);
            }
            if (sasContext.target_supports != 1024) return this.getIdentity();
            if (this.isMechanismSupported(sasContext)) return this.getIdentity();
            String errmsg = localStrings.getLocalString("securitymechanismselector.invalid_mechanism", "The given mechanism type is unsupported.");
            CSIV2Messages.warningMsg(errmsg);
            throw new InvalidMechanismException(errmsg);
        }
        if (!this.isSet(asContext.target_supports, 64)) return null;
        if (!clientAuth) return null;
        ctx = this.setUsernameAndPassword(plainIIOP, ci);
        if (ctx.authcls != null) return ctx;
        return null;
    }

    private SecurityContext getIdentity() {
        Subject s;
        CSIV2Messages.finestMsg("Getting PRINCIPAL/DN from TLS");
        SecurityContext ctx = new SecurityContext();
        ctx.subject = s = this.getSubjectFromSecurityCurrent();
        final Subject sub = s;
        Set<Object> credSet = (Set<Object>)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return sub.getPrivateCredentials(class$oracle$oc4j$corba$security$auth$login$PasswordCredential == null ? (class$oracle$oc4j$corba$security$auth$login$PasswordCredential = SecurityMechanismSelector.class$("oracle.oc4j.corba.security.auth.login.PasswordCredential")) : class$oracle$oc4j$corba$security$auth$login$PasswordCredential);
            }
        });
        if (credSet.size() == 1) {
            Subject subj;
            ctx.identcls = GSSUPName.class;
            final Set<Object> cs = credSet;
            ctx.subject = subj = (Subject)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Subject ss = new Subject();
                    Iterator iter = cs.iterator();
                    PasswordCredential pc = (PasswordCredential)iter.next();
                    GSSUPName gssname = new GSSUPName(pc.getUser(), pc.getRealm());
                    ss.getPublicCredentials().add(gssname);
                    return ss;
                }
            });
            return ctx;
        }
        credSet = s.getPublicCredentials();
        if (credSet.size() != 1) {
            CSIV2Messages.finestMsg("Principal propagation: Cannot find principal information in subject");
            return null;
        }
        Iterator<Object> credIter = credSet.iterator();
        if (credIter.hasNext()) {
            Object o = credIter.next();
            ctx.identcls = o instanceof GSSUPName ? GSSUPName.class : (o instanceof X500Name ? X500Name.class : (o instanceof AnonCredential ? AnonCredential.class : X509CertificateCredential.class));
        } else {
            System.err.println("Principal propagation: Cannot find credential information in subject. ");
            return null;
        }
        return ctx;
    }

    protected Subject getSubjectFromSecurityCurrent() {
        Subject threadStateSubject = this.getCurrentSubjectFromThreadState();
        if (SecurityMechanismSelector.subjectContains(threadStateSubject, "Anonymous")) {
            if (this.isJndiCredentialAvailable()) {
                return this.getJndiSubject();
            }
        } else {
            if (SecurityMechanismSelector.subjectContainsAuthenticatedUser(threadStateSubject)) {
                if (this.isJndiCredentialAvailable()) {
                    return this.getJndiSubject();
                }
                return threadStateSubject;
            }
            if (SecurityMechanismSelector.subjectContainsRunAsUser(threadStateSubject) && this.isJndiCredentialAvailable()) {
                return this.addSubjectToJndiSubject(threadStateSubject);
            }
        }
        return threadStateSubject;
    }

    protected Subject getCurrentSubjectFromThreadState() {
        return CSIv2Security.getCsiSubject();
    }

    private static boolean subjectContainsRunAsUser(Subject threadStateSubject) {
        return !SecurityMechanismSelector.subjectContains(threadStateSubject, "Anonymous") && threadStateSubject.getPrivateCredentials().isEmpty();
    }

    private static boolean subjectContainsAuthenticatedUser(Subject subject) {
        return !subject.getPrivateCredentials().isEmpty();
    }

    private static boolean subjectContains(Subject threadStateSubject, String userName) {
        Iterator<Principal> itar = threadStateSubject.getPrincipals().iterator();
        while (itar.hasNext()) {
            Principal p = itar.next();
            if (!p.getName().equalsIgnoreCase(userName)) continue;
            return true;
        }
        return false;
    }

    Subject addSubjectToJndiSubject(final Subject sub) {
        if (sub == null) {
            CSIV2Messages.warningMsg("ThreadState returned a null subject");
        }
        String userName = SecurityMechanismSelector.getUserPassTuple().getUserName();
        String password = new String(SecurityMechanismSelector.getUserPassTuple().getPassword());
        if (userName != null) {
            sub.getPrincipals().add(new OC4JPrincipal(userName));
        }
        if (password != null) {
            Set credSet = (Set)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return sub.getPrivateCredentials();
                }
            });
            credSet.add(new PasswordCredential(userName, password, IIOPProperties.getSecurityRealm()));
        }
        return sub;
    }

    private byte[] getTargetName(Subject subj) {
        byte[] tgt_name = new byte[]{};
        final Subject sub = subj;
        final Set credset = (Set)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return sub.getPrivateCredentials(class$oracle$oc4j$corba$security$auth$login$PasswordCredential == null ? (class$oracle$oc4j$corba$security$auth$login$PasswordCredential = SecurityMechanismSelector.class$("oracle.oc4j.corba.security.auth.login.PasswordCredential")) : class$oracle$oc4j$corba$security$auth$login$PasswordCredential);
            }
        });
        if (credset.size() == 1) {
            tgt_name = (byte[])AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Iterator iter = credset.iterator();
                    PasswordCredential pc = (PasswordCredential)iter.next();
                    return pc.getTargetName();
                }
            });
        }
        return tgt_name;
    }

    private boolean evaluate_client_conformance_ssl(EjbIORConfigurationDescriptor iordesc, boolean ssl_used, X509Certificate[] certchain) {
        boolean ssl_required = false;
        boolean ssl_supported = false;
        int ssl_target_requires = 0;
        int ssl_target_supports = 0;
        ssl_target_requires = ((CSIV2TaggedComponentInfo)this.ctc).getTargetRequires(iordesc);
        ssl_target_supports = ((CSIV2TaggedComponentInfo)this.ctc).getTargetSupports(iordesc);
        ssl_required = this.isSet(ssl_target_requires, 2) || this.isSet(ssl_target_requires, 4) || this.isSet(ssl_target_requires, 64);
        ssl_supported = ssl_target_supports != 0;
        if (ssl_used ? !ssl_required && !ssl_supported : ssl_required) {
            return false;
        }
        return !(certchain != null ? !this.isSet(ssl_target_requires, 64) && !this.isSet(ssl_target_supports, 64) : this.isSet(ssl_target_requires, 64));
    }

    private boolean evaluate_client_conformance_ascontext(SecurityContext ctx, EjbIORConfigurationDescriptor iordesc) {
        boolean client_authenticated = false;
        AS_ContextSec ascontext = null;
        try {
            ascontext = ((CSIV2TaggedComponentInfo)this.ctc).createASContextSec(iordesc);
        }
        catch (Exception e) {
            CSIV2Messages.finerThrowableNoMsg(e);
            return false;
        }
        if (ascontext == null) {
            return false;
        }
        client_authenticated = ctx != null && ctx.authcls != null && ctx.subject != null;
        if (client_authenticated) {
            if (!this.isSet(ascontext.target_requires, 64) && !this.isSet(ascontext.target_supports, 64)) {
                return false;
            }
            byte[] client_tgtname = this.getTargetName(ctx.subject);
            if (ascontext.target_name.length != client_tgtname.length) {
                return false;
            }
            for (int i = 0; i < ascontext.target_name.length; ++i) {
                if (ascontext.target_name[i] == client_tgtname[i]) continue;
                return false;
            }
        } else if (this.isSet(ascontext.target_requires, 64)) {
            return false;
        }
        return true;
    }

    private boolean evaluate_client_conformance_sascontext(SecurityContext ctx, EjbIORConfigurationDescriptor iordesc) {
        boolean caller_propagated = false;
        SAS_ContextSec sascontext = null;
        try {
            sascontext = ((CSIV2TaggedComponentInfo)this.ctc).createSASContextSec(iordesc);
        }
        catch (Exception e) {
            CSIV2Messages.finerThrowableNoMsg(e);
            return false;
        }
        if (sascontext == null) {
            return false;
        }
        caller_propagated = ctx != null && ctx.identcls != null && ctx.subject != null;
        if (caller_propagated) {
            return this.isSet(sascontext.target_supports, 1024);
        }
        return true;
    }

    private boolean evaluate_client_conformance(SecurityContext ctx, byte[] object_id, boolean ssl_used, X509Certificate[] certchain) {
        if (object_id == null) {
            return true;
        }
        Set iorDescSet = this.getIORConfigurationDescriptors(object_id);
        if (iorDescSet.isEmpty()) {
            return true;
        }
        Iterator itr = iorDescSet.iterator();
        while (itr.hasNext()) {
            EjbIORConfigurationDescriptor iorDesc = (EjbIORConfigurationDescriptor)itr.next();
            if (!this.evaluate_client_conformance_ssl(iorDesc, ssl_used, certchain) || !this.evaluate_client_conformance_ascontext(ctx, iorDesc) || !this.evaluate_client_conformance_sascontext(ctx, iorDesc)) continue;
            return true;
        }
        return false;
    }

    private Set getIORConfigurationDescriptors(byte[] object_id) {
        EJBObjectID objectID = null;
        CorbaEJBHome home = null;
        BeanDescriptor descriptor = null;
        try {
            if (EJBObjectID.hasEJBObjectID(object_id)) {
                objectID = (EJBObjectID)EJBObjectID.extract(object_id, Thread.currentThread().getContextClassLoader());
                home = HomeLocator.getHome(objectID);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        if (home != null) {
            descriptor = ((EJBObjectKey)((Object)home)).getBeanDescriptor();
        }
        return descriptor != null ? descriptor.getIORConfigurationDescriptors() : new OrderedSet();
    }

    public SecurityContext evaluateTrust(SecurityContext ctx, byte[] object_id) throws SecurityMechanismException {
        SecurityContext ssc = null;
        Socket socket = null;
        boolean ssl_used = false;
        X509Certificate[] certChain = null;
        ServerConnectionContext scc = SecurityMechanismSelector.getServerConnectionContext();
        if (scc != null) {
            socket = scc.getSocket();
            if (socket != null && socket instanceof SSLSocket) {
                ssl_used = true;
                SSLSocket sslSock = (SSLSocket)socket;
                CSIV2Messages.finestMsg("socket = " + sslSock);
                SSLSession sslSession = sslSock.getSession();
                try {
                    certChain = sslSession.getPeerCertificateChain();
                    if (CSIV2Messages.isLoggable(Level.FINEST)) {
                        CSIV2Messages.finestMsg("Negotiated cipher suite: " + sslSession.getCipherSuite());
                        CSIV2Messages.finestMsg("Peer cert chain length : " + certChain.length);
                        for (int i = 0; i < certChain.length; ++i) {
                            CSIV2Messages.finestMsg("Peer cert chain length : " + certChain[i]);
                        }
                    }
                }
                catch (Exception e) {
                    CSIV2Messages.finerThrowableNoMsg(e);
                }
            }
            try {
                boolean trusted = false;
                if (ctx != null && ctx.identcls != null) {
                    InetAddress clientAddr = socket.getInetAddress();
                    String tc = ORBManagerImpl.getORBManager().getORBConfig().getORBProperties().getProperty("com.oracle.corba.ee.security.trusted.clients");
                    if (tc != null && !tc.trim().equals("")) {
                        String[] trustedClients = SecurityMechanismSelector.stringToArray(tc, ",");
                        for (int i = 0; i < trustedClients.length; ++i) {
                            if (trustedClients[i].length() != 1 || !trustedClients[i].equals("*")) continue;
                            trusted = true;
                        }
                        if (!trusted && !this.isDomainInTrustedList(clientAddr, trustedClients)) {
                            String msg = "client " + clientAddr + " is not allowed to insert an identity assertion";
                            CSIV2Messages.finestMsg(msg);
                            throw new SecurityMechanismException(msg);
                        }
                    }
                }
            }
            catch (Exception e) {
                CSIV2Messages.finerThrowableNoMsg(e);
                throw new SecurityMechanismException(e.getMessage());
            }
        }
        if (socket == null && ctx == null) {
            return null;
        }
        if (!this.evaluate_client_conformance(ctx, object_id, ssl_used, certChain)) {
            String msg = "Trust evaluation failed because ";
            msg = msg + "client does not conform to configured security policies";
            throw new SecurityMechanismException(msg);
        }
        if (ctx == null) {
            if (socket == null || !ssl_used || certChain == null) {
                return null;
            }
            ssc = new SecurityContext();
            X500Name x500Name = (X500Name)certChain[0].getSubjectDN();
            ssc.subject = new Subject();
            ssc.subject.getPublicCredentials().add(x500Name);
            ssc.identcls = X500Name.class;
            ssc.authcls = null;
            return ssc;
        }
        ssc = ctx;
        Class authCls = ctx.authcls;
        Class identCls = ctx.identcls;
        ssc.subject = ctx.subject;
        ssc.authcls = null;
        ssc.identcls = null;
        if (identCls != null) {
            ssc.identcls = identCls;
        } else if (authCls != null) {
            ssc.authcls = authCls;
        } else {
            ssc.identcls = AnonCredential.class;
        }
        return ssc;
    }
}

