/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.corba.iiop;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.oc4j.corba.iiop.ClientConnectionInterceptor;
import oracle.oc4j.corba.iiop.security.ClientCsiv2Manager;
import oracle.oc4j.corba.iiop.security.ClientSecurityServiceImpl;
import oracle.oc4j.corba.iiop.security.SecClientRequestInterceptor;
import org.omg.CORBA.LocalObject;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecFactory;
import org.omg.IOP.CodecFactoryPackage.UnknownEncoding;
import org.omg.IOP.Encoding;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitInfoPackage.DuplicateName;
import org.omg.PortableInterceptor.ORBInitializer;

public class IIOPClientInitializer
extends LocalObject
implements ORBInitializer {
    private Logger m_logger = Logger.getLogger("oc4j.orb.logger");

    public void pre_init(ORBInitInfo info) {
    }

    public void post_init(ORBInitInfo info) {
        Codec codec = null;
        codec = this.getCodec(info);
        try {
            this.registerCSIv2Interceptors(info, codec);
        }
        catch (Exception e) {
            if (this.m_logger.isLoggable(Level.FINE)) {
                this.m_logger.log(Level.FINE, "Exception registering JTS interceptors", e);
            }
            throw new RuntimeException(e.getMessage());
        }
    }

    private void registerCSIv2Interceptors(ORBInitInfo info, Codec codec) throws DuplicateName {
        SecClientRequestInterceptor creq;
        ClientConnectionInterceptor cci = new ClientConnectionInterceptor("ClientConnInterceptor", 1);
        info.add_client_request_interceptor((ClientRequestInterceptor)cci);
        String clientSecInterceptor = System.getProperty("interop.secinterceptor.client");
        if (clientSecInterceptor == null) {
            creq = new SecClientRequestInterceptor("SecClientRequestInterceptor", codec);
        } else {
            try {
                creq = (ClientRequestInterceptor)this.createInterceptorFromProperty("SecClientRequestInterceptor", clientSecInterceptor, codec);
            }
            catch (Exception e) {
                if (this.m_logger.isLoggable(Level.FINE)) {
                    this.m_logger.log(Level.FINE, "Exception registering security client request interceptor", e);
                    this.m_logger.log(Level.FINE, "Going to register default security client request interceptor");
                }
                creq = new SecClientRequestInterceptor("SecClientRequestInterceptor", codec);
            }
        }
        info.add_client_request_interceptor((ClientRequestInterceptor)creq);
        ClientSecurityServiceImpl ss = new ClientSecurityServiceImpl();
        ClientCsiv2Manager.setClientSecurityService(ss);
    }

    private Object createInterceptorFromProperty(String name, String clientSecInterceptor, Codec codec) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class<?> cInterceptorClass = Class.forName(clientSecInterceptor);
        Class[] paramTypes = new Class[]{String.class, Codec.class};
        Object[] params = new Object[]{name, codec};
        Constructor<?> constructor = cInterceptorClass.getConstructor(paramTypes);
        Object interceptor = constructor.newInstance(params);
        return interceptor;
    }

    private Codec getCodec(ORBInitInfo info) {
        Codec codec;
        CodecFactory cf = info.codec_factory();
        byte major_version = 1;
        byte minor_version = 2;
        Encoding encoding = new Encoding(0, major_version, minor_version);
        try {
            codec = cf.create_codec(encoding);
        }
        catch (UnknownEncoding unknownEncoding) {
            if (this.m_logger.isLoggable(Level.FINE)) {
                this.m_logger.log(Level.FINE, "Exception otaining codec", unknownEncoding);
            }
            throw new RuntimeException(unknownEncoding.getMessage());
        }
        return codec;
    }
}

