/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.management.mbeans;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import oracle.oc4j.admin.management.callbackinterfaces.ThreadPoolCallBackIf;
import oracle.oc4j.admin.management.mbeans.J2EEServerDependentObjectBase;
import oracle.oc4j.admin.management.mbeans.ThreadPoolMBean;

public class ThreadPool
extends J2EEServerDependentObjectBase
implements ThreadPoolMBean {
    private String name_ = null;
    private ThreadPoolCallBackIf callback_ = null;

    public ThreadPool(ThreadPoolCallBackIf callback, String domain, String threadPoolName, String j2eeSeverName) {
        super(domain, j2eeSeverName);
        this.callback_ = callback;
        this.name_ = threadPoolName;
        this.setBaseObjectName(":j2eeType=ThreadPool,name=" + this.name_ + ",J2EEServer=" + j2eeSeverName);
        this.init();
    }

    public ThreadPool(ThreadPoolCallBackIf callback, String threadPoolName) {
        this.callback_ = callback;
        this.name_ = threadPoolName;
        this.setBaseObjectName(":j2eeType=ThreadPool,name=" + this.name_ + ",J2EEServer=" + this.getJ2eeServerName());
        this.init();
    }

    public ThreadPool(Locale loc) {
        super(loc);
        this.init();
    }

    private void init() {
        HashMap<String, String> persistenceDescriptorProperties = new HashMap<String, String>();
        persistenceDescriptorProperties.put("persistPolicy", "OnUpdate");
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("minPoolSize", "int", this.getLocalizedMessage("threadpool_MinPoolSize"), true, true, false), persistenceDescriptorProperties);
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("maxPoolSize", "int", this.getLocalizedMessage("threadpool_MaxPoolSize"), true, true, false), persistenceDescriptorProperties);
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("poolSize", "long", this.getLocalizedMessage("threadpool_PoolSize"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("keepAliveTime", "long", this.getLocalizedMessage("threadpool_KeepAliveTime"), true, true, false), persistenceDescriptorProperties);
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("queueSize", "int", this.getLocalizedMessage("threadpool_QueueSize"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("debug", "boolean", this.getLocalizedMessage("threadpool_Debug"), true, true, false), persistenceDescriptorProperties);
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("queueCapacity", "int", this.getLocalizedMessage("threadpool_QueueCapacity"), true, true, false), persistenceDescriptorProperties);
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("executingThreadNames", "[Ljava.lang.String;", this.getLocalizedMessage("threadpool_ExecutingThreadNames"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("executingUsers", "java.util.Set", this.getLocalizedMessage("threadpool_executingUsers"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("applicationsInUse", "java.util.Map", this.getLocalizedMessage("threadpool_ApplicationsInUse"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("name", "java.lang.String", this.getLocalizedMessage("threadpool_Name"), true, false, false));
    }

    public String getDescription() {
        return this.getLocalizedMessage("threadpool_description");
    }

    public int getminPoolSize() {
        return this.callback_.getMinPoolSize();
    }

    public int getmaxPoolSize() {
        return this.callback_.getMaxPoolSize();
    }

    public void setminPoolSize(int size) {
        this.callback_.setMinPoolSizeFromMBean(size);
    }

    public void setmaxPoolSize(int size) {
        this.callback_.setMaxPoolSizeFromMBean(size);
    }

    public int getpoolSize() {
        return this.callback_.getPoolSize();
    }

    private void persistConfigChange() {
        this.callback_.persistConfigChange();
    }

    public long getkeepAliveTime() {
        return this.callback_.getKeepAliveTime();
    }

    public void setkeepAliveTime(long timeInMs) {
        this.callback_.setKeepAliveTimeFromMBean(timeInMs);
    }

    public int getqueueSize() {
        return this.callback_.getQueueSize();
    }

    public int getqueueCapacity() {
        return this.callback_.getQueueCapacity();
    }

    public void setqueueCapacity(int queueCapacity) {
        this.callback_.setQueueCapacityFromMBean(queueCapacity);
    }

    public boolean getdebug() {
        return this.callback_.isDebug();
    }

    public String getname() {
        return this.callback_.getName();
    }

    public void setdebug(boolean debug) {
        this.callback_.setDebugFromMBean(debug);
    }

    public String[] getexecutingThreadNames() {
        return this.callback_.getExecutingThreadNames();
    }

    public Set getexecutingUsers() {
        return this.callback_.getConnectedUsers();
    }

    public Map getapplicationsInUse() {
        return this.callback_.getApplicationsInUse();
    }

    public final void store() throws MBeanException, RuntimeOperationsException, InstanceNotFoundException {
        this.callback_.persistConfigChange();
    }
}

