/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.management.mbeans;

import com.evermind.server.jms.JMSUtils;
import java.net.InetAddress;
import java.util.Locale;
import javax.management.j2ee.statistics.Stats;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import oracle.oc4j.admin.jmx.shared.util.ObjectNameUtil;
import oracle.oc4j.admin.management.callbackinterfaces.JMSCallBackIf;
import oracle.oc4j.admin.management.mbeans.J2EEManagedObjectBase;
import oracle.oc4j.admin.management.mbeans.J2EEServerDependentObjectBase;
import oracle.oc4j.admin.management.mbeans.JMSMBean;
import oracle.oc4j.admin.management.shared.statistic.JMSStatsImpl;

public class JMS
extends J2EEServerDependentObjectBase
implements JMSMBean {
    private JMSCallBackIf m_callback;
    private long m_startTime;
    private long m_tmInterval;
    private InetAddress m_addr;
    private int m_port;

    public JMS(JMSCallBackIf callback) {
        this.m_callback = callback;
        this.setBaseObjectName(":j2eeType=JMSResource,name=" + ObjectNameUtil.quote((String)"JMS") + ",J2EEServer=" + "standalone");
        this.init();
    }

    public JMS(Locale loc) {
        super(loc);
        this.init();
    }

    private void init() {
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("stats", "javax.management.j2ee.statistics.Stats", this.getLocalizedMessage("jms_stats"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("startTime", "long", this.getLocalizedMessage("jms_starttime"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("taskManagerInterval", "long", this.getLocalizedMessage("jms_taskmanagerinterval"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("address", "java.net.InetAddress", this.getLocalizedMessage("jms_address"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("host", "java.net.InetAddress", this.getLocalizedMessage("jms_host"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("port", "int", this.getLocalizedMessage("jms_port"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("connections", "int", this.getLocalizedMessage("jms_connections"), true, false, false));
    }

    public final boolean getstatisticsProvider() {
        return true;
    }

    public Stats getstats() {
        return new JMSStatsImpl(J2EEManagedObjectBase.getLocaleForCall(), this.m_callback.getMetricPath(), (JMSStatsImpl)this.m_callback.getJSR77Stats());
    }

    public void setstartTime(long time) {
        this.m_startTime = time;
    }

    public long getstartTime() {
        return this.m_startTime;
    }

    public void settaskManagerInterval(long interval) {
        this.m_tmInterval = interval;
    }

    public long gettaskManagerInterval() {
        return this.m_tmInterval;
    }

    public void setaddress(InetAddress addr) {
        this.m_addr = addr;
    }

    public InetAddress getaddress() {
        return this.m_addr;
    }

    public InetAddress gethost() {
        return JMSUtils.normalize(this.m_addr);
    }

    public void setport(int port) {
        this.m_port = port;
    }

    public int getport() {
        return this.m_port;
    }

    public int getconnections() {
        return this.m_callback.getNumConnections();
    }
}

