/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.management.mbeans;

import java.util.Locale;
import java.util.logging.Logger;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXException;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXRuntimeException;
import oracle.oc4j.admin.management.callbackinterfaces.J2EEApplicationCallBackIf;
import oracle.oc4j.admin.management.mbeans.JDBCBase;
import oracle.oc4j.admin.management.mbeans.JDBCResourceMBean;

public abstract class JDBCResource
extends JDBCBase
implements JDBCResourceMBean {
    private static Logger m_logger = Logger.getLogger(JDBCResource.class.getName());

    public JDBCResource(String name, J2EEApplicationCallBackIf applicationCallBack) {
        super(name, applicationCallBack);
        this.init();
    }

    protected JDBCResource(Locale locale) {
        super(locale);
        this.init();
    }

    private void init() {
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("jdbcDataSources", "[Ljava.lang.String;", this.getLocalizedMessage("jdbcresource_jdbcDataSources"), true, false, false), NEVER_PERSISTENCE_PROPERTIES);
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("displayName", "java.lang.String", this.getLocalizedMessage("jdbcresource_DisplayName"), true, false, false), NEVER_PERSISTENCE_PROPERTIES);
    }

    public abstract String getdisplayName();

    public String getDescription() {
        return this.getLocalizedMessage("jdbcresource_description");
    }

    private ObjectName[] getJdbcDataSourceObjectNames() throws JMXException {
        String jdbcDataSourcePattern = this.getDomain() + ":j2eeType=JDBCDataSource,JDBCResource=" + this.getQuotedName() + ",J2EEApplication=" + this.getApplicationName() + ",J2EEServer=" + this.getJ2eeServerName() + ",*";
        return this.getObjectNameForPattern(jdbcDataSourcePattern);
    }

    public String[] getjdbcDataSources() throws JMXException {
        ObjectName[] objs = this.getJdbcDataSourceObjectNames();
        if (objs == null) {
            objs = new ObjectName[]{};
        }
        String[] res = new String[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            res[i] = objs[i].toString();
        }
        return res;
    }

    public synchronized void unregisterDependents() {
        try {
            this.unregisterMBeans(new ObjectName(this.getDomain() + ":j2eeType=JDBCDataSource,JDBCResource=" + this.getQuotedName() + ",J2EEApplication=" + this.getApplicationName() + ",J2EEServer=" + this.getJ2eeServerName() + ",*"));
        }
        catch (MalformedObjectNameException e) {
            m_logger.warning("Error occurred creating ObjectName for '" + this.getName() + "'.  Exception: " + e.getMessage());
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    protected void setBaseObjectName() {
        this.setBaseObjectName(JDBCResource.getTheBaseObjectName(this.getJ2eeServerName(), this.getName(), this.getApplicationName()));
    }

    public static String getTheBaseObjectName(String j2eeServerName, String resourceName, String applicationName) {
        resourceName = resourceName == null ? "" : ObjectName.quote(resourceName);
        return ":j2eeType=JDBCResource,name=" + resourceName + ",J2EEApplication=" + applicationName + ",J2EEServer=" + j2eeServerName;
    }
}

