/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.management.mbeans;

import java.util.HashMap;
import java.util.Locale;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanParameterInfo;
import javax.management.RuntimeOperationsException;
import javax.management.j2ee.statistics.Stats;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import oracle.j2ee.connector.ConnectionPoolImpl;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXException;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXRuntimeException;
import oracle.oc4j.admin.management.callbackinterfaces.JCAConnectionPoolCallBackIf;
import oracle.oc4j.admin.management.callbackinterfaces.JCAConnectionPoolMetricCallBackIf;
import oracle.oc4j.admin.management.mbeans.J2EEManagedObjectBase;
import oracle.oc4j.admin.management.mbeans.J2EEServerDependentObjectBase;
import oracle.oc4j.admin.management.mbeans.JCASharedConnectionPoolMBean;
import oracle.oc4j.admin.management.shared.statistic.JCAConnectionPoolStatsImpl;

public class JCASharedConnectionPool
extends J2EEServerDependentObjectBase
implements JCASharedConnectionPoolMBean {
    protected JCAConnectionPoolCallBackIf callBackIf_ = null;

    public JCASharedConnectionPool(String connectorName, String moduleName, String j2eeAppName, String j2eeServerName, String domain, JCAConnectionPoolCallBackIf cback) {
        super(domain, j2eeServerName);
        this.callBackIf_ = cback;
        this.setBaseObjectName(":j2eeType=" + this.getJ2eeType() + ",name=" + this.callBackIf_.getPoolName() + ",ResourceAdapterModule=" + moduleName + ",ResourceAdapter=" + connectorName + ",J2EEApplication=" + j2eeAppName + ",J2EEServer=" + j2eeServerName);
        this.init();
    }

    public JCASharedConnectionPool(String connectorName, String moduleName, String j2eeAppName, JCAConnectionPoolCallBackIf cback) {
        this.callBackIf_ = cback;
        this.setBaseObjectName(":j2eeType=" + this.getJ2eeType() + ",name=" + this.callBackIf_.getPoolName() + ",ResourceAdapterModule=" + moduleName + ",ResourceAdapter=" + connectorName + ",J2EEApplication=" + j2eeAppName + ",J2EEServer=" + this.getJ2eeServerName());
        this.init();
    }

    public JCASharedConnectionPool(Locale loc) {
        super(loc);
        this.init();
    }

    public void init() {
        HashMap<String, String> persistenceDescriptorProperties = new HashMap<String, String>();
        persistenceDescriptorProperties.put("persistPolicy", "OnUpdate");
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("stats", "javax.management.j2ee.statistics.Stats", this.getLocalizedMessage("connectionpool_stats"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("connectionPoolScheme", "java.lang.String", this.getLocalizedMessage("connectionpool_connectionPoolScheme"), true, true, false), persistenceDescriptorProperties);
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("minConnections", "int", this.getLocalizedMessage("connectionpool_minConnections"), true, true, false), persistenceDescriptorProperties);
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("maxConnections", "int", this.getLocalizedMessage("connectionpool_maxConnections"), true, true, false), persistenceDescriptorProperties);
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("fixedWaitTimeout", "int", this.getLocalizedMessage("connectionpool_fixedWaitTimeout"), true, true, false), persistenceDescriptorProperties);
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("connectionCleanupScheme", "java.lang.String", this.getLocalizedMessage("connectionpool_connectionCleanupScheme"), true, true, false), persistenceDescriptorProperties);
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("invalidConnectionTimeout", "int", this.getLocalizedMessage("connectionpool_invalidConnectionTimeout"), true, true, false), persistenceDescriptorProperties);
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("managedConnectionFactoryClass", "java.lang.String", this.getLocalizedMessage("connectionpool_managedConnectionFactoryClass"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("isPoolInUse", "boolean", this.getLocalizedMessage("connectionpool_isPoolInUse"), true, false, false));
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("cleanup", this.getLocalizedMessage("connectionpool_cleanup"), new MBeanParameterInfo[0], "void", 1));
    }

    public String getconnectionPoolScheme() throws JMXException {
        return this.callBackIf_.getScheme();
    }

    public void setconnectionPoolScheme(String scheme) throws JMXException {
        try {
            this.callBackIf_.setScheme(scheme);
        }
        catch (Exception e) {
            throw new JMXRuntimeException((Throwable)e, e.getMessage());
        }
    }

    public int getminConnections() throws JMXException {
        return this.callBackIf_.getMinConnections();
    }

    public void setminConnections(int newValue) throws JMXException {
        try {
            this.callBackIf_.setMinConnections(ConnectionPoolImpl.getValidatedMinConnectionValue(newValue, this.callBackIf_.getMaxConnections()));
        }
        catch (Exception e) {
            throw new JMXRuntimeException((Throwable)e, e.getMessage());
        }
    }

    public int getmaxConnections() throws JMXException {
        return this.callBackIf_.getMaxConnections();
    }

    public void setmaxConnections(int newValue) throws JMXException {
        try {
            this.callBackIf_.setMaxConnections(ConnectionPoolImpl.getValidatedMaxConnectionValue(newValue, this.callBackIf_.getMinConnections()));
        }
        catch (Exception e) {
            throw new JMXRuntimeException((Throwable)e, e.getMessage());
        }
    }

    public int getfixedWaitTimeout() throws JMXException {
        return this.callBackIf_.getWaitTimeout();
    }

    public void setfixedWaitTimeout(int newValue) throws JMXException {
        try {
            this.callBackIf_.setWaitTimeout(newValue);
        }
        catch (Exception e) {
            throw new JMXRuntimeException((Throwable)e, e.getMessage());
        }
    }

    public String getconnectionCleanupScheme() throws JMXException {
        String retVal = this.callBackIf_.getInactivityTimeoutCheck();
        if (retVal == null) {
            retVal = "None";
        }
        return retVal;
    }

    public void setconnectionCleanupScheme(String newScheme) throws JMXException {
        try {
            this.callBackIf_.setInactivityTimeoutCheck(newScheme);
        }
        catch (Exception e) {
            throw new JMXRuntimeException((Throwable)e, e.getMessage());
        }
    }

    public int getinvalidConnectionTimeout() throws JMXException {
        return this.callBackIf_.getInactivityTimeout();
    }

    public void setinvalidConnectionTimeout(int newValue) throws JMXException {
        try {
            this.callBackIf_.setInactivityTimeout(newValue);
        }
        catch (Exception e) {
            throw new JMXRuntimeException((Throwable)e, e.getMessage());
        }
    }

    public void cleanup() throws JMXException {
        this.callBackIf_.pruneInvalidAndExpiredConnections();
    }

    public String getmanagedConnectionFactoryClass() throws JMXException {
        return this.callBackIf_.getManagedConnectionFactoryClass();
    }

    public boolean getisPoolInUse() throws JMXException {
        return this.callBackIf_.isPoolInUse();
    }

    protected String getJ2eeType() {
        return "JCASharedConnectionPool";
    }

    public boolean getstatisticsProvider() {
        JCAConnectionPoolMetricCallBackIf metricCallBack = this.callBackIf_.getDMSMetrics();
        return metricCallBack != null;
    }

    public Stats getstats() {
        JCAConnectionPoolMetricCallBackIf metricCallBack = this.callBackIf_.getDMSMetrics();
        JCAConnectionPoolStatsImpl stats = new JCAConnectionPoolStatsImpl(J2EEManagedObjectBase.getLocaleForCall(), metricCallBack, null, null);
        return stats;
    }

    static String getInternalPropertyName(String externalName) {
        if (externalName.equals("connectionPoolScheme")) {
            return "scheme";
        }
        if (externalName.equals("fixedWaitTimeout")) {
            return "waitTimeout";
        }
        if (externalName.equals("connectionCleanupScheme")) {
            return "inactivity-timeout-check";
        }
        if (externalName.equals("invalidConnectionTimeout")) {
            return "inactivity-timeout";
        }
        return externalName;
    }

    public final void store() throws MBeanException, RuntimeOperationsException, InstanceNotFoundException {
        try {
            this.callBackIf_.persistConfigChange();
        }
        catch (Exception e) {
            throw new JMXRuntimeException((Throwable)e);
        }
    }
}

