/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.management.mbeans;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Locale;
import javax.management.ObjectName;
import oracle.classloader.ConfigurationOrigin;
import oracle.classloader.ExtensionDeclaration;
import oracle.classloader.ExtensionDependency;
import oracle.classloader.MBean;
import oracle.classloader.MBeanTarget;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.SharedCodeSource;
import oracle.classloader.SubscriberSet;
import oracle.classloader.util.ArrayUtils;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXRuntimeException;
import oracle.oc4j.admin.management.mbeans.ClassLoader;
import oracle.oc4j.admin.management.mbeans.ClassLoadingMBeanBase;
import oracle.oc4j.admin.management.mbeans.CodeSourceMBean;

public class CodeSource
extends ClassLoadingMBeanBase
implements CodeSourceMBean {
    private SharedCodeSource codeSource;

    public static synchronized ObjectName getObjectNameFor(SharedCodeSource codeSource, boolean createMBean) {
        ObjectName result = null;
        try {
            MBean mBean = codeSource.getMBean();
            if (mBean != null) {
                result = (ObjectName)mBean.getName();
            } else if (createMBean) {
                CodeSource newBean = new CodeSource(codeSource);
                result = newBean.objectName();
            }
        }
        catch (Exception e) {
            throw new JMXRuntimeException((Throwable)e);
        }
        return result;
    }

    private CodeSource(SharedCodeSource codeSource) {
        super("CodeSource", CodeSource.nameFor(codeSource), (MBeanTarget)codeSource);
        this.codeSource = codeSource;
    }

    private static String nameFor(SharedCodeSource codeSource) {
        String path = codeSource.getLocation().getPath();
        String quotedName = ObjectName.quote(path);
        return quotedName;
    }

    public CodeSource(Locale loc) {
        super("CodeSource", loc);
    }

    protected void initMetaData() {
        super.initMetaData();
        this.initReadOnlyAttribute("lastModifiedTime", "long");
        this.initReadOnlyAttribute("size", "long");
        this.initReadOnlyAttribute("state", "int");
        this.initReadOnlyAttribute("stateNames", "[Ljava.lang.String;");
        this.initReadOnlyAttribute("lastAccessTick", "int");
        this.initReadOnlyAttribute("lastReadTick", "int");
        this.initReadOnlyAttribute("extensionDeclaration", "java.lang.String");
        this.initReadOnlyAttribute("extensionDependencies", "[Ljava.lang.String;");
        this.initReadOnlyAttribute("classPathDependencies", "[Ljava.io.File;");
        this.initReadOnlyAttribute("location", "java.net.URL");
        this.initReadOnlyAttribute("subscribers", "[Ljavax.management.ObjectName;");
        this.initReadOnlyAttribute("origins", "[Ljava.lang.String;");
        this.initReadOnlyAttribute("contents", "[Ljava.lang.String;");
        this.initReadOnlyAttribute("digest", "[B");
    }

    public long getlastModifiedTime() {
        return this.codeSource.getLastModifiedTime();
    }

    public long getsize() {
        return this.codeSource.getSize();
    }

    public int getstate() {
        return this.codeSource.getState();
    }

    public String[] getstateNames() {
        return SharedCodeSource.getStateNames();
    }

    public int getlastAccessTick() {
        return this.codeSource.getLastAccessTick();
    }

    public int getlastReadTick() {
        return this.codeSource.getLastReadTick();
    }

    public String getextensionDeclaration() {
        ExtensionDeclaration declaration = this.codeSource.getExtensionDeclaration();
        if (declaration != null) {
            return declaration.toString(false);
        }
        return "none";
    }

    public String[] getextensionDependencies() {
        String[] result = EMPTY_STRING_ARRAY;
        ExtensionDependency[] deps = this.codeSource.getExtensionDependencies();
        if (deps != null) {
            int count = deps.length;
            result = new String[count];
            for (int i = 0; i < deps.length; ++i) {
                result[i] = deps[i].toString(false);
            }
        }
        return result;
    }

    public File[] getclassPathDependencies() {
        File[] result = this.codeSource.getClassPathDependencies();
        if (result != null) {
            return result;
        }
        return EMPTY_FILE_ARRAY;
    }

    public URL getlocation() {
        return this.codeSource.getLocation();
    }

    public ObjectName[] getsubscribers() {
        PolicyClassLoader[] loaders = this.codeSource.getSubscribers().getSubscribers();
        return ClassLoader.getObjectNamesFor(loaders, true);
    }

    public String[] getorigins() {
        ArrayList<String> list = new ArrayList<String>();
        SubscriberSet subscribers = this.codeSource.getSubscribers();
        PolicyClassLoader[] loaders = subscribers.getSubscribers();
        for (int i = 0; i < loaders.length; ++i) {
            PolicyClassLoader loader = loaders[i];
            ConfigurationOrigin[] origins = this.codeSource.getSubscribers().getOriginsFor(loader);
            for (int j = 0; j < origins.length; ++j) {
                ConfigurationOrigin origin = origins[j];
                list.add(origin.toString());
            }
        }
        return (String[])ArrayUtils.toArray((Class)String.class, list, (boolean)true);
    }

    public String[] getcontents() throws IOException {
        return this.codeSource.list();
    }

    public byte[] getdigest() throws IOException {
        return this.codeSource.getSHADigest();
    }
}

