/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.internal;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ias.opmn.optic.CharBuf;
import oracle.ias.opmn.optic.IasInstance;
import oracle.ias.opmn.optic.OpmnEntity;
import oracle.ias.opmn.optic.OpmnProcess;
import oracle.ias.opmn.optic.OpmnQuery;
import oracle.ias.opmn.optic.OpticBadConnectException;
import oracle.j2ee.admin.jmx.JMXStateFactory;
import oracle.j2ee.admin.jmx.exception.config.ConfigMBeanException;
import oracle.j2ee.admin.jmx.exception.config.ConfigMBeanExceptionHelper;
import oracle.j2ee.util.TraceLogger;

public class OpmnRuntimeHelper {
    private static Logger logger_ = TraceLogger.getLogger(OpmnRuntimeHelper.class);

    public static boolean isOpmnAlive(String oracleHome) {
        try {
            OpmnQuery opmnQuery = new OpmnQuery(oracleHome);
            IasInstance iasInstance = opmnQuery.getIasInstance(null);
            return true;
        }
        catch (OpticBadConnectException e) {
            return false;
        }
        catch (Exception e) {
            logger_.log(Level.WARNING, "failed to get opmn status", e);
            return false;
        }
    }

    public static boolean isOc4jGroupAlive(String oracleHome, String grpName) {
        boolean alive = false;
        try {
            OpmnQuery opmnQuery = new OpmnQuery(oracleHome);
            List procs = opmnQuery.getProc("/dump?type=dms&dmsarg=[name=/&format=pdml]");
            for (int i = 0; i < procs.size(); ++i) {
                OpmnProcess proc = (OpmnProcess)procs.get(i);
                if (!grpName.equals(proc.getIasComponentName()) || !"OC4J".equals(proc.getType()) || !"Alive".equals(proc.getStatus())) continue;
                alive = true;
                break;
            }
        }
        catch (OpticBadConnectException e) {
        }
        catch (Exception e) {
            logger_.log(Level.WARNING, "failed to get oc4j group status", e);
        }
        return alive;
    }

    public static boolean isOc4jAlive(String oracleHome, String grpName, String oc4jName) {
        boolean alive = false;
        try {
            OpmnQuery opmnQuery = new OpmnQuery(oracleHome);
            List procs = opmnQuery.getProc("/dump?type=dms&dmsarg=[name=/&format=pdml]");
            for (int i = 0; i < procs.size(); ++i) {
                OpmnProcess proc = (OpmnProcess)procs.get(i);
                if (!grpName.equals(proc.getIasComponentName()) || !oc4jName.equals(proc.getProcessTypeName()) || !"Alive".equals(proc.getStatus())) continue;
                alive = true;
                break;
            }
        }
        catch (OpticBadConnectException e) {
        }
        catch (Exception e) {
            logger_.log(Level.WARNING, "failed to get oc4j process status", e);
        }
        return alive;
    }

    public static void stopOc4j(String oracleHome, String grpName, String oc4jName) {
        try {
            OpmnQuery opmnQuery = new OpmnQuery(oracleHome);
            List procs = opmnQuery.getProc("/dump?type=dms&dmsarg=[name=/&format=pdml]");
            for (int i = 0; i < procs.size(); ++i) {
                OpmnProcess proc = (OpmnProcess)procs.get(i);
                if (!grpName.equals(proc.getIasComponentName()) || !oc4jName.equals(proc.getProcessTypeName()) || !"Alive".equals(proc.getStatus())) continue;
                proc.stop(null);
            }
        }
        catch (OpticBadConnectException e) {
        }
        catch (Exception e) {
            logger_.log(Level.WARNING, "failed to stop oc4j process status", e);
        }
    }

    public static void startOc4j(String oracleHome, String grpName, String oc4jName) throws ConfigMBeanException {
        try {
            OpmnQuery opmnQuery = new OpmnQuery(oracleHome);
            IasInstance iasInstance = opmnQuery.getIasInstance(null);
            if (iasInstance == null) {
                throw ConfigMBeanExceptionHelper.getException(66, oc4jName, ConfigMBeanExceptionHelper.getLocalizedMessage("OpmnIsDown", JMXStateFactory.getJMXState().getLocale()), JMXStateFactory.getJMXState().getLocale());
            }
            OpmnEntity oc4jGrp = OpmnRuntimeHelper.getChild((OpmnEntity)iasInstance, grpName);
            if (oc4jGrp == null) {
                throw ConfigMBeanExceptionHelper.getException(66, oc4jName, ConfigMBeanExceptionHelper.getLocalizedMessage("GroupNotFound", JMXStateFactory.getJMXState().getLocale()), JMXStateFactory.getJMXState().getLocale());
            }
            OpmnEntity oc4jProc = OpmnRuntimeHelper.getChild(oc4jGrp, oc4jName);
            if (oc4jProc == null) {
                throw ConfigMBeanExceptionHelper.getException(66, oc4jName, ConfigMBeanExceptionHelper.getLocalizedMessage("Oc4jNotFound", JMXStateFactory.getJMXState().getLocale()), JMXStateFactory.getJMXState().getLocale());
            }
            if (!OpmnRuntimeHelper.isOc4jAlive(oracleHome, grpName, oc4jName)) {
                CharBuf cbuf = oc4jProc.start(null);
            }
        }
        catch (OpticBadConnectException e) {
            logger_.log(Level.INFO, "start oc4j fails because opmn is down", e);
            throw ConfigMBeanExceptionHelper.getException(66, oc4jName, ConfigMBeanExceptionHelper.getLocalizedMessage("OpmnIsDown", JMXStateFactory.getJMXState().getLocale()), JMXStateFactory.getJMXState().getLocale());
        }
        catch (ConfigMBeanException e) {
            throw e;
        }
        catch (Exception e) {
            logger_.log(Level.SEVERE, "start oc4j fails", e);
            throw ConfigMBeanExceptionHelper.getException(66, oc4jName, e.getMessage(), e, JMXStateFactory.getJMXState().getLocale());
        }
    }

    private static OpmnEntity getChild(OpmnEntity parent, String childId) {
        OpmnEntity result = null;
        List children = parent.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            OpmnEntity entity = (OpmnEntity)children.get(i);
            if (!childId.equals(entity.getName())) continue;
            result = entity;
            break;
        }
        return result;
    }
}

