/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.config;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.oc4j.admin.config.ConfigUtils;
import oracle.oc4j.admin.config.CreationException;
import oracle.oc4j.admin.config.LocalizationHelper;

public class CommandParser {
    String _instanceName = null;
    String _groupName = null;
    String _password = null;
    String _oracle_home = null;
    String _port = null;
    String _protocol = null;
    String _config_home = null;
    String _numProcs = null;
    boolean _defaultAdminPass = false;
    boolean _startASControl = false;
    boolean _ascontrolIsRoutable = false;
    boolean _cloneHome = true;
    String _opmnHomeXml = null;
    static LocalizationHelper _locHelper = null;

    public CommandParser() {
        _locHelper = new LocalizationHelper();
    }

    public void init() {
    }

    void parseArguments(List args) throws CreationException {
        String instanceName = null;
        String groupName = null;
        Object password = null;
        String port = null;
        String oracle_home = null;
        String protocol = null;
        String numProcs = null;
        String opmnHomeXml = null;
        while (!this.isArgsEmpty(args)) {
            String argument = ConfigUtils.getNextArgument(args, "argument");
            if (argument.equalsIgnoreCase("-instanceName")) {
                instanceName = ConfigUtils.getNextArgument(args, _locHelper.getMessage("new_oc4j_name"));
                if (instanceName.startsWith("-")) {
                    throw new CreationException(_locHelper.getMessage("missing_instance_name"));
                }
                if (!ConfigUtils.isValidName(instanceName)) {
                    throw new CreationException(_locHelper.getMessage("not_reserve_characters", instanceName));
                }
                this.setInstanceName(instanceName);
                continue;
            }
            if (argument.equalsIgnoreCase("-groupName")) {
                groupName = ConfigUtils.getNextArgument(args, _locHelper.getMessage("user_group_name"));
                if (groupName == null || groupName.equals("")) {
                    throw new CreationException(_locHelper.getMessage("missing_group_value"));
                }
                if (groupName.startsWith("-")) {
                    throw new CreationException(_locHelper.getMessage("missing_group_value"));
                }
                this.setGroupName(groupName);
                continue;
            }
            if (argument.equalsIgnoreCase("-httpPort")) {
                port = ConfigUtils.getNextArgument(args, _locHelper.getMessage("user_http_port"));
                Integer n_port = null;
                try {
                    n_port = new Integer(port);
                }
                catch (NumberFormatException e) {
                    throw new CreationException(_locHelper.getMessage("http_port_not_number"));
                }
                this.setPort(port);
                continue;
            }
            if (argument.equalsIgnoreCase("-protocol")) {
                protocol = ConfigUtils.getNextArgument(args, _locHelper.getMessage("protocol_value"));
                if (protocol == null || protocol.equals("")) {
                    throw new CreationException(_locHelper.getMessage("missing_protocol_value"));
                }
                if (!(protocol.equalsIgnoreCase("ajp") || protocol.equalsIgnoreCase("http") || protocol.equalsIgnoreCase("ajps") || protocol.equalsIgnoreCase("https"))) {
                    throw new CreationException(_locHelper.getMessage("invalid_protocol_value"));
                }
                this.setProtocol(protocol.toLowerCase());
                continue;
            }
            if (argument.equalsIgnoreCase("-numProcs")) {
                numProcs = ConfigUtils.getNextArgument(args, _locHelper.getMessage("number_of_procs"));
                Integer n_numProcs = null;
                try {
                    n_numProcs = new Integer(numProcs);
                }
                catch (NumberFormatException e) {
                    throw new CreationException(_locHelper.getMessage("number_of_procs_error"));
                }
                this.setNumProcs(numProcs);
                continue;
            }
            if (argument.equalsIgnoreCase("-oracleHome")) {
                oracle_home = ConfigUtils.getNextArgument(args, _locHelper.getMessage("oracle_home_variable"));
                File oh = new File(oracle_home);
                try {
                    if (!oh.getCanonicalFile().exists()) {
                        throw new CreationException(_locHelper.getMessage("file_not_exist", oracle_home));
                    }
                }
                catch (Throwable t) {
                    throw new CreationException(_locHelper.getMessage("file_not_exist", oracle_home));
                }
                this.setOracleHome(oracle_home);
                continue;
            }
            if (argument.equalsIgnoreCase("-configHome")) {
                this._config_home = ConfigUtils.getNextArgument(args, _locHelper.getMessage("oracle_config_home"));
                if (this._config_home == null || this._config_home.equals("")) {
                    throw new CreationException(_locHelper.getMessage("missing_config_home_value"));
                }
                if (this._config_home.startsWith("-")) {
                    throw new CreationException(_locHelper.getMessage("missing_config_home_value"));
                }
                this.setConfigHome(this._config_home);
                continue;
            }
            if (argument.equalsIgnoreCase("-defaultAdminPass")) {
                this._defaultAdminPass = true;
                continue;
            }
            if (argument.equalsIgnoreCase("-startASControl")) {
                this._startASControl = true;
                continue;
            }
            if (argument.equalsIgnoreCase("-ASControlIsRoutable")) {
                this._ascontrolIsRoutable = true;
                continue;
            }
            if (argument.equalsIgnoreCase("-noCloneHome")) {
                this._cloneHome = false;
                continue;
            }
            if (argument.equalsIgnoreCase("-opmnSnippet")) {
                opmnHomeXml = ConfigUtils.getNextArgument(args, _locHelper.getMessage("opmn_snippet"));
                if (opmnHomeXml == null || opmnHomeXml.equals("")) {
                    throw new CreationException(_locHelper.getMessage("missing_opmn_snippet_value"));
                }
                if (opmnHomeXml.startsWith("-")) {
                    throw new CreationException(_locHelper.getMessage("missing_opmn_snippet_value"));
                }
                this.setOpmnSnippet(opmnHomeXml);
                continue;
            }
            throw new CreationException(_locHelper.getMessage("unknown_argument") + argument);
        }
        if (instanceName == null) {
            throw new CreationException(_locHelper.getMessage("null_instance_name"));
        }
        if (this._config_home == null) {
            this._config_home = this._oracle_home;
            this.setConfigHome(this._config_home);
        }
    }

    boolean isArgsEmpty(List args) {
        return args.isEmpty();
    }

    String getInstanceName() {
        return this._instanceName;
    }

    void setInstanceName(String instanceName) {
        this._instanceName = instanceName;
    }

    String getGroupName() {
        return this._groupName;
    }

    void setGroupName(String groupName) {
        this._groupName = groupName;
    }

    String getPassword() {
        return this._password;
    }

    void setPassword(String password) {
        this._password = password;
    }

    String getOracleHome() {
        return this._oracle_home;
    }

    void setOracleHome(String oracle_home) {
        this._oracle_home = oracle_home;
    }

    String getConfigHome() {
        return this._config_home;
    }

    void setConfigHome(String config_home) {
        this._config_home = config_home;
    }

    String getPort() {
        return this._port;
    }

    void setProtocol(String protocol) {
        this._protocol = protocol;
    }

    String getProtocol() {
        return this._protocol;
    }

    void setPort(String port) {
        this._port = port;
    }

    String getNumProcs() {
        return this._numProcs;
    }

    void setNumProcs(String numProcs) {
        this._numProcs = numProcs;
    }

    boolean defaultAdminPass() {
        return this._defaultAdminPass;
    }

    boolean startASControl() {
        return this._startASControl;
    }

    boolean ascontrolIsRoutable() {
        return this._ascontrolIsRoutable;
    }

    boolean needCloneHome() {
        return this._cloneHome;
    }

    void setOpmnSnippet(String file) {
        this._opmnHomeXml = file;
    }

    String getOpmnSnippet() {
        return this._opmnHomeXml;
    }

    public Map getExtraParams() {
        ConfigUtils.log("       ORACLE_HOME: " + this.getOracleHome());
        ConfigUtils.log("ORACLE_CONFIG_HOME: " + this.getConfigHome());
        ConfigUtils.log("        Group name: " + this.getGroupName());
        ConfigUtils.log("     Instance name: " + this.getInstanceName());
        ConfigUtils.log("          Protocol: " + this.getProtocol());
        ConfigUtils.log("         http port: " + this.getPort());
        ConfigUtils.log("  defaultAdminPass: " + this.defaultAdminPass());
        ConfigUtils.log("   start ASControl: " + this.startASControl());
        ConfigUtils.log("ASControl routable: " + this.ascontrolIsRoutable());
        ConfigUtils.log("          numprocs: " + this.getNumProcs());
        ConfigUtils.log("     opmn_home.xml: " + this.getOpmnSnippet());
        ConfigUtils.log("        clone home: " + this.needCloneHome());
        HashMap<String, String> extraParams = new HashMap<String, String>();
        if (this.getOracleHome() != null) {
            extraParams.put("oracle.home", this.getOracleHome());
        }
        if (this.getConfigHome() != null) {
            extraParams.put("config.home", this.getConfigHome());
        }
        if (this.getProtocol() != null) {
            extraParams.put("protocol", this.getProtocol());
        }
        if (this.getPort() != null) {
            extraParams.put("port", this.getPort());
        }
        if (this.getNumProcs() != null) {
            extraParams.put("numprocs", this.getNumProcs());
        }
        if (this.startASControl()) {
            extraParams.put("asc.enable", "true");
        } else {
            extraParams.put("asc.enable", "false");
        }
        if (this.ascontrolIsRoutable()) {
            extraParams.put("asc.routable", "true");
        } else {
            extraParams.put("asc.routable", "false");
        }
        if (this.defaultAdminPass()) {
            extraParams.put("defaultAdminPass", "true");
        } else {
            extraParams.put("defaultAdminPass", "false");
        }
        if (this.needCloneHome()) {
            extraParams.put("clone.home", "true");
        } else {
            extraParams.put("clone.home", "false");
        }
        if (this.getOpmnSnippet() != null) {
            extraParams.put("opmnsnippet", this.getOpmnSnippet());
        }
        extraParams.put(new String("start.oc4j"), "false");
        return extraParams;
    }
}

