/*
 * Decompiled with CFR 0.152.
 */
package oracle.j2ee.ws.server.deployment.oc4j;

import com.evermind.server.ejb.AnnotationListener;
import com.evermind.server.ejb.EJBUtils;
import com.evermind.server.ejb.deployment.EJBPackage;
import com.evermind.server.ejb.logging.EJBAnnotationMessages;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class WebServiceAnnotationListener
implements AnnotationListener {
    private File m_deploymentDirectory;
    private EJBPackage m_ejbPackage;
    private String m_earName;
    private String m_classpath;
    private static final String ANNOTATION_PARSER = "oracle.j2ee.ws.common.metadata.annotation.EJBWebServiceAnnotationParser";
    private static final String ANNOTATION_PARSER_METHOD = "parseAnnotatedBean";
    private Method m_parserMethod;

    public WebServiceAnnotationListener(File deploymentDirectory, EJBPackage pkg) {
        this.m_deploymentDirectory = deploymentDirectory;
        this.m_earName = pkg.getName();
        this.m_earName = this.m_earName.replaceAll(" ", "_");
        this.m_classpath = pkg.getContainer().getApplication().getClassPath();
        this.m_ejbPackage = pkg;
        this.init();
    }

    private void init() {
        try {
            Class<?> annotationParserClass = Class.forName(ANNOTATION_PARSER);
            this.m_parserMethod = annotationParserClass.getMethod(ANNOTATION_PARSER_METHOD, File.class, String.class, String.class, Class.class, ClassLoader.class, EJBPackage.class);
        }
        catch (ClassNotFoundException e) {
            EJBAnnotationMessages.warningWebServicesAnnotation();
        }
        catch (NoSuchMethodException e) {
            EJBAnnotationMessages.warningFailedInvokeWebServicesAnnotationListener();
        }
    }

    public void parseAnnotatedClass(Class annotatedClass, ClassLoader loader, Object annotationManager) {
        if (this.m_parserMethod != null) {
            try {
                Object[] args = new Object[]{this.m_deploymentDirectory, this.m_classpath, this.m_earName, annotatedClass, loader, this.m_ejbPackage};
                this.m_parserMethod.invoke(null, args);
            }
            catch (IllegalAccessException e) {
                throw EJBUtils.createEJBException(e);
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                if (t instanceof Exception) {
                    throw EJBUtils.createEJBException((Exception)t);
                }
                throw EJBUtils.createEJBException(e);
            }
        }
    }
}

