/*
 * Decompiled with CFR 0.152.
 */
package oracle.j2ee.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LoggingUtils {
    public static String logAndReturnMessage(Logger logger, Level level, String key, Object[] params) {
        logger.log(level, key, params);
        return MessageFormat.format(logger.getResourceBundle().getString(key), params);
    }

    public static String logAndReturnMessage(Logger logger, Level level, String key) {
        return LoggingUtils.logAndReturnMessage(logger, level, key, new Object[0]);
    }

    public static void logWarningStackTrace(Logger logger, Throwable throwable) {
        if (logger.isLoggable(Level.FINE)) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            throwable.printStackTrace(pw);
            logger.fine(sw.toString());
        }
    }

    public static void logSevereStackTrace(Logger logger, Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        throwable.printStackTrace(pw);
        logger.severe(sw.toString());
    }

    public static String getMessage(Logger logger, String key) {
        return LoggingUtils.getMessage(logger, key, new Object[0]);
    }

    public static String getMessage(Logger logger, String key, Object p1) {
        return LoggingUtils.getMessage(logger, key, new Object[]{p1});
    }

    public static String getMessage(Logger logger, String key, Object p1, Object p2) {
        return LoggingUtils.getMessage(logger, key, new Object[]{p1, p2});
    }

    public static String getMessage(Logger logger, String key, Object p1, Object p2, Object p3) {
        return LoggingUtils.getMessage(logger, key, new Object[]{p1, p2, p3});
    }

    public static String getMessage(Logger logger, String key, Object p1, Object p2, Object p3, Object p4) {
        return LoggingUtils.getMessage(logger, key, new Object[]{p1, p2, p3, p4});
    }

    private static String getMessage(Logger logger, String key, Object[] params) {
        return MessageFormat.format(logger.getResourceBundle().getString(key), params);
    }
}

