/*
 * Decompiled with CFR 0.152.
 */
package oracle.j2ee.rmi;

import com.evermind.server.rmi.Credentials;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.j2ee.rmi.RMIMessageBundle;
import oracle.j2ee.util.CustomerLogger;
import oracle.j2ee.util.LoggingUtils;

public class RMIMessages {
    private static Logger m_logger = CustomerLogger.getLogger("oracle.j2ee.rmi", RMIMessageBundle.class.getName());

    public static void warningReleaseErrorDuringShutdown(Throwable reason) {
        m_logger.log(Level.WARNING, "J2EE RMI-00001", reason);
    }

    public static Logger getLogger() {
        return m_logger;
    }

    private static boolean isLoggable(Level level) {
        return m_logger.isLoggable(level);
    }

    public static void severeUnableToCreateSocket(String hostname, int port, Exception e) {
        Object[] args = new Object[]{hostname, new Integer(port), e.getMessage()};
        m_logger.log(Level.SEVERE, "J2EE RMI-00002", args);
        LoggingUtils.logSevereStackTrace(m_logger, e);
        System.err.println(MessageFormat.format(RMIMessageBundle.getBundle(RMIMessageBundle.class.getName()).getString("J2EE RMI-00002"), args));
    }

    public static void infoLoginFailedWithBadPassword(String contextName, Credentials credentials) {
        if (RMIMessages.isLoggable(Level.INFO)) {
            m_logger.log(Level.INFO, "J2EE RMI-00004", new Object[]{contextName, credentials.getUsername()});
        }
    }

    public static void infoLoginFailedWithUnknownUser(String contextName, Credentials credentials) {
        if (RMIMessages.isLoggable(Level.INFO)) {
            m_logger.log(Level.INFO, "J2EE RMI-00003", new Object[]{contextName, credentials.getUsername()});
        }
    }

    public static void infoLoginNotPermitted(String contextName, Credentials credentials) {
        if (RMIMessages.isLoggable(Level.INFO)) {
            m_logger.log(Level.INFO, "J2EE RMI-00005", new Object[]{contextName, credentials.getUsername()});
        }
    }

    public static void infoRemoteBindFailed(String name, Object value, Throwable reason) {
        if (RMIMessages.isLoggable(Level.INFO)) {
            m_logger.log(Level.INFO, "J2EE RMI-00006", new Object[]{name, value, reason});
        }
    }

    public static void finerThrowable(Throwable e) {
        if (RMIMessages.isLoggable(Level.FINER)) {
            m_logger.log(Level.FINER, "J2EE RMI-00008", e);
        }
    }

    public static void finerThrowable(String s, Throwable e) {
        if (RMIMessages.isLoggable(Level.FINER)) {
            m_logger.log(Level.FINER, "J2EE RMI-00007", new Object[]{s, e});
        }
    }

    public static void EXCEPTION_ORIGINATES_FROM_THE_REMOTE_SERVER(Throwable e) {
        if (RMIMessages.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, "J2EE RMI-00009", e);
        }
    }
}

